/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import portablejim.veinminer.VeinMiner;
import portablejim.veinminer.network.GenericHandler;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.PlayerStatus;

public class PacketChangeMode
implements IMessage {
    public short mode;

    public PacketChangeMode() {
        this.mode = 0;
    }

    public PacketChangeMode(int clientMode) {
        switch (clientMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mode = (short)clientMode;
                break;
            }
            default: {
                this.mode = 0;
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeShort((int)this.mode);
    }

    public void fromBytes(ByteBuf buffer) {
        this.mode = buffer.readShort();
    }

    public static class Handler
    extends GenericHandler<PacketChangeMode> {
        @Override
        public void processMessage(PacketChangeMode packetClientPresent, MessageContext context) {
            if (context.side == Side.CLIENT) {
                VeinMiner.instance.currentMode = packetClientPresent.mode;
                VeinMiner.instance.logger.info(String.format("Received mode change %d", packetClientPresent.mode));
                switch (packetClientPresent.mode) {
                    case 0: 
                    case 3: 
                    case 4: {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation("command.veinminerc.set.disabled", new Object[0]));
                        break;
                    }
                    case 1: {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation("command.veinminerc.set.pressed", new Object[0]));
                        break;
                    }
                    case 2: {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation("command.veinminerc.set.released", new Object[0]));
                    }
                }
            } else if (context.side == Side.SERVER) {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                UUID playerName = player.func_110124_au();
                MinerServer minerServer = VeinMiner.instance.minerServer;
                minerServer.addClientPlayer(playerName);
                switch (packetClientPresent.mode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        minerServer.setPlayerStatus(playerName, PlayerStatus.INACTIVE);
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.auto", new Object[0]));
                        break;
                    }
                    case 3: {
                        minerServer.setPlayerStatus(playerName, PlayerStatus.SNEAK_ACTIVE);
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.sneak", new Object[0]));
                        break;
                    }
                    case 4: {
                        minerServer.setPlayerStatus(playerName, PlayerStatus.SNEAK_INACTIVE);
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.nosneak", new Object[0]));
                    }
                }
            }
        }
    }
}

