/*
 * Decompiled with CFR 0.152.
 */
package glowredman.defaultserverlist.mixins;

import glowredman.defaultserverlist.Config;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerList.class})
public class ServerListMixin {
    @Shadow
    @Final
    private List field_78858_b;

    @Inject(at={@At(value="TAIL")}, method={"loadServerList()V"})
    private void removeDuplicateServers(CallbackInfo ci) {
        this.field_78858_b.removeIf(o -> {
            String s1 = ((ServerData)o).field_78845_b.replace("http://", "").replace("https://", "").replace(":25565", "");
            for (ServerData s2 : Config.SERVERS) {
                if (!s1.equals(s2.field_78845_b.replace("http://", "").replace("https://", "").replace(":25565", ""))) continue;
                return true;
            }
            return false;
        });
        for (ServerData s : Config.SERVERS) {
            s.field_78841_f = false;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"saveServerList()V"})
    private void saveDefaultServerList(CallbackInfo ci) {
        if (Config.config.allowModifications) {
            try {
                LinkedHashMap<String, String> newServers = new LinkedHashMap<String, String>();
                Config.SERVERS.forEach(serverData -> newServers.put(serverData.field_78847_a, serverData.field_78845_b));
                Config.config.servers = newServers;
                Config.saveConfig(Config.config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Overwrite
    public ServerData func_78850_a(int index) {
        if (index < this.field_78858_b.size()) {
            return (ServerData)this.field_78858_b.get(index);
        }
        return Config.SERVERS.get(index - this.field_78858_b.size());
    }

    @Overwrite
    public void func_78851_b(int index) {
        if (index < this.field_78858_b.size()) {
            this.field_78858_b.remove(index);
        } else if (Config.config.allowModifications) {
            Config.SERVERS.remove(index - this.field_78858_b.size());
        }
    }

    @Overwrite
    public int func_78856_c() {
        return this.field_78858_b.size() + Config.SERVERS.size();
    }

    @Overwrite
    public void func_78857_a(int index1, int index2) {
        if (index1 < this.field_78858_b.size() && index2 < this.field_78858_b.size()) {
            ServerData serverdata = this.func_78850_a(index1);
            this.field_78858_b.set(index1, this.func_78850_a(index2));
            this.field_78858_b.set(index2, serverdata);
            this.func_78855_b();
        } else if (index1 >= this.field_78858_b.size() && index2 >= this.field_78858_b.size()) {
            ServerData serverdata = this.func_78850_a(index1);
            Config.SERVERS.set(index1 - this.field_78858_b.size(), this.func_78850_a(index2));
            Config.SERVERS.set(index2 - this.field_78858_b.size(), serverdata);
            this.saveDefaultServerList(null);
        }
    }

    @Shadow
    public void func_78855_b() {
    }

    @Overwrite
    public void func_147413_a(int index, ServerData data) {
        if (index < this.field_78858_b.size()) {
            this.field_78858_b.set(index, data);
        }
    }
}

