/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.data.IAEItemStack;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.tiles.TileJarFillableVoid;
import thaumicenergistics.api.grid.IMEEssentiaMonitor;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.integration.tc.EssentiaTileContainerHelper;
import thaumicenergistics.common.items.ItemCraftingAspect;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.parts.ThEPartEssentiaIOBus_Base;
import thaumicenergistics.implementaion.ThEMultiCraftingTracker;

public class PartEssentiaExportBus
extends ThEPartEssentiaIOBus_Base
implements ICraftingRequester {
    private final ThEMultiCraftingTracker craftingTracker = new ThEMultiCraftingTracker(this, 9);
    private static final String NBT_KEY_VOID = "IsVoidAllowed";
    private final BaseActionSource mySrc = new MachineSource((IActionHost)this);
    private boolean isVoidAllowed = false;
    private boolean isCraftingOnly = false;

    public PartEssentiaExportBus() {
        super(AEPartsEnum.EssentiaExportBus, SecurityPermissions.EXTRACT);
    }

    @Override
    public boolean aspectTransferAllowed(Aspect aspect) {
        return true;
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public boolean doWork(int amountToFillContainer) {
        if (this.facingContainer == null) {
            return false;
        }
        for (int slot = 0; slot < this.filteredAspects.size(); ++slot) {
            Aspect filterAspect = (Aspect)this.filteredAspects.get(slot);
            if (filterAspect == null || EssentiaTileContainerHelper.INSTANCE.injectEssentiaIntoContainer(this.facingContainer, 1, filterAspect, Actionable.SIMULATE) <= 0L && (!this.isVoidAllowed || EssentiaTileContainerHelper.INSTANCE.getAspectInContainer(this.facingContainer) != filterAspect)) continue;
            IMEEssentiaMonitor essMonitor = this.getGridBlock().getEssentiaMonitor();
            if (essMonitor == null) {
                return false;
            }
            if (this.isCraftingOnly()) {
                this.handleCratting(amountToFillContainer, slot, filterAspect);
                continue;
            }
            long extractedAmount = essMonitor.extractEssentia(filterAspect, amountToFillContainer, Actionable.SIMULATE, (BaseActionSource)this.asMachineSource, true);
            if (extractedAmount <= 0L) {
                if (!this.hasCraftingCard) continue;
                this.handleCratting(amountToFillContainer, slot, filterAspect);
                continue;
            }
            long filledAmount = this.injectAspect(Actionable.MODULATE, filterAspect, extractedAmount);
            if (filledAmount <= 0L) continue;
            return true;
        }
        return false;
    }

    private void handleCratting(int amountToFillContainer, int slot, Aspect filterAspect) {
        IGrid grid = this.getGridNode().getGrid();
        ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IAEItemStack result = AEApi.instance().storage().createItemStack(ItemCraftingAspect.createStackForAspect(filterAspect, amountToFillContainer));
        this.craftingTracker.handleCrafting(slot, amountToFillContainer, result, this.getHostTile().func_145831_w(), grid, cg, this.mySrc);
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 13.5);
        helper.addBox(5.0, 5.0, 13.5, 11.0, 11.0, 15.0);
        helper.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[2];
    }

    @Override
    public boolean isVoidAllowed() {
        return this.isVoidAllowed;
    }

    @Override
    public boolean isCraftingOnly() {
        return this.isCraftingOnly;
    }

    @Override
    public void setCraftingOnly(boolean c) {
        this.isCraftingOnly = c;
    }

    @Override
    public void onClientRequestFilterList(EntityPlayer player) {
        super.onClientRequestFilterList(player);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_VOID)) {
            this.isVoidAllowed = data.func_74767_n(NBT_KEY_VOID);
        }
        this.craftingTracker.readFromNBT(data);
        if (data.func_74764_b("isCraftingOnly")) {
            this.isCraftingOnly = data.func_74767_n("isCraftingOnly");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon busSideTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[3];
        helper.setTexture(busSideTexture);
        helper.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 12.5f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[2]);
        helper.setBounds(4.0f, 4.0f, 12.5f, 12.0f, 12.0f, 13.5f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(5.0f, 5.0f, 13.5f, 11.0f, 11.0f, 14.5f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(busSideTexture);
        helper.setBounds(5.0f, 5.0f, 14.5f, 11.0f, 11.0f, 15.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(busSideTexture, busSideTexture, busSideTexture, BlockTextureManager.ESSENTIA_EXPORT_BUS.getTexture(), busSideTexture, busSideTexture);
        helper.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setInvColor(ThEPartBase.INVENTORY_OVERLAY_COLOR);
        ts.func_78380_c(0xF000F0);
        IIcon faceOverlayTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[1];
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.UP, renderer);
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.DOWN, renderer);
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.EAST, renderer);
        helper.renderInventoryFace(faceOverlayTexture, ForgeDirection.WEST, renderer);
        helper.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon busSideTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[3];
        helper.setTexture(busSideTexture);
        helper.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 12.5f);
        helper.renderBlock(x, y, z, renderer);
        helper.renderForPass(1);
        helper.setTexture(BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[2]);
        helper.setBounds(4.0f, 4.0f, 12.5f, 12.0f, 12.0f, 13.5f);
        helper.renderBlock(x, y, z, renderer);
        helper.setBounds(5.0f, 5.0f, 13.5f, 11.0f, 11.0f, 14.5f);
        helper.renderBlock(x, y, z, renderer);
        helper.renderForPass(0);
        helper.setTexture(busSideTexture);
        helper.setBounds(5.0f, 5.0f, 14.5f, 11.0f, 11.0f, 15.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setTexture(busSideTexture, busSideTexture, busSideTexture, BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[0], busSideTexture, busSideTexture);
        helper.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        ts.func_78378_d(this.getHost().getColor().blackVariant);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        IIcon faceOverlayTexture = BlockTextureManager.ESSENTIA_EXPORT_BUS.getTextures()[1];
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.UP, renderer);
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.DOWN, renderer);
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.EAST, renderer);
        helper.renderFace(x, y, z, faceOverlayTexture, ForgeDirection.WEST, renderer);
        helper.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    public void toggleVoidMode() {
        this.isVoidAllowed = !this.isVoidAllowed;
    }

    public void toggleCraftingMode() {
        this.isCraftingOnly = !this.isCraftingOnly;
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        boolean doSave;
        super.writeToNBT(data, saveType);
        boolean bl = doSave = saveType == PartItemStack.World;
        if (!doSave) {
            for (Aspect aspect : this.filteredAspects) {
                if (aspect == null) continue;
                doSave = true;
                break;
            }
        }
        if (doSave) {
            data.func_74757_a(NBT_KEY_VOID, this.isVoidAllowed);
            this.craftingTracker.writeToNBT(data);
            data.func_74757_a("isCraftingOnly", this.isCraftingOnly);
        }
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        Aspect a;
        if (this.getGridNode().isActive() && ItemEnum.CRAFTING_ASPECT.getItem() == items.getItem() && (a = ItemCraftingAspect.getAspect(items.getItemStack())) != null) {
            long toFill = items.getStackSize();
            long filledAmount = this.injectAspect(mode, a, toFill);
            IAEItemStack c = items.copy();
            c.setStackSize(toFill - filledAmount);
            return c;
        }
        return items;
    }

    private long injectAspect(Actionable mode, Aspect a, long extractedAmount) {
        long filledAmount = this.isVoidAllowed && this.facingContainer instanceof TileJarFillableVoid ? extractedAmount : EssentiaTileContainerHelper.INSTANCE.injectEssentiaIntoContainer(this.facingContainer, (int)extractedAmount, a, Actionable.SIMULATE);
        if (filledAmount <= 0L) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            long actualFilledAmount = EssentiaTileContainerHelper.INSTANCE.injectEssentiaIntoContainer(this.facingContainer, (int)filledAmount, a, Actionable.MODULATE);
            if (!this.isVoidAllowed) {
                filledAmount = actualFilledAmount;
            }
            this.getGridBlock().getEssentiaMonitor().extractEssentia(a, filledAmount, Actionable.MODULATE, (BaseActionSource)this.asMachineSource, true);
        }
        return filledAmount;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }
}

