/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.liquid.AbstractEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketRoundRobinMode
extends AbstractConduitPacket<ILiquidConduit>
implements IMessageHandler<PacketRoundRobinMode, IMessage> {
    private ForgeDirection dir;
    private boolean roundRobin;

    public PacketRoundRobinMode() {
    }

    public PacketRoundRobinMode(AbstractEnderLiquidConduit eConduit, ForgeDirection dir) {
        super(eConduit.getBundle().getEntity(), ConTypeEnum.FLUID);
        this.dir = dir;
        this.roundRobin = eConduit.isRoundRobin(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeBoolean(this.roundRobin);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readShort()];
        this.roundRobin = buf.readBoolean();
    }

    public IMessage onMessage(PacketRoundRobinMode message, MessageContext ctx) {
        ILiquidConduit conduit = (ILiquidConduit)message.getTileCasted(ctx);
        if (conduit instanceof AbstractEnderLiquidConduit) {
            ((AbstractEnderLiquidConduit)conduit).setRoundRobin(message.dir, message.roundRobin);
            message.getWorld(ctx).func_147471_g(message.x, message.y, message.z);
        }
        return null;
    }
}

