/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import com.github.bartimaeusnek.bartworks.API.BioVatLogicAdder;
import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.reflect.FieldUtils;

public class BW_Util {
    public static final int STANDART = 0;
    public static final int LOWGRAVITY = -100;
    public static final int CLEANROOM = -200;
    private static Block bw_realglasRef;
    private static Field sBufferedRecipeList;

    public static String translateGTItemStack(ItemStack itemStack) {
        if (!GT_Utility.isStackValid((Object)itemStack)) {
            return "Not a Valid ItemStack:" + itemStack;
        }
        String ret = GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)itemStack));
        if (!ret.contains("%material")) {
            return ret;
        }
        String matname = "";
        if (BW_Util.checkStackAndPrefix(itemStack)) {
            matname = GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial.mDefaultLocalName;
        }
        return ret.replace("%material", matname);
    }

    public static void set2DCoordTo1DArray(int indexX, int indexY, int sizeY, Object value, Object[] array) {
        int index = indexX * sizeY + indexY;
        array[index] = value;
    }

    public static Object get2DCoordFrom1DArray(int indexX, int indexY, int sizeY, Object[] array) {
        int index = indexX * sizeY + indexY;
        return array[index];
    }

    public static GT_Recipe copyAndSetTierToNewRecipe(GT_Recipe recipe, byte tier) {
        byte oldTier = GT_Utility.getTier((long)recipe.mEUt);
        int newTime = recipe.mDuration;
        int newVoltage = recipe.mEUt;
        if (tier < oldTier) {
            newTime <<= oldTier - tier;
            newVoltage >>= 2 * (oldTier - tier);
        } else {
            newTime >>= tier - oldTier;
            newVoltage <<= 2 * (tier - oldTier);
        }
        recipe.mEUt = newVoltage;
        recipe.mDuration = newTime;
        return recipe;
    }

    public static String subscriptNumbers(String b) {
        char[] chars = b.toCharArray();
        char[] nu = new char[chars.length];
        block12: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '0': {
                    nu[i] = 8320;
                    continue block12;
                }
                case '1': {
                    nu[i] = 8321;
                    continue block12;
                }
                case '2': {
                    nu[i] = 8322;
                    continue block12;
                }
                case '3': {
                    nu[i] = 8323;
                    continue block12;
                }
                case '4': {
                    nu[i] = 8324;
                    continue block12;
                }
                case '5': {
                    nu[i] = 8325;
                    continue block12;
                }
                case '6': {
                    nu[i] = 8326;
                    continue block12;
                }
                case '7': {
                    nu[i] = 8327;
                    continue block12;
                }
                case '8': {
                    nu[i] = 8328;
                    continue block12;
                }
                case '9': {
                    nu[i] = 8329;
                    continue block12;
                }
                default: {
                    nu[i] = chars[i];
                }
            }
        }
        return new String(nu);
    }

    public static String subscriptNumber(Number b) {
        char[] chars = Long.toString(b.longValue()).toCharArray();
        char[] nu = new char[chars.length];
        block12: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '0': {
                    nu[i] = 8320;
                    continue block12;
                }
                case '1': {
                    nu[i] = 8321;
                    continue block12;
                }
                case '2': {
                    nu[i] = 8322;
                    continue block12;
                }
                case '3': {
                    nu[i] = 8323;
                    continue block12;
                }
                case '4': {
                    nu[i] = 8324;
                    continue block12;
                }
                case '5': {
                    nu[i] = 8325;
                    continue block12;
                }
                case '6': {
                    nu[i] = 8326;
                    continue block12;
                }
                case '7': {
                    nu[i] = 8327;
                    continue block12;
                }
                case '8': {
                    nu[i] = 8328;
                    continue block12;
                }
                case '9': {
                    nu[i] = 8329;
                }
            }
        }
        return new String(nu);
    }

    public static String superscriptNumbers(String b) {
        char[] chars = b.toCharArray();
        char[] nu = new char[chars.length];
        block12: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '0': {
                    nu[i] = 8304;
                    continue block12;
                }
                case '1': {
                    nu[i] = 185;
                    continue block12;
                }
                case '2': {
                    nu[i] = 178;
                    continue block12;
                }
                case '3': {
                    nu[i] = 179;
                    continue block12;
                }
                case '4': {
                    nu[i] = 8308;
                    continue block12;
                }
                case '5': {
                    nu[i] = 8309;
                    continue block12;
                }
                case '6': {
                    nu[i] = 8310;
                    continue block12;
                }
                case '7': {
                    nu[i] = 8311;
                    continue block12;
                }
                case '8': {
                    nu[i] = 8312;
                    continue block12;
                }
                case '9': {
                    nu[i] = 8313;
                    continue block12;
                }
                default: {
                    nu[i] = chars[i];
                }
            }
        }
        return new String(nu);
    }

    public static String superscriptNumber(Number b) {
        char[] chars = Long.toString(b.longValue()).toCharArray();
        char[] nu = new char[chars.length];
        block12: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '0': {
                    nu[i] = 8304;
                    continue block12;
                }
                case '1': {
                    nu[i] = 185;
                    continue block12;
                }
                case '2': {
                    nu[i] = 178;
                    continue block12;
                }
                case '3': {
                    nu[i] = 179;
                    continue block12;
                }
                case '4': {
                    nu[i] = 8308;
                    continue block12;
                }
                case '5': {
                    nu[i] = 8309;
                    continue block12;
                }
                case '6': {
                    nu[i] = 8310;
                    continue block12;
                }
                case '7': {
                    nu[i] = 8311;
                    continue block12;
                }
                case '8': {
                    nu[i] = 8312;
                    continue block12;
                }
                case '9': {
                    nu[i] = 8313;
                }
            }
        }
        return new String(nu);
    }

    public static byte specialToByte(int aSpecialValue) {
        int special = 0;
        if (aSpecialValue == -100) {
            special = 1;
        } else if (aSpecialValue == -200) {
            special = 2;
        } else if (aSpecialValue == -68) {
            special = 3;
        }
        return (byte)special;
    }

    public static boolean addBlockToMachine(int x, int y, int z, int offsetsize, IGregTechTileEntity aBaseMetaTileEntity, Block block) {
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * offsetsize;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * offsetsize;
        return block == Blocks.field_150350_a ? aBaseMetaTileEntity.getAirOffset(xDir + x, y, zDir + z) : aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(block);
    }

    public static boolean addBlockToMachine(int x, int y, int z, int offsetsize, IGregTechTileEntity aBaseMetaTileEntity, Block block, int damage) {
        byte dmg = (byte)damage;
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * offsetsize;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * offsetsize;
        return block == Blocks.field_150350_a ? aBaseMetaTileEntity.getAirOffset(xDir + x, y, zDir + z) : aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(block) && aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == dmg;
    }

    public static int calculateSv(Materials materials) {
        for (BioVatLogicAdder.MaterialSvPair pair : BioVatLogicAdder.RadioHatch.getMaSv()) {
            if (!pair.getMaterials().equals(materials)) continue;
            return pair.getSievert();
        }
        return (int)(materials.getProtons() == 43L ? (long)(materials.equals(Materials.NaquadahEnriched) ? 140 : (materials.equals(Materials.Naquadria) ? 150 : (materials.equals(Materials.Naquadah) ? 130 : 43))) : materials.getProtons());
    }

    public static ItemStack setStackSize(ItemStack stack, int size) {
        if (stack != null) {
            stack.field_77994_a = size;
        }
        return stack;
    }

    public static boolean checkStackAndPrefix(ItemStack itemStack) {
        return itemStack != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack) != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial != null;
    }

    public static Map<ItemStack, ItemStack[]> getInputsFromOutput(Collection<GT_Recipe> gt_recipes, ItemStack ... inputs) {
        return gt_recipes.stream().filter(ar -> Arrays.stream(inputs).anyMatch(st -> GT_Utility.areStacksEqual((ItemStack)st, (ItemStack)ar.mOutputs[0]))).collect(Collectors.toMap(k -> k.mOutputs[0], k -> k.mInputs));
    }

    public static Map<ItemStack, ItemStack[]> getAsslineInputsFromOutputs(ItemStack ... inputs) {
        return GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes.stream().filter(ar -> Arrays.stream(inputs).anyMatch(st -> GT_Utility.areStacksEqual((ItemStack)st, (ItemStack)ar.mOutput))).collect(Collectors.toMap(k -> k.mOutput, k -> k.mInputs));
    }

    public static int abstractHashGTRecipe(GT_Recipe recipe) {
        int hash = 31;
        hash += recipe.mDuration / 20 * 31;
        hash += GT_Utility.getTier((long)recipe.mEUt) * 31;
        hash += BW_Util.specialToByte(recipe.mSpecialValue) * 31;
        hash += recipe.mInputs.length * 31;
        for (ItemStack itemStack : recipe.mInputs) {
            if (itemStack == null) continue;
            hash += itemStack.field_77994_a * 31;
            hash += Item.func_150891_b((Item)itemStack.func_77973_b()) * 31;
        }
        hash += recipe.mOutputs.length * 31;
        for (ItemStack itemStack : recipe.mOutputs) {
            if (itemStack == null) continue;
            hash += itemStack.field_77994_a * 31;
            hash += Item.func_150891_b((Item)itemStack.func_77973_b()) * 31;
        }
        hash += recipe.mFluidInputs.length * 31;
        for (ItemStack itemStack : recipe.mFluidInputs) {
            if (itemStack == null) continue;
            hash += itemStack.amount * 31;
            hash += itemStack.getFluidID() * 31;
        }
        hash += recipe.mFluidOutputs.length * 31;
        for (ItemStack itemStack : recipe.mFluidOutputs) {
            if (itemStack == null) continue;
            hash += itemStack.amount * 31;
            hash += itemStack.getFluidID() * 31;
        }
        return hash;
    }

    public static <T> T[] copyAndRemoveNulls(T[] input, Class<T> clazz) {
        List ret = Arrays.stream(input).filter(Objects::nonNull).collect(Collectors.toList());
        if (ret.size() <= 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        Object[] retArr = (Object[])Array.newInstance(clazz, ret.size());
        for (int i = 0; i < ret.size(); ++i) {
            retArr[i] = ret.get(i);
        }
        return retArr;
    }

    public static int getMachineVoltageFromTier(int tier) {
        return (int)(30.0 * Math.pow(4.0, tier - 1));
    }

    public static long getTierVoltage(int tier) {
        return BW_Util.getTierVoltage((byte)tier);
    }

    public static long getTierVoltage(byte tier) {
        return 8L << 2 * tier;
    }

    public static byte getTier(long voltage) {
        if (voltage <= 0x7FFFFFF8L) {
            return GT_Utility.getTier((long)voltage);
        }
        byte t = 0;
        while (voltage > 8L) {
            voltage >>= 2;
            t = (byte)(t + 1);
        }
        return t;
    }

    public static String getTierName(byte tier) {
        if (GT_Values.VN.length - 1 <= tier) {
            return "MAX+";
        }
        return GT_Values.VN[tier];
    }

    public static String getTierNameFromVoltage(long voltage) {
        return BW_Util.getTierName(BW_Util.getTier(voltage));
    }

    public static boolean areStacksEqualOrNull(ItemStack aStack1, ItemStack aStack2) {
        return aStack1 == null && aStack2 == null || GT_Utility.areStacksEqual((ItemStack)aStack1, (ItemStack)aStack2);
    }

    public static boolean areStacksEqualOrEachNull(ItemStack aStack1, ItemStack aStack2) {
        return aStack1 == null || aStack2 == null || GT_Utility.areStacksEqual((ItemStack)aStack1, (ItemStack)aStack2);
    }

    public static byte getByteFromRarity(EnumRarity rarity) {
        if (rarity.equals((Object)EnumRarity.uncommon)) {
            return 1;
        }
        if (rarity.equals((Object)EnumRarity.epic)) {
            return 2;
        }
        if (rarity.equals((Object)EnumRarity.rare)) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static byte getTierFromGlasMeta(int meta) {
        byte ret;
        switch (meta) {
            case 1: {
                ret = 4;
                break;
            }
            case 2: 
            case 12: {
                ret = 5;
                break;
            }
            case 3: {
                ret = 6;
                break;
            }
            case 4: {
                ret = 7;
                break;
            }
            case 5: {
                ret = 8;
                break;
            }
            case 13: {
                ret = 9;
                break;
            }
            case 14: {
                ret = 10;
                break;
            }
            default: {
                ret = 3;
            }
        }
        return ret;
    }

    public static void calculateOverclockedNessMulti(@Nonnegative int aEUt, @Nonnegative int aDuration, @Nonnegative int mAmperage, @Nonnegative long maxInputVoltage, @Nonnull GT_MetaTileEntity_MultiBlockBase base) {
        BW_Util.calculateOverclockednessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, base, false);
    }

    public static void calculatePerfectOverclockedNessMulti(@Nonnegative int aEUt, @Nonnegative int aDuration, @Nonnegative int mAmperage, @Nonnegative long maxInputVoltage, @Nonnull GT_MetaTileEntity_MultiBlockBase base) {
        BW_Util.calculateOverclockednessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, base, true);
    }

    private static void calculateOverclockednessMultiInternal(@Nonnegative int aEUt, @Nonnegative int aDuration, @Nonnegative int mAmperage, @Nonnegative long maxInputVoltage, @Nonnull GT_MetaTileEntity_MultiBlockBase base, @Nonnull boolean perfectOC) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier((long)maxInputVoltage));
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                base.mEUt = 0x7FFFFFFE;
                base.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                base.mEUt = aEUt >> 2;
                base.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            base.mMaxProgresstime = aDuration;
            for (long tempEUt = Math.max(xEUt, GT_Values.V[1]); tempEUt <= GT_Values.V[mTier - 1] * (long)mAmperage; tempEUt <<= 2) {
                base.mMaxProgresstime = base.mMaxProgresstime >> (perfectOC ? 2 : 1);
                xEUt = base.mMaxProgresstime <= 0 ? xEUt >> 1 : xEUt << 2;
            }
            while (xEUt > maxInputVoltage && xEUt >= (long)aEUt) {
                xEUt >>= 2;
                base.mMaxProgresstime = base.mMaxProgresstime << (perfectOC ? 2 : 1);
            }
            if (xEUt < (long)aEUt) {
                xEUt <<= 2;
                base.mMaxProgresstime = base.mMaxProgresstime >> (perfectOC ? 2 : 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                base.mEUt = 0x7FFFFFFE;
                base.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                base.mEUt = (int)xEUt;
                if (base.mEUt == 0) {
                    base.mEUt = 1;
                }
                if (base.mMaxProgresstime <= 0) {
                    base.mMaxProgresstime = 1;
                }
            }
        }
    }

    public static long getnominalVoltage(GT_MetaTileEntity_MultiBlockBase base) {
        long rVoltage = 0L;
        long rAmperage = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : base.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rVoltage = Math.max(tHatch.getBaseMetaTileEntity().getInputVoltage(), rVoltage);
            rAmperage += tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rVoltage * rAmperage;
    }

    public static FluidStack[] getFluidsFromInputHatches(GT_MetaTileEntity_MultiBlockBase aBaseMetaTileEntity) {
        ArrayList<FluidStack> tmp = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input fip : aBaseMetaTileEntity.mInputHatches) {
            tmp.add(fip.getFluid());
        }
        return tmp.toArray(new FluidStack[0]);
    }

    public static ItemStack[] getItemsFromInputBusses(GT_MetaTileEntity_MultiBlockBase aBaseMetaTileEntity) {
        ArrayList<ItemStack> tmp = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_InputBus fip : aBaseMetaTileEntity.mInputBusses) {
            tmp.addAll(Arrays.asList(fip.mInventory));
        }
        return tmp.toArray(new ItemStack[0]);
    }

    public static EnumRarity getRarityFromByte(byte b) {
        switch (b) {
            case 1: {
                return EnumRarity.uncommon;
            }
            case 2: {
                return EnumRarity.rare;
            }
            case 3: {
                return EnumRarity.epic;
            }
        }
        return EnumRarity.common;
    }

    public static boolean check_layer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, Block block, int dmg, int offset, boolean insideCheck, Block inside, int dmginside, int aBaseCasingIndex) {
        return BW_Util.check_layer(aBaseMetaTileEntity, radius, yLevel, height, block, dmg, offset, false, insideCheck, inside, dmginside, aBaseCasingIndex);
    }

    public static boolean check_layer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, Block block, int dmg, int offset, int aBaseCasingIndex) {
        return BW_Util.check_layer(aBaseMetaTileEntity, radius, yLevel, height, block, dmg, offset, false, aBaseCasingIndex);
    }

    public static boolean check_layer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, Block block, int dmg, int offset, boolean controllerLayer, int aBaseCasingIndex) {
        return BW_Util.check_layer(aBaseMetaTileEntity, radius, yLevel, height, block, dmg, offset, controllerLayer, false, aBaseCasingIndex);
    }

    public static boolean check_layer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, Block block, int dmg, int offset, boolean controllerLayer, boolean freeCorners, int aBaseCasingIndex) {
        return BW_Util.check_layer(aBaseMetaTileEntity, radius, yLevel, height, block, dmg, offset, controllerLayer, freeCorners, false, block, dmg, true, aBaseCasingIndex);
    }

    public static boolean check_layer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, Block block, int dmg, int offset, boolean controllerLayer, boolean insideCheck, Block inside, int dmginside, int aBaseCasingIndex) {
        return BW_Util.check_layer(aBaseMetaTileEntity, radius, yLevel, height, block, dmg, offset, controllerLayer, false, insideCheck, inside, dmginside, true, aBaseCasingIndex);
    }

    public static boolean check_layer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, Block block, int dmg, int offset, boolean controllerLayer, boolean freeCorners, boolean insideCheck, Block inside, int dmginside, boolean allowHatches, int aBaseCasingIndex) {
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * offset;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * offset;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = yLevel; y < height; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean b;
                    if (freeCorners && Math.abs(x) == radius && Math.abs(z) == radius || controllerLayer && xDir + x == 0 && zDir + z == 0) continue;
                    boolean bl = b = Math.abs(x) < radius && Math.abs(z) != radius;
                    if (insideCheck && b && !(!inside.equals(Blocks.field_150350_a) ? aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(inside) : aBaseMetaTileEntity.getAirOffset(xDir + x, y, zDir + z))) {
                        if (!(aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == dmginside && dmginside <= -1 || allowHatches && (((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addDynamoToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addEnergyInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addMaintenanceToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addMufflerToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex)))) {
                            return false;
                        }
                    }
                    if (b || aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(block) || aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == dmg && dmg <= -1 || allowHatches && (((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addDynamoToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addEnergyInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addMaintenanceToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addMufflerToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex) || ((GT_MetaTileEntity_MultiBlockBase)aBaseMetaTileEntity.getMetaTileEntity()).addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + x, y, zDir + z), aBaseCasingIndex))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static List<Byte> getMetasFromLayer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, int offset, boolean controllerLayer, boolean freeCorners, boolean insideCheck) {
        ArrayList<Byte> ret = new ArrayList<Byte>();
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * offset;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * offset;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = yLevel; y < height; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean inside;
                    if (freeCorners && Math.abs(x) == radius && Math.abs(z) == radius || controllerLayer && xDir + x == 0 && zDir + z == 0) continue;
                    boolean bl = inside = Math.abs(x) < radius && Math.abs(z) != radius;
                    if (insideCheck && inside) {
                        ret.add(aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z));
                    }
                    if (inside) continue;
                    ret.add(aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z));
                }
            }
        }
        return ret;
    }

    public static byte getCircuitTierFromOreDictName(String name) {
        switch (name) {
            case "circuitPrimitive": {
                return 0;
            }
            case "circuitBasic": {
                return 1;
            }
            case "circuitGood": {
                return 2;
            }
            case "circuitAdvanced": {
                return 3;
            }
            case "circuitData": {
                return 4;
            }
            case "circuitElite": {
                return 5;
            }
            case "circuitMaster": {
                return 6;
            }
            case "circuitUltimate": {
                return 7;
            }
            case "circuitSuperconductor": {
                return 8;
            }
            case "circuitInfinite": {
                return 9;
            }
            case "circuitBio": {
                return 10;
            }
            case "circuitNano": 
            case "circuitOptical": {
                return 11;
            }
            case "circuitPiko": 
            case "circuitExotic": {
                return 12;
            }
            case "circuitQuantum": 
            case "circuitCosmic": {
                return 13;
            }
            case "circuitTranscendent": {
                return 14;
            }
        }
        return -1;
    }

    public static byte getCircuitTierFromItemStack(ItemStack stack) {
        for (String oreName : BW_Util.getOreNames(stack)) {
            byte tier = BW_Util.getCircuitTierFromOreDictName(oreName);
            if (tier == -1) continue;
            return tier;
        }
        return -1;
    }

    public static boolean isTieredCircuit(ItemStack stack) {
        return BW_Util.getCircuitTierFromItemStack(stack) != -1;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            ret.add(OreDictionary.getOreName((int)oreID));
        }
        return ret;
    }

    public static byte calculateGlassTier(@Nonnull Block block, @Nonnegative byte meta) {
        byte boroTier = BorosilicateGlass.getTier(block, meta);
        if (boroTier != -1) {
            return boroTier;
        }
        if (block.func_149739_a().equals("blockAlloyGlass")) {
            return 4;
        }
        if (block.equals(Blocks.field_150359_w)) {
            return 3;
        }
        for (BioVatLogicAdder.BlockMetaPair B : BioVatLogicAdder.BioVatGlass.getGlassMap().keySet()) {
            if (!B.getBlock().equals(block) || !B.getaByte().equals(meta)) continue;
            return BioVatLogicAdder.BioVatGlass.getGlassMap().get(B);
        }
        if (block.func_149688_o().equals(Material.field_151592_s)) {
            return 3;
        }
        return 0;
    }

    public static <T> IStructureElement<T> ofGlassTiered(final byte mintier, final byte maxtier, final byte notset, final BiConsumer<T, Byte> setter, final Function<T, Byte> getter, final int aDots) {
        return new IStructureElement<T>(){
            private final IStructureElement<T> placementDelegate;
            {
                this.placementDelegate = BorosilicateGlass.ofBoroGlass(notset, mintier, maxtier, setter, getter);
            }

            public boolean check(T te, World world, int x, int y, int z) {
                if (world.func_147437_c(x, y, z)) {
                    return false;
                }
                byte glasstier = BW_Util.calculateGlassTier(world.func_147439_a(x, y, z), (byte)world.func_72805_g(x, y, z));
                if (glasstier == 0) {
                    return false;
                }
                if (glasstier == notset) {
                    return false;
                }
                if (glasstier < mintier) {
                    return false;
                }
                if (glasstier > maxtier) {
                    return false;
                }
                if ((Byte)getter.apply(te) == notset) {
                    setter.accept(te, glasstier);
                }
                return (Byte)getter.apply(te) == glasstier;
            }

            public boolean spawnHint(T te, World world, int x, int y, int z, ItemStack itemStack) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(aDots - 1));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return this.placementDelegate.placeBlock(t, world, x, y, z, trigger);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return this.placementDelegate.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureElement<T> ofGlassTieredMixed(final byte mintier, final byte maxtier, final int aDots) {
        return new IStructureElement<T>(){
            private final IStructureElement<T> placementDelegate;
            {
                this.placementDelegate = BorosilicateGlass.ofBoroGlass((byte)0, mintier, maxtier, (v1, v2) -> {}, v1 -> (byte)0);
            }

            public boolean check(T te, World world, int x, int y, int z) {
                if (world.func_147437_c(x, y, z)) {
                    return false;
                }
                byte glasstier = BW_Util.calculateGlassTier(world.func_147439_a(x, y, z), (byte)world.func_72805_g(x, y, z));
                if (glasstier == 0) {
                    return false;
                }
                return glasstier >= mintier && glasstier <= maxtier;
            }

            public boolean spawnHint(T te, World world, int x, int y, int z, ItemStack itemStack) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(aDots - 1));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return this.placementDelegate.placeBlock(t, world, x, y, z, trigger);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return this.placementDelegate.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static List<IRecipe> getGTBufferedRecipeList() throws SecurityException, IllegalArgumentException, IllegalAccessException {
        if (sBufferedRecipeList == null) {
            sBufferedRecipeList = FieldUtils.getDeclaredField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true);
        }
        if (sBufferedRecipeList == null) {
            sBufferedRecipeList = FieldUtils.getField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true);
        }
        return (List)sBufferedRecipeList.get(null);
    }

    public static ShapedOreRecipe createGTCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return BW_Util.createGTCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & GT_ModHandler.RecipeBits.MIRRORED) != 0L, (aBitMask & GT_ModHandler.RecipeBits.BUFFERED) != 0L, (aBitMask & GT_ModHandler.RecipeBits.KEEPNBT) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & GT_ModHandler.RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & GT_ModHandler.RecipeBits.REVERSIBLE) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS) == 0L, (aBitMask & GT_ModHandler.RecipeBits.ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT) != 0L, (aBitMask & GT_ModHandler.RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL) != 0L, aRecipe);
    }

    public static ShapedOreRecipe createGTCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, Object[] aRecipe) {
        aResult = GT_OreDictUnificator.get((boolean)true, (ItemStack)aResult);
        if (aOnlyAddIfResultIsNotNull && aResult == null) {
            return null;
        }
        if (aResult != null && Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        if (aRecipe == null || aRecipe.length <= 0) {
            return null;
        }
        boolean tThereWasARecipe = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof ItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            StringBuilder shape = new StringBuilder("");
            int idx = 0;
            if (aRecipe[idx] instanceof Boolean) {
                throw new IllegalArgumentException();
            }
            ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
            while (aRecipe[idx] instanceof String) {
                StringBuilder s = new StringBuilder((String)aRecipe[idx++]);
                shape.append((CharSequence)s);
                while (s.length() < 3) {
                    s.append(" ");
                }
                if (s.length() > 3) {
                    throw new IllegalArgumentException();
                }
                block33: for (char c : s.toString().toCharArray()) {
                    switch (c) {
                        case 'b': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolBlade.name());
                            continue block33;
                        }
                        case 'c': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolCrowbar.name());
                            continue block33;
                        }
                        case 'd': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolScrewdriver.name());
                            continue block33;
                        }
                        case 'f': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolFile.name());
                            continue block33;
                        }
                        case 'h': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolHardHammer.name());
                            continue block33;
                        }
                        case 'i': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingIron.name());
                            continue block33;
                        }
                        case 'j': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingMetal.name());
                            continue block33;
                        }
                        case 'k': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolKnife.name());
                            continue block33;
                        }
                        case 'm': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolMortar.name());
                            continue block33;
                        }
                        case 'p': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolDrawplate.name());
                            continue block33;
                        }
                        case 'r': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSoftHammer.name());
                            continue block33;
                        }
                        case 's': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSaw.name());
                            continue block33;
                        }
                        case 'w': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWrench.name());
                            continue block33;
                        }
                        case 'x': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWireCutter.name());
                        }
                    }
                }
            }
            aRecipe = tRecipeList.toArray();
            if (aRecipe[idx] instanceof Boolean) {
                ++idx;
            }
            HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
            HashMap<Character, ItemData> tItemDataMap = new HashMap<Character, ItemData>();
            tItemStackMap.put(Character.valueOf(' '), null);
            boolean tRemoveRecipe = true;
            while (idx < aRecipe.length) {
                if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                    if (GT_Values.D1) {
                        GT_Log.err.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                        for (Object tContent : aRecipe) {
                            GT_Log.err.println(tContent);
                        }
                    }
                    return null;
                }
                Character chr = (Character)aRecipe[idx];
                Object in = aRecipe[idx + 1];
                if (in instanceof ItemStack) {
                    tItemStackMap.put(chr, GT_Utility.copy((Object[])new Object[]{in}));
                    tItemDataMap.put(chr, GT_OreDictUnificator.getItemData((ItemStack)((ItemStack)in)));
                } else if (in instanceof ItemData) {
                    String tString = in.toString();
                    switch (tString) {
                        case "plankWood": {
                            tItemDataMap.put(chr, new ItemData(Materials.Wood, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneNetherrack": {
                            tItemDataMap.put(chr, new ItemData(Materials.Netherrack, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneObsidian": {
                            tItemDataMap.put(chr, new ItemData(Materials.Obsidian, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneEndstone": {
                            tItemDataMap.put(chr, new ItemData(Materials.Endstone, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        default: {
                            tItemDataMap.put(chr, (ItemData)in);
                        }
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre((Object)in, (long)1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                    aRecipe[idx + 1] = in.toString();
                } else if (in instanceof String) {
                    if (in.equals(OreDictNames.craftingChest.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Wood, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingBook.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Paper, 10886400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingPiston.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 14515200L, Materials.Wood, 10886400L));
                    } else if (in.equals(OreDictNames.craftingFurnace.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingIndustrialDiamond.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Diamond, 3628800L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingAnvil.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Iron, 36288000L, new MaterialStack[0]));
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre((Object)in, (long)1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                idx += 2;
            }
            if (aReversible && aResult != null) {
                Object[] tData = new ItemData[9];
                int x = -1;
                for (char chr : shape.toString().toCharArray()) {
                    tData[++x] = (ItemData)tItemDataMap.get(Character.valueOf(chr));
                }
                if (GT_Utility.arrayContainsNonNull((Object[])tData)) {
                    GT_OreDictUnificator.addItemData((ItemStack)aResult, (ItemData)new ItemData((ItemData[])tData));
                }
            }
            if (aCheckForCollisions && tRemoveRecipe) {
                ItemStack[] tRecipe = new ItemStack[9];
                int x = -1;
                for (char chr : shape.toString().toCharArray()) {
                    tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                    if (tRecipe[x] == null || Items.field_151008_G.getDamage(tRecipe[x]) != Short.MAX_VALUE) continue;
                    Items.field_151008_G.setDamage(tRecipe[x], 0);
                }
                tThereWasARecipe = GT_ModHandler.removeRecipe((ItemStack[])tRecipe) != null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return null;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            boolean bl = tThereWasARecipe = GT_ModHandler.removeRecipeByOutput((ItemStack)aResult, (!aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT ? 1 : 0) != 0, (boolean)aRemoveAllOtherShapedsWithSameOutput, (boolean)aRemoveAllOtherNativeRecipes) || tThereWasARecipe;
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tThereWasARecipe) {
            ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
            int tList_sS = tList.size();
            for (int i = 0; i < tList_sS && !tThereWasARecipe; ++i) {
                IRecipe tRecipe = (IRecipe)tList.get(i);
                if (GT_ModHandler.sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) || !GT_Utility.areStacksEqual((ItemStack)GT_OreDictUnificator.get((ItemStack)tRecipe.func_77571_b()), (ItemStack)aResult, (boolean)true)) continue;
                tList.remove(i--);
                tList_sS = tList.size();
                tThereWasARecipe = true;
            }
        }
        if (Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE || Items.field_151008_G.getDamage(aResult) < 0) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        GT_Utility.updateItemStack((ItemStack)aResult);
        return new GT_Shaped_Recipe(GT_Utility.copy((Object[])new Object[]{aResult}), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored);
    }

    public static void shortSleep(long nanos) {
        try {
            long end;
            long start = System.nanoTime();
            while (start + nanos >= (end = System.nanoTime())) {
            }
        }
        catch (Exception e) {
            MainMod.LOGGER.catching((Throwable)e);
        }
    }
}

