/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.net;

import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_BioVat;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.Coords;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GT_Packet;
import java.nio.ByteBuffer;
import net.minecraft.world.IBlockAccess;

public class RendererPacket
extends GT_Packet {
    private Coords coords;
    private int integer;
    private byte removal;

    public RendererPacket() {
        super(true);
    }

    public RendererPacket(Coords coords, int integer, boolean removal) {
        super(false);
        this.coords = coords;
        this.integer = integer;
        this.removal = (byte)(removal ? 1 : 0);
    }

    public byte getPacketID() {
        return 0;
    }

    public byte[] encode() {
        byte r = (byte)((this.integer >> 16 & 0xFF) + -128);
        byte g = (byte)((this.integer >> 8 & 0xFF) + -128);
        byte b = (byte)((this.integer & 0xFF) + -128);
        byte checksum = (byte)(this.coords.x % 25 + this.coords.y % 25 + this.coords.z % 25 + this.coords.wID % 25 + this.integer % 25 + this.removal);
        return ByteBuffer.allocate(19).putInt(0, this.coords.x).putShort(4, this.coords.y).putInt(6, this.coords.z).putInt(10, this.coords.wID).put(14, r).put(15, g).put(16, b).put(17, this.removal).put(18, checksum).array();
    }

    public GT_Packet decode(ByteArrayDataInput dataInput) {
        byte[] buffer = new byte[19];
        dataInput.readFully(buffer);
        this.coords = new Coords(ByteBuffer.wrap(buffer).getInt(0), ByteBuffer.wrap(buffer).getShort(4), ByteBuffer.wrap(buffer).getInt(6), ByteBuffer.wrap(buffer).getInt(10));
        int[] rgb = new int[]{ByteBuffer.wrap(buffer).get(14) - -128, ByteBuffer.wrap(buffer).get(15) - -128, ByteBuffer.wrap(buffer).get(16) - -128};
        this.integer = BW_ColorUtil.getColorFromRGBArray(rgb);
        this.removal = ByteBuffer.wrap(buffer).get(17);
        byte checksum = (byte)(this.coords.x % 25 + this.coords.y % 25 + this.coords.z % 25 + this.coords.wID % 25 + this.integer % 25 + this.removal);
        if (checksum != ByteBuffer.wrap(buffer).get(18)) {
            MainMod.LOGGER.error("BW Packet was corrupted or modified!");
            return null;
        }
        return new RendererPacket(this.coords, this.integer, this.removal == 1);
    }

    public void process(IBlockAccess iBlockAccess) {
        if (SideReference.Side.Client) {
            if (this.removal == 0) {
                GT_TileEntity_BioVat.staticColorMap.put(this.coords, this.integer);
            } else {
                GT_TileEntity_BioVat.staticColorMap.remove(this.coords);
            }
        }
    }
}

