/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.tinkers.material;

import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.tinkers.HANDLER_Tinkers;
import gtPlusPlus.xmod.tinkers.util.TinkersUtils;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;

public class BaseTinkersMaterial {
    private static HashMap<String, Integer> aInternalMaterialIdMap = new HashMap();
    private static int aNextFreeID = 16803;
    public final String mLocalName;
    private final String mUnlocalName;
    private final int mID;
    private final Material mMaterial;

    public BaseTinkersMaterial(Material aMaterial) {
        this.mLocalName = aMaterial.getLocalizedName();
        this.mUnlocalName = "material.gtpp." + Utils.sanitizeString(this.mLocalName);
        this.mMaterial = aMaterial;
        this.mID = aNextFreeID++;
        Logger.INFO("[TiCon] Assigning ID " + this.mID + " to " + this.mLocalName + ".");
        aInternalMaterialIdMap.put(this.mUnlocalName, this.mID);
        HANDLER_Tinkers.mTinkerMaterials.put(this);
    }

    public String getUnlocalName() {
        return this.mUnlocalName;
    }

    private static int calcDurability(Material aMaterial) {
        return MathUtils.safeCast_LongToInt(aMaterial.vDurability);
    }

    private static int calcMiningSpeed(Material aMaterial) {
        return aMaterial.vHarvestLevel * 2 + aMaterial.vTier;
    }

    private static int calcHarvestLevel(Material aMaterial) {
        return aMaterial.vHarvestLevel;
    }

    private static int calcAttack(Material aMaterial) {
        return aMaterial.vHarvestLevel + aMaterial.vTier + aMaterial.vRadiationLevel;
    }

    private static float calcHandleModifier(Material aMaterial) {
        return 1.0f;
    }

    private static int calcReinforced(Material aMaterial) {
        return aMaterial.getMeltingPointC() / 3600;
    }

    private static int calcBowProjectileSpeed(Material aMaterial) {
        return aMaterial.vHarvestLevel + 2;
    }

    private static int calcBowDrawSpeed(Material aMaterial) {
        return aMaterial.vHarvestLevel + 8;
    }

    private static float calcProjectileMass(Material aMaterial) {
        return (float)(aMaterial.getMeltingPointC() / 1800) * 0.1f;
    }

    private static float calcProjectileFragility(Material aMaterial) {
        return 0.0f;
    }

    private static String calcStyle(Material aMaterial) {
        String aReturn = "" + EnumChatFormatting.WHITE;
        int aTemp = aMaterial.getMeltingPointC();
        aReturn = aTemp < 3600 ? "" + EnumChatFormatting.WHITE : (aTemp >= 3600 ? "" + EnumChatFormatting.YELLOW : (aTemp >= 7200 ? "" + EnumChatFormatting.GREEN : (aTemp >= 10800 ? "" + EnumChatFormatting.RED : (aTemp >= 14400 ? "" + EnumChatFormatting.DARK_RED : "" + EnumChatFormatting.GOLD))));
        return aReturn;
    }

    private static int calcColour(Material aMaterial) {
        return aMaterial.getRgbAsHex();
    }

    public Object generateToolMaterial(Material aMaterial) {
        int level = BaseTinkersMaterial.calcHarvestLevel(aMaterial);
        int dura = BaseTinkersMaterial.calcDurability(aMaterial);
        int speed = BaseTinkersMaterial.calcMiningSpeed(aMaterial);
        int dmg = BaseTinkersMaterial.calcAttack(aMaterial);
        int reinf = BaseTinkersMaterial.calcReinforced(aMaterial);
        int primColour = BaseTinkersMaterial.calcColour(aMaterial);
        float handle = BaseTinkersMaterial.calcHandleModifier(aMaterial);
        float stonebound = 0.0f;
        return TinkersUtils.generateToolMaterial(aMaterial.getLocalizedName(), aMaterial.getUnlocalizedName(), level, dura, speed, dmg, handle, reinf, stonebound, BaseTinkersMaterial.calcStyle(aMaterial), primColour);
    }

    public void generate() {
        Logger.INFO("[TiCon] Trying to generate Material: " + this.mLocalName);
        int id = this.mID;
        if (id > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Id", id);
            tag.func_74778_a("Name", this.mUnlocalName);
            tag.func_74778_a("localizationString", this.mLocalName);
            tag.func_74768_a("Durability", BaseTinkersMaterial.calcDurability(this.mMaterial));
            tag.func_74768_a("MiningSpeed", BaseTinkersMaterial.calcMiningSpeed(this.mMaterial));
            tag.func_74768_a("HarvestLevel", BaseTinkersMaterial.calcHarvestLevel(this.mMaterial));
            tag.func_74768_a("Attack", BaseTinkersMaterial.calcAttack(this.mMaterial));
            tag.func_74776_a("HandleModifier", BaseTinkersMaterial.calcHandleModifier(this.mMaterial));
            tag.func_74768_a("Reinforced", BaseTinkersMaterial.calcReinforced(this.mMaterial));
            tag.func_74776_a("Bow_ProjectileSpeed", (float)BaseTinkersMaterial.calcBowProjectileSpeed(this.mMaterial));
            tag.func_74768_a("Bow_DrawSpeed", BaseTinkersMaterial.calcBowDrawSpeed(this.mMaterial));
            tag.func_74776_a("Projectile_Mass", BaseTinkersMaterial.calcProjectileMass(this.mMaterial));
            tag.func_74776_a("Projectile_Fragility", BaseTinkersMaterial.calcProjectileFragility(this.mMaterial));
            tag.func_74778_a("Style", BaseTinkersMaterial.calcStyle(this.mMaterial));
            tag.func_74768_a("Color", BaseTinkersMaterial.calcColour(this.mMaterial));
            boolean generate = this.generateRecipes(this.mMaterial, id);
            if (generate) {
                Logger.INFO("[TiCon] Sending IMC: addMaterial - " + this.mLocalName + ".");
                FMLInterModComms.sendMessage((String)Mods.TinkerConstruct.ID, (String)"addMaterial", (NBTTagCompound)tag);
                ItemStack itemstack = this.mMaterial.getIngot(1);
                tag = new NBTTagCompound();
                tag.func_74768_a("MaterialId", id);
                NBTTagCompound item = new NBTTagCompound();
                itemstack.func_77955_b(item);
                tag.func_74782_a("Item", (NBTBase)item);
                tag.func_74768_a("Value", 2);
                Logger.INFO("[TiCon] Sending IMC: addPartBuilderMaterial - " + this.mLocalName + ".");
                FMLInterModComms.sendMessage((String)Mods.TinkerConstruct.ID, (String)"addPartBuilderMaterial", (NBTTagCompound)tag);
                tag = new NBTTagCompound();
                tag.func_74768_a("MaterialId", id);
                tag.func_74768_a("Value", 2);
                item = new NBTTagCompound();
                itemstack.func_77955_b(item);
                tag.func_74782_a("Item", (NBTBase)item);
                Logger.INFO("[TiCon] Sending IMC: addMaterialItem - " + this.mLocalName + ".");
                FMLInterModComms.sendMessage((String)Mods.TinkerConstruct.ID, (String)"addMaterialItem", (NBTTagCompound)tag);
            }
        }
    }

    private boolean generateRecipes(Material aMaterial, int aID) {
        Fluid aFluid;
        Integer aMelt;
        Block aMatBlock;
        try {
            aMatBlock = aMaterial.getBlock();
            aMelt = aMaterial.getMeltingPointC();
            aFluid = aMaterial.getFluidStack(0).getFluid();
        }
        catch (Throwable t) {
            return false;
        }
        if (aMatBlock == null || aMelt == null || aFluid == null) {
            return false;
        }
        TinkersUtils.registerFluidType(this.mLocalName, aMatBlock, 0, aMelt, aFluid, true);
        TinkersUtils.addMelting(aMaterial.getBlock(1), aMatBlock, 0, aMelt, aMaterial.getFluidStack(1296));
        TinkersUtils.addMelting(aMaterial.getIngot(1), aMatBlock, 0, aMelt, aMaterial.getFluidStack(144));
        if (aMelt <= 3600) {
            ItemStack ingotcast = TinkersUtils.getPattern(1);
            TinkersUtils.addBasinRecipe(aMaterial.getBlock(1), aMaterial.getFluidStack(1296), null, true, 100);
            TinkersUtils.addCastingTableRecipe(aMaterial.getIngot(1), aMaterial.getFluidStack(144), ingotcast, false, 50);
        }
        boolean extended = TinkersUtils.generateCastingRecipes(aMaterial, aID);
        return true;
    }
}

