/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialRockBreaker
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialRockBreaker>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialRockBreaker> STRUCTURE_DEFINITION = null;
    private static final GT_Recipe.GT_Recipe_Map sFakeRecipeMap = new GT_Recipe.GT_Recipe_Map(new HashSet(0), "gt.recipe.fakerockbreaker", "Rock Breaker", "smelting", "", 1, 1, 0, 0, 1, "", 1, "", true, false);
    private static GT_Recipe sRecipe_Cobblestone;
    private static GT_Recipe sRecipe_SmoothStone;
    private static GT_Recipe sRecipe_Redstone;

    public GregtechMetaTileEntity_IndustrialRockBreaker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialRockBreaker(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialRockBreaker(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Rock Breaker";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Rock Breaker").addInfo("Speed: +200% | EU Usage: 75% | Parallel: Tier x 8").addInfo("Circuit goes in the GUI slot").addInfo("1 = cobble, 2 = stone, 3 = obsidian").addInfo("Supply Water/Lava").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 4, 3, true).addController("Bottom Center").addCasingInfoMin("Thermal Processing Casing", 9, false).addCasingInfoMin("Thermal Containment Casing", 16, false).addInputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialRockBreaker> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialRockBreaker.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.GTPP_INDEX(16)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)0))})).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)11)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        boolean aCheckPiece = this.checkPiece(this.mName, 1, 3, 0);
        boolean aCasingCount = this.mCasing >= 9;
        boolean aCheckHatch = this.checkHatch();
        this.log("" + aCheckPiece + ", " + aCasingCount + ", " + aCheckHatch);
        return aCheckPiece && aCasingCount && aCheckHatch;
    }

    @Override
    public String getSound() {
        return SoundResource.IC2_MACHINES_INDUCTION_LOOP.toString();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(16);
    }

    private static void generateRecipeMap() {
        if (sRecipe_Cobblestone == null || sRecipe_SmoothStone == null || sRecipe_Redstone == null) {
            GregtechMetaTileEntity_IndustrialRockBreaker.generateRecipes();
        }
        FluidStack[] aInputFluids = new FluidStack[]{FluidUtils.getWater(1000), FluidUtils.getLava(1000)};
        GT_Recipe aTemp = sRecipe_Cobblestone.copy();
        aTemp.mFluidInputs = aInputFluids;
        sFakeRecipeMap.add(aTemp);
        aTemp = sRecipe_SmoothStone.copy();
        aTemp.mFluidInputs = aInputFluids;
        sFakeRecipeMap.add(aTemp);
        aTemp = sRecipe_Redstone.copy();
        aTemp.mFluidInputs = aInputFluids;
        sFakeRecipeMap.add(aTemp);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (GregtechMetaTileEntity_IndustrialRockBreaker.sFakeRecipeMap.mRecipeList.isEmpty()) {
            GregtechMetaTileEntity_IndustrialRockBreaker.generateRecipeMap();
        }
        return sFakeRecipeMap;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private static final void generateRecipes() {
        sRecipe_Cobblestone = new GTPP_Recipe(false, new ItemStack[]{CI.getNumberedCircuit(1)}, new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150347_e)}, null, new int[]{10000}, null, null, 16, 32, 0);
        sRecipe_SmoothStone = new GTPP_Recipe(false, new ItemStack[]{CI.getNumberedCircuit(2)}, new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150348_b)}, null, new int[]{10000}, null, null, 16, 32, 0);
        sRecipe_Redstone = new GTPP_Recipe(false, new ItemStack[]{CI.getNumberedCircuit(3), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Redstone, (long)1L)}, new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150343_Z)}, null, new int[]{10000}, null, null, 128, 32, 0);
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList aFluids = this.getStoredFluids();
        if (!aFluids.isEmpty()) {
            boolean aHasWater = false;
            boolean aHasLava = false;
            for (FluidStack aFluid : aFluids) {
                if (aFluid.getFluid() == FluidRegistry.WATER) {
                    aHasWater = true;
                    continue;
                }
                if (aFluid.getFluid() != FluidRegistry.LAVA) continue;
                aHasLava = true;
            }
            ArrayList<ItemStack> aItems = this.getStoredInputs();
            boolean aHasRedstone = false;
            if (!aItems.isEmpty()) {
                for (ItemStack aItem : aItems) {
                    if (!GT_Utility.areStacksEqual((ItemStack)aItem, (ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Redstone, (long)1L))) continue;
                    aHasRedstone = true;
                    break;
                }
            }
            if (!aHasWater || !aHasLava) {
                return false;
            }
            ItemStack aGuiCircuit = this.getGUIItemStack();
            if (aGuiCircuit == null || !ItemUtils.isControlCircuit(aGuiCircuit)) {
                return false;
            }
            if (sRecipe_Cobblestone == null || sRecipe_SmoothStone == null || sRecipe_Redstone == null) {
                GregtechMetaTileEntity_IndustrialRockBreaker.generateRecipes();
            }
            int aCircuit = aGuiCircuit.func_77960_j();
            GT_Recipe tRecipe = null;
            switch (aCircuit) {
                case 1: {
                    tRecipe = sRecipe_Cobblestone;
                    break;
                }
                case 2: {
                    tRecipe = sRecipe_SmoothStone;
                    break;
                }
                case 3: {
                    if (!aHasRedstone) break;
                    tRecipe = sRecipe_Redstone;
                }
            }
            if (tRecipe == null) {
                return false;
            }
            ItemStack[] aItemInputs = aItems.toArray(new ItemStack[aItems.size()]);
            FluidStack[] aFluidInputs = new FluidStack[]{};
            this.lEUt = 0L;
            this.mMaxProgresstime = 0;
            this.mOutputItems = new ItemStack[0];
            this.mOutputFluids = new FluidStack[0];
            long tVoltage = this.getMaxInputVoltage();
            long tEnergy = this.getMaxInputEnergy();
            this.mLastRecipe = tRecipe;
            int aMaxParallelRecipes = this.getMaxParallelRecipes();
            int aEUPercent = this.getEuDiscountForParallelism();
            int aSpeedBonusPercent = 200;
            GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe(tRecipe).setItemInputs(aItemInputs).setFluidInputs(aFluidInputs).setAvailableEUt(tEnergy).setMaxParallel(aMaxParallelRecipes).enableConsumption().enableOutputCalculation().setEUtModifier((float)aEUPercent / 100.0f).setController((GT_MetaTileEntity_MultiBlockBase)this);
            if (this.batchMode) {
                helper.enableBatchMode(128);
            }
            helper.build();
            if (helper.getCurrentParallel() == 0) {
                return false;
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setEUt(tEnergy).setDuration(tRecipe.mDuration).setEUtDiscount((float)aEUPercent / 100.0f).setSpeedBoost(100.0f / (100.0f + (float)aSpeedBonusPercent)).setParallel((int)Math.floor((float)helper.getCurrentParallel() / helper.getDurationMultiplier())).calculate();
            this.lEUt = -calculator.getConsumption();
            this.mMaxProgresstime = (int)Math.ceil((float)calculator.getDuration() * helper.getDurationMultiplier());
            this.mOutputItems = helper.getItemOutputs();
            this.mOutputFluids = helper.getFluidOutputs();
            this.updateSlots();
            this.startProcess();
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 75;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialRockBreaker;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 2;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList aInputs = super.getStoredInputs();
        if (this.getGUIItemStack() != null) {
            aInputs.add(this.getGUIItemStack());
        }
        return aInputs;
    }
}

