/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.helpers.autocrafter.AC_Helper_Utils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT4Entity_AutoCrafter
extends GregtechMeta_MultiBlockBase<GT4Entity_AutoCrafter>
implements ISurvivalConstructable {
    protected GT_Recipe lastRecipeToBuffer;
    private int casing;
    private static IStructureDefinition<GT4Entity_AutoCrafter> STRUCTURE_DEFINITION = null;

    public void onRightclick(EntityPlayer player) {
    }

    public GT4Entity_AutoCrafter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT4Entity_AutoCrafter(String mName) {
        super(mName);
    }

    @Override
    public String getMachineType() {
        return "Assembler";
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new GT4Entity_AutoCrafter(this.mName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiAutoCrafter;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Highly Advanced Assembling Machine").addInfo("200% faster than using single block machines of the same voltage").addInfo("Processes two items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoRange("Bulk Production Frame", 10, 25, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 10);
    }

    public IStructureDefinition<GT4Entity_AutoCrafter> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT4Entity_AutoCrafter.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.buildPiece(this.mName, itemStack, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack itemStack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, itemStack, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity baseMetaTileEntity, ItemStack itemStack) {
        this.casing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.casing >= 10 && this.checkHatch();
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sAssemblerRecipes;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        FluidStack[] properArray = this.getStoredFluids().toArray(new FluidStack[0]);
        for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
            ArrayList<ItemStack> tBusItems = new ArrayList<ItemStack>();
            if (GT4Entity_AutoCrafter.isValidMetaTileEntity((MetaTileEntity)bus)) {
                for (int i = bus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                    if (bus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                    tBusItems.add(bus.getBaseMetaTileEntity().func_70301_a(i));
                }
            }
            if (!this.checkRecipeGeneric(tBusItems.toArray(new ItemStack[0]), properArray, this.getMaxParallelRecipes(), 100L, 200, 10000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * Math.max(1, GT_Utility.getTier((long)this.getMaxInputVoltage()));
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    @Override
    public String[] getExtraInfoData() {
        String running = this.mMaxProgresstime > 0 ? "Auto-Crafter running" : "Auto-Crafter stopped";
        String maintenance = this.getIdealStatus() == this.getRepairStatus() ? "No Maintenance issues" : "Needs Maintenance";
        String tSpecialText = this.lastRecipeToBuffer != null && this.lastRecipeToBuffer.mOutputs[0].func_82833_r() != null ? "Currently processing: " + this.lastRecipeToBuffer.mOutputs[0].func_82833_r() : "Currently processing: Nothing";
        return new String[]{"Large Scale Auto-Assembler v1.01c", running, maintenance, tSpecialText};
    }

    @Override
    public void explodeMultiblock() {
        AC_Helper_Utils.removeCrafter(this);
        super.explodeMultiblock();
    }

    public void doExplosion(long aExplosionPower) {
        AC_Helper_Utils.removeCrafter(this);
        super.doExplosion(aExplosionPower);
    }
}

