/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMetaTileEntity;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaGarbageCollector
extends GregtechMetaTileEntity {
    long mLastCleanup = 0L;
    long mLocalTickVar = 0L;
    int mFrequency = 5;

    public GregtechMetaGarbageCollector(String aName, String aNameRegional, String aDescription) {
        super(991, aName, aNameRegional, 5, 0, aDescription, new ITexture[0]);
    }

    public GregtechMetaGarbageCollector(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 5, 0, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.mDescription, "Can request the JVM to perform garbage collection", "Configurable to run once every 5 minute interval (5-180)", "This Machine has no recipe", "Admin Tool, Limit one per world if possible", CORE.GT_Tooltip.get()};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_RedSteel)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_RedSteel)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_Grisium)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_Grisium)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redox_3)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_RedSteel)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_RedSteel)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_Grisium)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_Grisium)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redox_3)};
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mFrequency = this.mFrequency < 180 ? (this.mFrequency += 5) : 5;
        PlayerUtils.messagePlayer(aPlayer, "Running every " + this.mFrequency + " minutes.");
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaGarbageCollector(this.mName, this.mDescription, this.mTextures);
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isElectric() {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isEnetInput() {
        return false;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxEUStore() {
        return 0L;
    }

    public int getCapacity() {
        return 0;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 0L;
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }

    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.showPollution(aPlayer.func_130014_f_(), aPlayer);
        return true;
    }

    private void showPollution(World worldIn, EntityPlayer playerIn) {
        PlayerUtils.messagePlayer(playerIn, "Running every " + this.mFrequency + " minutes. Owner: " + this.getBaseMetaTileEntity().getOwnerName());
        long aDiff = this.mLocalTickVar - this.mLastCleanup;
        PlayerUtils.messagePlayer(playerIn, "Last run: " + Utils.getSecondsFromMillis(aDiff) + " seconds ago.");
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public String[] getInfoData() {
        return new String[]{this.getLocalName()};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
    }

    public void loadNBTData(NBTTagCompound aNBT) {
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.mLocalTickVar = System.currentTimeMillis();
            long aDiff = this.mLocalTickVar - this.mLastCleanup;
            if (Utils.getSecondsFromMillis(aDiff) >= (long)(this.mFrequency * 60)) {
                System.gc();
                this.mLastCleanup = this.mLocalTickVar;
            }
        }
    }
}

