/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.custom.power;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.CustomMetaTileBase;
import gtPlusPlus.xmod.gregtech.common.Meta_GT_Proxy;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public abstract class MetaTileEntityCustomPower
extends CustomMetaTileBase {
    public MetaTileEntityCustomPower(int aID, String aBasicName, String aRegionalName, int aInvSlotCount) {
        super(aID, aBasicName, aRegionalName, aInvSlotCount);
        this.setBaseMetaTileEntity((IGregTechTileEntity)Meta_GT_Proxy.constructBaseMetaTileEntityCustomPower());
        this.getBaseMetaTileEntity().setMetaTileID((short)aID);
    }

    public MetaTileEntityCustomPower(String aStack, int aInvSlotCount) {
        super(aStack, aInvSlotCount);
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public boolean doesExplode() {
        return this.getBaseCustomMetaTileEntity().doesExplode();
    }

    public void doExplosion(long aExplosionPower) {
        if (!this.doesExplode()) {
            Logger.INFO("Machine tried to explode, let's stop that. xo [doExplosion]");
            return;
        }
        float tStrength = aExplosionPower < GT_Values.V[0] ? 1.0f : (aExplosionPower < GT_Values.V[1] ? 2.0f : (aExplosionPower < GT_Values.V[2] ? 3.0f : (aExplosionPower < GT_Values.V[3] ? 4.0f : (aExplosionPower < GT_Values.V[4] ? 5.0f : (aExplosionPower < GT_Values.V[4] * 2L ? 6.0f : (aExplosionPower < GT_Values.V[5] ? 7.0f : (aExplosionPower < GT_Values.V[6] ? 8.0f : (aExplosionPower < GT_Values.V[7] ? 9.0f : 10.0f))))))));
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        GT_Utility.sendSoundToPlayers((World)tWorld, (SoundResource)SoundResource.IC2_MACHINES_MACHINE_OVERLOAD, (float)1.0f, (float)-1.0f, (int)tX, (int)tY, (int)tZ);
        tWorld.func_147449_b(tX, (int)tY, tZ, Blocks.field_150350_a);
        if (GregTech_API.sMachineExplosions) {
            tWorld.func_72876_a((Entity)null, (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStrength, true);
        }
    }

    public void onExplosion() {
        if (!this.doesExplode()) {
            Logger.INFO("Machine tried to explode, let's stop that. xo [onExplosion]");
            return;
        }
        super.onExplosion();
    }

    public boolean isElectric() {
        return true;
    }

    public long getEUVar() {
        return super.getEUVar();
    }
}

