/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.legacylootgames.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.client.IconLoader;
import ru.timeconqueror.timecore.api.util.RandHelper;

public class DungeonBrick
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] mIcons;

    public DungeonBrick() {
        super(Material.field_151576_e);
        this.func_149663_c("dungeonBrick");
        this.func_149647_a(LootGames.CREATIVE_TAB);
        this.func_149711_c(10.0f);
        this.func_149752_b(6.0f);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 6));
    }

    public int func_149692_a(int meta) {
        int tRetMeta = meta;
        if (meta == Type.CEILING.ordinal() || meta == Type.FLOOR.ordinal() || meta == Type.WALL.ordinal()) {
            tRetMeta = meta + RandHelper.flipCoin(0, 3);
        }
        return tRetMeta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.mIcons = new IIcon[6];
        this.mIcons[0] = register.func_94245_a("LootGames:dungeon_wall");
        this.mIcons[1] = register.func_94245_a("LootGames:dungeon_ceiling");
        this.mIcons[2] = register.func_94245_a("LootGames:dungeon_floor");
        this.mIcons[3] = register.func_94245_a("LootGames:cracked_dungeon_wall");
        this.mIcons[4] = register.func_94245_a("LootGames:cracked_dungeon_ceiling");
        this.mIcons[5] = register.func_94245_a("LootGames:cracked_dungeon_floor");
    }

    public int getHarvestLevel(int metadata) {
        int tHarvestLevel = super.getHarvestLevel(metadata);
        if (metadata == Type.CEILING.ordinal() || metadata == Type.FLOOR.ordinal() || metadata == Type.WALL.ordinal()) {
            tHarvestLevel = 4;
        } else if (metadata == Type.CEILING_CRACKED.ordinal() || metadata == Type.FLOOR_CRACKED.ordinal() || metadata == Type.WALL_CRACKED.ordinal()) {
            tHarvestLevel = 2;
        }
        return tHarvestLevel;
    }

    public String getHarvestTool(int metadata) {
        return "pickaxe";
    }

    public float func_149712_f(World pWorld, int pX, int pY, int pZ) {
        int tMeta = pWorld.func_72805_g(pX, pY, pZ);
        float tBlockHardness = super.func_149712_f(pWorld, pX, pY, pZ);
        if (tMeta == Type.FLOOR_SHIELDED.ordinal()) {
            tBlockHardness = -1.0f;
        } else if (tMeta == Type.CEILING_CRACKED.ordinal() || tMeta == Type.FLOOR_CRACKED.ordinal() || tMeta == Type.WALL_CRACKED.ordinal()) {
            tBlockHardness = 2.0f;
        }
        return tBlockHardness;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int pSide, int pMeta) {
        if (pMeta == 6) {
            return IconLoader.shieldedDungeonFloor;
        }
        return this.mIcons[pMeta];
    }

    public static enum Type {
        WALL,
        CEILING,
        FLOOR,
        WALL_CRACKED,
        CEILING_CRACKED,
        FLOOR_CRACKED,
        FLOOR_SHIELDED;

    }
}

