/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.light;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.blocks.HEWater;
import com.sinthoras.hydroenergy.client.HEClient;
import com.sinthoras.hydroenergy.client.light.HELightChunk;
import com.sinthoras.hydroenergy.config.HEConfig;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@SideOnly(value=Side.CLIENT)
public class HELightManager {
    private static final float[] waterLevelOfLastUpdate = new float[HEConfig.maxDams];
    private static final long[] timestampsNextUpdate = new long[HEConfig.maxDams];
    private static final HashMap<Long, HELightChunk> chunks = new HashMap();
    private static final Stack<HELightChunk> availableBuffers = new Stack();

    public static void onChunkUnload(int chunkX, int chunkZ) {
        long key = HEUtil.chunkCoordsToKey(chunkX, chunkZ);
        if (chunks.containsKey(key)) {
            HELightChunk lightChunk = chunks.get(key);
            lightChunk.reset();
            availableBuffers.push(lightChunk);
            chunks.remove(key);
        }
    }

    public static void onChunkDataLoad(Chunk chunk) {
        int chunkX = chunk.field_76635_g;
        int chunkZ = chunk.field_76647_h;
        long key = HEUtil.chunkCoordsToKey(chunkX, chunkZ);
        HELightChunk lightChunk = chunks.get(key);
        if (lightChunk == null) {
            lightChunk = availableBuffers.empty() ? new HELightChunk() : availableBuffers.pop();
        }
        lightChunk.reset();
        lightChunk.parseChunk(chunk);
        chunks.put(key, lightChunk);
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            lightChunk.patchSubChunk(chunk, chunkY);
            if (!lightChunk.hasWaterInSubchunk(HEUtil.chunkYToFlag(chunkY))) continue;
            HELightManager.markChunkForRerender(Minecraft.func_71410_x().field_71438_f, chunkX, chunkY, chunkZ);
        }
    }

    public static void onSetBlock(int blockX, int blockY, int blockZ, Block block, Block oldBlock) {
        if (block instanceof HEWater) {
            int waterId = ((HEWater)block).getWaterId();
            int chunkX = HEUtil.coordBlockToChunk(blockX);
            int chunkZ = HEUtil.coordBlockToChunk(blockZ);
            long key = HEUtil.chunkCoordsToKey(chunkX, chunkZ);
            chunks.get(key).addWaterBlock(blockX, blockY, blockZ, waterId);
        } else if (oldBlock instanceof HEWater) {
            int chunkX = HEUtil.coordBlockToChunk(blockX);
            int chunkZ = HEUtil.coordBlockToChunk(blockZ);
            long key = HEUtil.chunkCoordsToKey(chunkX, chunkZ);
            chunks.get(key).removeWaterBlock(blockX, blockY, blockZ);
        }
    }

    public static void onLightUpdate(Chunk chunk, int blockX, int blockY, int blockZ) {
        if (chunk.func_150810_a(blockX, blockY, blockZ) instanceof HEWater) {
            long key = HEUtil.chunkCoordsToKey(chunk.field_76635_g, chunk.field_76647_h);
            chunks.get(key).patchBlock(chunk, blockX, blockY, blockZ);
        }
    }

    public static void onPreRender(World world, int blockX, int blockY, int blockZ) {
        int chunkX = HEUtil.coordBlockToChunk(blockX);
        int chunkY = HEUtil.coordBlockToChunk(blockY);
        int chunkZ = HEUtil.coordBlockToChunk(blockZ);
        long key = HEUtil.chunkCoordsToKey(chunkX, chunkZ);
        HELightChunk lightChunk = chunks.get(key);
        lightChunk.patchSubChunk(world.func_72964_e(chunkX, chunkZ), chunkY);
    }

    public static void onTick() {
        long currentTime = System.currentTimeMillis();
        for (int waterId = 0; waterId < HEConfig.maxDams; ++waterId) {
            float currentWaterLevel = HEClient.getDam(waterId).getWaterLevelForPhysicsAndLighting();
            if (!(Math.abs(waterLevelOfLastUpdate[waterId] - currentWaterLevel) > 0.16666667f) || currentTime - timestampsNextUpdate[waterId] < 0L) continue;
            HELightManager.timestampsNextUpdate[waterId] = currentTime;
            HELightManager.triggerLightingUpdate(waterId, currentWaterLevel, waterLevelOfLastUpdate[waterId]);
            HELightManager.waterLevelOfLastUpdate[waterId] = currentWaterLevel;
        }
    }

    public static void triggerLightingUpdate(int waterId, float waterLevel, float oldWaterLevel) {
        RenderGlobal renderGlobal = Minecraft.func_71410_x().field_71438_f;
        for (long key : chunks.keySet()) {
            HELightChunk chunk = chunks.get(key);
            if (!chunk.hasUpdateForDam(waterId)) continue;
            int chunkX = (int)(key >> 32);
            int chunkZ = (int)key;
            long keyWest = HEUtil.chunkCoordsToKey(chunkX - 1, chunkZ);
            long keyNorth = HEUtil.chunkCoordsToKey(chunkX, chunkZ - 1);
            long keyEast = HEUtil.chunkCoordsToKey(chunkX + 1, chunkZ);
            long keySouth = HEUtil.chunkCoordsToKey(chunkX, chunkZ + 1);
            HELightChunk neighborChunkWest = chunks.get(keyWest);
            HELightChunk neighborChunkNorth = chunks.get(keyNorth);
            HELightChunk neighborChunkEast = chunks.get(keyEast);
            HELightChunk neighborChunkSouth = chunks.get(keySouth);
            for (int chunkY = 0; chunkY < 16; ++chunkY) {
                short flagChunkY;
                boolean chunkTooHigh;
                int blockY = HEUtil.coordChunkToBlock(chunkY);
                boolean chunkTooLow = (float)(blockY + 16 + HE.underWaterSkylightDepth) < waterLevel && (float)(blockY + 16 + HE.underWaterSkylightDepth) < oldWaterLevel;
                boolean bl = chunkTooHigh = (float)blockY > waterLevel && (float)blockY > oldWaterLevel;
                if (chunkTooLow || chunkTooHigh || !chunk.hasWaterInSubchunk(flagChunkY = HEUtil.chunkYToFlag(chunkY))) continue;
                chunk.subChunkMustBePatched(flagChunkY);
                HELightManager.markChunkForRerender(renderGlobal, chunkX, chunkY, chunkZ);
                int n = waterId;
                timestampsNextUpdate[n] = timestampsNextUpdate[n] + (long)HEConfig.minLightUpdateTimePerSubChunk;
                if ((neighborChunkWest == null || !neighborChunkWest.hasWaterInSubchunk(flagChunkY)) && chunk.requiresPatchingWest(flagChunkY)) {
                    HELightManager.markChunkForRerender(renderGlobal, chunkX - 1, chunkY, chunkZ);
                    int n2 = waterId;
                    timestampsNextUpdate[n2] = timestampsNextUpdate[n2] + (long)HEConfig.minLightUpdateTimePerSubChunk;
                }
                if ((neighborChunkNorth == null || !neighborChunkNorth.hasWaterInSubchunk(flagChunkY)) && chunk.requiresPatchingNorth(flagChunkY)) {
                    HELightManager.markChunkForRerender(renderGlobal, chunkX, chunkY, chunkZ - 1);
                    int n3 = waterId;
                    timestampsNextUpdate[n3] = timestampsNextUpdate[n3] + (long)HEConfig.minLightUpdateTimePerSubChunk;
                }
                if ((neighborChunkEast == null || !neighborChunkEast.hasWaterInSubchunk(flagChunkY)) && chunk.requiresPatchingEast(flagChunkY)) {
                    HELightManager.markChunkForRerender(renderGlobal, chunkX + 1, chunkY, chunkZ);
                    int n4 = waterId;
                    timestampsNextUpdate[n4] = timestampsNextUpdate[n4] + (long)HEConfig.minLightUpdateTimePerSubChunk;
                }
                if (neighborChunkSouth != null && neighborChunkSouth.hasWaterInSubchunk(flagChunkY) || !chunk.requiresPatchingSouth(flagChunkY)) continue;
                HELightManager.markChunkForRerender(renderGlobal, chunkX, chunkY, chunkZ + 1);
                int n5 = waterId;
                timestampsNextUpdate[n5] = timestampsNextUpdate[n5] + (long)HEConfig.minLightUpdateTimePerSubChunk;
            }
        }
    }

    private static void markChunkForRerender(RenderGlobal renderGlobal, int chunkX, int chunkY, int chunkZ) {
        int blockX = HEUtil.coordChunkToBlock(chunkX);
        int blockY = HEUtil.coordChunkToBlock(chunkY);
        int blockZ = HEUtil.coordChunkToBlock(chunkZ);
        renderGlobal.func_72725_b(blockX, blockY, blockZ, blockX + 16 - 1, blockY + 16 - 1, blockZ + 16 - 1);
    }
}

