/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.reference.LoadedMods;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class EnchUtils {
    private static final int SOUL_BOUND_ID = EnchUtils.setSoulBoundID();

    private EnchUtils() {
    }

    private static int setSoulBoundID() {
        if (!ConfigHandler.allowSoulBound) {
            return -3;
        }
        if (!LoadedMods.ENDERIO) {
            return -2;
        }
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null || !ench.func_77320_a().equals("enchantment.enderio.soulBound")) continue;
            return ench.field_77352_x;
        }
        return -1;
    }

    public static boolean isSoulBounded(ItemStack stack) {
        NBTTagList stackEnch = stack.func_77986_q();
        if (SOUL_BOUND_ID >= 0 && stackEnch != null) {
            for (int i = 0; i < stackEnch.func_74745_c(); ++i) {
                int id = stackEnch.func_150305_b(i).func_74762_e("id");
                if (id != SOUL_BOUND_ID) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSoulBook(ItemStack book) {
        NBTTagList bookEnch;
        NBTTagCompound bookData;
        if (SOUL_BOUND_ID >= 0 && book.func_77942_o() && (bookData = book.field_77990_d).func_74764_b("StoredEnchantments") && !(bookEnch = bookData.func_150295_c("StoredEnchantments", 10)).func_150305_b(1).func_74767_n("id")) {
            int id = bookEnch.func_150305_b(0).func_74762_e("id");
            return id == SOUL_BOUND_ID;
        }
        return false;
    }
}

