/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.IPickupHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.errors.ErrorStateRegistry;
import forestry.core.render.TextureManager;
import forestry.plugins.PluginManager;
import java.util.Collection;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandlerCore {
    @SubscribeEvent
    public void handleItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        for (IPickupHandler handler : PluginManager.pickupHandlers) {
            if (!handler.onItemPickup(event.entityPlayer, event.item)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player != null) {
            Collection<ISpeciesRoot> speciesRoots = AlleleManager.alleleRegistry.getSpeciesRoot().values();
            for (ISpeciesRoot speciesRoot : speciesRoots) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.func_130014_f_(), player.func_146103_bH());
                breedingTracker.synchToPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldLoad(event.world);
        }
    }

    @SubscribeEvent
    public void handleWorldSave(WorldEvent.Save event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldSave(event.world);
        }
    }

    @SubscribeEvent
    public void handleWorldUnload(WorldEvent.Unload event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldUnload(event.world);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            ErrorStateRegistry.initIcons((IIconRegister)event.map);
            TextureManager.initDefaultIcons((IIconRegister)event.map);
        }
    }
}

