/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.recipes.RecipeManagers;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.CombType;
import gregtech.common.items.DropType;
import gregtech.common.items.PropolisType;
import gregtech.common.render.items.GT_GeneratedMaterial_Renderer;
import gregtech.loaders.misc.GT_Bees;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemComb
extends Item
implements IGT_ItemWithMaterialRenderer {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemComb() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77627_a(true);
        this.func_77655_b("gt.comb");
        GameRegistry.registerItem((Item)this, (String)"gt.comb", (String)Mods.GregTech.ID);
    }

    public ItemStack getStackForType(CombType type) {
        return new ItemStack((Item)this, 1, type.getId());
    }

    public ItemStack getStackForType(CombType type, int count) {
        return new ItemStack((Item)this, count, type.getId());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (CombType type : CombType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("forestry:beeCombs.0");
        this.secondIcon = iconRegister.func_94245_a("forestry:beeCombs.1");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        CombType type = CombType.valueOf(stack.func_77960_j());
        return type.getColours()[GT_Utility.clamp(pass, 0, 1)];
    }

    public String func_77653_i(ItemStack stack) {
        return CombType.valueOf(stack.func_77960_j()).getName();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean debugInfo) {
        tooltip.add(EnumChatFormatting.DARK_RED + "Forestry can't process it");
    }

    @Override
    public boolean shouldUseCustomRenderer(int aMetaData) {
        return CombType.valueOf((int)aMetaData).material.renderer != null;
    }

    @Override
    public GT_GeneratedMaterial_Renderer getMaterialRenderer(int aMetaData) {
        return CombType.valueOf((int)aMetaData).material.renderer;
    }

    @Override
    public boolean allowMaterialRenderer(int aMetaData) {
        return true;
    }

    @Override
    public IIcon getIcon(int aMetaData, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @Override
    public IIcon getOverlayIcon(int aMetaData, int pass) {
        return null;
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        return CombType.valueOf((int)aStack.func_77960_j()).material.mRGBa;
    }

    public void initCombsRecipes() {
        this.addProcessGT(CombType.LIGNIE, new Materials[]{Materials.Lignite}, Voltage.LV);
        this.addProcessGT(CombType.COAL, new Materials[]{Materials.Coal}, Voltage.LV);
        this.addCentrifugeToItemStack(CombType.STICKY, new ItemStack[]{ItemList.IC2_Resin.get(1L, new Object[0]), ItemList.IC2_Plantball.get(1L, new Object[0]), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{5000, 1500, 5000}, Voltage.ULV);
        this.addProcessGT(CombType.OIL, new Materials[]{Materials.Oilsands}, Voltage.LV);
        this.addProcessGT(CombType.APATITE, new Materials[]{Materials.Apatite}, Voltage.LV);
        this.addCentrifugeToMaterial(CombType.ASH, new Materials[]{Materials.DarkAsh, Materials.Ash}, new int[]{5000, 5000}, new int[0], Voltage.ULV, GT_Values.NI, 5000);
        this.addCentrifugeToItemStack(CombType.PHOSPHORUS, new ItemStack[]{Materials.Phosphorus.getDust(1), Materials.TricalciumPhosphate.getDust(2), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 10000, 10000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.MICA, new ItemStack[]{Materials.Mica.getDust(2), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 7500}, Voltage.HV);
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToItemStack(CombType.LIGNIE, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{9000, 5000}, Voltage.ULV);
            this.addCentrifugeToItemStack(CombType.COAL, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 5000}, Voltage.ULV);
            this.addCentrifugeToItemStack(CombType.OIL, new ItemStack[]{ItemList.Crop_Drop_OilBerry.get(6L, new Object[0]), GT_Bees.drop.getStackForType(DropType.OIL), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 10000, 5000}, Voltage.ULV);
        } else {
            this.addCentrifugeToItemStack(CombType.LIGNIE, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Lignite, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{9000, 10000, 5000}, Voltage.ULV);
            this.addCentrifugeToItemStack(CombType.COAL, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Coal, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 10000, 5000}, Voltage.ULV);
            this.addCentrifugeToItemStack(CombType.OIL, new ItemStack[]{ItemList.Crop_Drop_OilBerry.get(6L, new Object[0]), GT_Bees.drop.getStackForType(DropType.OIL), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Oilsands, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 10000, 10000, 5000}, Voltage.ULV);
            this.addCentrifugeToMaterial(CombType.APATITE, new Materials[]{Materials.Apatite, Materials.Phosphate}, new int[]{10000, 8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
        }
        this.addCentrifugeToItemStack(CombType.COOLANT, new ItemStack[]{GT_Bees.drop.getStackForType(DropType.COOLANT), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{10000, 10000}, Voltage.HV, 196);
        this.addCentrifugeToItemStack(CombType.ENERGY, new ItemStack[]{GT_Bees.drop.getStackForType(DropType.HOT_COOLANT), ItemList.IC2_Energium_Dust.get(1L, new Object[0]), ItemList.FR_RefractoryWax.get(1L, new Object[0])}, new int[]{2000, 2000, 5000}, Voltage.HV, 196);
        this.addCentrifugeToItemStack(CombType.LAPOTRON, new ItemStack[]{GT_Bees.drop.getStackForType(DropType.LAPIS), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.LapotronDust", 1L, 0), GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 2)}, new int[]{2000, 1500, 4000}, Voltage.HV, 196);
        this.addCentrifugeToMaterial(CombType.PYROTHEUM, new Materials[]{Materials.Blaze, Materials.Pyrotheum}, new int[]{2500, 2000}, new int[0], Voltage.HV, GT_Values.NI, 3000);
        this.addCentrifugeToItemStack(CombType.CRYOTHEUM, new ItemStack[]{ItemList.FR_RefractoryWax.get(1L, new Object[0]), Materials.Cryotheum.getDust(1)}, new int[]{5000, 10000}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.BLIZZ, new ItemStack[]{ItemList.FR_RefractoryWax.get(1L, new Object[0]), Materials.Blizz.getDust(1)}, new int[]{5000, 10000}, Voltage.MV);
        this.addProcessGT(CombType.REDALLOY, new Materials[]{Materials.RedAlloy}, Voltage.LV);
        this.addProcessGT(CombType.REDSTONEALLOY, new Materials[]{Materials.RedstoneAlloy}, Voltage.LV);
        this.addProcessGT(CombType.CONDUCTIVEIRON, new Materials[]{Materials.ConductiveIron}, Voltage.MV);
        this.addProcessGT(CombType.VIBRANTALLOY, new Materials[]{Materials.VibrantAlloy}, Voltage.HV);
        this.addProcessGT(CombType.ENERGETICALLOY, new Materials[]{Materials.EnergeticAlloy}, Voltage.HV);
        this.addProcessGT(CombType.ELECTRICALSTEEL, new Materials[]{Materials.ElectricalSteel}, Voltage.LV);
        this.addProcessGT(CombType.DARKSTEEL, new Materials[]{Materials.DarkSteel}, Voltage.MV);
        this.addProcessGT(CombType.PULSATINGIRON, new Materials[]{Materials.PulsatingIron}, Voltage.HV);
        this.addProcessGT(CombType.STAINLESSSTEEL, new Materials[]{Materials.StainlessSteel}, Voltage.HV);
        this.addProcessGT(CombType.BEDROCKIUM, new Materials[]{Materials.Bedrockium}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.ENDERIUM, new ItemStack[]{ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustSmall, Materials.EnderiumBase, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Enderium, 1L)}, new int[]{5000, 3000, 5000}, Voltage.HV);
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToMaterial(CombType.REDALLOY, new Materials[]{Materials.RedAlloy}, new int[]{10000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.REDSTONEALLOY, new Materials[]{Materials.RedstoneAlloy}, new int[]{10000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.CONDUCTIVEIRON, new Materials[]{Materials.ConductiveIron}, new int[]{9000}, new int[0], Voltage.MV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.VIBRANTALLOY, new Materials[]{Materials.VibrantAlloy}, new int[]{7000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.ENERGETICALLOY, new Materials[]{Materials.EnergeticAlloy}, new int[]{8000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.ELECTRICALSTEEL, new Materials[]{Materials.ElectricalSteel}, new int[]{10000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.DARKSTEEL, new Materials[]{Materials.DarkSteel}, new int[]{10000}, new int[0], Voltage.MV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.PULSATINGIRON, new Materials[]{Materials.PulsatingIron}, new int[]{8000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.STAINLESSSTEEL, new Materials[]{Materials.StainlessSteel}, new int[]{5000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.BEDROCKIUM, new Materials[]{Materials.Bedrockium}, new int[]{5000}, new int[0], Voltage.EV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        } else {
            this.addCentrifugeToMaterial(CombType.REDALLOY, new Materials[]{Materials.RedAlloy, Materials.Redstone, Materials.Copper}, new int[]{10000, 7500, 9000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.REDSTONEALLOY, new Materials[]{Materials.RedstoneAlloy, Materials.Redstone, Materials.Silicon, Materials.Coal}, new int[]{10000, 9000, 7500, 7500}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.CONDUCTIVEIRON, new Materials[]{Materials.ConductiveIron, Materials.Silver, Materials.Iron}, new int[]{9000, 5500, 6500}, new int[0], Voltage.MV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.VIBRANTALLOY, new Materials[]{Materials.VibrantAlloy, Materials.Chrome}, new int[]{7000, 5000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.ENERGETICALLOY, new Materials[]{Materials.EnergeticAlloy, Materials.Gold}, new int[]{8000, 6000}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.ELECTRICALSTEEL, new Materials[]{Materials.ElectricalSteel, Materials.Silicon, Materials.Coal}, new int[]{10000, 7500, 7500}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.DARKSTEEL, new Materials[]{Materials.DarkSteel, Materials.Coal}, new int[]{10000, 7500}, new int[0], Voltage.MV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.PULSATINGIRON, new Materials[]{Materials.PulsatingIron, Materials.Iron}, new int[]{8000, 7500}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.STAINLESSSTEEL, new Materials[]{Materials.StainlessSteel, Materials.Iron, Materials.Chrome, Materials.Manganese, Materials.Nickel}, new int[]{5000, 7500, 5500, 7500, 7500}, new int[0], Voltage.HV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
            this.addCentrifugeToMaterial(CombType.BEDROCKIUM, new Materials[]{Materials.Bedrockium}, new int[]{5000}, new int[0], Voltage.EV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 5000);
        }
        this.addProcessGT(CombType.THAUMIUMDUST, new Materials[]{Materials.Thaumium}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.THAUMIUMSHARD, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 1), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 2), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 3), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 4), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 5), GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 6), GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{2000, 2000, 2000, 2000, 2000, 2000, 5000}, Voltage.ULV);
        this.addProcessGT(CombType.AMBER, new Materials[]{Materials.Amber}, Voltage.LV);
        this.addProcessGT(CombType.QUICKSILVER, new Materials[]{Materials.Cinnabar}, Voltage.LV);
        this.addCentrifugeToItemStack(CombType.SALISMUNDUS, new ItemStack[]{GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L, 14), GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{10000, 5000}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.TAINTED, new ItemStack[]{GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L, 11), GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L, 12), GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "blockTaintFibres", 1L, 0), GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "blockTaintFibres", 1L, 1), GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "blockTaintFibres", 1L, 2), GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{1500, 1500, 1500, 1500, 1500, 5000}, Voltage.ULV);
        this.addProcessGT(CombType.MITHRIL, new Materials[]{Materials.Mithril}, Voltage.HV);
        this.addProcessGT(CombType.ASTRALSILVER, new Materials[]{Materials.AstralSilver}, Voltage.HV);
        this.addCentrifugeToMaterial(CombType.ASTRALSILVER, new Materials[]{Materials.AstralSilver, Materials.Silver}, new int[]{2000, (GT_Mod.gregtechproxy.mNerfedCombs ? 10 : 75) * 100}, new int[0], Voltage.HV, GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
        this.addCentrifugeToItemStack(CombType.THAUMINITE, new ItemStack[]{GT_ModHandler.getModItem(Mods.ThaumicBases.ID, "resource", 1L, 0), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Thaumium, 1L), GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0)}, new int[]{2000, 1000, 5000}, Voltage.HV);
        this.addProcessGT(CombType.SHADOWMETAL, new Materials[]{Materials.Shadow}, Voltage.HV);
        this.addCentrifugeToMaterial(CombType.SHADOWMETAL, new Materials[]{Materials.Shadow, Materials.ShadowSteel}, new int[]{(GT_Mod.gregtechproxy.mNerfedCombs ? 20 : 75) * 100, 1000}, new int[0], Voltage.HV, GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
        this.addProcessGT(CombType.DIVIDED, new Materials[]{Materials.Diamond}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.DIVIDED, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_ModHandler.getModItem(Mods.ExtraUtilities.ID, "unstableingot", 1L, 1), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Iron, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Diamond, 1L)}, new int[]{5000, 2000, (GT_Mod.gregtechproxy.mNerfedCombs ? 10 : 75) * 100, (GT_Mod.gregtechproxy.mNerfedCombs ? 5 : 55) * 100}, Voltage.HV);
        this.addProcessGT(CombType.SPARKELING, new Materials[]{Materials.NetherStar}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.SPARKELING, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_ModHandler.getModItem(Mods.MagicBees.ID, "miscResources", 2L, 5), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.NetherStar, 1L)}, new int[]{5000, 1000, (GT_Mod.gregtechproxy.mNerfedCombs ? 10 : 50) * 100}, Voltage.EV);
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToMaterial(CombType.THAUMIUMDUST, new Materials[]{Materials.Thaumium}, new int[]{10000}, new int[0], Voltage.MV, GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
            this.addCentrifugeToItemStack(CombType.QUICKSILVER, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "ItemNugget", 1L, 5)}, new int[]{5000, 10000}, Voltage.ULV);
        } else {
            this.addCentrifugeToMaterial(CombType.THAUMIUMDUST, new Materials[]{Materials.Thaumium, Materials.Iron}, new int[]{10000, 7500}, new int[0], Voltage.MV, GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
            this.addCentrifugeToMaterial(CombType.AMBER, new Materials[]{Materials.Amber}, new int[]{10000}, new int[0], Voltage.ULV, GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
            this.addCentrifugeToItemStack(CombType.QUICKSILVER, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "ItemNugget", 1L, 5), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Cinnabar, 1L)}, new int[]{5000, 10000, 8500}, Voltage.ULV);
            this.addCentrifugeToMaterial(CombType.MITHRIL, new Materials[]{Materials.Mithril, Materials.Platinum}, new int[]{7500, 5500}, new int[0], Voltage.HV, GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 5000);
        }
        this.addProcessGT(CombType.STONE, new Materials[]{Materials.Soapstone}, Voltage.LV);
        this.addProcessGT(CombType.CERTUS, new Materials[]{Materials.CertusQuartz}, Voltage.LV);
        this.addProcessGT(CombType.FLUIX, new Materials[]{Materials.Fluix}, Voltage.LV);
        this.addProcessGT(CombType.REDSTONE, new Materials[]{Materials.Redstone}, Voltage.LV);
        this.addCentrifugeToMaterial(CombType.RAREEARTH, new Materials[]{Materials.RareEarth}, new int[]{10000}, new int[]{1}, Voltage.ULV, GT_Values.NI, 3000);
        this.addProcessGT(CombType.LAPIS, new Materials[]{Materials.Lapis}, Voltage.LV);
        this.addProcessGT(CombType.RUBY, new Materials[]{Materials.Ruby}, Voltage.LV);
        this.addProcessGT(CombType.REDGARNET, new Materials[]{Materials.GarnetRed}, Voltage.LV);
        this.addProcessGT(CombType.YELLOWGARNET, new Materials[]{Materials.GarnetYellow}, Voltage.LV);
        this.addProcessGT(CombType.SAPPHIRE, new Materials[]{Materials.Sapphire}, Voltage.LV);
        this.addProcessGT(CombType.DIAMOND, new Materials[]{Materials.Diamond}, Voltage.LV);
        this.addProcessGT(CombType.OLIVINE, new Materials[]{Materials.Olivine}, Voltage.LV);
        this.addProcessGT(CombType.EMERALD, new Materials[]{Materials.Emerald}, Voltage.LV);
        this.addProcessGT(CombType.FIRESTONE, new Materials[]{Materials.Firestone}, Voltage.LV);
        this.addProcessGT(CombType.PYROPE, new Materials[]{Materials.Pyrope}, Voltage.LV);
        this.addProcessGT(CombType.GROSSULAR, new Materials[]{Materials.Grossular}, Voltage.LV);
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToMaterial(CombType.STONE, new Materials[]{Materials.Stone, Materials.GraniteBlack, Materials.GraniteRed, Materials.Basalt, Materials.Marble, Materials.Redrock}, new int[]{7000, 5000, 5000, 5000, 5000, 5000}, new int[]{9, 9, 9, 9, 9, 9}, Voltage.ULV, GT_Values.NI, 5000);
            this.addCentrifugeToMaterial(CombType.FLUIX, new Materials[]{Materials.Fluix}, new int[]{2500}, new int[]{9}, Voltage.ULV, GT_Values.NI, 3000);
        } else {
            this.addCentrifugeToMaterial(CombType.STONE, new Materials[]{Materials.Soapstone, Materials.Talc, Materials.Apatite, Materials.Phosphate, Materials.TricalciumPhosphate}, new int[]{9500, 9000, 8000, 7500, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 5000);
            this.addCentrifugeToMaterial(CombType.CERTUS, new Materials[]{Materials.CertusQuartz, Materials.Quartzite, Materials.Barite}, new int[]{10000, 8000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 5000);
            this.addCentrifugeToMaterial(CombType.FLUIX, new Materials[]{Materials.Fluix, Materials.Redstone, Materials.CertusQuartz, Materials.NetherQuartz}, new int[]{2500, 9000, 9000, 9000}, new int[]{9, 1, 1, 1}, Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.REDSTONE, new Materials[]{Materials.Redstone, Materials.Cinnabar}, new int[]{10000, 8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.LAPIS, new Materials[]{Materials.Lapis, Materials.Sodalite, Materials.Lazurite, Materials.Calcite}, new int[]{10000, 9000, 9000, 8500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.RUBY, new Materials[]{Materials.Ruby, Materials.Redstone}, new int[]{10000, 9000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.REDGARNET, new Materials[]{Materials.GarnetRed, Materials.GarnetYellow}, new int[]{10000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.YELLOWGARNET, new Materials[]{Materials.GarnetYellow, Materials.GarnetRed}, new int[]{10000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.SAPPHIRE, new Materials[]{Materials.Sapphire, Materials.GreenSapphire, Materials.Almandine, Materials.Pyrope}, new int[]{10000, 9000, 9000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.DIAMOND, new Materials[]{Materials.Diamond, Materials.Graphite}, new int[]{10000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.OLIVINE, new Materials[]{Materials.Olivine, Materials.Bentonite, Materials.Magnesite, Materials.Glauconite}, new int[]{10000, 9000, 8000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.EMERALD, new Materials[]{Materials.Emerald, Materials.Beryllium, Materials.Thorium}, new int[]{10000, 8500, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.FIRESTONE, new Materials[]{Materials.Firestone}, new int[]{10000}, new int[0], Voltage.ULV, ItemList.FR_RefractoryWax.get(1L, new Object[0]), 3000);
            this.addCentrifugeToMaterial(CombType.PYROPE, new Materials[]{Materials.Pyrope, Materials.Aluminium, Materials.Magnesium, Materials.Silicon}, new int[]{10000, 7500, 8000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.GROSSULAR, new Materials[]{Materials.Grossular, Materials.Aluminium, Materials.Silicon}, new int[]{10000, 7500, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
        }
        this.addProcessGT(CombType.SLAG, new Materials[]{Materials.Limestone}, Voltage.LV);
        this.addProcessGT(CombType.COPPER, new Materials[]{Materials.Copper}, Voltage.LV);
        this.addProcessGT(CombType.TIN, new Materials[]{Materials.Tin}, Voltage.LV);
        this.addProcessGT(CombType.LEAD, new Materials[]{Materials.Lead}, Voltage.LV);
        this.addProcessGT(CombType.INDIUM, new Materials[]{Materials.Indium}, Voltage.ZPM);
        this.addProcessGT(CombType.NICKEL, new Materials[]{Materials.Nickel}, Voltage.LV);
        this.addProcessGT(CombType.ZINC, new Materials[]{Materials.Zinc}, Voltage.LV);
        this.addProcessGT(CombType.SILVER, new Materials[]{Materials.Silver}, Voltage.LV);
        this.addProcessGT(CombType.CRYOLITE, new Materials[]{Materials.Cryolite}, Voltage.LV);
        this.addProcessGT(CombType.GOLD, new Materials[]{Materials.Gold}, Voltage.LV);
        this.addProcessGT(CombType.SULFUR, new Materials[]{Materials.Sulfur}, Voltage.LV);
        this.addProcessGT(CombType.GALLIUM, new Materials[]{Materials.Gallium}, Voltage.LV);
        this.addProcessGT(CombType.ARSENIC, new Materials[]{Materials.Arsenic}, Voltage.LV);
        this.addProcessGT(CombType.IRON, new Materials[]{Materials.Iron}, Voltage.LV);
        this.addProcessGT(CombType.STEEL, new Materials[]{Materials.Steel}, Voltage.LV);
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToMaterial(CombType.SLAG, new Materials[]{Materials.Stone, Materials.GraniteBlack, Materials.GraniteRed}, new int[]{5000, 2000, 2000}, new int[]{9, 9, 9}, Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.COPPER, new Materials[]{Materials.Copper}, new int[]{7000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.TIN, new Materials[]{Materials.Tin}, new int[]{6000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.LEAD, new Materials[]{Materials.Lead}, new int[]{4500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.IRON, new Materials[]{Materials.Iron}, new int[]{3000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.STEEL, new Materials[]{Materials.Steel}, new int[]{4000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.SILVER, new Materials[]{Materials.Silver}, new int[]{8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.CRYOLITE, new Materials[]{Materials.Cryolite}, new int[]{8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.SULFUR, new Materials[]{Materials.Sulfur}, new int[]{10000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
        } else {
            this.addCentrifugeToMaterial(CombType.SLAG, new Materials[]{Materials.Salt, Materials.RockSalt, Materials.Lepidolite, Materials.Spodumene, Materials.Monazite}, new int[]{10000, 10000, 10000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.COPPER, new Materials[]{Materials.Copper, Materials.Tetrahedrite, Materials.Chalcopyrite, Materials.Malachite, Materials.Pyrite, Materials.Stibnite}, new int[]{10000, 8500, 9500, 8000, 7500, 6500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.TIN, new Materials[]{Materials.Tin, Materials.Cassiterite, Materials.CassiteriteSand}, new int[]{10000, 8500, 6500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.LEAD, new Materials[]{Materials.Lead, Materials.Galena}, new int[]{10000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.IRON, new Materials[]{Materials.Iron, Materials.Magnetite, Materials.BrownLimonite, Materials.YellowLimonite, Materials.VanadiumMagnetite, Materials.MeteoricIron}, new int[]{10000, 9000, 8500, 8500, 8000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.LEAD, new Materials[]{Materials.Steel, Materials.Magnetite, Materials.VanadiumMagnetite, Materials.Molybdenite, Materials.Molybdenum, Materials.MeteoricIron}, new int[]{10000, 9000, 8000, 6500, 6500, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.NICKEL, new Materials[]{Materials.Nickel, Materials.Garnierite, Materials.Pentlandite, Materials.Cobaltite, Materials.Wulfenite, Materials.Powellite}, new int[]{10000, 8500, 8500, 8000, 7500, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.ZINC, new Materials[]{Materials.Zinc, Materials.Sphalerite, Materials.Sulfur}, new int[]{10000, 8000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.SILVER, new Materials[]{Materials.Silver, Materials.Galena}, new int[]{10000, 8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.CRYOLITE, new Materials[]{Materials.Cryolite, Materials.Silver}, new int[]{10000, 8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.GOLD, new Materials[]{Materials.Gold}, new int[]{10000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.SULFUR, new Materials[]{Materials.Sulfur, Materials.Pyrite, Materials.Sphalerite}, new int[]{10000, 9000, 8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.GALLIUM, new Materials[]{Materials.Gallium, Materials.Niobium}, new int[]{8000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.ARSENIC, new Materials[]{Materials.Arsenic, Materials.Bismuth, Materials.Antimony}, new int[]{8000, 7000, 7000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
        }
        this.addProcessGT(CombType.BAUXITE, new Materials[]{Materials.Bauxite}, Voltage.LV);
        this.addProcessGT(CombType.ALUMINIUM, new Materials[]{Materials.Aluminium}, Voltage.LV);
        this.addProcessGT(CombType.MANGANESE, new Materials[]{Materials.Manganese}, Voltage.LV);
        this.addProcessGT(CombType.TITANIUM, new Materials[]{Materials.Titanium}, Voltage.EV);
        this.addProcessGT(CombType.MAGNESIUM, new Materials[]{Materials.Magnesium}, Voltage.LV);
        this.addProcessGT(CombType.CHROME, new Materials[]{Materials.Chrome}, Voltage.HV);
        this.addProcessGT(CombType.TUNGSTEN, new Materials[]{Materials.Tungsten}, Voltage.IV);
        this.addProcessGT(CombType.PLATINUM, new Materials[]{Materials.Platinum}, Voltage.HV);
        this.addProcessGT(CombType.MOLYBDENUM, new Materials[]{Materials.Molybdenum}, Voltage.LV);
        this.addProcessGT(CombType.IRIDIUM, new Materials[]{Materials.Iridium}, Voltage.IV);
        this.addProcessGT(CombType.PALLADIUM, new Materials[]{Materials.Palladium}, Voltage.IV);
        this.addProcessGT(CombType.OSMIUM, new Materials[]{Materials.Osmium}, Voltage.IV);
        this.addProcessGT(CombType.LITHIUM, new Materials[]{Materials.Lithium}, Voltage.MV);
        this.addProcessGT(CombType.ELECTROTINE, new Materials[]{Materials.Electrotine}, Voltage.MV);
        this.addProcessGT(CombType.DRACONIC, new Materials[]{Materials.Draconium}, Voltage.IV);
        this.addProcessGT(CombType.AWAKENEDDRACONIUM, new Materials[]{Materials.DraconiumAwakened}, Voltage.ZPM);
        if (GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToItemStack(CombType.SALT, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Salt, 6L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.RockSalt, 6L), ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Saltpeter, 6L)}, new int[]{10000, 10000, 5000, 2500}, Voltage.MV, 160);
        } else {
            this.addCentrifugeToMaterial(CombType.BAUXITE, new Materials[]{Materials.Bauxite, Materials.Aluminium}, new int[]{7500, 5500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.ALUMINIUM, new Materials[]{Materials.Aluminium, Materials.Bauxite}, new int[]{6000, 8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.MANGANESE, new Materials[]{Materials.Manganese, Materials.Grossular, Materials.Spessartine, Materials.Pyrolusite, Materials.Tantalite}, new int[]{3000, 10000, 10000, 10000, 10000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.TITANIUM, new Materials[]{Materials.Titanium, Materials.Ilmenite, Materials.Bauxite, Materials.Rutile}, new int[]{9000, 8000, 7500, 7500}, new int[0], Voltage.EV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.MAGNESIUM, new Materials[]{Materials.Magnesium, Materials.Magnesite}, new int[]{10000, 8000}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.CHROME, new Materials[]{Materials.Chrome, Materials.Ruby, Materials.Chromite, Materials.Redstone, Materials.Neodymium, Materials.Bastnasite}, new int[]{5000, 10000, 5000, 10000, 8000, 8000}, new int[0], Voltage.HV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.TUNGSTEN, new Materials[]{Materials.Tungsten, Materials.Tungstate, Materials.Scheelite, Materials.Lithium}, new int[]{5000, 8000, 7500, 7500}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.PLATINUM, new Materials[]{Materials.Platinum, Materials.Cooperite, Materials.Palladium}, new int[]{4000, 4000, 4000}, new int[0], Voltage.HV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.MOLYBDENUM, new Materials[]{Materials.Molybdenum, Materials.Molybdenite, Materials.Powellite, Materials.Wulfenite}, new int[]{10000, 8000, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.IRIDIUM, new Materials[]{Materials.Iridium, Materials.Osmium}, new int[]{2000, 1500}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.OSMIUM, new Materials[]{Materials.Osmium, Materials.Iridium}, new int[]{2500, 1500}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.LITHIUM, new Materials[]{Materials.Lithium, Materials.Aluminium}, new int[]{8500, 7500}, new int[0], Voltage.MV, GT_Values.NI, 3000);
            this.addCentrifugeToItemStack(CombType.SALT, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Salt, 6L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.RockSalt, 6L), ItemList.FR_Wax.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Saltpeter, 6L)}, new int[]{10000, 10000, 5000, 2500}, Voltage.MV, 160);
        }
        this.addProcessGT(CombType.ALMANDINE, new Materials[]{Materials.Almandine}, Voltage.LV);
        this.addProcessGT(CombType.URANIUM, new Materials[]{Materials.Uranium}, Voltage.EV);
        this.addProcessGT(CombType.PLUTONIUM, new Materials[]{Materials.Plutonium}, Voltage.EV);
        this.addProcessGT(CombType.NAQUADAH, new Materials[]{Materials.Naquadah}, Voltage.IV);
        this.addProcessGT(CombType.NAQUADRIA, new Materials[]{Materials.Naquadria}, Voltage.LuV);
        this.addProcessGT(CombType.THORIUM, new Materials[]{Materials.Thorium}, Voltage.EV);
        this.addProcessGT(CombType.LUTETIUM, new Materials[]{Materials.Lutetium}, Voltage.IV);
        this.addProcessGT(CombType.AMERICIUM, new Materials[]{Materials.Americium}, Voltage.LuV);
        this.addProcessGT(CombType.NEUTRONIUM, new Materials[]{Materials.Neutronium}, Voltage.UHV);
        if (!GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToMaterial(CombType.ALMANDINE, new Materials[]{Materials.Almandine, Materials.Pyrope, Materials.Sapphire, Materials.GreenSapphire}, new int[]{9000, 8000, 7500, 7500}, new int[0], Voltage.ULV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.URANIUM, new Materials[]{Materials.Uranium, Materials.Pitchblende, Materials.Uraninite, Materials.Uranium235}, new int[]{5000, 6500, 7500, 5000}, new int[0], Voltage.EV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.PLUTONIUM, new Materials[]{Materials.Plutonium, Materials.Uranium235}, new int[]{10, 5}, new int[0], Voltage.EV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.NAQUADAH, new Materials[]{Materials.Naquadah, Materials.NaquadahEnriched, Materials.Naquadria}, new int[]{1000, 500, 500}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.NAQUADRIA, new Materials[]{Materials.Naquadria, Materials.NaquadahEnriched, Materials.Naquadah}, new int[]{1000, 1000, 1500}, new int[0], Voltage.LuV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.THORIUM, new Materials[]{Materials.Thorium, Materials.Uranium, Materials.Coal}, new int[]{7500, 750000, 9500}, new int[0], Voltage.EV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.LUTETIUM, new Materials[]{Materials.Lutetium, Materials.Thorium}, new int[]{3500, 5500}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.AMERICIUM, new Materials[]{Materials.Americium, Materials.Lutetium}, new int[]{2500, 4500}, new int[0], Voltage.LuV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.NEUTRONIUM, new Materials[]{Materials.Neutronium, Materials.Americium}, new int[]{1500, 3500}, new int[0], Voltage.UHV, GT_Values.NI, 3000);
        }
        this.addCentrifugeToItemStack(CombType.NAGA, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 4), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.NagaScaleChip", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.NagaScaleFragment", 1L, 0), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.MV);
        this.addCentrifugeToItemStack(CombType.LICH, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 5), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.LichBoneChip", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.LichBoneFragment", 1L, 0), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.HYDRA, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 1), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.FieryBloodDrop", 1L, 0), GT_Bees.drop.getStackForType(DropType.HYDRA), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.URGHAST, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 2), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CarminiteChip", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CarminiteFragment", 1L, 0), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.SNOWQUEEN, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "propolis", 1L, 3), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.SnowQueenBloodDrop", 1L, 0), GT_Bees.drop.getStackForType(DropType.SNOW_QUEEN), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{500, 3300, 800, 3000}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.ENDDUST, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.End), GT_Bees.drop.getStackForType(DropType.ENDERGOO), Materials.Endstone.getBlocks(4)}, new int[]{2000, 1500, 1000, 10000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.STARDUST, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Stardust), GT_Bees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{2000, 1500, 1000}, Voltage.HV);
        this.addCentrifugeToItemStack(CombType.ECTOPLASMA, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Ectoplasma), GT_Bees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{2500, 1000, 1500}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.ARCANESHARD, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Arcaneshard), GT_Bees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{2500, 1000, 1500}, Voltage.EV);
        this.addCentrifugeToItemStack(CombType.DRAGONESSENCE, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Dragonessence), GT_Bees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{3000, 750, 2000}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.ENDERMAN, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Enderman), GT_Bees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{3000, 750, 2000}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.SILVERFISH, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Silverfish), GT_Bees.drop.getStackForType(DropType.ENDERGOO), new ItemStack(Items.field_151063_bx, 1, 60)}, new int[]{2500, 1000, 2000, 1500}, Voltage.EV);
        this.addProcessGT(CombType.ENDIUM, new Materials[]{Materials.HeeEndium}, Voltage.HV);
        if (!GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToMaterial(CombType.ENDIUM, new Materials[]{Materials.HeeEndium}, new int[]{5000}, new int[0], Voltage.HV, GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), 2000);
        }
        this.addCentrifugeToItemStack(CombType.RUNEI, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfPowerFragment", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfAgilityFragment", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfVigorFragment", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfDefenseFragment", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfMagicFragment", 1L, 0)}, new int[]{2500, 500, 500, 500, 500, 500}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.RUNEII, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.RuneOfVoidFragment", 1L, 0)}, new int[]{5000, 250}, Voltage.IV);
        this.addCentrifugeToItemStack(CombType.FIREESSENSE, new ItemStack[]{GT_ModHandler.getModItem(Mods.MagicBees.ID, "wax", 1L, 0), GT_Bees.propolis.getStackForType(PropolisType.Fireessence), GT_Bees.drop.getStackForType(DropType.ENDERGOO)}, new int[]{3000, 750, 2000}, Voltage.IV);
        if (Mods.AE2FluidCraft.isModLoaded()) {
            this.addCentrifugeToItemStack(CombType.WALRUS, new ItemStack[]{GT_ModHandler.getModItem(Mods.AE2FluidCraft.ID, "walrus", 1L, 0)}, new int[]{10000}, Voltage.LV);
        }
        this.addCentrifugeToItemStack(CombType.SPACE, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), ItemList.FR_RefractoryWax.get(1L, new Object[0]), GT_Bees.drop.getStackForType(DropType.OXYGEN), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CoinSpace", 1L, 0)}, new int[]{5000, 3000, 1500, 500}, Voltage.HV);
        this.addProcessGT(CombType.METEORICIRON, new Materials[]{Materials.MeteoricIron}, Voltage.HV);
        this.addProcessGT(CombType.DESH, new Materials[]{Materials.Desh}, Voltage.EV);
        this.addProcessGT(CombType.LEDOX, new Materials[]{Materials.Ledox}, Voltage.EV);
        this.addProcessGT(CombType.CALLISTOICE, new Materials[]{Materials.CallistoIce}, Voltage.IV);
        this.addProcessGT(CombType.MYTRYL, new Materials[]{Materials.Mytryl}, Voltage.IV);
        this.addProcessGT(CombType.QUANTIUM, new Materials[]{Materials.Quantium}, Voltage.IV);
        this.addProcessGT(CombType.ORIHARUKON, new Materials[]{Materials.Oriharukon}, Voltage.IV);
        this.addProcessGT(CombType.MYSTERIOUSCRYSTAL, new Materials[]{Materials.MysteriousCrystal}, Voltage.LuV);
        this.addCentrifugeToMaterial(CombType.MYSTERIOUSCRYSTAL, new Materials[]{Materials.MysteriousCrystal}, new int[]{(GT_Mod.gregtechproxy.mNerfedCombs ? 10 : 40) * 100, (GT_Mod.gregtechproxy.mNerfedCombs ? 15 : 50) * 100}, new int[0], Voltage.LuV, 512, GT_Values.NI, 5000);
        this.addProcessGT(CombType.BLACKPLUTONIUM, new Materials[]{Materials.BlackPlutonium}, Voltage.LuV);
        this.addProcessGT(CombType.TRINIUM, new Materials[]{Materials.Trinium}, Voltage.ZPM);
        if (!GT_Mod.gregtechproxy.mNerfedCombs) {
            this.addCentrifugeToMaterial(CombType.METEORICIRON, new Materials[]{Materials.MeteoricIron, Materials.Iron}, new int[]{8500, 10000}, new int[0], Voltage.HV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.DESH, new Materials[]{Materials.Desh, Materials.Titanium}, new int[]{7500, 5000}, new int[0], Voltage.EV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.LEDOX, new Materials[]{Materials.Ledox, Materials.CallistoIce, Materials.Lead}, new int[]{6500, 5500, 8500}, new int[0], Voltage.EV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.CALLISTOICE, new Materials[]{Materials.CallistoIce, Materials.Ledox, Materials.Lead}, new int[]{6500, 7500, 10000}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.MYTRYL, new Materials[]{Materials.Mytryl, Materials.Mithril}, new int[]{5500, 5000}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.QUANTIUM, new Materials[]{Materials.Quantium, Materials.Osmium}, new int[]{5000, 6000}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.ORIHARUKON, new Materials[]{Materials.Oriharukon, Materials.Lead}, new int[]{5000, 7500}, new int[0], Voltage.IV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.BLACKPLUTONIUM, new Materials[]{Materials.BlackPlutonium, Materials.Plutonium}, new int[]{2500, 5000}, new int[0], Voltage.LuV, GT_Values.NI, 3000);
            this.addCentrifugeToMaterial(CombType.TRINIUM, new Materials[]{Materials.Trinium, Materials.Iridium}, new int[]{3500, 4500}, new int[0], Voltage.ZPM, GT_Values.NI, 3000);
        }
        this.addCentrifugeToItemStack(CombType.MOON, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MoonStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.MV, 300);
        this.addCentrifugeToItemStack(CombType.MARS, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MarsStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.HV, 300);
        this.addCentrifugeToItemStack(CombType.JUPITER, new ItemStack[]{GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.IoStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaIceDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.GanymedeStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CallistoStoneDust", 1L, 0), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.CallistoIce, 1L), ItemList.FR_Wax.get(1L, new Object[0])}, new int[]{3000, 3000, 3000, 3000, 3000, 500, 5000}, Voltage.HV, 300);
        this.addCentrifugeToItemStack(CombType.MERCURY, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MercuryCoreDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MercuryStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.EV, 300);
        this.addCentrifugeToItemStack(CombType.VENUS, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VenusStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.EV, 300);
        this.addCentrifugeToItemStack(CombType.SATURN, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EnceladusStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TitanStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.IV, 300);
        this.addCentrifugeToItemStack(CombType.URANUS, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MirandaStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.OberonStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.IV, 300);
        this.addCentrifugeToItemStack(CombType.NEPTUN, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.ProteusStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TritonStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.IV, 300);
        this.addCentrifugeToItemStack(CombType.PLUTO, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PlutoStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PlutoIceDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.LuV, 300);
        this.addCentrifugeToItemStack(CombType.HAUMEA, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.HaumeaStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.LuV, 300);
        this.addCentrifugeToItemStack(CombType.MAKEMAKE, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MakeMakeStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.LuV, 300);
        this.addCentrifugeToItemStack(CombType.CENTAURI, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CentauriASurfaceDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CentauriAStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.ZPM, 300);
        this.addCentrifugeToItemStack(CombType.TCETI, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TCetiEStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.ZPM, 300);
        this.addCentrifugeToItemStack(CombType.BARNARDA, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaEStoneDust", 1L, 0), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaFStoneDust", 1L, 0)}, new int[]{5000, 3000, 3000}, Voltage.ZPM, 300);
        this.addCentrifugeToItemStack(CombType.VEGA, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VegaBStoneDust", 1L, 0)}, new int[]{5000, 3000}, Voltage.ZPM, 300);
        if (Mods.GalaxySpace.isModLoaded()) {
            this.addCentrifugeToItemStack(CombType.SEAWEED, new ItemStack[]{ItemList.FR_Wax.get(1L, new Object[0]), GT_ModHandler.getModItem(Mods.GalaxySpace.ID, "tcetiedandelions", 1L, 0)}, new int[]{5000, 10000}, Voltage.UV, 100);
        }
        this.addCentrifugeToMaterial(CombType.INFINITYCATALYST, new Materials[]{Materials.InfinityCatalyst, Materials.Neutronium}, new int[]{2500, 2000}, new int[0], Voltage.ZPM, 100, GT_Values.NI, 5000);
        this.addFluidExtractorProcess(CombType.HELIUM, Materials.Helium.getGas(250L), Voltage.HV);
        this.addFluidExtractorProcess(CombType.ARGON, Materials.Argon.getGas(250L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.NITROGEN, Materials.Nitrogen.getGas(500L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.HYDROGEN, Materials.Hydrogen.getGas(500L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.FLUORINE, Materials.Fluorine.getGas(250L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.OXYGEN, Materials.Oxygen.getGas(500L), Voltage.MV);
        this.addFluidExtractorProcess(CombType.UNKNOWNWATER, FluidRegistry.getFluidStack((String)"unknowwater", (int)250), Voltage.ZPM);
    }

    public void addAutoclaveProcess(CombType comb, Materials aMaterial, Voltage volt, int circuitNumber) {
        if (GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L) == GT_Values.NI) {
            return;
        }
        GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
        recipeBuilder.itemInputs(GT_Utility.copyAmount(9L, this.getStackForType(comb)), GT_Utility.getIntegratedCircuit(circuitNumber)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.crushedPurified, aMaterial, 4L)).fluidInputs(Materials.UUMatter.getFluid(Math.max(1L, (aMaterial.getMass() + (long)volt.getUUAmplifier()) / 10L))).noFluidOutputs().duration((int)(aMaterial.getMass() * 128L) * 1).eut(volt.getAutoClaveEnergy());
        if (volt.compareTo(Voltage.HV) > 0) {
            recipeBuilder.requiresCleanRoom();
        }
        recipeBuilder.addTo(GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes);
    }

    public void addFluidExtractorProcess(CombType comb, FluidStack fluid, Voltage volt) {
        if (fluid == null) {
            return;
        }
        int duration = fluid.getFluid().getDensity() * 128 > 0 ? fluid.getFluid().getDensity() * 100 : 128;
        int eut = volt.getSimpleEnergy() / 2;
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, this.getStackForType(comb))).noItemOutputs().noFluidInputs().fluidOutputs(fluid).duration(duration).eut(eut).addTo(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes);
    }

    public void addProcessGT(CombType comb, Materials[] aMaterial, Voltage volt) {
        ItemStack tComb = this.getStackForType(comb);
        for (Materials materials : aMaterial) {
            boolean requiresCleanroom;
            int eut;
            int durationTicks;
            FluidStack fluidOutput;
            FluidStack fluidInput;
            ItemStack combOutput;
            ItemStack combInput;
            if (GT_OreDictUnificator.get(OrePrefixes.crushedPurified, materials, 4L) == null) continue;
            switch (comb) {
                case NEUTRONIUM: {
                    combInput = GT_Utility.copyAmount(4L, tComb);
                    combOutput = Materials.Neutronium.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Neutronium.getMolten(576L);
                    durationTicks = volt.getComplexTime() * 17;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.IV) > 0;
                    break;
                }
                case OSMIUM: {
                    combInput = GT_Utility.copyAmount(4L, tComb);
                    combOutput = Materials.Osmium.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Osmium.getMolten(288L);
                    durationTicks = volt.getComplexTime() * 17;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.IV) > 0;
                    break;
                }
                case PLATINUM: {
                    combInput = GT_Utility.copyAmount(4L, tComb);
                    combOutput = Materials.Platinum.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Platinum.getMolten(288L);
                    durationTicks = volt.getComplexTime() * 10;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.HV) > 0;
                    break;
                }
                case IRIDIUM: {
                    combInput = GT_Utility.copyAmount(4L, tComb);
                    combOutput = Materials.Iridium.getNuggets(1);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = Materials.Iridium.getMolten(288L);
                    durationTicks = volt.getComplexTime() * 14;
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.EV) > 0;
                    break;
                }
                default: {
                    combInput = GT_Utility.copyAmount(4L, tComb);
                    combOutput = GT_OreDictUnificator.get(OrePrefixes.crushedPurified, materials, 4L);
                    fluidInput = volt.getFluidAccordingToCombTier();
                    fluidOutput = null;
                    durationTicks = volt.getComplexTime();
                    eut = volt.getChemicalEnergy();
                    requiresCleanroom = volt.compareTo(Voltage.IV) > 0;
                }
            }
            GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
            recipeBuilder.itemInputs(combInput).itemOutputs(combOutput).fluidInputs(fluidInput);
            if (fluidOutput == null) {
                recipeBuilder.noFluidOutputs();
            } else {
                recipeBuilder.fluidOutputs(fluidOutput);
            }
            recipeBuilder.duration(durationTicks).eut(eut).metadata(GT_RecipeConstants.CLEANROOM, requiresCleanroom).addTo(GT_RecipeConstants.UniversalChemical);
        }
    }

    public void addCentrifugeToMaterial(CombType comb, Materials[] aMaterial, int[] chance, int[] stackSize, Voltage volt, ItemStack beeWax, int waxChance) {
        this.addCentrifugeToMaterial(comb, aMaterial, chance, stackSize, volt, volt.getSimpleTime(), beeWax, waxChance);
    }

    public void addCentrifugeToMaterial(CombType comb, Materials[] aMaterial, int[] chance, int[] stackSize, Voltage volt, int duration, ItemStack beeWax, int waxChance) {
        ItemStack[] aOutPut = new ItemStack[aMaterial.length + 1];
        stackSize = Arrays.copyOf(stackSize, aMaterial.length);
        chance = Arrays.copyOf(chance, aOutPut.length);
        chance[chance.length - 1] = waxChance;
        for (int i = 0; i < aMaterial.length; ++i) {
            if (chance[i] == 0) continue;
            aOutPut[i] = Math.max(1, stackSize[i]) % 9 == 0 ? GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial[i], (long)(Math.max(1, stackSize[i]) / 9)) : (Math.max(1, stackSize[i]) % 4 == 0 ? GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial[i], (long)(Math.max(1, stackSize[i]) / 4)) : GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial[i], (long)Math.max(1, stackSize[i])));
        }
        aOutPut[aOutPut.length - 1] = beeWax != GT_Values.NI ? beeWax : ItemList.FR_Wax.get(1L, new Object[0]);
        this.addCentrifugeToItemStack(comb, aOutPut, chance, volt, duration);
    }

    public void addCentrifugeToItemStack(CombType comb, ItemStack[] aItem, int[] chance, Voltage volt) {
        this.addCentrifugeToItemStack(comb, aItem, chance, volt, volt.getSimpleTime());
    }

    public void addCentrifugeToItemStack(CombType comb, ItemStack[] aItem, int[] chance, Voltage volt, int duration) {
        ItemStack tComb = this.getStackForType(comb);
        ImmutableMap.Builder Product = new ImmutableMap.Builder();
        for (int i = 0; i < aItem.length; ++i) {
            if (aItem[i] == GT_Values.NI) continue;
            Product.put((Object)aItem[i], (Object)Float.valueOf((float)chance[i] / 10000.0f));
        }
        if (volt.compareTo(Voltage.MV) < 0 || !GT_Mod.gregtechproxy.mNerfedCombs) {
            RecipeManagers.centrifugeManager.addRecipe(40, tComb, (Map)Product.build());
        }
        GT_Values.RA.stdBuilder().itemInputs(tComb).itemOutputs(aItem).outputChances(chance).noFluidInputs().noFluidOutputs().duration(duration).eut(volt.getSimpleEnergy()).addTo(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes);
    }

    public void registerOreDict() {
        for (CombType comb : CombType.values()) {
            ItemStack tComb = this.getStackForType(comb);
            GT_OreDictUnificator.registerOre(OrePrefixes.beeComb.name(), tComb);
            OrePrefixes.beeComb.add(tComb);
            if (comb.voltage == null) continue;
            GT_OreDictUnificator.registerOre("comb" + comb.voltage.name(), tComb);
        }
    }

    static enum Voltage {
        ULV,
        LV,
        MV,
        HV,
        EV,
        IV,
        LuV,
        ZPM,
        UV,
        UHV,
        UEV,
        UIV,
        UMV,
        UXV,
        MAX;


        public int getVoltage() {
            return (int)GT_Values.V[this.ordinal()];
        }

        public int getVoltageFromEU() {
            return (int)Math.max(Math.floor(Math.log(2 * this.getVoltage()) / Math.log(4.0) - 1.0), 0.0);
        }

        public int getChemicalEnergy() {
            return this.getVoltage() * 3 / 4;
        }

        public int getAutoClaveEnergy() {
            return (int)((double)(this.getVoltage() * 3 / 4) * Math.max(1.0, Math.pow(2.0, 5 - this.ordinal())));
        }

        public FluidStack getComplexChemical() {
            if (this.compareTo(MV) < 0) {
                return Materials.HydrofluoricAcid.getFluid(this.compareTo(ULV) > 0 ? 1000L : 500L);
            }
            if (this.compareTo(HV) < 0) {
                return GT_ModHandler.getDistilledWater(1000L);
            }
            if (this.compareTo(LuV) < 0) {
                return Materials.HydrofluoricAcid.getFluid((long)(Math.pow(2.0, this.compareTo(HV)) * 144.0));
            }
            if (this.compareTo(UHV) < 0) {
                return FluidRegistry.getFluidStack((String)"mutagen", (int)((int)(Math.pow(2.0, this.compareTo(LuV)) * 144.0)));
            }
            return GT_Values.NF;
        }

        public FluidStack getFluidAccordingToCombTier() {
            FluidStack fluidStack;
            int fluidAmount = this.getFluidAmount();
            switch (this.getVoltageFromEU()) {
                case 0: {
                    fluidStack = Materials.Water.getFluid(fluidAmount);
                    break;
                }
                case 1: {
                    fluidStack = Materials.SulfuricAcid.getFluid(fluidAmount);
                    break;
                }
                case 2: {
                    fluidStack = Materials.HydrochloricAcid.getFluid(fluidAmount);
                    break;
                }
                case 3: {
                    fluidStack = Materials.PhosphoricAcid.getFluid(fluidAmount);
                    break;
                }
                case 4: {
                    fluidStack = Materials.HydrofluoricAcid.getFluid(this.getFluidAmount());
                    break;
                }
                default: {
                    fluidStack = Materials.PhthalicAcid.getFluid(fluidAmount);
                }
            }
            return fluidStack;
        }

        public int getUUAmplifier() {
            return 9 * (this.compareTo(MV) < 0 ? 1 : this.compareTo(MV));
        }

        public int getComplexTime() {
            return 64 + this.ordinal() * 32;
        }

        public int getFluidAmount() {
            return 9 * this.getSimpleTime() / 3;
        }

        public int getSimpleTime() {
            if (!GT_Mod.gregtechproxy.mNerfedCombs) {
                return 96 + this.ordinal() * 32;
            }
            return 128 * Math.max(1, this.ordinal());
        }

        public int getSimpleEnergy() {
            if (this == ULV) {
                return 5;
            }
            return this.getVoltage() / 16 * 15;
        }
    }
}

