/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.GT_Mod;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_UO_Dimension;
import gregtech.api.objects.GT_UO_Fluid;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_ChunkAssociatedData;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class GT_UndergroundOil {
    public static final short DIVIDER = 5000;
    private static final GT_UndergroundOilStore STORAGE = new GT_UndergroundOilStore();
    private static final ChunkData NIL_FLUID_STACK = new ChunkData(-1, null, null, false);

    public static FluidStack undergroundOilReadInformation(IGregTechTileEntity te) {
        return GT_UndergroundOil.undergroundOil(te.getWorld().func_72938_d(te.getXCoord(), te.getZCoord()), -1.0f);
    }

    public static FluidStack undergroundOilReadInformation(Chunk chunk) {
        return GT_UndergroundOil.undergroundOil(chunk, -1.0f);
    }

    public static FluidStack undergroundOil(IGregTechTileEntity te, float readOrDrainCoefficient) {
        return GT_UndergroundOil.undergroundOil(te.getWorld().func_72938_d(te.getXCoord(), te.getZCoord()), readOrDrainCoefficient);
    }

    public static FluidStack undergroundOil(Chunk chunk, float readOrDrainCoefficient) {
        return GT_UndergroundOil.undergroundOil(chunk.field_76637_e, chunk.field_76635_g, chunk.field_76647_h, readOrDrainCoefficient);
    }

    public static FluidStack undergroundOil(World w, int chunkX, int chunkZ, float readOrDrainCoefficient) {
        if (w.field_72995_K) {
            return null;
        }
        ChunkData chunkData = (ChunkData)STORAGE.get(w, chunkX, chunkZ);
        if (chunkData.getVein() == null || chunkData.getFluid() == null) {
            return null;
        }
        FluidStack fluidInChunk = new FluidStack(chunkData.getFluid(), 0);
        if (readOrDrainCoefficient >= 0.0f) {
            int fluidExtracted = (int)Math.floor((double)chunkData.getAmount() * (double)readOrDrainCoefficient / 5000.0);
            double averageDecrease = (double)chunkData.getVein().DecreasePerOperationAmount * (double)readOrDrainCoefficient;
            int decrease = (int)Math.ceil(averageDecrease);
            if (fluidExtracted <= 0 || chunkData.amount <= decrease) {
                chunkData.setAmount(0);
            } else {
                fluidInChunk.amount = fluidExtracted;
                if ((double)XSTR.XSTR_INSTANCE.nextFloat() < (double)decrease - averageDecrease) {
                    --decrease;
                }
                chunkData.changeAmount(-decrease);
            }
        } else if (chunkData.amount <= 5000) {
            chunkData.setAmount(0);
        } else {
            fluidInChunk.amount = (int)Math.floor((double)chunkData.getAmount() * (double)(-readOrDrainCoefficient) / 5000.0);
        }
        return fluidInChunk;
    }

    public static Pair<GT_UO_Fluid, Integer> getPristineAmount(World world, int chunkX, int chunkZ) {
        int dimensionId = world.field_73011_w.field_76574_g;
        GT_UO_Dimension dimension = GT_Mod.gregtechproxy.mUndergroundOil.GetDimension(dimensionId);
        if (dimension == null) {
            return null;
        }
        XSTR tVeinRNG = new XSTR(world.func_72905_C() + (long)dimensionId * 2L + (long)(chunkX >> 3) + 8267L * (long)(chunkZ >> 3));
        GT_UO_Fluid uoFluid = dimension.getRandomFluid(tVeinRNG);
        if (uoFluid == null || uoFluid.getFluid() == null) {
            return null;
        }
        int veinAverage = uoFluid.getRandomAmount(tVeinRNG);
        for (int i = 0; i < ((chunkX & 7) << 3 | chunkZ & 7); ++i) {
            tVeinRNG.next(24);
        }
        int amount = (int)((float)veinAverage * (0.75f + tVeinRNG.nextFloat() / 2.0f));
        return Pair.of((Object)uoFluid, (Object)amount);
    }

    static void migrate(ChunkDataEvent.Load e) {
        ChunkData chunkData;
        Fluid fluid;
        if (e.getData().func_74764_b("GTOIL") && e.getData().func_74764_b("GTOILFLUID") && (fluid = (chunkData = (ChunkData)STORAGE.get(e.getChunk())).getFluid()) != null && fluid.getID() == e.getData().func_74762_e("GTOILFLUID")) {
            chunkData.setAmount(Math.min(chunkData.getAmount(), e.getData().func_74762_e("GTOIL")));
        }
    }

    private static final class ChunkData
    implements GT_ChunkAssociatedData.IData {
        private final Fluid fluid;
        @Nullable
        private final GT_UO_Fluid vein;
        private final String veinKey;
        private final int veinHash;
        private int amount;
        private boolean dirty;

        private ChunkData(int amount, GT_UO_Fluid veinKey, String veinID) {
            this(amount, veinKey, veinID, true);
        }

        private ChunkData(int amount, @Nullable GT_UO_Fluid vein, @Nullable String veinKey, boolean dirty) {
            this.amount = amount;
            this.vein = vein;
            this.dirty = dirty;
            if (vein == null) {
                this.fluid = null;
                this.veinKey = null;
                this.veinHash = 0;
            } else {
                this.fluid = vein.getFluid();
                this.veinKey = veinKey;
                this.veinHash = GT_UndergroundOilStore.hashes.computeIfAbsent(vein, x$0 -> GT_UndergroundOilStore.hash(x$0));
            }
        }

        @Nullable
        public Fluid getFluid() {
            return this.fluid;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            if (this.amount != amount) {
                this.dirty = true;
            }
            this.amount = Math.max(0, amount);
        }

        public void changeAmount(int delta) {
            if (delta != 0) {
                this.dirty = true;
            }
            this.amount = Math.max(this.amount + delta, 0);
        }

        @Nullable
        public GT_UO_Fluid getVein() {
            return this.vein;
        }

        @Nullable
        public String getVeinKey() {
            return this.veinKey;
        }

        public int getVeinHash() {
            return this.veinHash;
        }

        @Override
        public boolean isSameAsDefault() {
            return !this.dirty;
        }
    }

    @ParametersAreNonnullByDefault
    private static class GT_UndergroundOilStore
    extends GT_ChunkAssociatedData<ChunkData> {
        private static final WeakHashMap<GT_UO_Fluid, Integer> hashes = new WeakHashMap();

        private GT_UndergroundOilStore() {
            super("UO", ChunkData.class, 64, (byte)0, false);
        }

        @Override
        protected void writeElement(DataOutput output, ChunkData element, World world, int chunkX, int chunkZ) throws IOException {
            output.writeInt(element.getVeinHash());
            if (element.getVeinKey() == null) {
                return;
            }
            output.writeUTF(element.getVeinKey());
            if (element.getAmount() > 0 && element.getFluid() != null) {
                output.writeInt(element.getAmount());
            } else {
                output.writeInt(-1);
            }
        }

        @Override
        protected ChunkData readElement(DataInput input, int version, World world, int chunkX, int chunkZ) throws IOException {
            int amount;
            if (version != 0) {
                throw new IOException("Region file corrupted");
            }
            ChunkData pristine = this.createElement(world, chunkX, chunkZ);
            int hash = input.readInt();
            String veinKey = hash != 0 ? input.readUTF() : null;
            int n = amount = hash != 0 ? input.readInt() : -1;
            if (hash != pristine.veinHash || !Objects.equals(veinKey, pristine.getVeinKey())) {
                return pristine;
            }
            if (hash == 0) {
                return NIL_FLUID_STACK;
            }
            return new ChunkData(amount, GT_Mod.gregtechproxy.mUndergroundOil.GetDimension(world.field_73011_w.field_76574_g).getUOFluid(veinKey), veinKey);
        }

        @Override
        protected ChunkData createElement(World world, int chunkX, int chunkZ) {
            Pair<GT_UO_Fluid, Integer> pristine = GT_UndergroundOil.getPristineAmount(world, chunkX, chunkZ);
            if (pristine == null) {
                return NIL_FLUID_STACK;
            }
            int dimensionId = world.field_73011_w.field_76574_g;
            GT_UO_Dimension dimension = GT_Mod.gregtechproxy.mUndergroundOil.GetDimension(dimensionId);
            return new ChunkData((Integer)pristine.getRight(), (GT_UO_Fluid)pristine.getLeft(), dimension.getUOFluidKey((GT_UO_Fluid)pristine.getLeft()), false);
        }

        private static int hash(@Nullable GT_UO_Fluid fluid) {
            if (fluid == null) {
                return 0;
            }
            int result = fluid.Registry.hashCode();
            result = 31 * result + fluid.MaxAmount;
            result = 31 * result + fluid.MinAmount;
            result = 31 * result + fluid.Chance;
            return (result = 31 * result + fluid.DecreasePerOperationAmount) == 0 ? 1 : result;
        }
    }
}

