/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import appeng.core.CreativeTab;
import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GT_Mod;
import gregtech.api.multitileentity.MultiTileEntityBlockInternal;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.MultiTileEntityContainer;
import gregtech.api.multitileentity.MultiTileEntityItemInternal;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Util;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class MultiTileEntityRegistry {
    private static final HashMap<String, MultiTileEntityRegistry> NAMED_REGISTRIES = new HashMap();
    private static final ItemStackMap<MultiTileEntityRegistry> REGISTRIES = new ItemStackMap(false);
    private static final HashSet<Class<?>> sRegisteredTileEntities = new HashSet();
    public HashMap<Short, CreativeTab> mCreativeTabs = new HashMap();
    public Map<Short, MultiTileEntityClassContainer> mRegistry = new HashMap<Short, MultiTileEntityClassContainer>();
    public List<MultiTileEntityClassContainer> mRegistrations = new ArrayList<MultiTileEntityClassContainer>();
    public final String mNameInternal;
    public final MultiTileEntityBlockInternal mBlock;
    public short mLastRegisteredID = Short.MAX_VALUE;

    private static MultiTileEntityBlockInternal regblock(String aNameInternal, MultiTileEntityBlockInternal aBlock, Class<? extends ItemBlock> aItemClass) {
        GameRegistry.registerBlock((Block)aBlock, aItemClass == null ? ItemBlock.class : aItemClass, (String)aNameInternal);
        return aBlock;
    }

    public MultiTileEntityRegistry(String aNameInternal) {
        this(aNameInternal, new MultiTileEntityBlockInternal(), MultiTileEntityItemInternal.class);
    }

    public MultiTileEntityRegistry(String aNameInternal, MultiTileEntityBlockInternal aBlock, Class<? extends ItemBlock> aItemClass) {
        this(aNameInternal, MultiTileEntityRegistry.regblock(aNameInternal, aBlock, aItemClass));
    }

    public MultiTileEntityRegistry(String aNameInternal, MultiTileEntityBlockInternal aBlock) {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("The MultiTileEntity Registry must be initialized during Preload Phase and not before");
        }
        this.mNameInternal = aNameInternal;
        this.mBlock = aBlock;
        GT_Mod.GT_FML_LOGGER.info(aNameInternal + " " + Block.func_149682_b((Block)aBlock) + "This is the answer");
        this.mBlock.mMultiTileEntityRegistry = this;
        REGISTRIES.put(new ItemStack(Item.func_150898_a((Block)aBlock), 1, Short.MAX_VALUE), (Object)this);
        NAMED_REGISTRIES.put(this.mNameInternal, this);
    }

    public static TileEntity getCanonicalTileEntity(int aRegistryID, int aMultiTileEntityID) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aRegistryID);
        if (tRegistry == null) {
            return null;
        }
        MultiTileEntityClassContainer tClassContainer = tRegistry.getClassContainer(aMultiTileEntityID);
        if (tClassContainer == null) {
            return null;
        }
        return tClassContainer.mCanonicalTileEntity;
    }

    public static MultiTileEntityRegistry getRegistry(int aRegistryID) {
        return (MultiTileEntityRegistry)REGISTRIES.get((Object)new ItemStack(Item.func_150899_d((int)aRegistryID), 1, Short.MAX_VALUE));
    }

    public static MultiTileEntityRegistry getRegistry(String aRegistryName) {
        return NAMED_REGISTRIES.get(aRegistryName);
    }

    public MultiTileEntityClassContainer create(int aID, Class<? extends MultiTileEntity> aClass) {
        return new MultiTileEntityClassContainer(this, aID, aClass);
    }

    public ItemStack add(String aLocalised, String aCategoricalName, MultiTileEntityClassContainer aClassContainer) {
        boolean tFailed = false;
        if (GT_Utility.isStringInvalid(aLocalised)) {
            GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Localisation Missing!");
            tFailed = true;
        }
        if (aClassContainer == null) {
            GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container is null!");
            tFailed = true;
        } else {
            if (aClassContainer.mClass == null) {
                GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class inside Class Container is null!");
                tFailed = true;
            }
            if (aClassContainer.mID == Short.MAX_VALUE) {
                GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container uses Wildcard MetaData!");
                tFailed = true;
            }
            if (aClassContainer.mID < 0) {
                GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container uses negative MetaData!");
                tFailed = true;
            }
            if (this.mRegistry.containsKey(aClassContainer.mID)) {
                GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: Class Container uses occupied MetaData! (" + aClassContainer.mID + ")");
                tFailed = true;
            }
        }
        if (tFailed) {
            GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: STACKTRACE START");
            int i = 0;
            for (StackTraceElement tElement : new Exception().getStackTrace()) {
                if (i++ >= 5 || tElement.getClassName().startsWith("sun")) break;
                GT_Mod.GT_FML_LOGGER.error("\tat " + tElement);
            }
            GT_Mod.GT_FML_LOGGER.error("MULTI-TILE REGISTRY ERROR: STACKTRACE END");
            return null;
        }
        GT_LanguageManager.addStringLocalization(this.mNameInternal + "." + aClassContainer.mID + ".name", aLocalised, false);
        this.mRegistry.put(aClassContainer.mID, aClassContainer);
        this.mLastRegisteredID = aClassContainer.mID;
        this.mRegistrations.add(aClassContainer);
        if (sRegisteredTileEntities.add(aClassContainer.mCanonicalTileEntity.getClass())) {
            aClassContainer.mCanonicalTileEntity.onRegistrationFirst(this, aClassContainer.mID);
        }
        return this.getItem(aClassContainer.mID);
    }

    public ItemStack getItem() {
        return this.getItem(this.mLastRegisteredID, 1L, null);
    }

    public ItemStack getItem(int aID) {
        return this.getItem(aID, 1L, null);
    }

    public ItemStack getItem(int aID, NBTTagCompound aNBT) {
        return this.getItem(aID, 1L, aNBT);
    }

    public ItemStack getItem(int aID, long aAmount) {
        return this.getItem(aID, aAmount, null);
    }

    public ItemStack getItem(int aID, long aAmount, NBTTagCompound aNBT) {
        MultiTileEntityContainer tTileEntityContainer;
        ItemStack rStack = new ItemStack((Block)this.mBlock, (int)aAmount, aID);
        if ((aNBT == null || aNBT.func_82582_d()) && (tTileEntityContainer = this.getNewTileEntityContainer(aID, aNBT = new NBTTagCompound())) != null) {
            ((IMultiTileEntity)tTileEntityContainer.mTileEntity).writeItemNBT(aNBT);
        }
        rStack.func_77982_d(aNBT);
        return rStack;
    }

    public String getLocal(int aID) {
        return StatCollector.func_74838_a((String)(this.mNameInternal + "." + aID + ".name"));
    }

    public MultiTileEntityClassContainer getClassContainer(int aID) {
        return this.mRegistry.get((short)aID);
    }

    public MultiTileEntityClassContainer getClassContainer(ItemStack aStack) {
        return this.mRegistry.get((short)Items.field_151008_G.getDamage(aStack));
    }

    public TileEntity getNewTileEntity(int aID) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(null, 0, 0, 0, aID, null);
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public MultiTileEntityContainer getNewTileEntityContainer(World aWorld, int aX, int aY, int aZ, int aID, NBTTagCompound aNBT) {
        MultiTileEntityClassContainer tClass = this.mRegistry.get((short)aID);
        if (tClass == null || tClass.mBlock == null) {
            return null;
        }
        MultiTileEntityContainer rContainer = new MultiTileEntityContainer((TileEntity)GT_Utility.callConstructor(tClass.mClass, -1, null, true, new Object[0]), tClass.mBlock, tClass.mBlockMetaData);
        if (rContainer.mTileEntity == null) {
            return null;
        }
        rContainer.mTileEntity.func_145834_a(aWorld);
        rContainer.mTileEntity.field_145851_c = aX;
        rContainer.mTileEntity.field_145848_d = aY;
        rContainer.mTileEntity.field_145849_e = aZ;
        ((IMultiTileEntity)rContainer.mTileEntity).initFromNBT(aNBT == null || aNBT.func_82582_d() ? tClass.mParameters : GT_Util.fuseNBT(aNBT, tClass.mParameters), (short)aID, (short)Block.func_149682_b((Block)this.mBlock));
        return rContainer;
    }

    public TileEntity getNewTileEntity(World aWorld, int aX, int aY, int aZ, int aID) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(aWorld, aX, aY, aZ, aID, null);
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public TileEntity getNewTileEntity(ItemStack aStack) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(null, 0, 0, 0, Items.field_151008_G.getDamage(aStack), aStack.func_77978_p());
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public TileEntity getNewTileEntity(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(aWorld, aX, aY, aZ, Items.field_151008_G.getDamage(aStack), aStack.func_77978_p());
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public MultiTileEntityContainer getNewTileEntityContainer(ItemStack aStack) {
        return this.getNewTileEntityContainer(null, 0, 0, 0, Items.field_151008_G.getDamage(aStack), aStack.func_77978_p());
    }

    public MultiTileEntityContainer getNewTileEntityContainer(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
        return this.getNewTileEntityContainer(aWorld, aX, aY, aZ, Items.field_151008_G.getDamage(aStack), aStack.func_77978_p());
    }

    public MultiTileEntityContainer getNewTileEntityContainer(int aID, NBTTagCompound aNBT) {
        return this.getNewTileEntityContainer(null, 0, 0, 0, aID, aNBT);
    }
}

