/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import appeng.api.crafting.ICraftingIconProvider;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_Hatch
extends GT_MetaTileEntity_BasicTank
implements ICraftingIconProvider {
    @Deprecated
    public byte mMachineBlock = 0;
    private byte mTexturePage = 0;
    private byte actualTexture = 0;
    private ItemStack ae2CraftingIcon;

    public GT_MetaTileEntity_Hatch(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public static int getSlots(int aTier) {
        return aTier < 1 ? 1 : (aTier == 1 ? 4 : (aTier == 2 ? 9 : 16));
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public abstract ITexture[] getTexturesActive(ITexture var1);

    public abstract ITexture[] getTexturesInactive(ITexture var1);

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        byte texturePointer = (byte)(this.actualTexture & 0x7F);
        int textureIndex = texturePointer | this.mTexturePage << 7;
        try {
            if (side != aFacing) {
                if (textureIndex > 0) {
                    return new ITexture[]{Textures.BlockIcons.casingTexturePages[this.mTexturePage][texturePointer]};
                }
                return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
            }
            if (textureIndex > 0) {
                if (aActive) {
                    return this.getTexturesActive(Textures.BlockIcons.casingTexturePages[this.mTexturePage][texturePointer]);
                }
                return this.getTexturesInactive(Textures.BlockIcons.casingTexturePages[this.mTexturePage][texturePointer]);
            }
            if (aActive) {
                return this.getTexturesActive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]);
            }
            return this.getTexturesInactive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]);
        }
        catch (NullPointerException npe) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[0][0]};
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mMachineBlock", this.actualTexture);
        aNBT.func_74774_a("mTexturePage", this.mTexturePage);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.actualTexture = aNBT.func_74771_c("mMachineBlock");
        this.mTexturePage = aNBT.func_74771_c("mTexturePage");
        if (this.mTexturePage != 0 && GT_Values.GT.isServerSide()) {
            this.actualTexture = (byte)(this.actualTexture | 0x80);
        }
        this.mMachineBlock = this.actualTexture;
    }

    public final void updateTexture(int id) {
        this.onValueUpdate((byte)id);
        this.onTexturePageUpdate((byte)(id >> 7));
    }

    public final void updateCraftingIcon(ItemStack icon) {
        this.ae2CraftingIcon = icon;
    }

    @Override
    public ItemStack getMachineCraftingIcon() {
        return this.ae2CraftingIcon;
    }

    @Deprecated
    public final void updateTexture(byte page, byte index) {
        this.onValueUpdate(index);
        this.onTexturePageUpdate(page);
    }

    @Override
    public final void onValueUpdate(byte aValue) {
        this.mMachineBlock = this.actualTexture = (byte)(aValue & 0x7F);
        this.mTexturePage = 0;
    }

    public long maxWorkingAmperesIn() {
        return this.maxAmperesIn();
    }

    public ConnectionType getConnectionType() {
        return ConnectionType.CABLE;
    }

    @Override
    public final byte getUpdateData() {
        return (byte)(this.actualTexture & 0x7F);
    }

    public final void onTexturePageUpdate(byte aValue) {
        this.mTexturePage = (byte)(aValue & 0x7F);
        if (this.mTexturePage != 0 && this.getBaseMetaTileEntity().isServerSide()) {
            this.actualTexture = this.mMachineBlock = (byte)(this.mMachineBlock | 0x80);
        }
    }

    public final byte getTexturePage() {
        return (byte)(this.mTexturePage & 0x7F);
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.actualTexture != this.mMachineBlock) {
            this.mMachineBlock = this.actualTexture = (byte)(this.mMachineBlock & 0x7F);
            this.mTexturePage = 0;
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public int getCircuitSlot() {
        return -1;
    }

    public static enum ConnectionType {
        CABLE,
        WIRELESS,
        LASER;

    }
}

