/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_Buffer
extends GT_MetaTileEntity_TieredMachineBlock {
    private static final int OUTPUT_INDEX = 0;
    private static final int ARROW_RIGHT_INDEX = 1;
    private static final int ARROW_DOWN_INDEX = 2;
    private static final int ARROW_LEFT_INDEX = 3;
    private static final int ARROW_UP_INDEX = 4;
    private static final int FRONT_INDEX = 5;
    public int mMaxStackSize = 64;
    public static int MAX = 8;
    public boolean bOutput = false;
    public boolean bRedstoneIfFull = false;
    public boolean bInvert = false;
    public boolean bStockingMode = false;
    public boolean bSortStacks = false;
    public int mSuccess = 0;
    public int mTargetStackSize = 0;

    public GT_MetaTileEntity_Buffer(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Buffer(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Buffer(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Buffer(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[ForgeDirection.VALID_DIRECTIONS.length][17][];
        ITexture tIcon = this.getOverlayIcon();
        ITexture tOut = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        ITexture tUp = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_UP), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_UP_GLOW).glow().build());
        ITexture tDown = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_DOWN), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_DOWN_GLOW).glow().build());
        ITexture tLeft = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_LEFT), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_LEFT_GLOW).glow().build());
        ITexture tRight = TextureFactory.of(TextureFactory.of(Textures.BlockIcons.ARROW_RIGHT), TextureFactory.builder().addIcon(Textures.BlockIcons.ARROW_RIGHT_GLOW).glow().build());
        for (int i = 0; i < rTextures[0].length; ++i) {
            rTextures[0][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tOut};
            rTextures[1][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tRight, tIcon};
            rTextures[2][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tDown, tIcon};
            rTextures[3][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tLeft, tIcon};
            rTextures[4][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tUp, tIcon};
            rTextures[5][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], tIcon};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        ++colorIndex;
        if (sideDirection == facingDirection) {
            return this.mTextures[5][colorIndex];
        }
        if (sideDirection.getOpposite() == facingDirection) {
            return this.mTextures[0][colorIndex];
        }
        switch (facingDirection) {
            case DOWN: {
                return this.mTextures[4][colorIndex];
            }
            case UP: {
                return this.mTextures[2][colorIndex];
            }
            case NORTH: {
                switch (sideDirection) {
                    case DOWN: 
                    case UP: {
                        return this.mTextures[2][colorIndex];
                    }
                    case WEST: {
                        return this.mTextures[1][colorIndex];
                    }
                    case EAST: {
                        return this.mTextures[3][colorIndex];
                    }
                }
                break;
            }
            case SOUTH: {
                switch (sideDirection) {
                    case DOWN: 
                    case UP: {
                        return this.mTextures[4][colorIndex];
                    }
                    case WEST: {
                        return this.mTextures[3][colorIndex];
                    }
                    case EAST: {
                        return this.mTextures[1][colorIndex];
                    }
                }
                break;
            }
            case WEST: {
                switch (sideDirection) {
                    case UP: 
                    case SOUTH: {
                        return this.mTextures[1][colorIndex];
                    }
                    case DOWN: 
                    case NORTH: {
                        return this.mTextures[3][colorIndex];
                    }
                }
                break;
            }
            case EAST: {
                switch (sideDirection) {
                    case UP: 
                    case SOUTH: {
                        return this.mTextures[3][colorIndex];
                    }
                    case DOWN: 
                    case NORTH: {
                        return this.mTextures[1][colorIndex];
                    }
                }
                break;
            }
        }
        return this.mTextures[5][colorIndex];
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < this.mInventory.length - 1;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return !this.isOutputFacing(side);
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getBackFacing() == side;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 512L;
    }

    @Override
    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier] * 50L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return this.bOutput ? GT_Values.V[this.mTier] : 0L;
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public long maxAmperesOut() {
        return 2L;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public abstract ITexture getOverlayIcon();

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("bInvert", this.bInvert);
        aNBT.func_74757_a("bOutput", this.bOutput);
        aNBT.func_74757_a("bRedstoneIfFull", this.bRedstoneIfFull);
        aNBT.func_74757_a("bStockingMode", this.bStockingMode);
        aNBT.func_74768_a("mTargetStackSize", this.mTargetStackSize);
        aNBT.func_74757_a("bSortStacks", this.bSortStacks);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.bInvert = aNBT.func_74767_n("bInvert");
        this.bOutput = aNBT.func_74767_n("bOutput");
        this.bRedstoneIfFull = aNBT.func_74767_n("bRedstoneIfFull");
        this.bSortStacks = aNBT.func_74767_n("bSortStacks");
        if (aNBT.func_74764_b("bStockingMode")) {
            this.bStockingMode = aNBT.func_74767_n("bStockingMode");
        }
        if (aNBT.func_74764_b("bSortStacks")) {
            this.bSortStacks = aNBT.func_74767_n("bSortStacks");
        }
        this.mTargetStackSize = aNBT.func_74762_e("mTargetStackSize");
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.mTargetStackSize > 0) {
            aNBT.func_74768_a("mTargetStackSize", this.mTargetStackSize);
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getBackFacing()) {
            this.mTargetStackSize = (byte)((this.mTargetStackSize + (aPlayer.func_70093_af() ? -1 : 1)) % 65);
            if (this.mTargetStackSize < 0) {
                this.mTargetStackSize = this.mMaxStackSize;
            }
            if (this.mTargetStackSize == 0) {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("098", "Do not regulate Item Stack Size"));
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("099", "Regulate Item Stack Size to: ") + this.mTargetStackSize);
            }
        }
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        wrenchingSide = wrenchingSide.getOpposite();
        if (this.getBaseMetaTileEntity().isValidFacing(wrenchingSide)) {
            this.getBaseMetaTileEntity().setFrontFacing(wrenchingSide);
            return true;
        }
        return false;
    }

    protected void handleRedstoneOutput(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.bRedstoneIfFull) {
            boolean hasEmptySlots = IntStream.range(0, this.mInventory.length).anyMatch(i -> this.isValidSlot(i) && this.mInventory[i] == null);
            Arrays.stream(ForgeDirection.VALID_DIRECTIONS).forEach(side -> aBaseMetaTileEntity.setInternalOutputRedstoneSignal((ForgeDirection)side, (byte)(this.bInvert ^ hasEmptySlots ? 0 : 15)));
        } else {
            for (ForgeDirection side2 : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setInternalOutputRedstoneSignal(side2, (byte)0);
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.isServerSide() && (aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified() || aTimer % 200L == 0L || this.mSuccess > 0)) {
            --this.mSuccess;
            this.updateSlots();
            this.moveItems(aBaseMetaTileEntity, aTimer);
            this.handleRedstoneOutput(aBaseMetaTileEntity);
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            aBaseMetaTileEntity.setInternalOutputRedstoneSignal(side, (byte)0);
        }
    }

    protected void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        this.moveItems(aBaseMetaTileEntity, aTimer, 1);
    }

    protected void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long ignoredTimer, int stacks) {
        int tCost = this.bStockingMode ? GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.getBackFacing(), aBaseMetaTileEntity.getFrontFacing(), null, false, (byte)(this.mTargetStackSize == 0 ? 64 : (byte)this.mTargetStackSize), this.mTargetStackSize == 0 ? (byte)1 : (byte)this.mTargetStackSize, (byte)64, (byte)1, stacks) : GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.getBackFacing(), aBaseMetaTileEntity.getFrontFacing(), null, false, (byte)64, (byte)1, (byte)(this.mTargetStackSize == 0 ? 64 : (byte)this.mTargetStackSize), this.mTargetStackSize == 0 ? (byte)1 : (byte)this.mTargetStackSize, stacks);
        if (tCost > 0 || aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.mSuccess = 50;
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side != aBaseMetaTileEntity.getBackFacing();
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        if (this.bSortStacks) {
            this.fillStacksIntoFirstSlots();
        }
    }

    protected void fillStacksIntoFirstSlots() {
        HashMap<GT_Utility.ItemId, Integer> slots = new HashMap<GT_Utility.ItemId, Integer>(this.mInventory.length);
        HashMap<GT_Utility.ItemId, ItemStack> stacks = new HashMap<GT_Utility.ItemId, ItemStack>(this.mInventory.length);
        ArrayList<GT_Utility.ItemId> order = new ArrayList<GT_Utility.ItemId>(this.mInventory.length);
        ArrayList<Integer> validSlots = new ArrayList<Integer>(this.mInventory.length);
        for (int i = 0; i < this.mInventory.length - 1; ++i) {
            if (!this.isValidSlot(i)) continue;
            validSlots.add(i);
            ItemStack s = this.mInventory[i];
            if (s == null) continue;
            GT_Utility.ItemId sID = GT_Utility.ItemId.createNoCopy(s);
            slots.merge(sID, s.field_77994_a, Integer::sum);
            if (!stacks.containsKey(sID)) {
                stacks.put(sID, s);
            }
            order.add(sID);
            this.mInventory[i] = null;
        }
        int slotindex = 0;
        for (GT_Utility.ItemId sID : order) {
            int toSet = (Integer)slots.get(sID);
            if (toSet == 0) continue;
            int slot = (Integer)validSlots.get(slotindex);
            ++slotindex;
            this.mInventory[slot] = ((ItemStack)stacks.get(sID)).func_77946_l();
            this.mInventory[slot].field_77994_a = toSet = Math.min(toSet, this.mInventory[slot].func_77976_d());
            slots.merge(sID, toSet, (a, b) -> a - b);
        }
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (entityPlayer.func_70093_af()) {
            this.bSortStacks = !this.bSortStacks;
            GT_Utility.sendChatToPlayer(entityPlayer, GT_Utility.trans("200", "Sort mode: ") + (this.bSortStacks ? GT_Utility.trans("088", "Enabled") : GT_Utility.trans("087", "Disabled")));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, entityPlayer, aX, aY, aZ);
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    protected void addEmitEnergyButton(ModularWindow.Builder builder) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            boolean bl = this.bOutput = !this.bOutput;
            if (this.bOutput) {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("116", "Emit Energy to Outputside"));
            } else {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("117", "Don't emit Energy"));
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_EMIT_ENERGY}).setPos(7, 62).setSize(18, 18));
    }

    protected void addEmitRedstoneButton(ModularWindow.Builder builder) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            boolean bl = this.bRedstoneIfFull = !this.bRedstoneIfFull;
            if (this.bRedstoneIfFull) {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("118", "Emit Redstone if no Slot is free"));
            } else {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("119", "Don't emit Redstone"));
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_EMIT_REDSTONE}).setPos(25, 62).setSize(18, 18));
    }

    protected void addInvertRedstoneButton(ModularWindow.Builder builder) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            boolean bl = this.bInvert = !this.bInvert;
            if (this.bInvert) {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("120", "Invert Redstone"));
            } else {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("121", "Don't invert Redstone"));
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_INVERT_REDSTONE}).setPos(43, 62).setSize(18, 18));
    }

    protected void addStockingModeButton(ModularWindow.Builder builder) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            boolean bl = this.bStockingMode = !this.bStockingMode;
            if (this.bStockingMode) {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("217", "Stocking mode. Keeps this many items in destination input slots. This mode can be server unfriendly."));
            } else {
                GT_Utility.sendChatToPlayer(widget.getContext().getPlayer(), GT_Utility.trans("218", "Transfer size mode. Add exactly this many items in destination input slots as long as there is room."));
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_STOCKING_MODE}).setPos(61, 62).setSize(18, 18));
    }

    protected void addInventorySlots(ModularWindow.Builder builder) {
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)9).endAtSlot(26).build().setPos(7, 4));
    }
}

