/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyInstance;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PartyManager
extends SimpleDatabase<IParty>
implements IPartyDatabase {
    public static final PartyManager INSTANCE = new PartyManager();
    private final HashMap<UUID, Integer> partyCache = new HashMap();

    public static void SyncPartyQuests(IParty party, UUID targetPlayer, boolean prohibitClaim) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        uuids.add(targetPlayer);
        PartyManager.SyncPartyQuests(party, uuids, prohibitClaim);
    }

    public static void SyncPartyQuests(IParty party, boolean prohibitClaim) {
        PartyManager.SyncPartyQuests(party, party.getMembers(), prohibitClaim);
    }

    private static void SyncPartyQuests(IParty party, List<UUID> targetUUIDs, boolean prohibitClaim) {
        new Thread(() -> {
            BetterQuesting.logger.info("Start force party quest sync");
            List<UUID> partyMembers = party.getMembers();
            List t = targetUUIDs.stream().map(SyncPlayerContainer::new).collect(Collectors.toList());
            for (Map.Entry questEntry : QuestDatabase.INSTANCE.entrySet()) {
                IQuest quest = (IQuest)questEntry.getValue();
                long completionTime = -1L;
                for (UUID member : partyMembers) {
                    NBTTagCompound completionInfo = quest.getCompletionInfo(member);
                    if (completionInfo == null) continue;
                    completionTime = completionInfo.func_74763_f("timestamp");
                    break;
                }
                if (completionTime == -1L) continue;
                for (SyncPlayerContainer target : t) {
                    if (quest.isComplete(target.uuid)) continue;
                    quest.setComplete(target.uuid, completionTime);
                    if (prohibitClaim) {
                        quest.setClaimed(target.uuid, completionTime);
                    }
                    if (target.isPlayerOnline()) {
                        target.questCache.markQuestDirty(questEntry.getKey());
                    }
                    SyncPlayerContainer syncPlayerContainer = target;
                    Integer.valueOf(syncPlayerContainer.questsCompleted + 1);
                    syncPlayerContainer.questsCompleted = syncPlayerContainer.questsCompleted;
                }
            }
            for (SyncPlayerContainer syncPlayerContainer : t) {
                if (syncPlayerContainer.questsCompleted == 0) continue;
                BetterQuesting.logger.info("Force party quest sync: completed " + syncPlayerContainer.questsCompleted + " quests for " + syncPlayerContainer.playerName);
            }
        }).start();
    }

    @Override
    public synchronized IParty createNew(int id) {
        PartyInstance party = new PartyInstance();
        if (id >= 0) {
            this.add(id, party);
        }
        return party;
    }

    @Override
    @Nullable
    public synchronized DBEntry<IParty> getParty(@Nonnull UUID uuid) {
        IParty cachedParty;
        if (!QuestSettings.INSTANCE.getProperty(NativeProps.PARTY_ENABLE).booleanValue()) {
            return null;
        }
        Integer cachedID = this.partyCache.get(uuid);
        IParty iParty = cachedParty = cachedID == null ? null : (IParty)this.getValue(cachedID);
        if (cachedID != null && cachedParty == null) {
            this.partyCache.remove(uuid);
        } else if (cachedParty != null) {
            EnumPartyStatus status = cachedParty.getStatus(uuid);
            if (status != null) {
                return new DBEntry<IParty>(cachedID, cachedParty);
            }
            this.partyCache.remove(uuid);
        }
        for (DBEntry<IParty> dBEntry : this.getEntries()) {
            EnumPartyStatus status = ((IParty)dBEntry.getValue()).getStatus(uuid);
            if (status == null) continue;
            this.partyCache.put(uuid, dBEntry.getID());
            return dBEntry;
        }
        return null;
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, @Nullable List<Integer> subset) {
        for (DBEntry entry : this.getEntries()) {
            if (subset != null && !subset.contains(entry.getID())) continue;
            NBTTagCompound jp = ((IParty)entry.getValue()).writeToNBT(new NBTTagCompound());
            jp.func_74768_a("partyID", entry.getID());
            json.func_74742_a((NBTBase)jp);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, boolean merge) {
        if (!merge) {
            this.reset();
        }
        for (int i = 0; i < json.func_74745_c(); ++i) {
            int partyID;
            NBTTagCompound jp = json.func_150305_b(i);
            int n = partyID = jp.func_150297_b("partyID", 99) ? jp.func_74762_e("partyID") : -1;
            if (partyID < 0) continue;
            PartyInstance party = new PartyInstance();
            party.readFromNBT(jp);
            if (party.getMembers().size() <= 0) continue;
            this.add(partyID, party);
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.partyCache.clear();
    }

    private static class SyncPlayerContainer {
        public UUID uuid;
        public EntityPlayerMP player;
        public QuestCache questCache;
        public String playerName;
        public Integer questsCompleted = 0;

        public SyncPlayerContainer(UUID uuid, EntityPlayerMP entityPlayerMP, QuestCache questCache, String playerName) {
            this.uuid = uuid;
            this.player = entityPlayerMP;
            this.questCache = questCache;
            this.playerName = playerName;
        }

        public SyncPlayerContainer(UUID uuid) {
            this.uuid = uuid;
            this.player = QuestingAPI.getPlayer(uuid);
            this.questCache = this.player != null ? (QuestCache)this.player.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString()) : null;
            this.playerName = this.player != null ? this.player.getDisplayName() : String.format("%s (%s)", uuid.toString(), NameCache.INSTANCE.getName(uuid));
        }

        public boolean isPlayerOnline() {
            return this.player != null;
        }
    }
}

