/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestDatabase;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.network.handlers.NetChapterEdit;
import betterquesting.network.handlers.NetQuestEdit;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Keyboard;

public class GuiQuestLineAddRemove
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen,
INeedsRefresh {
    @Nullable
    private IQuestLine questLine;
    private final UUID lineID;
    private CanvasQuestDatabase canvasDB;
    private CanvasScrolling canvasQL;

    public GuiQuestLineAddRemove(GuiScreen parent, @Nullable IQuestLine questLine) {
        super(parent);
        this.questLine = questLine;
        this.lineID = QuestLineDatabase.INSTANCE.lookupKey(questLine);
    }

    @Override
    public void refreshGui() {
        this.questLine = this.lineID == null ? null : (IQuestLine)QuestLineDatabase.INSTANCE.get(this.lineID);
        this.canvasDB.refreshSearch();
        if (this.questLine != null) {
            this.refreshQuestList();
        }
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        PanelTextBox panTxt = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.edit_line2", this.questLine == null ? "" : QuestTranslation.translateQuestLineName(this.lineID, this.questLine))).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(panTxt);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        CanvasEmpty cvLeft = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 8, 24), 8));
        cvBackground.addPanel(cvLeft);
        if (this.questLine != null) {
            PanelTextBox txtQuest = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translateQuestLineName(this.lineID, this.questLine)).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor());
            cvLeft.addPanel(txtQuest);
        }
        this.canvasQL = new CanvasScrolling(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0));
        cvLeft.addPanel(this.canvasQL);
        PanelVScrollBar scReq = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        cvLeft.addPanel(scReq);
        this.canvasQL.setScrollDriverY(scReq);
        CanvasEmpty cvRight = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 24), 0));
        cvBackground.addPanel(cvRight);
        PanelTextBox txtDb = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.database", new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_MAIN.getColor());
        cvRight.addPanel(txtDb);
        PanelTextField<String> searchBox = new PanelTextField<String>(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 8, -32), 0), "", FieldFilterString.INSTANCE);
        searchBox.setWatermark("Search...");
        cvRight.addPanel(searchBox);
        this.canvasDB = new CanvasQuestDatabase(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 32, 8, 24), 0)){

            @Override
            protected boolean addResult(Map.Entry<UUID, IQuest> entry, int index, int width) {
                PanelButtonStorage<Map.Entry<UUID, IQuest>> btnAdd = new PanelButtonStorage<Map.Entry<UUID, IQuest>>(new GuiRectangle(0, index * 16, 16, 16, 0), 2, "", entry);
                btnAdd.setIcon(PresetIcon.ICON_POSITIVE.getTexture());
                btnAdd.setActive(GuiQuestLineAddRemove.this.questLine != null && GuiQuestLineAddRemove.this.questLine.get(entry.getKey()) == null);
                this.addPanel(btnAdd);
                PanelButtonStorage<Map.Entry<UUID, IQuest>> btnEdit = new PanelButtonStorage<Map.Entry<UUID, IQuest>>(new GuiRectangle(16, index * 16, width - 32, 16, 0), 1, QuestTranslation.translateQuestName(entry), entry);
                this.addPanel(btnEdit);
                PanelButtonStorage<Map.Entry<UUID, IQuest>> btnDel = new PanelButtonStorage<Map.Entry<UUID, IQuest>>(new GuiRectangle(width - 16, index * 16, 16, 16, 0), 4, "", entry);
                btnDel.setIcon(PresetIcon.ICON_TRASH.getTexture());
                this.addPanel(btnDel);
                return true;
            }
        };
        cvRight.addPanel(this.canvasDB);
        searchBox.setCallback(this.canvasDB::setSearchFilter);
        PanelVScrollBar scDb = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 32, 0, 24), 0));
        cvRight.addPanel(scDb);
        this.canvasDB.setScrollDriverY(scDb);
        PanelButton btnNew = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(0, -16, 0, 0), 0), 5, QuestTranslation.translate("betterquesting.btn.new", new Object[0]));
        cvRight.addPanel(btnNew);
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -24, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine0);
        this.refreshQuestList();
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            Map.Entry entry = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuest(this, (UUID)entry.getKey()));
        } else if (btn.getButtonID() == 2) {
            Map.Entry entry = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            QuestLineEntry qe = new QuestLineEntry(0, 0);
            int x1 = 0;
            int y1 = 0;
            block0: while (this.questLine != null) {
                for (IQuestLineEntry qle : this.questLine.values()) {
                    int x2 = qle.getPosX();
                    int y2 = qle.getPosY();
                    int s2 = qle.getSize();
                    if (x1 < x2 || x1 >= x2 + s2 || y1 < y2 || y1 >= y2 + s2) continue;
                    x1 += s2;
                    y1 += s2;
                    continue block0;
                }
            }
            qe.setPosition(x1, y1);
            this.questLine.put(entry.getKey(), qe);
            this.SendChanges();
        } else if (btn.getButtonID() == 3 && this.questLine != null) {
            Map.Entry entry = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            this.questLine.remove(entry.getKey());
            this.SendChanges();
        } else if (btn.getButtonID() == 4) {
            Map.Entry entry = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74782_a("questIDs", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds(Collections.singletonList(entry.getKey())));
            payload.func_74768_a("action", 1);
            NetQuestEdit.sendEdit(payload);
        } else if (btn.getButtonID() == 5) {
            NBTTagCompound payload = new NBTTagCompound();
            NBTTagList dataList = new NBTTagList();
            NBTTagCompound entry = new NBTTagCompound();
            dataList.func_74742_a((NBTBase)entry);
            payload.func_74782_a("data", (NBTBase)dataList);
            payload.func_74768_a("action", 3);
            NetQuestEdit.sendEdit(payload);
        } else if (btn.getButtonID() == 6) {
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74782_a("questIDs", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds(Collections.singletonList(((PanelButtonStorage)btn).getStoredValue())));
            payload.func_74768_a("action", 1);
            NetQuestEdit.sendEdit(payload);
        }
    }

    private void refreshQuestList() {
        this.canvasQL.resetCanvas();
        if (this.questLine == null) {
            return;
        }
        int width = this.canvasQL.getTransform().getWidth();
        Iterator qleIterator = this.questLine.entrySet().iterator();
        int i = 0;
        while (qleIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)qleIterator.next();
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.get(entry.getKey());
            if (quest == null) {
                PanelButtonStorage btnErr = new PanelButtonStorage(new GuiRectangle(width - 16, i * 16, 16, 16, 0), 6, "[ERROR]", entry.getKey());
                btnErr.setActive(true);
                this.canvasQL.addPanel(btnErr);
            } else {
                Map.Entry questEntry = Maps.immutableEntry(entry.getKey(), (Object)quest);
                PanelButtonStorage<Map.Entry> btnEdit = new PanelButtonStorage<Map.Entry>(new GuiRectangle(0, i * 16, width - 16, 16, 0), 1, QuestTranslation.translateQuestName(questEntry), questEntry);
                this.canvasQL.addPanel(btnEdit);
                PanelButtonStorage<Map.Entry> btnRem = new PanelButtonStorage<Map.Entry>(new GuiRectangle(width - 16, i * 16, 16, 16, 0), 3, "", questEntry);
                btnRem.setIcon(PresetIcon.ICON_NEGATIVE.getTexture());
                this.canvasQL.addPanel(btnRem);
            }
            ++i;
        }
    }

    private void SendChanges() {
        if (this.questLine == null) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        NBTTagList dataList = new NBTTagList();
        NBTTagCompound entry = new NBTTagCompound();
        NBTConverter.UuidValueType.QUEST_LINE.writeId(this.lineID, entry);
        entry.func_74782_a("config", this.questLine.writeToNBT((NBTBase)new NBTTagCompound(), null));
        dataList.func_74742_a((NBTBase)entry);
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        NetChapterEdit.sendEdit(payload);
    }
}

