/*
 * Decompiled with CFR 0.152.
 */
package net.glease.ggfab.mte;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_AssemblyLineUtils;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GT_Waila;
import gregtech.api.util.IGT_HatchAdder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.glease.ggfab.BlockIcons;
import net.glease.ggfab.ConfigurationHandler;
import net.glease.ggfab.GGConstants;
import net.glease.ggfab.util.OverclockHelper;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTE_AdvAssLine
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<MTE_AdvAssLine>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final String STRUCTURE_PIECE_LAST = "last";
    public static final String TAG_KEY_CURRENT_STICK = "mCurrentStick";
    public static final String TAG_KEY_PROGRESS_TIMES = "mProgressTimeArray";
    private static final IStructureDefinition<MTE_AdvAssLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"~", "l", "G"}, {"g", "m", "g"}, {"b", "i", "b"}})).addShape("later", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"b", "I", "b"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"o", "i", "b"}})).addElement('G', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)10)).addElement('l', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)9)).addElement('m', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)5)).addElement('g', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlockUnlocalizedName((String)"IC2", (String)"blockAlloyGlass", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)"bartworks", (String)"BW_GlasBlocks", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)"Thaumcraft", (String)"blockCosmeticOpaque", (int)2, (boolean)false)})).addElement('e', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_HatchElement.Energy.or((IHatchElement)GT_HatchElement.ExoticEnergy).newAny(16, 1, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH}), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0)})).addElement('d', (IStructureElement)GT_StructureUtility.buildHatchAdder(MTE_AdvAssLine.class).atLeast(new IHatchElement[]{DataHatchElement.DataAccess}).dot(2).casingIndex(42).allowOnly(new ForgeDirection[]{ForgeDirection.NORTH}).buildAndChain(GregTech_API.sBlockCasings3, 10)).addElement('b', (IStructureElement)GT_StructureUtility.buildHatchAdder(MTE_AdvAssLine.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.Maintenance}).casingIndex(16).dot(3).allowOnly(new ForgeDirection[]{ForgeDirection.DOWN}).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)16, (int)4)})).addElement('I', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_HatchElement.InputBus.newAny(16, 5, new ForgeDirection[]{ForgeDirection.DOWN}), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)16, (int)4)})).addElement('i', GT_HatchElement.InputBus.newAny(16, 5, new ForgeDirection[]{ForgeDirection.DOWN})).addElement('o', GT_HatchElement.OutputBus.newAny(16, 4, new ForgeDirection[]{ForgeDirection.DOWN})).build();
    private ItemStack currentStick;
    private GT_Recipe.GT_Recipe_AssemblyLine currentRecipe;
    private final Slice[] slices = (Slice[])IntStream.range(0, 16).mapToObj(x$0 -> new Slice(x$0)).toArray(Slice[]::new);
    private boolean processing;
    private long inputVoltage;
    private long inputEUt;
    private long baseEUt;
    private boolean stuck;
    private final ArrayList<GT_MetaTileEntity_Hatch_DataAccess> mDataAccessHatches = new ArrayList();

    public MTE_AdvAssLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTE_AdvAssLine(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTE_AdvAssLine(this.mName);
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DataAccess) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((GT_MetaTileEntity_Hatch_DataAccess)aMetaTileEntity);
        }
        return false;
    }

    private boolean checkMachine() {
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 1, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 16; ++i) {
            if (!this.checkPiece(STRUCTURE_PIECE_LATER, leftToRight ? -i : i, 1, 0)) {
                return false;
            }
            if (this.mOutputBusses.isEmpty()) continue;
            return (!this.mEnergyHatches.isEmpty() || !this.mExoticEnergyHatches.isEmpty()) && this.mMaintenanceHatches.size() == 1 && this.mDataAccessHatches.size() <= 1;
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 1, 0);
        int tLength = Math.min(stackSize.field_77994_a + 3, 16);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LATER, stackSize, hintsOnly, -i, 1, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivialBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 0, 1, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        int tLength = Math.min(stackSize.field_77994_a + 3, 16);
        for (int i = 1; i < tLength - 1; ++i) {
            build = this.survivialBuildPiece(STRUCTURE_PIECE_LATER, stackSize, -i, 1, 0, elementBudget, env, false, true);
            if (build < 0) continue;
            return build;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_LAST, stackSize, 1 - tLength, 1, 0, elementBudget, env, false, true);
    }

    public void initDefaultModes(NBTTagCompound aNBT) {
        super.initDefaultModes(aNBT);
        if (this.getBaseMetaTileEntity() != null && this.getBaseMetaTileEntity().isServerSide()) {
            UUID ownerUuid = this.getBaseMetaTileEntity().getOwnerUuid();
            if (ownerUuid == null) {
                return;
            }
            float factor = ConfigurationHandler.INSTANCE.getLaserOCPenaltyFactor();
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server == null) {
                return;
            }
            List l = server.func_71203_ab().field_72404_b;
            for (EntityPlayerMP p : l) {
                if (!p.func_110124_au().equals(ownerUuid)) continue;
                for (int i = 0; i < 9; ++i) {
                    Object[] args;
                    switch (i) {
                        case 7: {
                            args = new Object[]{Float.valueOf(factor)};
                            break;
                        }
                        case 8: {
                            args = new Object[]{(int)(factor * 100.0f) + 400, (int)((4.0f + factor) * (4.0f + factor + factor) * 100.0f), Float.valueOf(4.0f + factor), Float.valueOf(4.0f + factor + factor)};
                            break;
                        }
                        default: {
                            args = new Object[]{};
                        }
                    }
                    p.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.advassline." + i, args));
                }
            }
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (this.stuck) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(new IIconContainer[]{BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_STUCK}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_STUCK_GLOW}).extFacing().glow().build()};
            }
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(new IIconContainer[]{BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(new IIconContainer[]{BlockIcons.OVERLAY_FRONT_ADV_ASSLINE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{BlockIcons.OVERLAY_FRONT_ADV_ASSLINE_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Assembling Line").addInfo("Controller block for the Advanced Assembling Line").addInfo("Built exactly the same as standard Assembling Line").addInfo("Place in world to get more info. It will be a lengthy read.").addInfo("Assembling Line with item pipelining").addInfo("All fluids are however consumed at start").addInfo("Use voltage of worst energy hatch for overclocking").addInfo("EU/t is (number of slices working) * (overclocked EU/t)").addSeparator().beginVariableStructureBlock(5, 16, 4, 4, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input Bus (last can be Output Bus), Solid Steel Machine Casing").addStructureInfo("Layer 2 - Borosilicate Glass(any)/Warded Glass/Reinforced Glass, Assembling Line Casing, Reinforced Glass").addStructureInfo("Layer 3 - Grate Machine Casing, Assembler Machine Casing, Grate Machine Casing").addStructureInfo("Layer 4 - Empty, Solid Steel Machine Casing, Empty").addStructureInfo("Up to 16 repeating slices, each one allows for 1 more item in recipes").addController("Either Grate on layer 3 of the first slice").addEnergyHatch("Any layer 4 casing", new int[]{1}).addMaintenanceHatch("Any layer 1 casing", new int[]{3}).addInputBus("As specified on layer 1", new int[]{4, 5}).addInputHatch("Any layer 1 casing", new int[]{3}).addOutputBus("Replaces Input Bus on final slice or on any solid steel casing on layer 1", new int[]{4}).addOtherStructurePart("Data Access Hatch", "Optional, next to controller", new int[]{2}).toolTipFinisher(GGConstants.GGMARK);
        return tt;
    }

    private void setCurrentRecipe(ItemStack stick, GT_Recipe.GT_Recipe_AssemblyLine recipe) {
        this.currentRecipe = recipe;
        this.currentStick = stick;
    }

    private void clearCurrentRecipe() {
        this.currentRecipe = null;
        this.currentStick = null;
        this.stuck = false;
        this.baseEUt = 0L;
        for (Slice slice : this.slices) {
            slice.reset();
        }
        this.mMaxProgresstime = 0;
        this.getBaseMetaTileEntity().issueClientUpdate();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.getBaseMetaTileEntity().isActive() && GT_Utility.isStackValid((Object)this.currentStick)) {
            aNBT.func_74782_a(TAG_KEY_CURRENT_STICK, (NBTBase)this.currentStick.func_77955_b(new NBTTagCompound()));
            aNBT.func_74768_a("mRecipeHash", this.currentRecipe.getPersistentHash());
            aNBT.func_74783_a(TAG_KEY_PROGRESS_TIMES, Arrays.stream(this.slices).limit(this.currentRecipe.mInputs.length).mapToInt(s -> ((Slice)s).progress).toArray());
            aNBT.func_74757_a("stuck", this.stuck);
            aNBT.func_74772_a("inputV", this.inputVoltage);
            aNBT.func_74772_a("inputEU", this.inputEUt);
            aNBT.func_74772_a("baseEU", this.baseEUt);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        ItemStack loadedStack = null;
        GT_Recipe.GT_Recipe_AssemblyLine recipe = null;
        if (aNBT.func_150297_b(TAG_KEY_PROGRESS_TIMES, 11)) {
            int[] arr = aNBT.func_74759_k(TAG_KEY_PROGRESS_TIMES);
            for (int i = 0; i < this.slices.length; ++i) {
                if (i < arr.length) {
                    this.slices[i].progress = arr[i];
                    if (arr[i] != 0) continue;
                    this.stuck = true;
                    continue;
                }
                this.slices[i].reset();
            }
        }
        if (aNBT.func_150297_b(TAG_KEY_CURRENT_STICK, 10)) {
            loadedStack = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l(TAG_KEY_CURRENT_STICK));
            GT_AssemblyLineUtils.LookupResult lookupResult = GT_AssemblyLineUtils.findAssemblyLineRecipeFromDataStick((ItemStack)loadedStack, (boolean)false);
            switch (lookupResult.getType()) {
                case VALID_STACK_AND_VALID_HASH: {
                    recipe = lookupResult.getRecipe();
                    this.stuck = aNBT.func_74767_n("stuck");
                    this.inputVoltage = aNBT.func_74763_f("inputV");
                    this.inputEUt = aNBT.func_74763_f("inputEU");
                    this.baseEUt = aNBT.func_74763_f("baseEU");
                    if (this.inputVoltage > 0L && this.inputEUt > 0L && this.baseEUt < 0L) break;
                    this.criticalStopMachine();
                    loadedStack = null;
                    recipe = null;
                    break;
                }
                default: {
                    this.criticalStopMachine();
                    loadedStack = null;
                }
            }
        }
        this.setCurrentRecipe(loadedStack, recipe);
    }

    public IStructureDefinition<MTE_AdvAssLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void clearHatches() {
        super.clearHatches();
        this.mExoticEnergyHatches.clear();
        this.mDataAccessHatches.clear();
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (this.checkMachine() && (this.mEnergyHatches.size() > 0 || this.mExoticEnergyHatches.size() > 0)) {
            long oV = this.inputVoltage;
            long oEut = this.inputEUt;
            this.inputVoltage = Integer.MAX_VALUE;
            this.inputEUt = 0L;
            this.mEnergyHatches.forEach(this::recordEnergySupplier);
            this.mExoticEnergyHatches.forEach(this::recordEnergySupplier);
            if (this.mMaxProgresstime > 0 && (oV != this.inputVoltage || oEut != this.inputEUt)) {
                this.criticalStopMachine();
            }
            return true;
        }
        this.inputVoltage = GT_Values.V[0];
        return false;
    }

    private void recordEnergySupplier(GT_MetaTileEntity_Hatch hatch) {
        if (!MTE_AdvAssLine.isValidMetaTileEntity((MetaTileEntity)hatch)) {
            return;
        }
        this.inputEUt += hatch.maxEUInput() * hatch.maxWorkingAmperesIn();
        this.inputVoltage = Math.min(this.inputVoltage, hatch.maxEUInput());
        if (this.inputEUt < 0L) {
            this.inputEUt = Long.MAX_VALUE;
        }
    }

    protected void startRecipeProcessing() {
        if (!this.processing) {
            super.startRecipeProcessing();
            this.processing = true;
        }
    }

    protected void endRecipeProcessing() {
        if (!this.processing) {
            return;
        }
        super.endRecipeProcessing();
        this.processing = false;
    }

    public void onValueUpdate(byte aValue) {
        boolean oStuck = this.stuck;
        boolean bl = this.stuck = (aValue & 1) == 1;
        if (oStuck != this.stuck) {
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    public byte getUpdateData() {
        return (byte)(this.stuck ? 1 : 0);
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.currentRecipe == null) {
            this.criticalStopMachine();
            return false;
        }
        for (GT_MetaTileEntity_Hatch_DataAccess hatch_dataAccess : this.mDataAccessHatches) {
            hatch_dataAccess.setActive(true);
        }
        if (this.mInputBusses.size() < this.currentRecipe.mInputs.length) {
            this.criticalStopMachine();
            return false;
        }
        boolean oStuck = this.stuck;
        this.stuck = false;
        for (int i = this.slices.length - 1; i >= 0; --i) {
            this.slices[i].tick();
        }
        if (oStuck != this.stuck) {
            this.getBaseMetaTileEntity().issueClientUpdate();
        }
        boolean foundWorking = false;
        int working = 0;
        for (Slice slice : this.slices) {
            if (slice.progress >= 0 && !foundWorking) {
                foundWorking = true;
                this.mProgresstime = (slice.id + 1) * (this.mMaxProgresstime / this.currentRecipe.mInputs.length) - slice.progress;
            }
            if (slice.progress <= 0) continue;
            ++working;
        }
        this.lEUt = (long)working * this.baseEUt;
        if (this.lEUt > 0L) {
            this.lEUt = Long.MIN_VALUE;
            for (int i = 0; i < working; ++i) {
                if (this.drainEnergyInput(-this.baseEUt)) continue;
                this.criticalStopMachine();
                return false;
            }
        } else if (!super.onRunningTick(aStack)) {
            return false;
        }
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.hasAllFluids(this.currentRecipe) && this.slices[0].start()) {
            this.drainAllFluids(this.currentRecipe);
            this.mProgresstime = 0;
        }
        this.endRecipeProcessing();
        return true;
    }

    private GT_Recipe.GT_Recipe_AssemblyLine findRecipe(ItemStack tDataStick) {
        GT_AssemblyLineUtils.LookupResult tLookupResult = GT_AssemblyLineUtils.findAssemblyLineRecipeFromDataStick((ItemStack)tDataStick, (boolean)false);
        if (tLookupResult.getType() == GT_AssemblyLineUtils.LookupResultType.INVALID_STICK) {
            return null;
        }
        GT_Recipe.GT_Recipe_AssemblyLine tRecipe = tLookupResult.getRecipe();
        if (tLookupResult.getType() != GT_AssemblyLineUtils.LookupResultType.VALID_STACK_AND_VALID_HASH && (tRecipe = GT_AssemblyLineUtils.processDataStick((ItemStack)tDataStick)) == null) {
            return null;
        }
        int aItemCount = tRecipe.mInputs.length;
        if (this.mInputBusses.size() < aItemCount) {
            return null;
        }
        for (int i = 0; i < aItemCount; ++i) {
            GT_MetaTileEntity_Hatch_InputBus tInputBus = (GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i);
            if (tInputBus == null) {
                return null;
            }
            ItemStack tSlotStack = tInputBus.func_70301_a(0);
            int tRequiredStackSize = MTE_AdvAssLine.isStackValidIngredient(tSlotStack, tRecipe.mInputs[i], tRecipe.mOreDictAlt[i]);
            if (tRequiredStackSize < 0) {
                return null;
            }
            if (!GT_Values.D1) continue;
            GT_Mod.GT_FML_LOGGER.info("Item: " + i + " accepted");
        }
        if (!this.hasAllFluids(tRecipe)) {
            return null;
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Check overclock");
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Find available recipe");
        }
        return tRecipe;
    }

    private boolean hasAllFluids(GT_Recipe.GT_Recipe_AssemblyLine tRecipe) {
        int aFluidCount = tRecipe.mFluidInputs.length;
        if (this.mInputHatches.size() < aFluidCount) {
            return false;
        }
        for (int i = 0; i < aFluidCount; ++i) {
            GT_MetaTileEntity_Hatch_Input tInputHatch = (GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(i);
            if (!MTE_AdvAssLine.isValidMetaTileEntity((MetaTileEntity)tInputHatch)) {
                return false;
            }
            FluidStack drained = tInputHatch.drain(ForgeDirection.UNKNOWN, tRecipe.mFluidInputs[i], false);
            if (drained == null || drained.amount < tRecipe.mFluidInputs[i].amount) {
                return false;
            }
            if (!GT_Values.D1) continue;
            GT_Mod.GT_FML_LOGGER.info("Fluid:" + i + " accepted");
        }
        return true;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual((Object)aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual((Object)aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual((Object)aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStackValid((Object)this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (GT_MetaTileEntity_Hatch_DataAccess tHatch : this.mDataAccessHatches) {
            if (!MTE_AdvAssLine.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Start Adv ALine recipe check");
        }
        this.clearCurrentRecipe();
        ArrayList<ItemStack> tDataStickList = this.getDataItems(2);
        if (tDataStickList.isEmpty()) {
            return false;
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Stick accepted, " + tDataStickList.size() + " Data Sticks found");
        }
        GT_Recipe.GT_Recipe_AssemblyLine recipe = null;
        for (ItemStack stack : tDataStickList) {
            OverclockHelper.OverclockOutput laserOverclock;
            recipe = this.findRecipe(stack);
            if (recipe == null || (long)recipe.mEUt > this.inputVoltage) continue;
            this.setCurrentRecipe(stack, recipe);
            GT_OverclockCalculator ocCalc = new GT_OverclockCalculator().setRecipeEUt((long)this.currentRecipe.mEUt).setDuration(Math.max(recipe.mDuration / recipe.mInputs.length, 1)).setEUt(this.inputVoltage);
            this.lEUt = ocCalc.getConsumption();
            this.mMaxProgresstime = ocCalc.getDuration();
            if (!this.mExoticEnergyHatches.isEmpty() && (laserOverclock = OverclockHelper.laserOverclock(this.lEUt, this.mMaxProgresstime, this.inputEUt / (long)recipe.mInputs.length, ConfigurationHandler.INSTANCE.getLaserOCPenaltyFactor())) != null) {
                this.lEUt = laserOverclock.getEUt();
                this.mMaxProgresstime = laserOverclock.getDuration();
            }
            this.mMaxProgresstime *= recipe.mInputs.length;
            break;
        }
        if (recipe == null) {
            if (GT_Values.D1) {
                GT_Mod.GT_FML_LOGGER.info("Did not find a recipe");
            }
            return false;
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("All checked start consuming inputs");
        }
        if (!this.slices[0].start()) {
            this.clearCurrentRecipe();
            return false;
        }
        this.drainAllFluids(recipe);
        this.mOutputItems = new ItemStack[]{recipe.mOutput};
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.baseEUt = this.lEUt;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Recipe successful");
        }
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        String machineProgressString = GT_Waila.getMachineProgressString((boolean)tag.func_74767_n("isActive"), (int)tag.func_74762_e("maxProgress"), (int)tag.func_74762_e("progress"));
        currentTip.remove(machineProgressString);
        int duration = tag.func_74762_e("mDuration");
        if (tag.func_150297_b(TAG_KEY_PROGRESS_TIMES, 9)) {
            NBTTagList tl = tag.func_150295_c(TAG_KEY_PROGRESS_TIMES, 3);
            List list = tl.field_74747_a;
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                NBTTagInt t = (NBTTagInt)list.get(i);
                int progress = t.func_150287_d();
                if (progress == 0) {
                    currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice.stuck", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if (progress < 0) {
                    currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice.idle", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if (duration > 40) {
                    currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice", (Object[])new Object[]{i + 1, (duration - progress) / 20, duration / 20}));
                    continue;
                }
                currentTip.add(I18n.func_135052_a((String)"ggfab.waila.advassline.slice.small", (Object[])new Object[]{i + 1, duration - progress, duration}));
            }
        }
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.currentRecipe == null || !this.getBaseMetaTileEntity().isActive()) {
            return;
        }
        NBTTagList l = new NBTTagList();
        for (int i = 0; i < this.currentRecipe.mInputs.length; ++i) {
            l.func_74742_a((NBTBase)new NBTTagInt(this.slices[i].progress));
        }
        tag.func_74782_a(TAG_KEY_PROGRESS_TIMES, (NBTBase)l);
        tag.func_74768_a("mDuration", this.mMaxProgresstime / this.currentRecipe.mInputs.length);
    }

    private void drainAllFluids(GT_Recipe.GT_Recipe_AssemblyLine recipe) {
        for (int i = 0; i < recipe.mFluidInputs.length; ++i) {
            this.depleteInput(recipe.mFluidInputs[i]);
        }
    }

    public void stopMachine() {
        this.clearCurrentRecipe();
        super.stopMachine();
    }

    private static int isStackValidIngredient(ItemStack aSlotStack, ItemStack aIngredient, ItemStack[] alts) {
        if (alts == null || alts.length == 0) {
            return MTE_AdvAssLine.isStackValidIngredient(aSlotStack, aIngredient);
        }
        for (ItemStack tAltStack : alts) {
            int i = MTE_AdvAssLine.isStackValidIngredient(aSlotStack, tAltStack);
            if (i < 0) continue;
            return i;
        }
        return -1;
    }

    private static int isStackValidIngredient(ItemStack aSlotStack, ItemStack aIngredient) {
        if (GT_Utility.areStacksEqual((ItemStack)aSlotStack, (ItemStack)aIngredient, (boolean)true) && aIngredient.field_77994_a <= aSlotStack.field_77994_a) {
            return aIngredient.field_77994_a;
        }
        return -1;
    }

    private static enum DataHatchElement implements IHatchElement<MTE_AdvAssLine>
    {
        DataAccess;


        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(GT_MetaTileEntity_Hatch_DataAccess.class);
        }

        public IGT_HatchAdder<MTE_AdvAssLine> adder() {
            return MTE_AdvAssLine::addDataAccessToMachineList;
        }

        public long count(MTE_AdvAssLine t) {
            return t.mDataAccessHatches.size();
        }
    }

    private class Slice {
        private final int id;
        private int progress = -1;

        public Slice(int id) {
            this.id = id;
        }

        public void reset() {
            this.progress = -1;
        }

        public void tick() {
            if (this.progress < 0) {
                return;
            }
            if (this.progress == 0 || --this.progress == 0) {
                if (this.id + 1 >= ((MTE_AdvAssLine)MTE_AdvAssLine.this).currentRecipe.mInputs.length) {
                    MTE_AdvAssLine.this.addOutput(((MTE_AdvAssLine)MTE_AdvAssLine.this).currentRecipe.mOutput);
                    this.reset();
                } else if (MTE_AdvAssLine.this.slices[this.id + 1].start()) {
                    this.reset();
                } else {
                    MTE_AdvAssLine.this.stuck = true;
                }
            }
        }

        public boolean start() {
            if (this.progress >= 0) {
                return false;
            }
            MTE_AdvAssLine.this.startRecipeProcessing();
            GT_MetaTileEntity_Hatch_InputBus bus = (GT_MetaTileEntity_Hatch_InputBus)MTE_AdvAssLine.this.mInputBusses.get(this.id);
            ItemStack stack = bus.func_70301_a(0);
            int size = MTE_AdvAssLine.isStackValidIngredient(stack, ((MTE_AdvAssLine)MTE_AdvAssLine.this).currentRecipe.mInputs[this.id], ((MTE_AdvAssLine)MTE_AdvAssLine.this).currentRecipe.mOreDictAlt[this.id]);
            if (size < 0) {
                return false;
            }
            this.progress = MTE_AdvAssLine.this.mMaxProgresstime / ((MTE_AdvAssLine)MTE_AdvAssLine.this).currentRecipe.mInputs.length;
            stack.field_77994_a -= size;
            bus.updateSlots();
            return true;
        }

        public boolean canStart() {
            if (this.progress >= 0) {
                return false;
            }
            return this.hasInput();
        }

        public boolean hasInput() {
            ItemStack stack = ((GT_MetaTileEntity_Hatch_InputBus)MTE_AdvAssLine.this.mInputBusses.get(this.id)).func_70301_a(0);
            return MTE_AdvAssLine.isStackValidIngredient(stack, ((MTE_AdvAssLine)MTE_AdvAssLine.this).currentRecipe.mInputs[this.id], ((MTE_AdvAssLine)MTE_AdvAssLine.this).currentRecipe.mOreDictAlt[this.id]) >= 0;
        }

        public String toString() {
            return "Slice{id=" + this.id + ", progress=" + this.progress + '}';
        }
    }
}

