/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.pyramid;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.item.ARItems;
import de.katzenpapst.amunra.world.mapgen.BaseStructureComponent;
import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import de.katzenpapst.amunra.world.mapgen.pyramid.PyramidRoom;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.ChestGenHooks;

public class Pyramid
extends BaseStructureStart {
    protected int pyramidSize = 56;
    protected BlockMetaPair wallMaterial = ARBlocks.blockAluCrate;
    protected BlockMetaPair floorMaterial = ARBlocks.blockSmoothBasalt;
    protected BlockMetaPair fillMaterial = ARBlocks.blockBasaltBrick;
    private final int innerRingOffset = 32;
    private final int tunnelWidth = 3;
    private final int tunnelHeight = 4;
    private final int mainRoomOffset = 3;
    private final int innerRoomOffset = 13;
    private final int smallRoomWidth = 17;
    private final PyramidRoom[] roomList = new PyramidRoom[12];
    private PyramidRoom centralRoom = null;
    public static final String LOOT_CATEGORY_BASIC = "amunraPyramidChest";
    public static final String LOOT_CATEGORY_BOSS = "amunraPyramidChestBoss";
    private static boolean initDone = false;

    static void initLoot() {
        if (initDone) {
            return;
        }
        initDone = true;
        WeightedRandomChestContent alienBook = new WeightedRandomChestContent(ARItems.alienBook.getItemStack(0), 1, 1, 3);
        WeightedRandomChestContent ironIngot = new WeightedRandomChestContent(new ItemStack(Items.field_151042_j, 2), 1, 5, 10);
        WeightedRandomChestContent goldIngot = new WeightedRandomChestContent(new ItemStack(Items.field_151043_k, 0), 1, 3, 5);
        WeightedRandomChestContent diamond = new WeightedRandomChestContent(new ItemStack(Items.field_151045_i, 0), 1, 3, 5);
        WeightedRandomChestContent lithium = new WeightedRandomChestContent(ARItems.lithiumGem.getItemStack(1), 1, 3, 5);
        WeightedRandomChestContent coldcrystal = new WeightedRandomChestContent(ARItems.coldCrystal.getItemStack(1), 1, 3, 5);
        WeightedRandomChestContent ruby = new WeightedRandomChestContent(ARItems.rubyGem.getItemStack(1), 1, 3, 5);
        WeightedRandomChestContent deshPick = new WeightedRandomChestContent(new ItemStack(MarsItems.deshPickaxe, 0), 1, 1, 1);
        WeightedRandomChestContent desh = new WeightedRandomChestContent(new ItemStack(MarsItems.marsItemBasic, 0, 0), 1, 1, 5);
        WeightedRandomChestContent nanites = new WeightedRandomChestContent(ARItems.naniteCluster.getItemStack(1), 1, 1, 2);
        WeightedRandomChestContent pearl = new WeightedRandomChestContent(new ItemStack(Items.field_151079_bi), 1, 1, 2);
        ChestGenHooks basicLoot = ChestGenHooks.getInfo((String)LOOT_CATEGORY_BASIC);
        basicLoot.setMin(5);
        basicLoot.setMax(8);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)alienBook);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)ironIngot);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)goldIngot);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)diamond);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)nanites);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)pearl);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)lithium);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)coldcrystal);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)ruby);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)deshPick);
        ChestGenHooks.addItem((String)LOOT_CATEGORY_BASIC, (WeightedRandomChestContent)desh);
    }

    public Pyramid(World world, int chunkX, int chunkZ, Random rand) {
        super(world, chunkX, chunkZ, rand);
        int startX = CoordHelper.chunkToMinBlock(chunkX);
        int startZ = CoordHelper.chunkToMinBlock(chunkZ);
        StructureBoundingBox bb = new StructureBoundingBox(startX - 56, startZ - 56, startX + 56 - 1, startZ + 56 - 1);
        this.setStructureBoundingBox(bb);
        Pyramid.initLoot();
        AmunRa.LOGGER.debug("Generating Pyramid at {}/{}", new Object[]{startX, startZ});
    }

    public void setSmallRooms(List<BaseStructureComponent> roomList) {
        if (roomList.size() < 12) {
            while (roomList.size() < 12) {
                PyramidRoom filler = new PyramidRoom();
                roomList.add(filler);
            }
        } else {
            while (roomList.size() > 12) {
                roomList.remove(roomList.size() - 1);
            }
        }
        Collections.shuffle(roomList, this.rand);
        Object[] tempList = roomList.toArray();
        for (int i = 0; i < 12; ++i) {
            Object object = tempList[i];
            if (!(object instanceof PyramidRoom)) continue;
            PyramidRoom room = (PyramidRoom)object;
            room.setParent(this);
            StructureBoundingBox roomBB = this.getSmallRoomBB(i + 1);
            roomBB.field_78895_b = 0;
            roomBB.field_78894_e = 4;
            StructureBoundingBox entranceBB = this.getRoomEntranceBox(i + 1, roomBB);
            room.setBoundingBoxes(entranceBB, roomBB);
            this.roomList[i] = room;
        }
    }

    public void setMainRoom(PyramidRoom room) {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        int innerRoomTotalOffset = this.innerRingOffset + 3 + 3;
        StructureBoundingBox innerRoomBB = new StructureBoundingBox(this.structBB.field_78897_a + innerRoomTotalOffset, this.structBB.field_78896_c + innerRoomTotalOffset, this.structBB.field_78893_d - innerRoomTotalOffset, this.structBB.field_78892_f - innerRoomTotalOffset);
        innerRoomBB.field_78895_b = 0;
        innerRoomBB.field_78894_e = 8;
        StructureBoundingBox mainEntranceBB = new StructureBoundingBox();
        mainEntranceBB.field_78897_a = innerRoomBB.func_78881_e() - 1;
        mainEntranceBB.field_78893_d = innerRoomBB.func_78881_e() + 1;
        mainEntranceBB.field_78896_c = innerRoomBB.field_78892_f + 1;
        mainEntranceBB.field_78892_f = innerRoomBB.field_78892_f + 4;
        this.centralRoom = room;
        this.centralRoom.setBoundingBoxes(mainEntranceBB, innerRoomBB);
        this.centralRoom.setParent(this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] blocks, byte[] metas) {
        super.generateChunk(chunkX, chunkZ, blocks, metas);
        chunkBB = CoordHelper.getChunkBB(chunkX, chunkZ);
        myBB = this.getStructureBoundingBox();
        if (!chunkBB.func_78884_a(myBB)) {
            return false;
        }
        fallbackGround = this.getWorldGroundLevel();
        if (this.groundLevel == -1) {
            this.groundLevel = Pyramid.getAverageGroundLevel(blocks, metas, this.getStructureBoundingBox(), chunkBB, fallbackGround);
            if (this.groundLevel == -1) {
                this.groundLevel = fallbackGround;
            }
        }
        startX = false;
        stopX = myBB.func_78883_b();
        startZ = false;
        stopZ = myBB.func_78880_d();
        radius = xCenter = (int)Math.ceil((stopX - 0) / 2 + 0);
        for (x = 0; x <= stopX; ++x) {
            for (z = 0; z <= stopZ; ++z) {
                highestGroundBlock = this.getHighestSolidBlockInBB(blocks, metas, chunkX, chunkZ, x, z);
                if (highestGroundBlock == -1) continue;
                for (y = highestGroundBlock - 1; y < this.groundLevel; ++y) {
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, y, z, this.fillMaterial);
                }
                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel, z, this.floorMaterial);
                for (y = 0; y <= radius; ++y) {
                    if (x >= 0 + y && x <= stopX - y && z >= 0 + y && z <= stopZ - y) {
                        if (z == 0 + y || z == stopZ - y || x == 0 + y || x == stopX - y) {
                            this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, this.wallMaterial);
                        } else {
                            this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, this.fillMaterial);
                        }
                    }
                    if (y < 5 || y > 13) continue;
                    if (x >= xCenter - 4 && x <= xCenter + 4) {
                        if (z >= 5 && z <= 12) {
                            if (x == xCenter - 4 || x == xCenter + 4 || y == 13) {
                                if (z == 5 || y == 13) {
                                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, this.fillMaterial);
                                }
                            } else if (z > 5) {
                                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, this.fillMaterial);
                            }
                        }
                        if (x >= xCenter - 1 && x <= xCenter + 1 && z >= 6 && y >= 5 && y <= 6 + this.tunnelHeight && z >= 5) {
                            Objects.requireNonNull(this);
                            if (z <= 5 + this.innerRingOffset - 3) {
                                if (y == 5) {
                                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, this.floorMaterial);
                                } else {
                                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, Blocks.field_150350_a, 0);
                                }
                            }
                        }
                    }
                    if (y < 5 || y > 6 + this.tunnelHeight || x < 0 + this.innerRingOffset || x > stopX - this.innerRingOffset || z < 0 + this.innerRingOffset || z > stopZ - this.innerRingOffset) continue;
                    if (x < 0 + this.innerRingOffset) ** GOTO lbl-1000
                    Objects.requireNonNull(this);
                    if (x < 0 + this.innerRingOffset + 3) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = xMinEdge = false;
                    }
                    if (x > stopX - this.innerRingOffset) ** GOTO lbl-1000
                    Objects.requireNonNull(this);
                    if (x > stopX - this.innerRingOffset - 3) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = xMaxEdge = false;
                    }
                    if (z < 0 + this.innerRingOffset) ** GOTO lbl-1000
                    Objects.requireNonNull(this);
                    if (z < 0 + this.innerRingOffset + 3) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = zMinEdge = false;
                    }
                    if (z > stopZ - this.innerRingOffset) ** GOTO lbl-1000
                    Objects.requireNonNull(this);
                    if (z > stopZ - this.innerRingOffset - 3) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = zMaxEdge = false;
                    }
                    if (!xMinEdge && !xMaxEdge && !zMinEdge && !zMaxEdge) continue;
                    if (y == 5) {
                        this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, this.floorMaterial);
                        continue;
                    }
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, Blocks.field_150350_a, 0);
                }
            }
        }
        this.generateSmallRooms(chunkBB, blocks, metas);
        return true;
    }

    protected StructureBoundingBox getRoomEntranceBox(int position, StructureBoundingBox roomBox) {
        int direction = 0;
        switch (position) {
            case 1: {
                direction = Math.random() > 0.5 ? 0 : 1;
                break;
            }
            case 2: 
            case 3: {
                direction = 0;
                break;
            }
            case 4: {
                direction = Math.random() > 0.5 ? 0 : 3;
                break;
            }
            case 5: 
            case 6: {
                direction = 3;
                break;
            }
            case 7: {
                direction = Math.random() > 0.5 ? 3 : 2;
                break;
            }
            case 8: 
            case 9: {
                direction = 2;
                break;
            }
            case 10: {
                direction = Math.random() > 0.5 ? 1 : 2;
                break;
            }
            case 11: 
            case 12: {
                direction = 1;
            }
        }
        StructureBoundingBox doorBB = new StructureBoundingBox();
        doorBB.field_78895_b = 0;
        doorBB.field_78894_e = 255;
        switch (direction) {
            case 0: {
                doorBB.field_78896_c = roomBox.field_78892_f + 1;
                doorBB.field_78892_f = doorBB.field_78896_c + 1;
                doorBB.field_78897_a = roomBox.func_78881_e() - 1;
                doorBB.field_78893_d = roomBox.func_78881_e() + 1;
                break;
            }
            case 1: {
                doorBB.field_78897_a = roomBox.field_78893_d + 1;
                doorBB.field_78893_d = doorBB.field_78897_a + 1;
                doorBB.field_78896_c = roomBox.func_78891_g() - 1;
                doorBB.field_78892_f = roomBox.func_78891_g() + 1;
                break;
            }
            case 2: {
                doorBB.field_78892_f = roomBox.field_78896_c - 1;
                doorBB.field_78896_c = doorBB.field_78892_f - 1;
                doorBB.field_78897_a = roomBox.func_78881_e() - 1;
                doorBB.field_78893_d = roomBox.func_78881_e() + 1;
                break;
            }
            case 3: {
                doorBB.field_78893_d = roomBox.field_78897_a - 1;
                doorBB.field_78897_a = doorBB.field_78893_d - 1;
                doorBB.field_78896_c = roomBox.func_78891_g() - 1;
                doorBB.field_78892_f = roomBox.func_78891_g() + 1;
            }
        }
        return doorBB;
    }

    protected StructureBoundingBox getSmallRoomBB(int position) {
        int offsetBetweenRooms = 3;
        StructureBoundingBox myBB = this.getStructureBoundingBox();
        StructureBoundingBox bb = new StructureBoundingBox();
        bb.field_78895_b = 0;
        bb.field_78894_e = 255;
        int tempRoomWidth = this.smallRoomWidth - 1;
        switch (position) {
            case 1: {
                bb.field_78897_a = myBB.field_78897_a + this.innerRoomOffset;
                bb.field_78893_d = bb.field_78897_a + tempRoomWidth;
                bb.field_78896_c = myBB.field_78896_c + this.innerRoomOffset;
                bb.field_78892_f = bb.field_78896_c + tempRoomWidth;
                break;
            }
            case 2: {
                bb.field_78897_a = myBB.field_78897_a + this.innerRoomOffset + 3 + tempRoomWidth;
                bb.field_78896_c = myBB.field_78896_c + this.innerRoomOffset;
                bb.field_78893_d = bb.field_78897_a + tempRoomWidth;
                bb.field_78892_f = bb.field_78896_c + tempRoomWidth;
                break;
            }
            case 3: {
                bb.field_78893_d = myBB.field_78893_d - this.innerRoomOffset - 3 - tempRoomWidth + 1;
                bb.field_78897_a = bb.field_78893_d - tempRoomWidth;
                bb.field_78896_c = myBB.field_78896_c + this.innerRoomOffset;
                bb.field_78892_f = bb.field_78896_c + tempRoomWidth;
                break;
            }
            case 4: {
                bb.field_78893_d = myBB.field_78893_d - this.innerRoomOffset + 1;
                bb.field_78897_a = bb.field_78893_d - tempRoomWidth;
                bb.field_78896_c = myBB.field_78896_c + this.innerRoomOffset;
                bb.field_78892_f = bb.field_78896_c + tempRoomWidth;
                break;
            }
            case 5: {
                bb.field_78896_c = myBB.field_78896_c + this.innerRoomOffset + 3 + tempRoomWidth;
                bb.field_78892_f = bb.field_78896_c + tempRoomWidth;
                bb.field_78893_d = myBB.field_78893_d - this.innerRoomOffset + 1;
                bb.field_78897_a = bb.field_78893_d - tempRoomWidth;
                break;
            }
            case 6: {
                bb.field_78892_f = myBB.field_78892_f - this.innerRoomOffset - (3 + tempRoomWidth) + 1;
                bb.field_78896_c = bb.field_78892_f - tempRoomWidth;
                bb.field_78893_d = myBB.field_78893_d - this.innerRoomOffset + 1;
                bb.field_78897_a = bb.field_78893_d - tempRoomWidth;
                break;
            }
            case 7: {
                bb.field_78892_f = myBB.field_78892_f - this.innerRoomOffset + 1;
                bb.field_78896_c = bb.field_78892_f - tempRoomWidth;
                bb.field_78893_d = myBB.field_78893_d - this.innerRoomOffset + 1;
                bb.field_78897_a = bb.field_78893_d - tempRoomWidth;
                break;
            }
            case 8: {
                bb.field_78892_f = myBB.field_78892_f - this.innerRoomOffset + 1;
                bb.field_78896_c = bb.field_78892_f - tempRoomWidth;
                bb.field_78893_d = myBB.field_78893_d - this.innerRoomOffset - (3 + tempRoomWidth) + 1;
                bb.field_78897_a = bb.field_78893_d - tempRoomWidth;
                break;
            }
            case 9: {
                bb.field_78892_f = myBB.field_78892_f - this.innerRoomOffset + 1;
                bb.field_78896_c = bb.field_78892_f - tempRoomWidth;
                bb.field_78897_a = myBB.field_78897_a + this.innerRoomOffset + 3 + tempRoomWidth;
                bb.field_78893_d = bb.field_78897_a + tempRoomWidth;
                break;
            }
            case 10: {
                bb.field_78897_a = myBB.field_78897_a + this.innerRoomOffset;
                bb.field_78893_d = bb.field_78897_a + tempRoomWidth;
                bb.field_78892_f = myBB.field_78892_f - this.innerRoomOffset + 1;
                bb.field_78896_c = bb.field_78892_f - tempRoomWidth;
                break;
            }
            case 11: {
                bb.field_78897_a = myBB.field_78897_a + this.innerRoomOffset;
                bb.field_78893_d = bb.field_78897_a + tempRoomWidth;
                bb.field_78892_f = myBB.field_78892_f - this.innerRoomOffset - (3 + tempRoomWidth) + 1;
                bb.field_78896_c = bb.field_78892_f - tempRoomWidth;
                break;
            }
            case 12: {
                bb.field_78897_a = myBB.field_78897_a + this.innerRoomOffset;
                bb.field_78893_d = bb.field_78897_a + tempRoomWidth;
                bb.field_78896_c = myBB.field_78896_c + this.innerRoomOffset + 3 + tempRoomWidth;
                bb.field_78892_f = bb.field_78896_c + tempRoomWidth;
                break;
            }
            default: {
                throw new IllegalArgumentException("Pyramid room position " + position + " is invalid");
            }
        }
        return bb;
    }

    protected void generateSmallRooms(StructureBoundingBox chunkBB, Block[] blocks, byte[] metas) {
        int chunkX = CoordHelper.blockToChunk(chunkBB.field_78897_a);
        int chunkZ = CoordHelper.blockToChunk(chunkBB.field_78896_c);
        for (PyramidRoom r : this.roomList) {
            if (r == null || !r.getStructureBoundingBox().func_78884_a(chunkBB)) continue;
            r.generateChunk(chunkX, chunkZ, blocks, metas);
        }
        if (this.centralRoom.getStructureBoundingBox().func_78884_a(chunkBB)) {
            this.centralRoom.generateChunk(chunkX, chunkZ, blocks, metas);
        }
    }

    protected int coords2int(int x, int y, int z) {
        return ((x << 4) + z) * 256 + y;
    }

    public BlockMetaPair getWallMaterial() {
        return this.wallMaterial;
    }

    public void setWallMaterial(BlockMetaPair wallMaterial) {
        this.wallMaterial = wallMaterial;
    }

    public BlockMetaPair getFloorMaterial() {
        return this.floorMaterial;
    }

    public void setFloorMaterial(BlockMetaPair floorMaterial) {
        this.floorMaterial = floorMaterial;
    }

    public BlockMetaPair getFillMaterial() {
        return this.fillMaterial;
    }

    public void setFillMaterial(BlockMetaPair fillMaterial) {
        this.fillMaterial = fillMaterial;
    }
}

