/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.core.BCRegistry;
import buildcraft.core.CompatHooks;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.builders.schematics.SchematicFree;
import buildcraft.core.builders.schematics.SchematicRotateMeta;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.lib.network.ChannelHandler;
import buildcraft.core.lib.network.PacketHandler;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockFloodGate;
import buildcraft.factory.BlockHopper;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.FactoryGuiHandler;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.FactoryProxyClient;
import buildcraft.factory.PumpDimensionList;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileFloodGate;
import buildcraft.factory.TileHopper;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.schematics.SchematicAutoWorkbench;
import buildcraft.factory.schematics.SchematicPump;
import buildcraft.factory.schematics.SchematicRefinery;
import buildcraft.factory.schematics.SchematicTileIgnoreState;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="BuildCraft Factory", version="7.1.33", useMetadata=false, modid="BuildCraft|Factory", dependencies="required-after:BuildCraft|Core@7.1.33")
public class BuildCraftFactory
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Factory")
    public static BuildCraftFactory instance;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockFloodGate floodGateBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockHopper hopperBlock;
    public static Achievement aLotOfCraftingAchievement;
    public static Achievement straightDownAchievement;
    public static Achievement refineAndRedefineAchievement;
    public static int miningDepth;
    public static boolean pumpsNeedRealPower;
    public static PumpDimensionList pumpDimensionList;

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new FactoryGuiHandler());
        BCRegistry.INSTANCE.registerTileEntity(TileMiningWell.class, "MiningWell");
        BCRegistry.INSTANCE.registerTileEntity(TileAutoWorkbench.class, "AutoWorkbench");
        BCRegistry.INSTANCE.registerTileEntity(TilePump.class, "net.minecraft.src.buildcraft.factory.TilePump");
        BCRegistry.INSTANCE.registerTileEntity(TileFloodGate.class, "net.minecraft.src.buildcraft.factory.TileFloodGate");
        BCRegistry.INSTANCE.registerTileEntity(TileTank.class, "net.minecraft.src.buildcraft.factory.TileTank");
        BCRegistry.INSTANCE.registerTileEntity(TileRefinery.class, "net.minecraft.src.buildcraft.factory.Refinery");
        BCRegistry.INSTANCE.registerTileEntity(TileHopper.class, "net.minecraft.src.buildcraft.factory.TileHopper");
        FactoryProxy.proxy.initializeTileEntities();
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)refineryBlock, SchematicRefinery.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)tankBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)pumpBlock, SchematicPump.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)miningWellBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)floodGateBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)autoWorkbenchBlock, SchematicAutoWorkbench.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)hopperBlock, SchematicTile.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)plainPipeBlock, SchematicFree.class, new Object[0]);
        aLotOfCraftingAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.aLotOfCrafting", "aLotOfCraftingAchievement", 1, 2, (Block)autoWorkbenchBlock, BuildCraftCore.woodenGearAchievement));
        straightDownAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.straightDown", "straightDownAchievement", 5, 2, (Block)miningWellBlock, BuildCraftCore.ironGearAchievement));
        refineAndRedefineAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.refineAndRedefine", "refineAndRedefineAchievement", 10, 0, (Block)refineryBlock, BuildCraftCore.diamondGearAchievement));
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    @Mod.EventHandler
    public void initialize(FMLPreInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-FACTORY", new io.netty.channel.ChannelHandler[]{new ChannelHandler(), new PacketHandler()});
        String plc = "Allows admins to whitelist or blacklist pumping of specific fluids in specific dimensions.\nEg. \"-/-1/Lava\" will disable lava in the nether. \"-/*/Lava\" will disable lava in any dimension. \"+/0/*\" will enable any fluid in the overworld.\nEntries are comma seperated, banned fluids have precedence over allowed ones.Default is \"+/*/*,+/-1/Lava\" - the second redundant entry (\"+/-1/lava\") is there to show the format.";
        BuildCraftCore.mainConfigManager.register("general.miningDepth", 256, "Should the mining well only be usable once after placing?", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.get("general.miningDepth").setMinValue(2).setMaxValue(256);
        BuildCraftCore.mainConfigManager.register("general.pumpDimensionControl", DefaultProps.PUMP_DIMENSION_LIST, plc, ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.register("general.pumpsNeedRealPower", false, "Do pumps need real (non-redstone) power?", ConfigManager.RestartRequirement.WORLD);
        this.reloadConfig(ConfigManager.RestartRequirement.GAME);
        miningWellBlock = (BlockMiningWell)CompatHooks.INSTANCE.getBlock(BlockMiningWell.class);
        if (BCRegistry.INSTANCE.registerBlock(miningWellBlock.func_149663_c("miningWellBlock"), false)) {
            plainPipeBlock = new BlockPlainPipe();
            BCRegistry.INSTANCE.registerBlock(plainPipeBlock.func_149663_c("plainPipeBlock"), true);
        }
        autoWorkbenchBlock = (BlockAutoWorkbench)CompatHooks.INSTANCE.getBlock(BlockAutoWorkbench.class);
        BCRegistry.INSTANCE.registerBlock(autoWorkbenchBlock.func_149663_c("autoWorkbenchBlock"), false);
        tankBlock = (BlockTank)CompatHooks.INSTANCE.getBlock(BlockTank.class);
        BCRegistry.INSTANCE.registerBlock(tankBlock.func_149663_c("tankBlock"), false);
        pumpBlock = (BlockPump)CompatHooks.INSTANCE.getBlock(BlockPump.class);
        BCRegistry.INSTANCE.registerBlock(pumpBlock.func_149663_c("pumpBlock"), false);
        floodGateBlock = (BlockFloodGate)CompatHooks.INSTANCE.getBlock(BlockFloodGate.class);
        BCRegistry.INSTANCE.registerBlock(floodGateBlock.func_149663_c("floodGateBlock"), false);
        refineryBlock = (BlockRefinery)CompatHooks.INSTANCE.getBlock(BlockRefinery.class);
        BCRegistry.INSTANCE.registerBlock(refineryBlock.func_149663_c("refineryBlock"), false);
        hopperBlock = (BlockHopper)CompatHooks.INSTANCE.getBlock(BlockHopper.class);
        BCRegistry.INSTANCE.registerBlock(hopperBlock.func_149663_c("blockHopper"), false);
        FactoryProxy.proxy.initializeEntityRenders();
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadRecipes() {
        if (BuildCraftCore.GTNH) {
            return;
        }
        if (miningWellBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)miningWellBlock, 1), "ipi", "igi", "iPi", Character.valueOf('p'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "gearIron", Character.valueOf('P'), Items.field_151035_b);
        }
        if (pumpBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)pumpBlock), new Object[]{"ipi", "igi", "TBT", Character.valueOf('p'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('T'), tankBlock, Character.valueOf('g'), "gearIron", Character.valueOf('B'), Items.field_151133_ar});
        }
        if (autoWorkbenchBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), "gwg", Character.valueOf('w'), "craftingTableWood", Character.valueOf('g'), "gearStone");
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), "g", "w", "g", Character.valueOf('w'), "craftingTableWood", Character.valueOf('g'), "gearStone");
        }
        if (tankBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)tankBlock), "ggg", "g g", "ggg", Character.valueOf('g'), "blockGlass");
        }
        if (refineryBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)refineryBlock), "RTR", "TGT", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearDiamond", Character.valueOf('R'), Blocks.field_150429_aA);
        }
        if (hopperBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)hopperBlock), "ICI", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "chestWood", Character.valueOf('G'), "gearStone");
            BCRegistry.INSTANCE.addShapelessRecipe(new ItemStack((Block)hopperBlock), Blocks.field_150438_bZ, "gearStone");
        }
        if (floodGateBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)floodGateBlock), "IGI", "FTF", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearIron", Character.valueOf('F'), new ItemStack(Blocks.field_150411_aY));
        }
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            miningDepth = BuildCraftCore.mainConfigManager.get("general.miningDepth").getInt();
            pumpsNeedRealPower = BuildCraftCore.mainConfigManager.get("general.pumpsNeedRealPower").getBoolean();
            pumpDimensionList = new PumpDimensionList(BuildCraftCore.mainConfigManager.get("general.pumpDimensionControl").getString());
            if (BuildCraftCore.mainConfiguration.hasChanged()) {
                BuildCraftCore.mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map.func_130086_a() == 0) {
            TextureMap terrainTextures = evt.map;
            FactoryProxyClient.pumpTexture = terrainTextures.func_94245_a("buildcraftfactory:pumpBlock/tube");
        }
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAutoWorkbench.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFloodGate.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileTank.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileRefinery.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileHopper.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.name.equals("BuildCraft|Factory:machineBlock")) {
                if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
                    if (mapping.type == GameRegistry.Type.BLOCK) {
                        mapping.remap(Block.func_149684_b((String)"BuildCraft|Builders:machineBlock"));
                        continue;
                    }
                    if (mapping.type != GameRegistry.Type.ITEM) continue;
                    mapping.remap(Item.func_150898_a((Block)Block.func_149684_b((String)"BuildCraft|Builders:machineBlock")));
                    continue;
                }
                mapping.warn();
                continue;
            }
            if (!mapping.name.equals("BuildCraft|Factory:frameBlock")) continue;
            if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    mapping.remap(Block.func_149684_b((String)"BuildCraft|Builders:frameBlock"));
                    continue;
                }
                if (mapping.type != GameRegistry.Type.ITEM) continue;
                mapping.remap(Item.func_150898_a((Block)Block.func_149684_b((String)"BuildCraft|Builders:frameBlock")));
                continue;
            }
            mapping.ignore();
        }
    }

    static {
        miningDepth = 256;
        pumpsNeedRealPower = false;
    }
}

