/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.thermalexpansion;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.core.lib.inventory.StackHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldSettings;

public class SchematicTE4Base
extends SchematicTile {
    protected static final int[] shiftMatrix = new int[]{0, 1, 5, 4, 2, 3, 6, 7};
    private static final String[] checkedNBTTags = new String[]{"Level"};

    public boolean isItemMatchingRequirement(ItemStack suppliedStack, ItemStack requiredStack) {
        Block b = Block.func_149634_a((Item)requiredStack.func_77973_b());
        if (b != null && b.func_149667_c(this.block)) {
            if (StackHelper.isMatchingItem((ItemStack)suppliedStack, (ItemStack)requiredStack, (boolean)true, (boolean)false)) {
                NBTTagCompound suppliedTag = suppliedStack.func_77978_p();
                NBTTagCompound requiredTag = requiredStack.func_77978_p();
                if (suppliedTag == null || requiredTag == null) {
                    return false;
                }
                for (String s : checkedNBTTags) {
                    if (suppliedTag.func_74781_a(s) == null) {
                        if (requiredTag.func_74781_a(s) == null) continue;
                        return false;
                    }
                    if (requiredTag.func_74781_a(s) == null) {
                        return false;
                    }
                    if (requiredTag.func_74781_a(s).equals((Object)suppliedTag.func_74781_a(s))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return super.isItemMatchingRequirement(suppliedStack, requiredStack);
    }

    public void rotateLeft(IBuilderContext context) {
        if (this.tileNBT != null) {
            if (this.tileNBT.func_74764_b("Facing")) {
                this.tileNBT.func_74774_a("Facing", (byte)shiftMatrix[this.tileNBT.func_74771_c("Facing") & 7]);
            }
            if (this.tileNBT.func_74764_b("SideCache")) {
                byte[] sideCache = this.tileNBT.func_74770_j("SideCache");
                byte[] newSideCache = new byte[sideCache.length];
                for (int i = 0; i < sideCache.length; ++i) {
                    if (i < 6) {
                        newSideCache[SchematicTE4Base.shiftMatrix[i]] = sideCache[i];
                        continue;
                    }
                    newSideCache[i] = sideCache[i];
                }
                this.tileNBT.func_74773_a("SideCache", newSideCache);
            }
        }
    }

    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        this.setBlockInWorld(context, x, y, z);
        if (this.block.hasTileEntity(this.meta)) {
            this.tileNBT.func_74768_a("x", x);
            this.tileNBT.func_74768_a("y", y);
            this.tileNBT.func_74768_a("z", z);
            for (ItemStack s : stacks) {
                Block b;
                if (s == null || (b = Block.func_149634_a((Item)s.func_77973_b())) == null || !b.func_149667_c(this.block)) continue;
                NBTTagCompound nbt = s.func_77978_p();
                if (nbt != null && nbt.func_74764_b("Energy")) {
                    this.tileNBT.func_74768_a("Energy", nbt.func_74762_e("Energy"));
                }
                if (nbt != null && nbt.func_74764_b("Augments")) {
                    this.tileNBT.func_74782_a("Augments", nbt.func_74781_a("Augments"));
                } else if (context.world().func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE) {
                    this.tileNBT.func_82580_o("Augments");
                }
                if (nbt != null && nbt.func_74764_b("Enchant")) {
                    this.tileNBT.func_74774_a("Enchant", nbt.func_74771_c("Enchant"));
                    continue;
                }
                if (context.world().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) continue;
                this.tileNBT.func_74774_a("Enchant", (byte)0);
            }
            context.world().func_147455_a(x, y, z, TileEntity.func_145827_c((NBTTagCompound)this.tileNBT));
        }
    }

    protected void fixDualNBT(NBTTagCompound tileNBT) {
        if (tileNBT.func_74764_b("Owner")) {
            tileNBT.func_74778_a("Owner", "[None]");
            tileNBT.func_82580_o("OwnerUUID");
        }
        if (tileNBT.func_74764_b("Energy")) {
            tileNBT.func_74768_a("Energy", 0);
        }
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        if (this.tileNBT != null) {
            if (this.tileNBT.func_150297_b("RS", 10)) {
                this.tileNBT.func_74775_l("RS").func_74774_a("Power", (byte)0);
            }
            if (this.tileNBT.func_74764_b("Active")) {
                this.tileNBT.func_74774_a("Active", (byte)0);
            }
            if (this.tileNBT.func_74764_b("Access")) {
                this.tileNBT.func_74774_a("Access", (byte)0);
            }
            this.fixDualNBT(this.tileNBT);
        }
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        if (this.block != null) {
            ArrayList rqs = this.block.getDrops(context.world(), x, y, z, this.meta, 0);
            this.storedRequirements = rqs.toArray(new ItemStack[rqs.size()]);
        }
        for (ItemStack s : this.storedRequirements) {
            Block b;
            if (s == null || !(b = Block.func_149634_a((Item)s.func_77973_b())).func_149667_c(this.block) || s.func_77978_p() == null) continue;
            this.fixDualNBT(s.func_77978_p());
        }
    }
}

