/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util.p2p;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import appeng.me.GridNode;
import appeng.me.cache.P2PCache;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.automation.UpgradeInventory;
import appeng.parts.p2p.PartP2PInterface;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import com.projecturanus.betterp2p.BetterP2P;
import com.projecturanus.betterp2p.network.P2PInfo;
import com.projecturanus.betterp2p.util.p2p.P2PStatus;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\n\u001a\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a(\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a<\u0010\u0011\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u001a$\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u001a6\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\u001f\u001a\u00020 *\u0006\u0012\u0002\b\u00030\u0002\u001a\u000e\u0010!\u001a\u00020\"*\u0006\u0012\u0002\b\u00030\u0002\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\",\u0010\u0006\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\u0004\"\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"hasChannel", "", "Lappeng/parts/p2p/PartP2PTunnel;", "getHasChannel", "(Lappeng/parts/p2p/PartP2PTunnel;)Z", "value", "outputProperty", "getOutputProperty", "setOutputProperty", "(Lappeng/parts/p2p/PartP2PTunnel;Z)V", "changeAllP2Ps", "tunnel", "newType", "Lcom/projecturanus/betterp2p/util/p2p/TunnelInfo;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "changeP2P", "linkP2P", "Lkotlin/Pair;", "inputIndex", "", "outputIndex", "status", "Lcom/projecturanus/betterp2p/util/p2p/P2PStatus;", "unlinkP2P", "p2pIndex", "updateP2P", "frequency", "output", "name", "", "getTypeIndex", "", "toInfo", "Lcom/projecturanus/betterp2p/network/P2PInfo;", "betterp2p"})
@SourceDebugExtension(value={"SMAP\nP2PUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P2PUtil.kt\ncom/projecturanus/betterp2p/util/p2p/P2PUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1858#2,3:243\n1858#2,3:246\n1858#2,3:249\n1858#2,3:252\n1849#2,2:255\n1849#2,2:257\n1858#2,3:259\n*S KotlinDebug\n*F\n+ 1 P2PUtil.kt\ncom/projecturanus/betterp2p/util/p2p/P2PUtilKt\n*L\n65#1:243,3\n69#1:246,3\n73#1:249,3\n77#1:252,3\n81#1:255,2\n85#1:257,2\n91#1:259,3\n*E\n"})
public final class P2PUtilKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Pair<PartP2PTunnel<?>, PartP2PTunnel<?>> linkP2P(@NotNull EntityPlayer player, long inputIndex, long outputIndex, @NotNull P2PStatus status) {
        PartP2PTunnel originalInput;
        IGrid grid;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        PartP2PTunnel<?> partP2PTunnel = status.getListP2P().get(inputIndex);
        if (partP2PTunnel == null) {
            return null;
        }
        PartP2PTunnel<?> input = partP2PTunnel;
        PartP2PTunnel<?> partP2PTunnel2 = status.getListP2P().get(outputIndex);
        if (partP2PTunnel2 == null) {
            return null;
        }
        PartP2PTunnel<?> output = partP2PTunnel2;
        IGridNode iGridNode = input.getGridNode();
        Object object = grid = iGridNode != null ? iGridNode.getGrid() : null;
        if (!(!(grid instanceof ISecurityGrid) || ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD) && ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.SECURITY))) {
            return null;
        }
        if (!Intrinsics.areEqual(input.getClass(), output.getClass())) {
            TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass(input.getClass());
            Intrinsics.checkNotNull((Object)tunnelInfo);
            PartP2PTunnel<?> partP2PTunnel3 = P2PUtilKt.changeP2P(output, tunnelInfo, player);
            if (partP2PTunnel3 == null) {
                return null;
            }
            output = partP2PTunnel3;
        }
        if (Intrinsics.areEqual(input, output)) {
            return null;
        }
        long frequency = input.getFrequency();
        P2PCache cache = input.getProxy().getP2P();
        if (input.getFrequency() == 0L || input.isOutput()) {
            frequency = System.currentTimeMillis();
        }
        if (cache.getInput(frequency) != null && !Intrinsics.areEqual((Object)(originalInput = cache.getInput(frequency)), input)) {
            Intrinsics.checkNotNullExpressionValue((Object)originalInput, (String)"originalInput");
            String string = input.getCustomName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.customName");
            P2PUtilKt.updateP2P(originalInput, frequency, true, player, string);
        }
        String string = input.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.customName");
        PartP2PTunnel<?> inputResult = P2PUtilKt.updateP2P(input, frequency, false, player, string);
        String string2 = input.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"input.customName");
        PartP2PTunnel<?> outputResult = P2PUtilKt.updateP2P(output, frequency, true, player, string2);
        if (input instanceof PartP2PInterface && output instanceof PartP2PInterface) {
            Intrinsics.checkNotNull(inputResult, (String)"null cannot be cast to non-null type appeng.parts.p2p.PartP2PInterface");
            PartP2PInterface cfr_ignored_0 = (PartP2PInterface)inputResult;
            Intrinsics.checkNotNull(outputResult, (String)"null cannot be cast to non-null type appeng.parts.p2p.PartP2PInterface");
            PartP2PInterface cfr_ignored_1 = (PartP2PInterface)outputResult;
            IInventory iInventory = ((PartP2PInterface)input).getInterfaceDuality().getInventoryByName("upgrades");
            Intrinsics.checkNotNull((Object)iInventory, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
            UpgradeInventory upgradesIn = (UpgradeInventory)iInventory;
            Iterable $this$forEachIndexed$iv = (Iterable)upgradesIn;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void stack2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ItemStack itemStack = (ItemStack)item$iv;
                int index = n;
                boolean bl = false;
                IInventory iInventory2 = ((PartP2PInterface)inputResult).getInterfaceDuality().getInventoryByName("upgrades");
                Intrinsics.checkNotNull((Object)iInventory2, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
                ((UpgradeInventory)iInventory2).func_70299_a(index, (ItemStack)stack2);
            }
            IInventory iInventory3 = ((PartP2PInterface)output).getInterfaceDuality().getInventoryByName("upgrades");
            Intrinsics.checkNotNull((Object)iInventory3, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
            UpgradeInventory upgradesOut = (UpgradeInventory)iInventory3;
            Iterable $this$forEachIndexed$iv2 = (Iterable)upgradesOut;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv : $this$forEachIndexed$iv2) {
                void stack3;
                int stack2;
                if ((stack2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ItemStack index = (ItemStack)item$iv;
                int index2 = stack2;
                boolean bl = false;
                IInventory iInventory4 = ((PartP2PInterface)outputResult).getInterfaceDuality().getInventoryByName("upgrades");
                Intrinsics.checkNotNull((Object)iInventory4, (String)"null cannot be cast to non-null type appeng.parts.automation.UpgradeInventory");
                ((UpgradeInventory)iInventory4).func_70299_a(index2, (ItemStack)stack3);
            }
            IInventory iInventory5 = ((PartP2PInterface)input).getInterfaceDuality().getStorage();
            Intrinsics.checkNotNull((Object)iInventory5, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            AppEngInternalInventory itemsIn = (AppEngInternalInventory)iInventory5;
            Iterable $this$forEachIndexed$iv3 = (Iterable)itemsIn;
            boolean $i$f$forEachIndexed3 = false;
            int index$iv3 = 0;
            for (Object item$iv : $this$forEachIndexed$iv3) {
                void stack4;
                int stack3;
                if ((stack3 = index$iv3++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ItemStack index2 = (ItemStack)item$iv;
                int index = stack3;
                boolean bl = false;
                IInventory iInventory6 = ((PartP2PInterface)inputResult).getInterfaceDuality().getStorage();
                Intrinsics.checkNotNull((Object)iInventory6, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
                ((AppEngInternalInventory)iInventory6).func_70299_a(index, (ItemStack)stack4);
            }
            IInventory iInventory7 = ((PartP2PInterface)output).getInterfaceDuality().getStorage();
            Intrinsics.checkNotNull((Object)iInventory7, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            AppEngInternalInventory itemsOut = (AppEngInternalInventory)iInventory7;
            Iterable $this$forEachIndexed$iv4 = (Iterable)itemsOut;
            boolean $i$f$forEachIndexed4 = false;
            int index$iv4 = 0;
            for (Object item$iv : $this$forEachIndexed$iv4) {
                void stack;
                int stack4;
                if ((stack4 = index$iv4++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ItemStack index = (ItemStack)item$iv;
                int index3 = stack4;
                boolean bl = false;
                IInventory iInventory8 = ((PartP2PInterface)outputResult).getInterfaceDuality().getStorage();
                Intrinsics.checkNotNull((Object)iInventory8, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
                ((AppEngInternalInventory)iInventory8).func_70299_a(index3, (ItemStack)stack);
            }
            IConfigManager settingsIn = ((PartP2PInterface)input).getInterfaceDuality().getConfigManager();
            Set set = settingsIn.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"settingsIn.settings");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Settings it = (Settings)element$iv;
                boolean bl = false;
                ((PartP2PInterface)inputResult).getConfigManager().putSetting(it, settingsIn.getSetting(it));
            }
            IConfigManager settingsOut = ((PartP2PInterface)output).getInterfaceDuality().getConfigManager();
            Set set2 = settingsOut.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"settingsOut.settings");
            Iterable $this$forEach$iv2 = set2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Settings it = (Settings)element$iv;
                boolean bl = false;
                ((PartP2PInterface)outputResult).getConfigManager().putSetting(it, settingsOut.getSetting(it));
            }
            IInventory iInventory9 = ((PartP2PInterface)input).getInterfaceDuality().getPatterns();
            Intrinsics.checkNotNull((Object)iInventory9, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            AppEngInternalInventory patternsIn = (AppEngInternalInventory)iInventory9;
            Iterable $this$forEachIndexed$iv5 = (Iterable)patternsIn;
            boolean $i$f$forEachIndexed5 = false;
            int index$iv5 = 0;
            for (Object item$iv : $this$forEachIndexed$iv5) {
                void stack;
                int n;
                if ((n = index$iv5++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ItemStack itemStack = (ItemStack)item$iv;
                int index = n;
                boolean bl = false;
                IInventory iInventory10 = ((PartP2PInterface)inputResult).getInterfaceDuality().getPatterns();
                Intrinsics.checkNotNull((Object)iInventory10, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
                ((AppEngInternalInventory)iInventory10).func_70299_a(index, (ItemStack)stack);
            }
            List dropItems = new ArrayList();
            IInventory iInventory11 = ((PartP2PInterface)output).getInterfaceDuality().getPatterns();
            Intrinsics.checkNotNull((Object)iInventory11, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            AppEngInternalInventory patternsOut = (AppEngInternalInventory)iInventory11;
            CollectionsKt.addAll((Collection)dropItems, (Iterable)((Iterable)patternsOut));
            Platform.spawnDrops((World)player.field_70170_p, (int)((PartP2PInterface)output).getLocation().x, (int)((PartP2PInterface)output).getLocation().y, (int)((PartP2PInterface)output).getLocation().z, (List)dropItems);
        }
        return TuplesKt.to(inputResult, outputResult);
    }

    @Nullable
    public static final PartP2PTunnel<?> unlinkP2P(@NotNull EntityPlayer player, long p2pIndex, @NotNull P2PStatus status) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (!(!(status.getGrid() instanceof ISecurityGrid) || ((ISecurityGrid)status.getGrid()).hasPermission(player, SecurityPermissions.BUILD) && ((ISecurityGrid)status.getGrid()).hasPermission(player, SecurityPermissions.SECURITY))) {
            return null;
        }
        PartP2PTunnel<?> partP2PTunnel = status.getListP2P().get(p2pIndex);
        if (partP2PTunnel == null) {
            return null;
        }
        PartP2PTunnel<?> tunnel = partP2PTunnel;
        long oldFreq = tunnel.getFrequency();
        if (oldFreq == 0L) {
            return tunnel;
        }
        String string = tunnel.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tunnel.customName");
        P2PUtilKt.updateP2P(tunnel, 0L, false, player, string);
        return tunnel;
    }

    @Nullable
    public static final PartP2PTunnel<?> changeP2P(@NotNull PartP2PTunnel<?> tunnel, @NotNull TunnelInfo newType, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(tunnel, (String)"tunnel");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        IGrid grid = tunnel.getGridNode().getGrid();
        if (!(!(grid instanceof ISecurityGrid) || ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD) && ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.SECURITY))) {
            return null;
        }
        if (Intrinsics.areEqual((Object)BetterP2P.INSTANCE.getProxy().getP2PFromClass(tunnel.getClass()), (Object)newType)) {
            return null;
        }
        if (tunnel instanceof PartP2PInterface) {
            List dropItems = new ArrayList();
            IInventory iInventory = ((PartP2PInterface)tunnel).getInterfaceDuality().getPatterns();
            Intrinsics.checkNotNull((Object)iInventory, (String)"null cannot be cast to non-null type appeng.tile.inventory.AppEngInternalInventory");
            AppEngInternalInventory patternsOut = (AppEngInternalInventory)iInventory;
            CollectionsKt.addAll((Collection)dropItems, (Iterable)((Iterable)patternsOut));
            Platform.spawnDrops((World)player.field_70170_p, (int)((PartP2PInterface)tunnel).getLocation().x, (int)((PartP2PInterface)tunnel).getLocation().y, (int)((PartP2PInterface)tunnel).getLocation().z, (List)dropItems);
        }
        IPartHost host = tunnel.getHost();
        host.removePart(tunnel.getSide(), false);
        ForgeDirection dir = host.addPart(newType.getStack(), tunnel.getSide(), player);
        IPart newPart = host.getPart(dir);
        if (newPart instanceof PartP2PTunnel) {
            P2PUtilKt.setOutputProperty((PartP2PTunnel)newPart, tunnel.isOutput());
            try {
                P2PCache p2PCache = ((PartP2PTunnel)newPart).getProxy().getP2P();
                Intrinsics.checkNotNullExpressionValue((Object)p2PCache, (String)"newPart.proxy.p2P");
                P2PCache p2p = p2PCache;
                p2p.updateFreq((PartP2PTunnel)newPart, tunnel.getFrequency());
                return (PartP2PTunnel)newPart;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final boolean changeAllP2Ps(@NotNull PartP2PTunnel<?> tunnel, @NotNull TunnelInfo newType, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(tunnel, (String)"tunnel");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        IGrid grid = tunnel.getGridNode().getGrid();
        if (!(!(grid instanceof ISecurityGrid) || ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD) && ((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.SECURITY))) {
            return false;
        }
        try {
            if (tunnel.isOutput() && tunnel.getInput() != null) {
                PartP2PTunnel partP2PTunnel = tunnel.getInput();
                Intrinsics.checkNotNullExpressionValue((Object)partP2PTunnel, (String)"tunnel.input");
                return P2PUtilKt.changeAllP2Ps(partP2PTunnel, newType, player);
            }
            TunnelCollection tunnelCollection = tunnel.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)tunnelCollection, (String)"tunnel.outputs");
            List outputs = CollectionsKt.toMutableList((Iterable)((Iterable)tunnelCollection));
            P2PUtilKt.changeP2P(tunnel, newType, player);
            for (PartP2PTunnel o : outputs) {
                Intrinsics.checkNotNullExpressionValue((Object)o, (String)"o");
                P2PUtilKt.changeP2P(o, newType, player);
            }
            return true;
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    @NotNull
    public static final PartP2PTunnel<?> updateP2P(@NotNull PartP2PTunnel<?> tunnel, long frequency, boolean output, @NotNull EntityPlayer player, @NotNull String name) {
        Intrinsics.checkNotNullParameter(tunnel, (String)"tunnel");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ForgeDirection side = tunnel.getSide();
        NBTTagCompound data = new NBTTagCompound();
        tunnel.getHost().removePart(side, true);
        ItemStack itemStack = tunnel.getItemStack(PartItemStack.Wrench);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"tunnel.getItemStack(PartItemStack.Wrench)");
        ItemStack p2pItem = itemStack;
        P2PUtilKt.setOutputProperty(tunnel, output);
        tunnel.setCustomName(name);
        p2pItem.func_77955_b(data);
        data.func_74772_a("freq", frequency);
        ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)data);
        IPartHost iPartHost = tunnel.getHost();
        ForgeDirection forgeDirection = iPartHost != null ? iPartHost.addPart(newType, side, player) : null;
        if (forgeDirection == null) {
            throw new RuntimeException("Cannot bind");
        }
        ForgeDirection dir = forgeDirection;
        IPart iPart = tunnel.getHost().getPart(dir);
        Intrinsics.checkNotNullExpressionValue((Object)iPart, (String)"tunnel.host.getPart(dir)");
        IPart newBus = iPart;
        if (newBus instanceof PartP2PTunnel) {
            P2PUtilKt.setOutputProperty((PartP2PTunnel)newBus, output);
            try {
                P2PCache p2p = ((PartP2PTunnel)newBus).getProxy().getP2P();
                p2p.updateFreq((PartP2PTunnel)newBus, frequency);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            ((PartP2PTunnel)newBus).onTunnelNetworkChange();
            return (PartP2PTunnel)newBus;
        }
        throw new RuntimeException("Cannot bind");
    }

    public static final boolean getOutputProperty(@NotNull PartP2PTunnel<?> $this$outputProperty) {
        Intrinsics.checkNotNullParameter($this$outputProperty, (String)"<this>");
        return $this$outputProperty.isOutput();
    }

    public static final void setOutputProperty(@NotNull PartP2PTunnel<?> $this$outputProperty, boolean value) {
        Intrinsics.checkNotNullParameter($this$outputProperty, (String)"<this>");
        Field field = PartP2PTunnel.class.getDeclaredField("output");
        field.setAccessible(true);
        field.setBoolean($this$outputProperty, value);
    }

    public static final boolean getHasChannel(@NotNull PartP2PTunnel<?> $this$hasChannel) {
        Intrinsics.checkNotNullParameter($this$hasChannel, (String)"<this>");
        return $this$hasChannel.isPowered() && $this$hasChannel.isActive();
    }

    @NotNull
    public static final P2PInfo toInfo(@NotNull PartP2PTunnel<?> $this$toInfo) {
        Intrinsics.checkNotNullParameter($this$toInfo, (String)"<this>");
        long l = $this$toInfo.getFrequency();
        int n = $this$toInfo.getLocation().x;
        int n2 = $this$toInfo.getLocation().y;
        int n3 = $this$toInfo.getLocation().z;
        int n4 = $this$toInfo.getLocation().getDimension();
        ForgeDirection forgeDirection = $this$toInfo.getSide();
        Intrinsics.checkNotNullExpressionValue((Object)forgeDirection, (String)"side");
        String string = $this$toInfo.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customName");
        IGridNode iGridNode = $this$toInfo.getExternalFacingNode();
        GridNode gridNode = iGridNode instanceof GridNode ? (GridNode)iGridNode : null;
        return new P2PInfo(l, n, n2, n3, n4, forgeDirection, string, $this$toInfo.isOutput(), P2PUtilKt.getHasChannel($this$toInfo), gridNode != null ? gridNode.usedChannels() : -1, P2PUtilKt.getTypeIndex($this$toInfo));
    }

    public static final int getTypeIndex(@NotNull PartP2PTunnel<?> $this$getTypeIndex) {
        Intrinsics.checkNotNullParameter($this$getTypeIndex, (String)"<this>");
        TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass($this$getTypeIndex.getClass());
        return tunnelInfo != null ? tunnelInfo.getIndex() : -1;
    }
}

