/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import appeng.util.ReadableNumberConverter;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.recipe.EyeOfHarmonyRecipe;
import com.github.technus.tectech.thing.block.TileEyeOfHarmony;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.ItemStackLong;
import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IGlobalWirelessEnergy;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_OutputBus_ME;
import gregtech.common.tileentities.machines.GT_MetaTileEntity_Hatch_Output_ME;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class GT_MetaTileEntity_EM_EyeOfHarmony
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable,
IGlobalWirelessEnergy,
ISurvivalConstructable {
    public static final boolean EOH_DEBUG_MODE = false;
    private static final long MOLTEN_SPACETIME_PER_FAILURE_TIER = 14400L;
    private static final double SPACETIME_FAILURE_BASE = 2.0;
    private static final String TOOLTIP_BAR = EnumChatFormatting.GOLD + "------------------------------------------------------------------------------------";
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private int spacetimeCompressionFieldMetadata = -1;
    private int timeAccelerationFieldMetadata = -1;
    private int stabilisationFieldMetadata = -1;
    private static final double SPACETIME_CASING_DIFFERENCE_DISCOUNT_PERCENTAGE = 0.03;
    private static final double TIME_ACCEL_DECREASE_CHANCE_PER_TIER = 0.1;
    private static final double STABILITY_INCREASE_PROBABILITY_DECREASE_YIELD_PER_TIER = 0.05;
    private static final double LOG_BASE_CONSTANT;
    private static final int TOTAL_CASING_TIERS_WITH_POWER_PENALTY = 8;
    private String userUUID = "";
    private long euOutput = 0L;
    private long startEU = 0L;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_EM_EyeOfHarmony> STRUCTURE_DEFINITION;
    private double hydrogenOverflowProbabilityAdjustment;
    private double heliumOverflowProbabilityAdjustment;
    private static final long TICKS_BETWEEN_HATCH_DRAIN = 20L;
    private List<ItemStackLong> outputItems = new ArrayList<ItemStackLong>();
    private boolean animationsEnabled = true;
    private final Map<FluidStack, Long> validFluidMap = new HashMap<FluidStack, Long>(){
        private static final long serialVersionUID = -8452610443191188130L;
        {
            this.put(Materials.Hydrogen.getGas(1L), 0L);
            this.put(Materials.Helium.getGas(1L), 0L);
        }
    };
    private EyeOfHarmonyRecipe currentRecipe;
    private long lagPreventer = 0L;
    private static final long RECIPE_CHECK_INTERVAL = 60L;
    private long currentCircuitMultiplier = 0L;
    private double successChance;
    private boolean recipeRunning = false;
    private static final String EYE_OF_HARMONY = "eyeOfHarmonyOutput";
    private static final String NUMBER_OF_ITEMS_NBT_TAG = "eyeOfHarmonyOutputnumberOfItems";
    private static final String ITEM_OUTPUT_NBT_TAG = "eyeOfHarmonyOutputitemOutput";
    private static final String RECIPE_RUNNING_NBT_TAG = "eyeOfHarmonyOutputrecipeRunning";
    private static final String RECIPE_EU_OUTPUT_NBT_TAG = "eyeOfHarmonyOutputeuOutput";
    private static final String RECIPE_SUCCESS_CHANCE_NBT_TAG = "eyeOfHarmonyOutputrecipeSuccessChance";
    private static final String CURRENT_CIRCUIT_MULTIPLIER_TAG = "eyeOfHarmonyOutputcurrentCircuitMultiplier";
    private static final String ANIMATIONS_ENABLED = "eyeOfHarmonyOutputanimationsEnabled";
    private static final String STACK_SIZE = "stackSize";
    private static final String ITEM_STACK_NBT_TAG = "itemStack";

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 16, 16, 0, realBudget, source, actor, false, true);
    }

    private void calculateHydrogenHeliumInputExcessValues(long hydrogenRecipeRequirement, long heliumRecipeRequirement) {
        double hydrogenStored = this.validFluidMap.get(Materials.Hydrogen.getGas(1L)).longValue();
        double heliumStored = this.validFluidMap.get(Materials.Helium.getGas(1L)).longValue();
        double hydrogenExcessPercentage = hydrogenStored / (double)hydrogenRecipeRequirement - 1.0;
        double heliumExcessPercentage = heliumStored / (double)heliumRecipeRequirement - 1.0;
        this.hydrogenOverflowProbabilityAdjustment = 1.0 - Math.exp(-Math.pow(30.0 * hydrogenExcessPercentage, 2.0));
        this.heliumOverflowProbabilityAdjustment = 1.0 - Math.exp(-Math.pow(30.0 * heliumExcessPercentage, 2.0));
    }

    private double recipeChanceCalculator() {
        double chance = this.currentRecipe.getBaseRecipeSuccessChance() - (double)this.timeAccelerationFieldMetadata * 0.1 + (double)this.stabilisationFieldMetadata * 0.05 - this.hydrogenOverflowProbabilityAdjustment - this.heliumOverflowProbabilityAdjustment;
        return GT_MetaTileEntity_EM_EyeOfHarmony.clamp(chance, 0.0, 1.0);
    }

    public static double clamp(double amount, double min, double max) {
        return Math.max(min, Math.min(amount, max));
    }

    private double recipeYieldCalculator() {
        double yield = 1.0 - this.hydrogenOverflowProbabilityAdjustment - this.heliumOverflowProbabilityAdjustment - (double)this.stabilisationFieldMetadata * 0.05;
        return GT_MetaTileEntity_EM_EyeOfHarmony.clamp(yield, 0.0, 1.0);
    }

    private int recipeProcessTimeCalculator(long recipeTime, long recipeSpacetimeCasingRequired) {
        long spacetimeCasingDifference = recipeSpacetimeCasingRequired - (long)this.spacetimeCompressionFieldMetadata;
        double recipeTimeDiscounted = (double)recipeTime * Math.pow(2.0, -this.timeAccelerationFieldMetadata) * Math.pow(0.97, -spacetimeCasingDifference) / Math.max(1.0, Math.pow(2.0, this.currentCircuitMultiplier));
        return (int)Math.max(recipeTimeDiscounted, 1.0);
    }

    public IStructureDefinition<GT_MetaTileEntity_EM_EyeOfHarmony> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public GT_MetaTileEntity_EM_EyeOfHarmony(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_EyeOfHarmony(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_EyeOfHarmony(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.spacetimeCompressionFieldMetadata = -1;
        this.timeAccelerationFieldMetadata = -1;
        this.stabilisationFieldMetadata = -1;
        if (!this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 16, 16, 0)) {
            return false;
        }
        if (this.mOutputBusses.size() != 1) {
            return false;
        }
        if (!(this.mOutputBusses.get(0) instanceof GT_MetaTileEntity_Hatch_OutputBus_ME)) {
            return false;
        }
        if (this.mOutputHatches.size() != 1) {
            return false;
        }
        if (!(this.mOutputHatches.get(0) instanceof GT_MetaTileEntity_Hatch_Output_ME)) {
            return false;
        }
        if (this.mInputBusses.size() != 1) {
            return false;
        }
        if (this.mEnergyHatches.size() > 0) {
            return false;
        }
        if (this.mExoticEnergyHatches.size() > 0) {
            return false;
        }
        if (this.mInputHatches.size() != 2) {
            return false;
        }
        this.mHardHammer = true;
        this.mSoftHammer = true;
        this.mScrewdriver = true;
        this.mCrowbar = true;
        this.mSolderingTool = true;
        this.mWrench = true;
        return true;
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.animationsEnabled = !this.animationsEnabled;
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Animations are now " + (this.animationsEnabled ? "enabled" : "disabled") + "."));
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Spacetime Manipulator, EOH").addInfo(TOOLTIP_BAR).addInfo("Creates a pocket of spacetime that is bigger on the inside using transdimensional").addInfo("engineering. Certified Time Lord regulation compliant. This multi uses too much EU").addInfo("to be handled with conventional means. All EU requirements are handled directly by").addInfo("your wireless EU network.").addInfo(TOOLTIP_BAR).addInfo("This multiblock will constantly consume hydrogen and helium when it is not running a").addInfo("recipe once per second. It will store this internally, you can see the totals by").addInfo("using a scanner. This multi also has three tiered blocks with " + EnumChatFormatting.RED + 9 + EnumChatFormatting.GRAY + " tiers").addInfo("each. They are as follows and have the associated effects on the multi.").addInfo(EnumChatFormatting.BLUE + "Spacetime Compression Field Generator:").addInfo("- The tier of this block determines what recipes can be run. If the multiblocks").addInfo("  spacetime compression field block exceeds the requirements of the recipe it").addInfo("  will decrease the processing time by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)3.0) + "%" + EnumChatFormatting.GRAY + " per tier over the requirement (multiplicative).").addInfo(EnumChatFormatting.BLUE + "Time Dilation Field Generator:").addInfo("- Decreases the time required for a recipe by " + EnumChatFormatting.RED + "50%" + EnumChatFormatting.GRAY + " per tier of block (multiplicative).").addInfo("  Decreases the probability of a recipe succeeding by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)10.0) + "%" + EnumChatFormatting.GRAY + " per tier (additive)").addInfo(EnumChatFormatting.BLUE + "Stabilisation Field Generator:").addInfo("- Increases the power output and probability of a recipe succeeding by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)5.0) + "%" + EnumChatFormatting.GRAY + " per tier (additive).").addInfo("  Decreases the yield of a recipe by " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)5.0) + "%" + EnumChatFormatting.GRAY + " per tier (additive). ").addInfo(TOOLTIP_BAR).addInfo("Going over a recipe requirement on hydrogen or helium has a penalty on yield and recipe chance.").addInfo("All stored hydrogen and helium is consumed during a craft. The associated formulas are:").addInfo(EnumChatFormatting.GREEN + "percentageOverflow = fluidStored/recipeRequirement - 1").addInfo(EnumChatFormatting.GREEN + "adjustmentValue = 1 - exp(-(30 * percentageOverflow)^2)").addInfo("The value of adjustmentValue is then subtracted from the total yield and recipe chance.").addInfo(TOOLTIP_BAR).addInfo("It should be noted that base recipe chance is determined per recipe and yield always starts").addInfo("at 1 and subtracts depending on penalties. All fluid/item outputs are multiplied by the").addInfo("yield. Failure fluid is exempt. All power outputs start at 60% of what the recipes display.").addInfo(TOOLTIP_BAR).addInfo("This multiblock can only output to ME output buses/hatches. If no space in the network").addInfo("is available the items/fluids will be " + EnumChatFormatting.UNDERLINE + EnumChatFormatting.DARK_RED + "voided" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ".").addInfo(TOOLTIP_BAR).addInfo("This multiblock can be overclocked by placing a programmed circuit into the input bus.").addInfo("Each OC halves recipe time and multiplies startup cost by a factor of:").addInfo(EnumChatFormatting.GREEN + "(log4.4(overclockAmount + 1) + 1) * 0.77^overclockAmount").addInfo("Furthermore, each OC decreases the power output by a factor of " + EnumChatFormatting.RED + "0.77^overclockAmount" + EnumChatFormatting.GRAY + ".").addInfo("All item and fluid output chances & amounts per recipe are unaffected.").addInfo(TOOLTIP_BAR).addInfo("If a recipe fails the EOH will output " + EnumChatFormatting.GREEN + "successChance * " + GT_Utility.formatNumbers((long)14400L) + " * (" + 2.0 + ")^(Recipe tier)" + EnumChatFormatting.GRAY + "L of molten").addInfo(MaterialsUEVplus.SpaceTime.getLocalizedNameForItem("%material") + " instead of fluid/item outputs and output as much EU as a successful recipe.").addInfo(TOOLTIP_BAR).addInfo("Animations can be disabled by using a screwdriver on the multiblock.").addSeparator().addStructureInfo("Eye of Harmony structure is too complex! See schematic for details.").addStructureInfo(EnumChatFormatting.GOLD + "896" + EnumChatFormatting.GRAY + " Reinforced Spatial Structure Casing.").addStructureInfo(EnumChatFormatting.GOLD + "534" + EnumChatFormatting.GRAY + " Reinforced Temporal Structure Casing.").addStructureInfo(EnumChatFormatting.GOLD + "32" + EnumChatFormatting.GRAY + " Infinite SpaceTime Energy Boundary Casing.").addStructureInfo(EnumChatFormatting.GOLD + "168" + EnumChatFormatting.GRAY + " Time Dilation Field Generator.").addStructureInfo(EnumChatFormatting.GOLD + "48" + EnumChatFormatting.GRAY + " Stabilisation Field Generator.").addStructureInfo(EnumChatFormatting.GOLD + "138" + EnumChatFormatting.GRAY + " Spacetime Compression Field Generator.").addStructureInfo("--------------------------------------------").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 2 + EnumChatFormatting.GRAY + " input hatches.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " ME output hatch.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " input bus.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " ME output bus.").addStructureInfo("--------------------------------------------").beginStructureBlock(33, 33, 33, false).toolTipFinisher(GT_Values.AuthorColen.substring(8) + EnumChatFormatting.GRAY + "&" + CommonValues.TEC_MARK_EM);
        return tt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_BHG");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_BHG_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12]};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 16, 16, 0, stackSize, hintsOnly);
    }

    private void drainFluidFromHatchesAndStoreInternally() {
        for (GT_MetaTileEntity_Hatch_Input inputHatch : this.mInputHatches) {
            FluidStack fluidInHatch = inputHatch.getFluid();
            if (fluidInHatch == null) continue;
            for (FluidStack validFluid : this.validFluidMap.keySet()) {
                if (!fluidInHatch.isFluidEqual(validFluid)) continue;
                this.validFluidMap.put(validFluid, this.validFluidMap.get(validFluid) + (long)fluidInHatch.amount);
                inputHatch.setFillableStack(null);
            }
        }
    }

    @Override
    public boolean checkRecipe_EM(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        ++this.lagPreventer;
        if (this.lagPreventer < 60L) {
            this.lagPreventer = 0L;
            this.currentRecipe = TecTech.eyeOfHarmonyRecipeStorage.recipeLookUp(aStack);
            if (this.currentRecipe == null) {
                return false;
            }
            if (this.processRecipe(this.currentRecipe)) {
                return true;
            }
            this.currentRecipe = null;
        }
        return false;
    }

    private long getHydrogenStored() {
        return this.validFluidMap.get(Materials.Hydrogen.getGas(1L));
    }

    private long getHeliumStored() {
        return this.validFluidMap.get(Materials.Helium.getGas(1L));
    }

    public boolean processRecipe(EyeOfHarmonyRecipe recipeObject) {
        ItemStack circuit = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(0)).func_70301_a(0);
        this.currentCircuitMultiplier = circuit != null ? (long)GT_MetaTileEntity_EM_EyeOfHarmony.clamp(circuit.func_77960_j(), 0.0, 24.0) : 0L;
        if (this.getHydrogenStored() < this.currentRecipe.getHydrogenRequirement() || this.getHeliumStored() < this.currentRecipe.getHeliumRequirement()) {
            return false;
        }
        if (this.spacetimeCompressionFieldMetadata == -1) {
            return false;
        }
        if ((long)(this.spacetimeCompressionFieldMetadata + 1) < recipeObject.getSpacetimeCasingTierRequired()) {
            return false;
        }
        this.startEU = recipeObject.getEUStartCost();
        if (!this.addEUToGlobalEnergyMap(this.userUUID, (long)((double)(-this.startEU) * (Math.log(this.currentCircuitMultiplier + 1L) / LOG_BASE_CONSTANT + 1.0) * Math.pow(0.77, this.currentCircuitMultiplier)))) {
            return false;
        }
        this.mMaxProgresstime = this.recipeProcessTimeCalculator(recipeObject.getRecipeTimeInTicks(), recipeObject.getSpacetimeCasingTierRequired());
        this.calculateHydrogenHeliumInputExcessValues(recipeObject.getHydrogenRequirement(), recipeObject.getHeliumRequirement());
        this.successChance = this.recipeChanceCalculator();
        this.euOutput = (long)((double)recipeObject.getEUOutput() * Math.pow(0.77, this.currentCircuitMultiplier));
        this.validFluidMap.put(Materials.Hydrogen.getGas(1L), 0L);
        this.validFluidMap.put(Materials.Helium.getGas(1L), 0L);
        double yield = this.recipeYieldCalculator();
        this.mOutputFluids = recipeObject.getOutputFluids();
        this.outputItems = recipeObject.getOutputItems();
        if (yield != 1.0) {
            for (ItemStackLong itemStackLong : this.outputItems) {
                itemStackLong.stackSize = (long)((double)itemStackLong.stackSize * yield);
            }
            for (FluidStack fluidStack : this.mOutputFluids) {
                fluidStack.amount = (int)((double)fluidStack.amount * yield);
            }
        }
        this.updateSlots();
        if (this.animationsEnabled) {
            this.createRenderBlock(this.currentRecipe);
        }
        this.recipeRunning = true;
        return true;
    }

    private void createRenderBlock(EyeOfHarmonyRecipe currentRecipe) {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), Blocks.field_150350_a);
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), TT_Container_Casings.eyeOfHarmonyRenderBlock);
        TileEyeOfHarmony rendererTileEntity = (TileEyeOfHarmony)this.getBaseMetaTileEntity().getWorld().func_147438_o((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset));
        rendererTileEntity.setTier(currentRecipe.getRocketTier());
        int recipeSpacetimeTier = (int)currentRecipe.getSpacetimeCasingTierRequired();
        rendererTileEntity.setSize(1 + recipeSpacetimeTier);
        rendererTileEntity.setRotationSpeed((float)(1 + this.timeAccelerationFieldMetadata) / 2.0f);
    }

    private void outputFailedChance() {
        this.mOutputFluids = new FluidStack[]{MaterialsUEVplus.SpaceTime.getMolten((long)(this.successChance * 14400.0 * Math.pow(2.0, this.currentRecipe.getRocketTier() + 1L)))};
        super.outputAfterRecipe_EM();
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.recipeRunning = false;
    }

    private void destroyRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), Blocks.field_150350_a);
    }

    @Override
    public void outputAfterRecipe_EM() {
        this.recipeRunning = false;
        this.eRequiredData = 0L;
        this.destroyRenderBlock();
        this.addEUToGlobalEnergyMap(this.userUUID, (long)((double)this.euOutput * (1.0 - (double)(8 - this.stabilisationFieldMetadata) * 0.05)));
        this.startEU = 0L;
        this.euOutput = 0L;
        if (this.successChance < Math.random()) {
            this.outputFailedChance();
            this.outputItems = new ArrayList<ItemStackLong>();
            return;
        }
        for (ItemStackLong itemStack : this.outputItems) {
            this.outputItemToAENetwork(itemStack.itemStack, itemStack.stackSize);
        }
        this.outputItems = new ArrayList<ItemStackLong>();
        super.outputAfterRecipe_EM();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aTick == 1L) {
            this.userUUID = String.valueOf(this.getBaseMetaTileEntity().getOwnerUuid());
            String userName = this.getBaseMetaTileEntity().getOwnerName();
            this.strongCheckOrAddUser(this.userUUID, userName);
        }
        if (!this.recipeRunning && aTick % 20L == 0L) {
            this.drainFluidFromHatchesAndStoreInternally();
        }
    }

    private void outputItemToAENetwork(ItemStack item, long amount) {
        if (item == null || amount <= 0L) {
            return;
        }
        if (amount < Integer.MAX_VALUE) {
            ItemStack tmpItem = item.func_77946_l();
            tmpItem.field_77994_a = (int)amount;
            ((GT_MetaTileEntity_Hatch_OutputBus_ME)this.mOutputBusses.get(0)).store(tmpItem);
        } else {
            ItemStack tmpItem;
            while (amount >= Integer.MAX_VALUE) {
                tmpItem = item.func_77946_l();
                tmpItem.field_77994_a = Integer.MAX_VALUE;
                ((GT_MetaTileEntity_Hatch_OutputBus_ME)this.mOutputBusses.get(0)).store(tmpItem);
                amount -= Integer.MAX_VALUE;
            }
            tmpItem = item.func_77946_l();
            tmpItem.field_77994_a = (int)amount;
            ((GT_MetaTileEntity_Hatch_OutputBus_ME)this.mOutputBusses.get(0)).store(tmpItem);
        }
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        str.add(EnumChatFormatting.GOLD + "---------------- Control Block Statistics ----------------");
        str.add("Spacetime Compression Field Grade: " + EnumChatFormatting.BLUE + this.spacetimeCompressionFieldMetadata);
        str.add("Time Dilation Field Grade: " + EnumChatFormatting.BLUE + this.timeAccelerationFieldMetadata);
        str.add("Stabilisation Field Grade: " + EnumChatFormatting.BLUE + this.stabilisationFieldMetadata);
        str.add(EnumChatFormatting.GOLD + "----------------- Internal Fluids Stored ----------------");
        this.validFluidMap.forEach((key, value) -> str.add(EnumChatFormatting.BLUE + key.getLocalizedName() + EnumChatFormatting.RESET + " : " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)value)));
        if (this.recipeRunning) {
            long euPerTick;
            str.add(EnumChatFormatting.GOLD + "---------------------- Other Stats ---------------");
            str.add("Recipe Success Chance: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)(100.0 * this.successChance)) + EnumChatFormatting.RESET + "%");
            str.add("Recipe Yield: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)(100.0 * this.recipeYieldCalculator())) + EnumChatFormatting.RESET + "%");
            str.add("EU Output: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((double)((double)this.euOutput * (1.0 - (double)(8 - this.stabilisationFieldMetadata) * 0.05))) + EnumChatFormatting.RESET + " EU");
            if (this.mOutputFluids.length > 0) {
                str.add("Estimated Star Matter Output: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.mOutputFluids[this.mOutputFluids.length - 1].amount) + EnumChatFormatting.RESET + " L");
            }
            if (Math.abs(euPerTick = (long)((double)this.startEU * (Math.log(this.currentCircuitMultiplier + 1L) / LOG_BASE_CONSTANT + 1.0) * Math.pow(0.77, this.currentCircuitMultiplier) - (double)this.euOutput * (1.0 - (double)(8 - this.stabilisationFieldMetadata) * 0.05)) / (long)(-this.maxProgresstime())) < LongMath.pow((long)10L, (int)12)) {
                str.add("Estimated EU/t: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)euPerTick) + EnumChatFormatting.RESET + " EU/t");
            } else {
                str.add("Estimated EU/t: " + EnumChatFormatting.RED + ReadableNumberConverter.INSTANCE.toWideReadableForm(euPerTick) + EnumChatFormatting.RESET + " EU/t");
            }
            str.add(EnumChatFormatting.GOLD + "-----------------------------------------------------");
        }
        return str.toArray(new String[0]);
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return new String[]{"Eye of Harmony multiblock"};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        this.validFluidMap.forEach((key, value) -> aNBT.func_74772_a("stored." + key.getUnlocalizedName(), value.longValue()));
        aNBT.func_74757_a(RECIPE_RUNNING_NBT_TAG, this.recipeRunning);
        aNBT.func_74772_a(RECIPE_EU_OUTPUT_NBT_TAG, this.euOutput);
        aNBT.func_74780_a(RECIPE_SUCCESS_CHANCE_NBT_TAG, this.successChance);
        aNBT.func_74772_a(CURRENT_CIRCUIT_MULTIPLIER_TAG, this.currentCircuitMultiplier);
        aNBT.func_74757_a(ANIMATIONS_ENABLED, this.animationsEnabled);
        NBTTagCompound itemStackListNBTTag = new NBTTagCompound();
        itemStackListNBTTag.func_74772_a(NUMBER_OF_ITEMS_NBT_TAG, (long)this.outputItems.size());
        int index = 0;
        for (ItemStackLong itemStackLong : this.outputItems) {
            itemStackListNBTTag.func_74772_a(index + STACK_SIZE, itemStackLong.stackSize);
            aNBT.func_74782_a(index + ITEM_STACK_NBT_TAG, (NBTBase)itemStackLong.itemStack.func_77955_b(new NBTTagCompound()));
            ++index;
        }
        aNBT.func_74782_a(ITEM_OUTPUT_NBT_TAG, (NBTBase)itemStackListNBTTag);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.validFluidMap.forEach((key, value) -> this.validFluidMap.put((FluidStack)key, aNBT.func_74763_f("stored." + key.getUnlocalizedName())));
        this.recipeRunning = aNBT.func_74767_n(RECIPE_RUNNING_NBT_TAG);
        this.euOutput = aNBT.func_74763_f(RECIPE_EU_OUTPUT_NBT_TAG);
        this.successChance = aNBT.func_74769_h(RECIPE_SUCCESS_CHANCE_NBT_TAG);
        this.currentCircuitMultiplier = aNBT.func_74763_f(CURRENT_CIRCUIT_MULTIPLIER_TAG);
        this.animationsEnabled = aNBT.func_74767_n(ANIMATIONS_ENABLED);
        NBTTagCompound tempItemTag = aNBT.func_74775_l(ITEM_OUTPUT_NBT_TAG);
        for (int index = 0; index < tempItemTag.func_74762_e(NUMBER_OF_ITEMS_NBT_TAG); ++index) {
            long stackSize = tempItemTag.func_74763_f(index + STACK_SIZE);
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l(index + ITEM_STACK_NBT_TAG));
            this.outputItems.add(new ItemStackLong(itemStack, stackSize));
        }
        super.loadNBTData(aNBT);
    }

    static {
        LOG_BASE_CONSTANT = Math.log(4.4);
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "              DDDDD              ", "             DDCDCDD             ", "         CCCCDCCDCCDCCCC         ", "             DDDDDDD             ", "         CCCCDCCDCCDCCCC         ", "             DDCDCDD             ", "              DDDDD              ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "                D                ", "                D                ", "             DDDDDDD             ", "            DD     DD            ", "            D  EEE  D            ", "       CCC  D EAAAE D  CCC       ", "          DDD EAAAE DDD          ", "       CCC  D EAAAE D  CCC       ", "            D  EEE  D            ", "            DD     DD            ", "             DDDDDDD             ", "                D                ", "                D                ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "      CC                 CC      ", "        DD             DD        ", "      CC                 CC      ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "      C                   C      ", "     CC                   CC     ", "      CDAA             AADC      ", "     CC                   CC     ", "      C                   C      ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "       S                 S       ", "       E                 E       ", "    CC E                 E CC    ", "      DA                 AD      ", "    CC E                 E CC    ", "       E                 E       ", "       S                 S       ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "    C                       C    ", "   CC                       CC   ", "    CDA                   ADC    ", "   CC                       CC   ", "    C                       C    ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "     E                     E     ", "  CC E                     E CC  ", "    DA                     AD    ", "  CC E                     E CC  ", "     E                     E     ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  C                           C  ", "   DA                       AD   ", "  C                           C  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "               C C               ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " CC                           CC ", "   DA                       AD   ", " CC                           CC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"             CCCCCCC             ", "               C C               ", "             DDDDDDD             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             DDDDDDD             ", "               C C               ", "               C C               "}, {"            CCHHHHHCC            ", "              DDDDD              ", "            DD     DD            ", "                                 ", "                                 ", "       S                 S       ", "                                 ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", " D                             D ", "CD                             DC", " D                             D ", "CD                             DC", " D                             D ", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "                                 ", "       S                 S       ", "                                 ", "                                 ", "            DD     DD            ", "              DDDDD              ", "               C C               "}, {"            CHHHHHHHC            ", "             DDCDCDD             ", "            D  EEE  D            ", "                                 ", "      C                   C      ", "       E                 E       ", "    C                       C    ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", " D                             D ", " D                             D ", "CCE                           ECC", " DE                           ED ", "CCE                           ECC", " D                             D ", " D                             D ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "    C                       C    ", "       E                 E       ", "      C                   C      ", "                                 ", "            D  EEE  D            ", "             DDCDCDD             ", "               C C               "}, {"            CHHCCCHHC            ", "         CCCCDCCDCCDCCCC         ", "       CCC  D EAAAE D  CCC       ", "      CC                 CC      ", "     CC                   CC     ", "    CC E                 E CC    ", "   CC                       CC   ", "  CC E                     E CC  ", "  C                           C  ", " CC                           CC ", " C                             C ", " C                             C ", "CCD                           DCC", "CD                             DC", "CCE                           ECC", "CCA                           ACC", "CDA                           ADC", "CCA                           ACC", "CCE                           ECC", "CD                             DC", "CCD                           DCC", " C                             C ", " C                             C ", " CC                           CC ", "  C                           C  ", "  CC E                     E CC  ", "   CC                       CC   ", "    CC E                 E CC    ", "     CC                   CC     ", "      CC                 CC      ", "       CCC  D EAAAE D  CCC       ", "         CCCCDCCDCCDCCCC         ", "            CCCCCCCCC            "}, {"            CHHC~CHHC            ", "             DDDDDDD             ", "          DDD EAAAE DDD          ", "        DD             DD        ", "      CDAA             AADC      ", "      DA                 AD      ", "    CDA                   ADC    ", "    DA                     AD    ", "   DA                       AD   ", "   DA                       AD   ", "  D                           D  ", "  D                           D  ", "  D                           D  ", " D                             D ", " DE                           ED ", "CDA                           ADC", " DA                           AD ", "CDA                           ADC", " DE                           ED ", " D                             D ", "  D                           D  ", "  D                           D  ", "  D                           D  ", "   DA                       AD   ", "   DA                       AD   ", "    DA                     AD    ", "    CDA                   ADC    ", "      DA                 AD      ", "      CDAA             AADC      ", "        DD             DD        ", "          DDD EAAAE DDD          ", "             DDDDDDD             ", "               C C               "}, {"            CHHCCCHHC            ", "         CCCCDCCDCCDCCCC         ", "       CCC  D EAAAE D  CCC       ", "      CC                 CC      ", "     CC                   CC     ", "    CC E                 E CC    ", "   CC                       CC   ", "  CC E                     E CC  ", "  C                           C  ", " CC                           CC ", " C                             C ", " C                             C ", "CCD                           DCC", "CD                             DC", "CCE                           ECC", "CCA                           ACC", "CDA                           ADC", "CCA                           ACC", "CCE                           ECC", "CD                             DC", "CCD                           DCC", " C                             C ", " C                             C ", " CC                           CC ", "  C                           C  ", "  CC E                     E CC  ", "   CC                       CC   ", "    CC E                 E CC    ", "     CC                   CC     ", "      CC                 CC      ", "       CCC  D EAAAE D  CCC       ", "         CCCCDCCDCCDCCCC         ", "            CCCCCCCCC            "}, {"            CHHHHHHHC            ", "             DDCDCDD             ", "            D  EEE  D            ", "                                 ", "      C                   C      ", "       E                 E       ", "    C                       C    ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", " D                             D ", " D                             D ", "CCE                           ECC", " DE                           ED ", "CCE                           ECC", " D                             D ", " D                             D ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "    C                       C    ", "       E                 E       ", "      C                   C      ", "                                 ", "            D  EEE  D            ", "             DDCDCDD             ", "               C C               "}, {"            CCHHHHHCC            ", "              DDDDD              ", "            DD     DD            ", "                                 ", "                                 ", "       S                 S       ", "                                 ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", " D                             D ", "CD                             DC", " D                             D ", "CD                             DC", " D                             D ", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "                                 ", "       S                 S       ", "                                 ", "                                 ", "            DD     DD            ", "              DDDDD              ", "               C C               "}, {"             CCCCCCC             ", "               C C               ", "             DDDDDDD             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "CCD                           DCC", "  D                           D  ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             DDDDDDD             ", "               C C               ", "               C C               "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " C                             C ", "  D                           D  ", " C                             C ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "               C C               ", "                                 "}, {"                                 ", "               C C               ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " CC                           CC ", "   DA                       AD   ", " CC                           CC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "               C C               ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  C                           C  ", "   DA                       AD   ", "  C                           C  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "     S                     S     ", "     E                     E     ", "  CC E                     E CC  ", "    DA                     AD    ", "  CC E                     E CC  ", "     E                     E     ", "     S                     S     ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "    C                       C    ", "   CC                       CC   ", "    CDA                   ADC    ", "   CC                       CC   ", "    C                       C    ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "             SEEAEES             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "       S                 S       ", "       E                 E       ", "    CC E                 E CC    ", "      DA                 AD      ", "    CC E                 E CC    ", "       E                 E       ", "       S                 S       ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             SEEAEES             ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "              CCCCC              ", "                D                ", "                A                ", "                A                ", "                                 ", "                                 ", "                                 ", "                                 ", "      C                   C      ", "     CC                   CC     ", "      CDAA             AADC      ", "     CC                   CC     ", "      C                   C      ", "                                 ", "                                 ", "                                 ", "                                 ", "                A                ", "                A                ", "                D                ", "              CCCCC              ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "                D                ", "                D                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "      CC                 CC      ", "        DD             DD        ", "      CC                 CC      ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                D                ", "                D                ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "                D                ", "                D                ", "             DDDDDDD             ", "            DD     DD            ", "            D  EEE  D            ", "       CCC  D EAAAE D  CCC       ", "          DDD EAAAE DDD          ", "       CCC  D EAAAE D  CCC       ", "            D  EEE  D            ", "            DD     DD            ", "             DDDDDDD             ", "                D                ", "                D                ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "              DDDDD              ", "             DDCDCDD             ", "         CCCCDCCDCCDCCCC         ", "             DDDDDDD             ", "         CCCCDCCDCCDCCCC         ", "             DDCDCDD             ", "              DDDDD              ", "               C C               ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               C C               ", "               C C               ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "            CCCCCCCCC            ", "               C C               ", "               C C               ", "               C C               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}})).addElement('A', StructureUtility.ofBlocksTiered((block, meta) -> block == TT_Container_Casings.SpacetimeCompressionFieldGenerators ? meta : -1, (List)ImmutableList.of((Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)0), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)1), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)2), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)3), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)4), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)5), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)6), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)7), (Object)Pair.of((Object)TT_Container_Casings.SpacetimeCompressionFieldGenerators, (Object)8)), (Object)-1, (t, meta) -> {
            t.spacetimeCompressionFieldMetadata = meta;
        }, t -> t.spacetimeCompressionFieldMetadata)).addElement('S', StructureUtility.ofBlocksTiered((block, meta) -> block == TT_Container_Casings.StabilisationFieldGenerators ? meta : -1, (List)ImmutableList.of((Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)0), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)1), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)2), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)3), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)4), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)5), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)6), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)7), (Object)Pair.of((Object)TT_Container_Casings.StabilisationFieldGenerators, (Object)8)), (Object)-1, (t, meta) -> {
            t.stabilisationFieldMetadata = meta;
        }, t -> t.stabilisationFieldMetadata)).addElement('C', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsBA0, (int)11)).addElement('D', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsBA0, (int)10)).addElement('H', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_EM_EyeOfHarmony.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus}).casingIndex(1024).dot(1).buildAndChain(TT_Container_Casings.sBlockCasingsBA0, 12)).addElement('E', StructureUtility.ofBlocksTiered((block, meta) -> block == TT_Container_Casings.TimeAccelerationFieldGenerator ? meta : -1, (List)ImmutableList.of((Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)0), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)1), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)2), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)3), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)4), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)5), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)6), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)7), (Object)Pair.of((Object)TT_Container_Casings.TimeAccelerationFieldGenerator, (Object)8)), (Object)-1, (t, meta) -> {
            t.timeAccelerationFieldMetadata = meta;
        }, t -> t.timeAccelerationFieldMetadata)).build();
    }
}

