/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.definitions;

import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.registry.EMDefinitionsRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMDefinitionStack;
import com.github.technus.tectech.util.TT_Utility;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public interface IEMDefinition
extends Comparable<IEMDefinition>,
Cloneable {
    public static final double STABLE_RAW_LIFE_TIME = 1.5E36;
    public static final double NO_DECAY_RAW_LIFE_TIME = -1.0;
    public static final long DEFAULT_ENERGY_LEVEL = 0L;
    public static final double DEFAULT_ENERGY_REQUIREMENT = 25000.0;

    public String getLocalizedTypeName();

    public String getShortLocalizedName();

    default public String getLocalizedName() {
        return this.getLocalizedTypeName() + ": " + this.getShortLocalizedName();
    }

    public String getShortSymbol();

    public String getSymbol();

    default public void addScanShortSymbols(ArrayList<String> lines, int capabilities, long energyLevel, EMDefinitionsRegistry registry) {
        if (TT_Utility.areBitsSet(8345, capabilities)) {
            lines.add(this.getShortSymbol());
        }
    }

    default public void addScanResults(ArrayList<String> lines, int capabilities, long energyLevel, EMDefinitionsRegistry registry) {
        if (TT_Utility.areBitsSet(8344, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.class") + " = " + registry.getTypes().get(this.getClass()).getLocalizedName());
            if (TT_Utility.areBitsSet(1, capabilities)) {
                lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.name") + " = " + this.getLocalizedName());
                lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.symbol") + " = " + this.getSymbol());
            }
        }
        if (TT_Utility.areBitsSet(8, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.charge") + " = " + (double)this.getCharge() / 3.0 + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.charge"));
        }
        if (TT_Utility.areBitsSet(512, capabilities)) {
            lines.add(this.hasColor() ? StatCollector.func_74838_a((String)"tt.keyword.scan.colored") : StatCollector.func_74838_a((String)"tt.keyword.scan.colorless"));
        }
        if (TT_Utility.areBitsSet(16, capabilities)) {
            lines.add(StatCollector.func_74838_a((String)"tt.keyword.scan.mass") + " = " + this.getMass() + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.mass"));
        }
        if (TT_Utility.areBitsSet(128, capabilities)) {
            lines.add((this.isTimeSpanHalfLife() ? StatCollector.func_74838_a((String)"tt.keyword.scan.half_life") : StatCollector.func_74838_a((String)"tt.keyword.scan.life_time")) + " = " + this.getRawTimeSpan(energyLevel) + " " + StatCollector.func_74838_a((String)"tt.keyword.unit.time"));
            lines.add("    " + StatCollector.func_74838_a((String)"tt.keyphrase.scan.at_current_energy_level"));
        }
    }

    public int getMatterMassType();

    public int getGeneration();

    public IEMDefinition getAnti();

    public EMDecay[] getDecayArray();

    public EMDecay[] getNaturalDecayInstant();

    public EMDecay[] getEnergyInducedDecay(long var1);

    public boolean usesSpecialEnergeticDecayHandling();

    public boolean usesMultipleDecayCalls(long var1);

    public boolean decayMakesEnergy(long var1);

    public boolean fusionMakesEnergy(long var1);

    public double getEnergyDiffBetweenStates(long var1, long var3);

    public double getMass();

    public int getCharge();

    public int getMaxColors();

    default public boolean hasColor() {
        return this.getMaxColors() > 0;
    }

    public double getRawTimeSpan(long var1);

    public boolean isTimeSpanHalfLife();

    public EMConstantStackMap getSubParticles();

    public NBTTagCompound toNBT(EMDefinitionsRegistry var1);

    default public EMDefinitionStack getStackForm(double amount) {
        return new EMDefinitionStack(this, amount);
    }

    default public IEMDefinition clone() {
        return this;
    }

    default public int compareClassID(IEMDefinition obj) {
        return this.getMatterMassType() - obj.getMatterMassType();
    }
}

