/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.api.helpers.Helpers;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.client.sounds.SoundLimiterTicker;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MachineTileRegistery;
import mods.railcraft.common.blocks.machine.MultiBlockHelper;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.LinkageHandler;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.LocomotivePaintingRecipe;
import mods.railcraft.common.carts.MinecartHooks;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.carts.TrainTransferHelper;
import mods.railcraft.common.commands.CommandAdmin;
import mods.railcraft.common.commands.CommandDebug;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.BucketHandler;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.RailcraftFluids;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.CrowbarHandler;
import mods.railcraft.common.items.EntityItemFireproof;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemCrowbarReinforced;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.ItemRail;
import mods.railcraft.common.items.ItemRailbed;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.items.enchantment.RailcraftEnchantments;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.buildcraft.BuildcraftPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.crafting.BlastFurnaceCraftingManager;
import mods.railcraft.common.util.crafting.CartFilterRecipe;
import mods.railcraft.common.util.crafting.CokeOvenCraftingManager;
import mods.railcraft.common.util.crafting.CraftingHandler;
import mods.railcraft.common.util.crafting.RockCrusherCraftingManager;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.crafting.RotorRepairRecipe;
import mods.railcraft.common.util.crafting.RoutingTableCopyRecipe;
import mods.railcraft.common.util.crafting.RoutingTicketCopyRecipe;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.RailcraftDamageSource;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;

public class ModuleCore
extends RailcraftModule {
    public static void addLiquidFuels() {
        Fluid creosote;
        Fluid pyrotheum;
        Fluid coal;
        Fluid fuel;
        Fluid biofuel;
        int bioheat = (int)(16000.0f * RailcraftConfig.boilerBiofuelMultiplier());
        Fluid ethanol = Fluids.BIOETHANOL.get();
        if (ethanol != null) {
            FuelManager.addBoilerFuel(ethanol, bioheat);
        }
        if ((biofuel = Fluids.BIOFUEL.get()) != null) {
            FuelManager.addBoilerFuel(biofuel, bioheat);
        }
        if ((fuel = Fluids.FUEL.get()) != null) {
            FuelManager.addBoilerFuel(fuel, (int)(48000.0f * RailcraftConfig.boilerFuelMultiplier()));
        }
        if ((coal = Fluids.COAL.get()) != null) {
            FuelManager.addBoilerFuel(coal, (int)(32000.0f * RailcraftConfig.boilerFuelMultiplier()));
        }
        if ((pyrotheum = Fluids.PYROTHEUM.get()) != null) {
            FuelManager.addBoilerFuel(pyrotheum, (int)(64000.0f * RailcraftConfig.boilerFuelMultiplier()));
        }
        if ((creosote = Fluids.CREOSOTE.get()) != null) {
            FuelManager.addBoilerFuel(creosote, 4800);
        }
    }

    @Override
    public void preInit() {
        LinkageManager.reset();
        CartTools.transferHelper = TrainTransferHelper.INSTANCE;
        Railcraft.rootCommand.addChildCommand(new CommandDebug());
        Railcraft.rootCommand.addChildCommand(new CommandAdmin());
        RailcraftCraftingManager.cokeOven = new CokeOvenCraftingManager();
        RailcraftCraftingManager.blastFurnace = new BlastFurnaceCraftingManager();
        RailcraftCraftingManager.rockCrusher = new RockCrusherCraftingManager();
        RailcraftCraftingManager.rollingMachine = new RollingMachineCraftingManager();
        SignalTools.packetBuilder = PacketBuilder.instance();
        RailcraftFluids.preInitFluids();
        MinecraftForge.EVENT_BUS.register(RailcraftFluids.getTextureHook());
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RailcraftDamageSource.EVENT_HANDLER);
        Helpers.structures = new MultiBlockHelper();
        EntityItemFireproof.register();
        RecipeSorter.register((String)"railcraft:rotor.repair", RotorRepairRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"railcraft:locomotive.painting", LocomotivePaintingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"railcraft:routing.table.copy", RoutingTableCopyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"railcraft:routing.ticket.copy", RoutingTicketCopyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"railcraft:cart.filter", CartFilterRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        OreDictionary.registerOre((String)"chestWood", (Block)Blocks.field_150486_ae);
        OreDictionary.registerOre((String)"craftingTableWood", (Block)Blocks.field_150462_ai);
    }

    @Override
    public void initFirst() {
        ShapedOreRecipe recipe;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Railcraft.getMod(), (IGuiHandler)new GuiHandler());
        LootPlugin.init();
        RailcraftEnchantments.registerEnchantment();
        ItemCrowbar.registerItem();
        ItemCrowbarReinforced.registerItem();
        MinecraftForge.EVENT_BUS.register((Object)CrowbarHandler.instance());
        ItemMagnifyingGlass.register();
        ItemGoggles.registerItem();
        RailcraftToolItems.initializeToolsArmor();
        RailcraftItem.nugget.getStack(ItemNugget.EnumNugget.IRON);
        EntityEnderman.setCarriable((Block)Blocks.field_150351_n, (boolean)false);
        BuildcraftPlugin.init();
        MinecraftForge.EVENT_BUS.register((Object)MinecartHooks.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)LinkageHandler.getInstance());
        FMLCommonHandler.instance().bus().register((Object)new CraftingHandler());
        FMLCommonHandler.instance().bus().register((Object)new SoundLimiterTicker());
        FMLCommonHandler.instance().bus().register((Object)this);
        if (RailcraftConfig.useCollisionHandler()) {
            if (EntityMinecart.getCollisionHandler() != null) {
                Game.log(Level.WARN, "Existing Minecart Collision Handler detected, overwriting. Please check your configs to ensure this is desired behavior.", new Object[0]);
            }
            EntityMinecart.setCollisionHandler((IMinecartCollisionHandler)MinecartHooks.getInstance());
        }
        HashSet<Item> testSet = new HashSet<Item>();
        if (!RailcraftConfig.useOldRecipes()) {
            testSet.add(Item.func_150898_a((Block)Blocks.field_150448_aq));
            testSet.add(Item.func_150898_a((Block)Blocks.field_150318_D));
            testSet.add(Item.func_150898_a((Block)Blocks.field_150319_E));
            testSet.add(Item.func_150898_a((Block)Blocks.field_150408_cc));
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.furnace")) {
            testSet.add(Items.field_151109_aJ);
        }
        Iterator it = CraftingManager.func_77594_a().func_77592_b().iterator();
        while (it.hasNext()) {
            IRecipe r = (IRecipe)it.next();
            ItemStack output = null;
            try {
                output = r.func_77571_b();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (output == null || !testSet.contains(output.func_77973_b())) continue;
            it.remove();
        }
        this.replaceVanillaCart(EnumCart.COMMAND_BLOCK, Items.field_151095_cc, "MinecartCommandBlock", 40);
        Items.field_151095_cc.func_77637_a(CreativeTabs.field_78029_e);
        this.replaceVanillaCart(EnumCart.BASIC, Items.field_151143_au, "MinecartRideable", 42);
        this.replaceVanillaCart(EnumCart.CHEST, Items.field_151108_aI, "MinecartChest", 43);
        this.replaceVanillaCart(EnumCart.FURNACE, Items.field_151109_aJ, "MinecartFurnace", 44);
        this.replaceVanillaCart(EnumCart.TNT, Items.field_151142_bV, "MinecartTNT", 45);
        this.replaceVanillaCart(EnumCart.HOPPER, Items.field_151140_bW, "MinecartHopper", 46);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), Items.field_151108_aI);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), Items.field_151109_aJ);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), Items.field_151142_bV);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Items.field_151143_au), Items.field_151140_bW);
        LootPlugin.addLootRailway(EnumCart.BASIC.getCartItem(), 1, 1, "cart.basic");
        LootPlugin.addLootRailway(EnumCart.CHEST.getCartItem(), 1, 1, "cart.chest");
        LootPlugin.addLootRailway(EnumCart.TNT.getCartItem(), 1, 3, "cart.tnt");
        LootPlugin.addLootRailway(new ItemStack(Blocks.field_150448_aq), 8, 32, "track.basic");
        LootPlugin.addLootRailway(EnumCart.HOPPER.getCartItem(), 1, 1, "cart.hopper");
        float h = 2.0f;
        Blocks.field_150448_aq.func_149711_c(h).setHarvestLevel("crowbar", 0);
        Blocks.field_150318_D.func_149711_c(h).setHarvestLevel("crowbar", 0);
        Blocks.field_150319_E.func_149711_c(h).setHarvestLevel("crowbar", 0);
        Blocks.field_150408_cc.func_149711_c(h).setHarvestLevel("crowbar", 0);
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.bronze")) {
            recipe = new ShapedOreRecipe(new ItemStack(Items.field_151143_au), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotBronze"}});
            CraftingPlugin.addRecipe((IRecipe)recipe);
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.steel")) {
            recipe = new ShapedOreRecipe(new ItemStack(Items.field_151143_au, 2), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotSteel"}});
            CraftingPlugin.addRecipe((IRecipe)recipe);
        }
        if (!RailcraftConfig.useOldRecipes()) {
            ItemStack stackRailNormal = new ItemStack(Blocks.field_150448_aq, 32);
            ItemStack stackRailBooster = new ItemStack(Blocks.field_150318_D, 16);
            ItemStack stackRailDetector = new ItemStack(Blocks.field_150319_E, 16);
            ItemStack stackRailActivator = new ItemStack(Blocks.field_150408_cc, 16);
            Object woodRailbed = RailcraftItem.railbed.getRecipeObject(ItemRailbed.EnumRailbed.WOOD);
            CraftingPlugin.addShapedRecipe(stackRailNormal, "I I", "I#I", "I I", Character.valueOf('I'), RailcraftItem.rail.getRecipeObject(ItemRail.EnumRail.STANDARD), Character.valueOf('#'), woodRailbed);
            CraftingPlugin.addShapedRecipe(stackRailBooster, "I I", "I#I", "IrI", Character.valueOf('I'), RailcraftItem.rail.getRecipeObject(ItemRail.EnumRail.ADVANCED), Character.valueOf('#'), woodRailbed, Character.valueOf('r'), "dustRedstone");
            CraftingPlugin.addShapedRecipe(stackRailDetector, "IsI", "I#I", "IrI", Character.valueOf('I'), RailcraftItem.rail.getRecipeObject(ItemRail.EnumRail.STANDARD), Character.valueOf('#'), Blocks.field_150456_au, Character.valueOf('r'), "dustRedstone", Character.valueOf('s'), woodRailbed);
            CraftingPlugin.addShapedRecipe(stackRailActivator, "ItI", "I#I", "ItI", Character.valueOf('I'), RailcraftItem.rail.getRecipeObject(ItemRail.EnumRail.STANDARD), Character.valueOf('#'), woodRailbed, Character.valueOf('t'), new ItemStack(Blocks.field_150429_aA));
        }
        MachineTileRegistery.registerTileEntities();
    }

    private void replaceVanillaCart(EnumCart cartType, Item original, String entityTag, int entityId) {
        cartType.registerEntity();
        Class minecartClass = (Class)EntityList.field_75625_b.remove(entityTag);
        CartUtils.classReplacements.put(minecartClass, cartType);
        CartUtils.vanillaCartItemMap.put(original, cartType);
        EntityList.field_75623_d.remove(entityId);
        EntityList.func_75618_a(cartType.getCartClass(), (String)entityTag, (int)entityId);
        BlockDispenser.field_149943_a.func_82595_a((Object)original, null);
        original.func_77625_d(RailcraftConfig.getMinecartStackSize());
        cartType.setCartItem(new ItemStack(original));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initSecond() {
        void var3_7;
        void var3_5;
        if (RailcraftConfig.useCreosoteFurnaceRecipes() || !EnumMachineAlpha.COKE_OVEN.isAvaliable()) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Items.field_151044_h, 1, 0), FluidContainers.getCreosoteOilBottle(2), 0.0f);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Items.field_151044_h, 1, 1), FluidContainers.getCreosoteOilBottle(1), 0.0f);
        }
        Enum[] enumArray = EnumSignal.values();
        int n = enumArray.length;
        boolean bl = false;
        while (var3_5 < n) {
            EnumSignal enumSignal = enumArray[var3_5];
            if (enumSignal.isEnabled()) {
                RailcraftRegistry.register(enumSignal.getItem());
            }
            ++var3_5;
        }
        enumArray = EnumCube.values();
        n = enumArray.length;
        boolean bl2 = false;
        while (var3_7 < n) {
            Enum enum_ = enumArray[var3_7];
            if (((EnumCube)enum_).isEnabled()) {
                RailcraftRegistry.register(((EnumCube)enum_).getItem());
            }
            ++var3_7;
        }
        HashSet<Enum> machines = new HashSet<Enum>();
        machines.addAll(EnumSet.allOf(EnumMachineAlpha.class));
        machines.addAll(EnumSet.allOf(EnumMachineBeta.class));
        machines.addAll(EnumSet.allOf(EnumMachineGamma.class));
        machines.addAll(EnumSet.allOf(EnumMachineDelta.class));
        machines.addAll(EnumSet.allOf(EnumMachineEpsilon.class));
        for (IEnumMachine iEnumMachine : machines) {
            if (!iEnumMachine.isAvaliable()) continue;
            RailcraftRegistry.register(iEnumMachine.getItem());
        }
    }

    @Override
    public void postInit() {
        RailcraftFluids.postInitFluids();
        RailcraftItem.definePostRecipes();
        GameRegistry.registerFuelHandler((IFuelHandler)FuelPlugin.getFuelHandler());
        ModuleCore.addLiquidFuels();
        FluidHelper.nerfWaterBottle();
    }

    @SubscribeEvent
    public void tick(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70154_o instanceof EntityMinecart) {
            EntityPlayer p = event.player;
            EntityMinecart cart = (EntityMinecart)event.player.field_70154_o;
            if (Train.getTrain(cart).size() > 1) {
                CartUtils.dismount(cart, p.field_70165_t, p.field_70163_u + 1.0, p.field_70161_v);
            }
        }
    }
}

