/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.IStackStringifyHandler;
import codechicken.nei.recipe.stackinfo.DefaultStackStringifyHandler;
import codechicken.nei.recipe.stackinfo.GTFluidStackStringifyHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.io.IOUtils;

public class StackInfo {
    public static final ArrayList<IStackStringifyHandler> stackStringifyHandlers = new ArrayList();
    private static final HashMap<String, HashMap<String, String[]>> guidfilters = new HashMap();
    private static final WeakHashMap<ItemStack, String> guidcache = new WeakHashMap();

    public static NBTTagCompound itemStackToNBT(ItemStack stack) {
        return StackInfo.itemStackToNBT(stack, true);
    }

    public static NBTTagCompound itemStackToNBT(ItemStack stack, boolean saveStackSize) {
        NBTTagCompound nbTag = null;
        for (int i = stackStringifyHandlers.size() - 1; i >= 0 && nbTag == null; --i) {
            nbTag = stackStringifyHandlers.get(i).convertItemStackToNBT(stack, saveStackSize);
        }
        return nbTag;
    }

    public static ItemStack loadFromNBT(NBTTagCompound nbtTag) {
        ItemStack stack = null;
        for (int i = stackStringifyHandlers.size() - 1; i >= 0 && nbtTag != null && stack == null; --i) {
            stack = stackStringifyHandlers.get(i).convertNBTToItemStack(nbtTag);
        }
        return stack;
    }

    public static boolean equalItemAndNBT(ItemStack stackA, ItemStack stackB, boolean useNBT) {
        if (!stackA.func_77969_a(stackB)) {
            return false;
        }
        if (useNBT) {
            NBTTagCompound tagCompoundA = StackInfo.itemStackToNBT(stackA, false);
            NBTTagCompound tagCompoundB = StackInfo.itemStackToNBT(stackB, false);
            return tagCompoundA == null && tagCompoundB == null || tagCompoundA != null && tagCompoundB != null && tagCompoundA.equals((Object)tagCompoundB);
        }
        return true;
    }

    public static FluidStack getFluid(ItemStack stack) {
        FluidStack fluid = null;
        for (int i = stackStringifyHandlers.size() - 1; i >= 0 && fluid == null; --i) {
            fluid = stackStringifyHandlers.get(i).getFluid(stack);
        }
        return fluid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getItemStackGUID(ItemStack stack) {
        if (!guidcache.containsKey(stack)) {
            NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack, false);
            if (nbTag == null) {
                return null;
            }
            nbTag.func_82580_o("Count");
            if (nbTag.func_74765_d("Damage") == 0) {
                nbTag.func_82580_o("Damage");
            }
            if (nbTag.func_74764_b("tag") && nbTag.func_74775_l("tag").func_82582_d()) {
                nbTag.func_82580_o("tag");
            }
            if (nbTag.func_74764_b("strId") && guidfilters.containsKey(nbTag.func_74779_i("strId"))) {
                ArrayList<String> keys = new ArrayList<String>();
                String strId = nbTag.func_74779_i("strId");
                keys.add(strId);
                guidfilters.get(strId).forEach((key, rule) -> {
                    Object local = nbTag;
                    for (int i = 0; i < ((String[])rule).length; ++i) {
                        try {
                            if (local instanceof NBTTagCompound) {
                                local = local.func_74781_a(rule[i]);
                                continue;
                            }
                            if (!(local instanceof NBTTagList)) break;
                            local = ((NBTTagList)local).field_74747_a.get(Integer.parseInt(rule[i]));
                            continue;
                        }
                        catch (Throwable e) {
                            break;
                        }
                    }
                    if (local instanceof NBTBase) {
                        keys.add(((NBTBase)local).toString());
                    } else if (local != null) {
                        keys.add(String.valueOf(local));
                    }
                });
                WeakHashMap<ItemStack, String> weakHashMap = guidcache;
                synchronized (weakHashMap) {
                    guidcache.put(stack, keys.toString());
                }
            }
            WeakHashMap<ItemStack, String> weakHashMap = guidcache;
            synchronized (weakHashMap) {
                guidcache.put(stack, nbTag.toString());
            }
        }
        return guidcache.get(stack);
    }

    public static void loadGuidFilters() {
        guidfilters.clear();
        File guidFlitersFile = new File(NEIClientConfig.configDir, "guidfilters.cfg");
        List itemStrings = new ArrayList();
        if (guidFlitersFile.exists()) {
            try (FileReader reader = new FileReader(guidFlitersFile);){
                NEIClientConfig.logger.info("Loading guid filters from file {}", new Object[]{guidFlitersFile});
                itemStrings = IOUtils.readLines((Reader)reader);
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Failed to load bookmarks from file {}", new Object[]{guidFlitersFile, e});
                e.printStackTrace();
            }
        } else {
            URL filterUrl = StackInfo.class.getResource("/assets/nei/guidfilters.cfg");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(filterUrl.openStream()));){
                itemStrings = IOUtils.readLines((Reader)reader);
            }
            catch (IOException e) {
                NEIClientConfig.logger.info("Error parsing guid filters");
                e.printStackTrace();
            }
            catch (Exception e) {
                NEIClientConfig.logger.info("Error parsing guid filters");
                e.printStackTrace();
            }
        }
        for (String guidStr : itemStrings) {
            String[] parts = guidStr.split(",");
            HashMap<String, String[]> rules = new HashMap<String, String[]>();
            for (int j = 1; j < parts.length; ++j) {
                rules.put(parts[j], parts[j].split("\\."));
            }
            guidfilters.put(parts[0], rules);
        }
    }

    public static ItemStack getItemStackWithMinimumDamage(ItemStack[] stacks) {
        int damage = Short.MAX_VALUE;
        ItemStack result = stacks[0];
        if (stacks.length > 1) {
            for (ItemStack stack : stacks) {
                if (stack.func_77973_b() == null || stack.func_77960_j() >= damage) continue;
                damage = stack.func_77960_j();
                result = stack;
            }
        }
        return result.func_77946_l();
    }

    static {
        stackStringifyHandlers.add(new DefaultStackStringifyHandler());
        stackStringifyHandlers.add(new GTFluidStackStringifyHandler());
    }
}

