/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.gui;

import codechicken.lib.gui.GuiDraw;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import me.eigenraven.personalspace.CommonProxy;
import me.eigenraven.personalspace.Config;
import me.eigenraven.personalspace.PersonalSpaceMod;
import me.eigenraven.personalspace.block.PortalTileEntity;
import me.eigenraven.personalspace.gui.Icons;
import me.eigenraven.personalspace.gui.WButton;
import me.eigenraven.personalspace.gui.WLabel;
import me.eigenraven.personalspace.gui.WSlider;
import me.eigenraven.personalspace.gui.WTextField;
import me.eigenraven.personalspace.gui.WToggleButton;
import me.eigenraven.personalspace.gui.Widget;
import me.eigenraven.personalspace.net.Packets;
import me.eigenraven.personalspace.world.DimensionConfig;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.FlatLayerInfo;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditWorld
extends GuiScreen {
    public PortalTileEntity tile;
    int xSize;
    int ySize;
    int guiLeft;
    int guiTop;
    DimensionConfig desiredConfig = new DimensionConfig();
    WSlider skyRed;
    WSlider skyGreen;
    WSlider skyBlue;
    WSlider starBrightness;
    WTextField biome;
    int biomeCycle = 0;
    WButton biomeEditButton;
    WToggleButton enableWeather;
    WToggleButton enableNightTime;
    WToggleButton enableClouds;
    WButton skyType;
    WToggleButton generateTrees;
    WToggleButton generateVegetation;
    WButton save;
    WTextField presetEntry;
    List<WButton> presetButtons = new ArrayList<WButton>();
    Widget presetEditor;
    Widget rootWidget = new Widget();
    String voidPresetName = "gui.personalWorld.voidWorld";

    public GuiEditWorld(PortalTileEntity tile) {
        this.tile = tile;
        boolean targetDimId = false;
        DimensionConfig currentDimConfig = DimensionConfig.getForDimension(tile.func_145831_w().field_73011_w.field_76574_g, true);
        if (currentDimConfig != null) {
            this.desiredConfig.copyFrom(currentDimConfig, false, true, true);
        } else if (tile.active && tile.targetDimId > 1) {
            DimensionConfig currentConfig = (DimensionConfig)CommonProxy.getDimensionConfigObjects(true).get(tile.targetDimId);
            if (currentConfig != null) {
                this.desiredConfig.copyFrom(currentConfig, false, true, true);
            } else {
                this.desiredConfig.setAllowGenerationChanges(true);
            }
        } else {
            this.desiredConfig.setAllowGenerationChanges(true);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.rootWidget.update();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    private void addButton(GuiButton btn) {
        this.field_146292_n.add(btn);
        this.ySize += btn.field_146121_g + 6;
    }

    private void addWidget(Widget w) {
        this.rootWidget.addChild(w);
        this.ySize += w.position.height + 1;
    }

    private void updateSkyTypeButton() {
        DimensionConfig.SkyType currentType = this.desiredConfig.getSkyType();
        this.skyType.text = currentType.getButtonText();
        this.skyType.tooltip = currentType.getButtonTooltip();
    }

    public void func_73866_w_() {
        this.ySize = 0;
        this.addWidget(new WLabel(0, this.ySize, I18n.func_135052_a((String)"gui.personalWorld.skyColor", (Object[])new Object[0]), false));
        this.skyRed = new WSlider(new Rectangle(0, this.ySize, 128, 12), I18n.func_135052_a((String)"gui.personalWorld.skyColor.red", (Object[])new Object[0]) + "%.0f", 0.0, 255.0, this.desiredConfig.getSkyColor() >> 16 & 0xFF, 1.0, false, 0xFFFFFF, null, null);
        this.addWidget(this.skyRed);
        this.skyGreen = new WSlider(new Rectangle(0, this.ySize, 128, 12), I18n.func_135052_a((String)"gui.personalWorld.skyColor.green", (Object[])new Object[0]) + "%.0f", 0.0, 255.0, this.desiredConfig.getSkyColor() >> 8 & 0xFF, 1.0, false, 0xFFFFFF, null, null);
        this.addWidget(this.skyGreen);
        this.skyBlue = new WSlider(new Rectangle(0, this.ySize, 128, 12), I18n.func_135052_a((String)"gui.personalWorld.skyColor.blue", (Object[])new Object[0]) + "%.0f", 0.0, 255.0, this.desiredConfig.getSkyColor() & 0xFF, 1.0, false, 0xFFFFFF, null, null);
        this.addWidget(this.skyBlue);
        this.ySize += 4;
        this.enableNightTime = new WToggleButton(new Rectangle(130, this.ySize, 18, 18), "", false, 0, this.desiredConfig.isNightTime(), () -> this.desiredConfig.setNightTime(this.enableNightTime.value));
        this.enableNightTime.noIcon = Icons.SUN;
        this.enableNightTime.yesIcon = Icons.MOON;
        this.enableNightTime.setValue(this.enableNightTime.value);
        this.rootWidget.addChild(this.enableNightTime);
        this.skyType = new WButton(new Rectangle(150, this.ySize, 18, 18), "?", true, 0xFFFFFF, null, () -> {
            int skyTypes = DimensionConfig.SkyType.values().length;
            int skyType = (this.desiredConfig.getSkyType().ordinal() + 1) % skyTypes;
            while (!DimensionConfig.SkyType.fromOrdinal(skyType).isLoaded()) {
                skyType = (skyType + 1) % skyTypes;
            }
            this.desiredConfig.setSkyType(DimensionConfig.SkyType.fromOrdinal(skyType));
            this.updateSkyTypeButton();
        });
        this.rootWidget.addChild(this.skyType);
        this.updateSkyTypeButton();
        this.addWidget(new WLabel(0, this.ySize, I18n.func_135052_a((String)"gui.personalWorld.starBrightness", (Object[])new Object[0]), false));
        this.starBrightness = new WSlider(new Rectangle(0, this.ySize, 128, 12), "%.2f", 0.0, 1.0, this.desiredConfig.getStarBrightness(), 0.01, false, 0xFFFFFF, null, null);
        this.addWidget(this.starBrightness);
        this.ySize += 4;
        this.addWidget(new WLabel(0, this.ySize, I18n.func_135052_a((String)"gui.personalWorld.biome", (Object[])new Object[0]), false));
        this.biome = new WTextField(new Rectangle(0, this.ySize, 142, 18), this.desiredConfig.getBiomeId());
        this.biomeEditButton = new WButton(new Rectangle(144, 0, 18, 18), "", false, 0, Icons.PENCIL, () -> {
            this.biomeCycle = this.biomeEditButton.lastButton == 0 ? this.biomeCycle + 1 : this.biomeCycle + PersonalSpaceMod.clientAllowedBiomes.size() - 1;
            this.biomeCycle %= PersonalSpaceMod.clientAllowedBiomes.size();
            this.biome.textField.func_146180_a(PersonalSpaceMod.clientAllowedBiomes.get(this.biomeCycle));
        });
        this.biome.addChild(this.biomeEditButton);
        this.addWidget(this.biome);
        this.ySize += 4;
        this.generateTrees = new WToggleButton(new Rectangle(0, this.ySize, 18, 18), "", false, 0, this.desiredConfig.isGeneratingTrees(), () -> this.desiredConfig.setGeneratingTrees(this.generateTrees.getValue()));
        this.generateTrees.addChild(new WLabel(24, 4, I18n.func_135052_a((String)"gui.personalWorld.trees", (Object[])new Object[0]), false));
        this.addWidget(this.generateTrees);
        this.enableWeather = new WToggleButton(new Rectangle(90, this.generateTrees.position.y, 18, 18), "", false, 0, this.desiredConfig.isWeatherEnabled(), () -> this.desiredConfig.setWeatherEnabled(this.enableWeather.getValue()));
        this.enableWeather.addChild(new WLabel(24, 4, I18n.func_135052_a((String)"gui.personalWorld.weather", (Object[])new Object[0]), false));
        this.rootWidget.addChild(this.enableWeather);
        this.generateVegetation = new WToggleButton(new Rectangle(0, this.ySize, 18, 18), "", false, 0, this.desiredConfig.isGeneratingVegetation(), () -> this.desiredConfig.setGeneratingVegetation(this.generateVegetation.getValue()));
        this.generateVegetation.addChild(new WLabel(24, 4, I18n.func_135052_a((String)"gui.personalWorld.vegetation", (Object[])new Object[0]), false));
        this.addWidget(this.generateVegetation);
        this.enableClouds = new WToggleButton(new Rectangle(90, this.generateVegetation.position.y, 18, 18), "", false, 0, this.desiredConfig.isCloudsEnabled(), () -> this.desiredConfig.setCloudsEnabled(this.enableClouds.getValue()));
        this.enableClouds.addChild(new WLabel(24, 4, I18n.func_135052_a((String)"gui.personalWorld.clouds", (Object[])new Object[0]), false));
        this.rootWidget.addChild(this.enableClouds);
        this.voidPresetName = I18n.func_135052_a((String)"gui.personalWorld.voidWorld", (Object[])new Object[0]);
        this.ySize += 2;
        this.presetEntry = new WTextField(new Rectangle(0, this.ySize, 160, 20), this.desiredConfig.getLayersAsString());
        if (this.presetEntry.textField.func_146179_b().isEmpty()) {
            this.presetEntry.textField.func_146180_a(this.voidPresetName);
        }
        this.addWidget(this.presetEntry);
        this.ySize += 2;
        this.addWidget(new WLabel(0, this.ySize, I18n.func_135052_a((String)"gui.personalWorld.presets", (Object[])new Object[0]), false));
        int px = 8;
        int pi = 1;
        for (String preset : Config.defaultPresets) {
            if (preset.isEmpty()) {
                preset = this.voidPresetName;
            }
            String finalPreset = preset;
            this.presetButtons.add(new WButton(new Rectangle(px, this.ySize, 24, 18), Integer.toString(pi), true, 0xFFFFFF, null, () -> this.presetEntry.textField.func_146180_a(finalPreset)));
            this.rootWidget.addChild(this.presetButtons.get(this.presetButtons.size() - 1));
            ++pi;
            px += 26;
        }
        this.ySize += 20;
        this.save = new WButton(new Rectangle(0, this.ySize, 128, 20), I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), true, 0xFFFFFF, Icons.CHECKMARK, () -> {
            Packets.INSTANCE.sendChangeWorldSettings(this.tile, this.desiredConfig).sendToServer();
            Minecraft.func_71410_x().func_147108_a(null);
        });
        this.rootWidget.addChild(new WButton(new Rectangle(130, this.ySize, 128, 20), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), true, 0xFFFFFF, Icons.CROSS, () -> Minecraft.func_71410_x().func_147108_a(null)));
        this.addWidget(this.save);
        this.presetEditor = new Widget();
        this.presetEditor.position = new Rectangle(172, 0, 1, 1);
        this.rootWidget.addChild(this.presetEditor);
        this.regeneratePresetEditor();
        this.xSize = 304;
        this.ySize = 224;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    private void regeneratePresetEditor() {
        boolean generationEnabled = this.desiredConfig.getAllowGenerationChanges();
        this.presetEditor.children.clear();
        int curX = 0;
        int curY = 0;
        for (String bl : PersonalSpaceMod.clientAllowedBlocks) {
            String[] blName = bl.split(":");
            if (blName.length != 2) continue;
            Block block = GameRegistry.findBlock((String)blName[0], (String)blName[1]);
            ItemStack is = new ItemStack(block);
            WButton addBtn = new WButton(new Rectangle(curX, curY, 20, 20), "", false, 0, null, () -> {
                FlatLayerInfo fli = new FlatLayerInfo(1, block);
                this.desiredConfig.getMutableLayers().add(fli);
                this.desiredConfig.setLayers(this.desiredConfig.getLayersAsString());
                this.configToPreset();
            });
            addBtn.itemStack = is;
            addBtn.itemStackText = "+";
            addBtn.tooltip = is.func_77973_b() != null ? is.func_82833_r() : block.func_149732_F();
            addBtn.enabled = generationEnabled;
            this.presetEditor.addChild(addBtn);
            if ((curY += 21) <= 188) continue;
            curY = 0;
            curX += 21;
        }
        curY = 0;
        this.presetEditor.addChild(new WLabel(curX += 22, curY, I18n.func_135052_a((String)"gui.personalWorld.layers", (Object[])new Object[0]), false));
        curY += 10;
        List<FlatLayerInfo> fli = this.desiredConfig.getLayers();
        for (int i = fli.size() - 1; i >= 0; --i) {
            FlatLayerInfo info = fli.get(i);
            int finalI = i;
            WButton block = new WButton(new Rectangle(curX + 12, curY, 20, 28), "", false, 0, null, null);
            Block gameBlock = info.func_151536_b();
            block.enabled = false;
            block.itemStack = new ItemStack(gameBlock);
            block.itemStackText = Integer.toString(info.func_82657_a());
            block.tooltip = gameBlock.func_149732_F();
            this.presetEditor.addChild(block);
            if (i < fli.size() - 1) {
                block.addChild(new WButton(new Rectangle(-12, 0, 10, 10), "", false, 0, Icons.SMALL_UP, () -> {
                    Collections.swap(this.desiredConfig.getMutableLayers(), finalI, finalI + 1);
                    this.configToPreset();
                }));
            }
            block.addChild(new WButton(new Rectangle(-12, 9, 10, 10), "", false, 0, Icons.SMALL_CROSS, () -> {
                this.desiredConfig.getMutableLayers().remove(finalI);
                this.configToPreset();
            }));
            if (i > 0) {
                block.addChild(new WButton(new Rectangle(-12, 18, 10, 10), "", false, 0, Icons.SMALL_DOWN, () -> {
                    Collections.swap(this.desiredConfig.getMutableLayers(), finalI, finalI - 1);
                    this.configToPreset();
                }));
            }
            IntConsumer plusMinus = mul -> {
                FlatLayerInfo orig = this.desiredConfig.getMutableLayers().get(finalI);
                boolean shiftHeld = Keyboard.isKeyDown((int)42);
                boolean ctrlHeld = Keyboard.isKeyDown((int)29);
                int newCnt = ctrlHeld ? 64 : (shiftHeld ? 10 : 1);
                newCnt *= mul;
                newCnt = MathHelper.func_76125_a((int)(orig.func_82657_a() + newCnt), (int)1, (int)255);
                this.desiredConfig.getMutableLayers().set(finalI, new FlatLayerInfo(newCnt, orig.func_151536_b()));
                this.desiredConfig.setLayers(this.desiredConfig.getLayersAsString());
                this.configToPreset();
            };
            block.addChild(new WButton(new Rectangle(21, 5, 18, 18), "", false, 0, generationEnabled ? Icons.PLUS : Icons.LOCK, () -> plusMinus.accept(1)));
            block.addChild(new WButton(new Rectangle(40, 5, 18, 18), "", false, 0, generationEnabled ? Icons.MINUS : Icons.LOCK, () -> plusMinus.accept(-1)));
            for (Widget child : block.children) {
                child.enabled = generationEnabled;
            }
            if ((curY += 30) <= 188) continue;
            curY = 10;
            curX += 21;
        }
    }

    private void configToPreset() {
        String preset = this.desiredConfig.getLayersAsString();
        if (preset == null || preset.isEmpty()) {
            preset = this.voidPresetName;
        }
        this.presetEntry.textField.func_146180_a(preset);
        this.presetEntry.textField.func_146196_d();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean generationEnabled;
        boolean inputsValid = true;
        this.func_146276_q_();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        mouseX -= this.guiLeft;
        mouseY -= this.guiTop;
        Icons.bindTexture();
        Icons.GUI_BG.draw9Patch(-8, -8, this.xSize + 16, this.ySize + 16);
        int skyR = MathHelper.func_76125_a((int)this.skyRed.getValueInt(), (int)0, (int)255);
        int skyG = MathHelper.func_76125_a((int)this.skyGreen.getValueInt(), (int)0, (int)255);
        int skyB = MathHelper.func_76125_a((int)this.skyBlue.getValueInt(), (int)0, (int)255);
        this.desiredConfig.setSkyColor(skyR << 16 | skyG << 8 | skyB);
        this.desiredConfig.setStarBrightness((float)this.starBrightness.getValue());
        this.generateTrees.enabled = generationEnabled = this.desiredConfig.getAllowGenerationChanges();
        this.generateVegetation.enabled = generationEnabled;
        for (WButton presetBtn : this.presetButtons) {
            presetBtn.enabled = generationEnabled;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.biome.enabled = generationEnabled;
        this.biomeEditButton.enabled = generationEnabled;
        this.biomeEditButton.buttonIcon = generationEnabled ? Icons.PENCIL : Icons.LOCK;
        this.presetEntry.enabled = generationEnabled;
        String actualText = this.presetEntry.textField.func_146179_b();
        if (this.voidPresetName.equals(actualText)) {
            actualText = "";
        }
        if (!generationEnabled) {
            this.presetEntry.textField.func_146193_g(0x909090);
        } else if (!DimensionConfig.PRESET_VALIDATION_PATTERN.matcher(actualText).matches()) {
            this.presetEntry.textField.func_146193_g(0xFF0000);
            this.presetEntry.tooltip = I18n.func_135052_a((String)"gui.personalWorld.invalidSyntax", (Object[])new Object[0]);
            inputsValid = false;
        } else if (!DimensionConfig.canUseLayers(actualText, true)) {
            this.presetEntry.textField.func_146193_g(0xFFFF00);
            this.presetEntry.tooltip = I18n.func_135052_a((String)"gui.personalWorld.notAllowed", (Object[])new Object[0]);
            inputsValid = false;
        } else {
            this.presetEntry.textField.func_146193_g(0xA0FFA0);
            this.presetEntry.tooltip = null;
            this.desiredConfig.setLayers(actualText);
            this.regeneratePresetEditor();
        }
        this.desiredConfig.setBiomeId(this.biome.textField.func_146179_b());
        if (!generationEnabled) {
            this.biome.textField.func_146193_g(0x909090);
        } else if (!this.desiredConfig.getBiomeId().equalsIgnoreCase(BiomeGenBase.func_150568_d((int)this.desiredConfig.getRawBiomeId()).field_76791_y)) {
            this.biome.textField.func_146193_g(0xFF0000);
            this.biome.tooltip = I18n.func_135052_a((String)"gui.personalWorld.invalidSyntax", (Object[])new Object[0]);
            inputsValid = false;
        } else if (!DimensionConfig.canUseBiome(this.desiredConfig.getBiomeId(), true)) {
            this.biome.textField.func_146193_g(0xFFFF00);
            this.biome.tooltip = I18n.func_135052_a((String)"gui.personalWorld.notAllowed", (Object[])new Object[0]);
            inputsValid = false;
        } else {
            this.biome.textField.func_146193_g(0xA0FFA0);
            this.biome.tooltip = null;
        }
        this.save.enabled = inputsValid;
        this.rootWidget.draw(mouseX, mouseY, partialTicks);
        GuiDraw.gui.setZLevel(0.0f);
        GuiDraw.drawRect((int)130, (int)this.skyRed.position.y, (int)32, (int)(3 * (this.skyRed.position.height + 1)), (int)-16777216);
        GuiDraw.drawRect((int)131, (int)(this.skyRed.position.y + 1), (int)30, (int)(3 * (this.skyRed.position.height + 1) - 2), (int)(0xFF000000 | this.desiredConfig.getSkyColor()));
        Icons.bindTexture();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.desiredConfig.getStarBrightness());
        Icons.STAR.drawAt(132, this.skyRed.position.y + 2);
        Icons.STAR.drawAt(145, this.skyRed.position.y + 12);
        Icons.STAR.drawAt(134, this.skyRed.position.y + 21);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.rootWidget.drawForeground(mouseX, mouseY, partialTicks);
        GL11.glPopMatrix();
    }

    protected void func_73869_a(char character, int key) {
        super.func_73869_a(character, key);
        this.rootWidget.keyTyped(character, key);
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x -= this.guiLeft, y -= this.guiTop, button);
        this.rootWidget.mouseClicked(x, y, button);
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x -= this.guiLeft, y -= this.guiTop, button);
        this.rootWidget.mouseMovedOrUp(x, y, button);
    }

    protected void func_146273_a(int x, int y, int lastBtn, long timeDragged) {
        super.func_146273_a(x -= this.guiLeft, y -= this.guiTop, lastBtn, timeDragged);
        this.rootWidget.mouseClickMove(x, y, lastBtn, timeDragged);
    }

    protected void func_146284_a(GuiButton button) {
    }

    public boolean func_73868_f() {
        return false;
    }
}

