/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.render.sky;

import cpw.mods.fml.client.FMLClientHandler;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.render.sky.SkyProviderBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class SkyProviderBaseSS
extends SkyProviderBase {
    private float spinAngle = 0.0f;
    public float spinDeltaPerTick = 0.0f;
    private float prevPartialTicks = 0.0f;
    private long prevTick;

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.calulateSpin(partialTicks, world.func_82737_E());
        this.renderDefaultWithoutSkyList2(partialTicks, world, mc);
    }

    @Override
    protected void renderStarList(float partialTicks, WorldClient world) {
        GL11.glPushMatrix();
        this.spin();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-19.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)GSConfigCore.spaceStationStarBrightness, (float)GSConfigCore.spaceStationStarBrightness, (float)GSConfigCore.spaceStationStarBrightness, (float)GSConfigCore.spaceStationStarBrightness);
        GL11.glCallList((int)this.starList);
        GL11.glPopMatrix();
    }

    @Override
    protected void renderSun(float partialTicks, WorldClient world, Minecraft mc) {
        float sunColorBlueAnaglyph;
        float sunColorGreenAnaglyph;
        float sunColorRedAnaglyph;
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        this.spin();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float starBrightness = 1.0f - world.func_72880_h(partialTicks);
        if (mc.field_71474_y.field_74337_g) {
            sunColorRedAnaglyph = this.sunRGBA[0] * 0.3f + this.sunRGBA[1] * 0.59f + this.sunRGBA[2] * 0.11f;
            sunColorGreenAnaglyph = this.sunRGBA[0] * 0.3f + this.sunRGBA[1] * 0.7f;
            sunColorBlueAnaglyph = this.sunRGBA[0] * 0.3f + this.sunRGBA[2] * 0.7f;
        } else {
            sunColorRedAnaglyph = this.sunRGBA[0];
            sunColorGreenAnaglyph = this.sunRGBA[1];
            sunColorBlueAnaglyph = this.sunRGBA[2];
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(6);
        tessellator.func_78369_a(sunColorRedAnaglyph * starBrightness, sunColorGreenAnaglyph * starBrightness, sunColorBlueAnaglyph * starBrightness, this.sunRGBA[3] * 2.0f / starBrightness);
        tessellator.func_78377_a(0.0, 100.0, 0.0);
        tessellator.func_78369_a(this.sunRGBA[0] * starBrightness, this.sunRGBA[1] * starBrightness, this.sunRGBA[2] * starBrightness, 0.0f);
        tessellator.func_78377_a(-this.innerFlareRadius, 100.0, -this.innerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, -this.innerFlareRadius * 1.5);
        tessellator.func_78377_a(this.innerFlareRadius, 100.0, -this.innerFlareRadius);
        tessellator.func_78377_a(this.innerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(this.innerFlareRadius, 100.0, this.innerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, this.innerFlareRadius * 1.5);
        tessellator.func_78377_a(-this.innerFlareRadius, 100.0, this.innerFlareRadius);
        tessellator.func_78377_a(-this.innerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(-this.innerFlareRadius, 100.0, -this.innerFlareRadius);
        tessellator.func_78381_a();
        tessellator.func_78371_b(6);
        tessellator.func_78369_a(sunColorRedAnaglyph * starBrightness, sunColorGreenAnaglyph * starBrightness, sunColorBlueAnaglyph * starBrightness, this.sunRGBA[3] * starBrightness);
        tessellator.func_78377_a(0.0, 100.0, 0.0);
        tessellator.func_78369_a(this.sunRGBA[0] * starBrightness, this.sunRGBA[1] * starBrightness, this.sunRGBA[2] * starBrightness, 0.0f);
        tessellator.func_78377_a(-this.outerFlareRadius, 100.0, -this.outerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, -this.outerFlareRadius * 1.5);
        tessellator.func_78377_a(this.outerFlareRadius, 100.0, -this.outerFlareRadius);
        tessellator.func_78377_a(this.outerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(this.outerFlareRadius, 100.0, this.outerFlareRadius);
        tessellator.func_78377_a(0.0, 100.0, this.outerFlareRadius * 1.5);
        tessellator.func_78377_a(-this.outerFlareRadius, 100.0, this.outerFlareRadius);
        tessellator.func_78377_a(-this.outerFlareRadius * 1.5, 100.0, 0.0);
        tessellator.func_78377_a(-this.outerFlareRadius, 100.0, -this.outerFlareRadius);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.spin();
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getSunTexture());
        tessellator.func_78382_b();
        tessellator.func_78374_a(-this.sunRadius, 100.0, -this.sunRadius, 0.0, 0.0);
        tessellator.func_78374_a(this.sunRadius, 100.0, -this.sunRadius, 1.0, 0.0);
        tessellator.func_78374_a(this.sunRadius, 100.0, this.sunRadius, 1.0, 1.0);
        tessellator.func_78374_a(-this.sunRadius, 100.0, this.sunRadius, 0.0, 1.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    protected void renderGalaxies() {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        this.spin();
        GL11.glRotatef((float)-105.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(lmcTexture, 15.0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        this.spin();
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-105.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(smcTexture, 5.0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        this.spin();
        GL11.glRotatef((float)145.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(andromedaTexture, 4.0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        this.spin();
        GL11.glRotatef((float)65.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawTexture(barnardaloopTexture, 40.0);
        GL11.glPopMatrix();
    }

    private void calulateSpin(float partialTicks, long currentTick) {
        float deltaTick = partialTicks - this.prevPartialTicks;
        this.prevPartialTicks = partialTicks;
        int tickDiff = (int)(currentTick - this.prevTick);
        this.prevTick = currentTick;
        if (tickDiff > 0 && tickDiff < 20) {
            deltaTick += (float)tickDiff;
        }
        this.spinAngle -= this.spinDeltaPerTick * deltaTick;
        this.spinAngle %= 360.0f;
        if (this.spinAngle < -180.0f) {
            this.spinAngle += 360.0f;
        }
    }

    protected void spin() {
        GL11.glRotatef((float)this.spinAngle, (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

