/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.tileentity;

import net.malisis.core.util.Timer;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.movement.IDoorMovement;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class DoorTileEntity
extends TileEntity {
    protected DoorDescriptor descriptor;
    protected int lastMetadata = -1;
    protected Timer timer = new Timer();
    protected DoorState state = DoorState.CLOSED;
    protected boolean moving;
    protected boolean centered = false;

    public DoorDescriptor getDescriptor() {
        if (this.descriptor == null || this.descriptor.getMovement() == null) {
            if (this.func_145838_q() == null) {
                return this.descriptor;
            }
            if (this.func_145838_q() instanceof Door) {
                this.descriptor = ((Door)this.func_145838_q()).getDescriptor();
            }
        }
        return this.descriptor;
    }

    public void setDescriptor(DoorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public DoorState getState() {
        return this.state;
    }

    public void setState(DoorState state) {
        this.state = state;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public IDoorMovement getMovement() {
        return this.getDescriptor() != null ? this.getDescriptor().getMovement() : null;
    }

    public int getOpeningTime() {
        return this.getDescriptor() != null ? this.getDescriptor().getOpeningTime() : 6;
    }

    public int getDirection() {
        return this.func_145832_p() & 3;
    }

    public boolean isTopBlock(int x, int y, int z) {
        return x == this.field_145851_c && y == this.field_145848_d + 1 && z == this.field_145849_e;
    }

    public int func_145832_p() {
        if (this.lastMetadata != this.field_145847_g || this.field_145847_g == -1 && this.func_145838_q() != null) {
            this.lastMetadata = this.field_145847_g = Door.fullMetadata((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145847_g;
    }

    public boolean isOpened() {
        return (this.func_145832_p() & 4) != 0;
    }

    public boolean isReversed() {
        return (this.func_145832_p() & 0x10) != 0;
    }

    public boolean isPowered() {
        return this.func_145831_w().func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || this.func_145831_w().func_72864_z(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public boolean isCentered() {
        return this.centered;
    }

    public boolean shouldCenter() {
        if (this.getMovement() == null) {
            return false;
        }
        int ox = 0;
        int oz = 0;
        if (this.getDirection() == 1 || this.getDirection() == 3) {
            ox = 1;
        } else {
            oz = 1;
        }
        Block b1 = this.field_145850_b.func_147439_a(this.field_145851_c - ox, this.field_145848_d, this.field_145849_e - oz);
        Block b2 = this.field_145850_b.func_147439_a(this.field_145851_c + ox, this.field_145848_d, this.field_145849_e + oz);
        return ArrayUtils.contains((Object[])Door.centerBlocks, (Object)b1) || ArrayUtils.contains((Object[])Door.centerBlocks, (Object)b2);
    }

    public boolean setCentered(boolean centered) {
        this.centered = centered;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return centered;
    }

    public void onBlockPlaced(Door door, ItemStack itemStack) {
        DoorDescriptor desc = itemStack.func_77978_p() != null ? new DoorDescriptor(itemStack.func_77978_p()) : door.getDescriptor();
        this.setDescriptor(desc);
    }

    public void openOrCloseDoor() {
        DoorState newState = this.state == DoorState.OPENED ? DoorState.CLOSING : DoorState.OPENING;
        this.setDoorState(newState);
        DoorTileEntity te = this.getDoubleDoor();
        if (te != null) {
            te.setDoorState(newState);
        }
    }

    public void setDoorState(DoorState newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        if (this.func_145831_w() == null) {
            return;
        }
        if (this.state == DoorState.CLOSING || this.state == DoorState.OPENING) {
            if (this.moving) {
                long s = this.timer.elapsedTime() - Timer.tickToTime((long)this.getOpeningTime());
                this.timer.setRelativeStart(s);
            } else {
                this.timer.start();
                this.moving = true;
            }
        } else {
            int metadata = this.func_145832_p();
            if (this.func_145838_q() instanceof Door) {
                metadata &= 7;
            }
            metadata = this.state == DoorState.OPENED ? metadata | 4 : metadata & 0xFFFFFFFB;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 2);
            this.moving = false;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.playSound();
    }

    public void playSound() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        String soundPath = null;
        if (this.descriptor.getSound() != null) {
            soundPath = this.descriptor.getSound().getSoundPath(this.state);
        }
        if (soundPath != null) {
            this.func_145831_w().func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, soundPath, 1.0f, 1.0f);
        }
    }

    public DoorTileEntity getDoubleDoor() {
        if (!this.descriptor.isDoubleDoor()) {
            return null;
        }
        int dir = this.getDirection();
        boolean reversed = this.isReversed();
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        if (dir == 1) {
            x += reversed ? 1 : -1;
        } else if (dir == 3) {
            x += reversed ? -1 : 1;
        } else if (dir == 2) {
            z += reversed ? 1 : -1;
        } else if (dir == 0) {
            z += reversed ? -1 : 1;
        }
        TileEntity te = this.field_145850_b.func_147438_o(x, this.field_145848_d, z);
        if (te instanceof DoorTileEntity && this.isMatchingDoubleDoor((DoorTileEntity)te)) {
            return (DoorTileEntity)te;
        }
        return null;
    }

    public boolean isMatchingDoubleDoor(DoorTileEntity te) {
        if (this.func_145838_q() != te.func_145838_q()) {
            return false;
        }
        if (this.getDirection() != te.getDirection()) {
            return false;
        }
        if (this.getMovement() != te.getMovement()) {
            return false;
        }
        if ((this.func_145832_p() & 4) != (te.func_145832_p() & 4)) {
            return false;
        }
        return (this.func_145832_p() & 0x10) != (te.func_145832_p() & 0x10);
    }

    public void setPowered(boolean powered) {
        if (this.isOpened() == powered && !this.isMoving()) {
            return;
        }
        DoorTileEntity te = this.getDoubleDoor();
        if (!powered && te != null && te.isPowered()) {
            return;
        }
        DoorState newState = powered ? DoorState.OPENING : DoorState.CLOSING;
        this.setDoorState(newState);
        if (te != null) {
            te.setDoorState(newState);
        }
    }

    public void func_145845_h() {
        if (!this.moving) {
            return;
        }
        if (this.timer.elapsedTick() > (long)this.descriptor.getOpeningTime()) {
            this.setDoorState(this.state == DoorState.CLOSING ? DoorState.CLOSED : DoorState.OPENED);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.descriptor = new DoorDescriptor(nbt);
        this.setDoorState(DoorState.values()[nbt.func_74762_e("state")]);
        this.setCentered(nbt.func_74767_n("centered"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.descriptor != null) {
            this.descriptor.writeNBT(nbt);
        }
        nbt.func_74768_a("state", this.state.ordinal());
        nbt.func_74757_a("centered", this.centered);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }
}

