/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util;

import aroma1997.core.log.LogHelperPre;
import aroma1997.core.recipes.ShapedAromicRecipe;
import aroma1997.core.recipes.ShapelessAromicRecipe;
import aroma1997.core.util.registry.SpecialItemBlock;
import aroma1997.core.util.registry.SpecialName;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class AromaRegistry {
    public static void register(Object o) {
        AromaRegistry.register(o.getClass(), o);
    }

    public static void register(Class<?> clazz) {
        AromaRegistry.register(clazz, null);
    }

    public static void register(Class<?> clazz, Object o) {
        block11: {
            for (Field field : clazz.getFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    String name = field.getName();
                    SpecialName sname = field.getAnnotation(SpecialName.class);
                    if (sname != null) {
                        name = sname.value();
                    }
                    if (Block.class.isInstance(field.get(o))) {
                        SpecialItemBlock s = field.getAnnotation(SpecialItemBlock.class);
                        Annotation[] a = field.getAnnotations();
                        if (s == null) {
                            GameRegistry.registerBlock((Block)((Block)field.get(o)), (String)name);
                            continue;
                        }
                        GameRegistry.registerBlock((Block)((Block)field.get(o)), s.value(), (String)name);
                        continue;
                    }
                    if (Item.class.isInstance(field.get(o))) {
                        GameRegistry.registerItem((Item)((Item)field.get(o)), (String)name);
                        continue;
                    }
                    if (!IRecipe.class.isInstance(field.get(o))) continue;
                    GameRegistry.addRecipe((IRecipe)((IRecipe)field.get(o)));
                }
                catch (Exception e) {
                    LogHelperPre.logException("Failed to register: " + field.getName(), e);
                }
            }
            try {
                Method method = clazz.getDeclaredMethod("init", new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof NoSuchMethodException) break block11;
                LogHelperPre.logException("Failed to invoke the Initialization of: " + clazz.getCanonicalName(), e);
            }
        }
    }

    public static IRecipe getShapedRecipe(ItemStack output, boolean hidden, Object ... input) {
        ShapedAromicRecipe recipe = new ShapedAromicRecipe(output, input);
        recipe.setHidden(hidden);
        return recipe;
    }

    public static IRecipe getShapelessRecipe(ItemStack output, boolean hidden, Object ... input) {
        ShapelessAromicRecipe recipe = new ShapelessAromicRecipe(output, input);
        recipe.setHidden(hidden);
        return recipe;
    }

    @Deprecated
    public static void registerShapedOreRecipe(ItemStack item, Object ... params) {
        AromaRegistry.registerShapedAromicRecipe(item, false, params);
    }

    @Deprecated
    public static void registerShapelessOreRecipe(ItemStack item, Object ... params) {
        AromaRegistry.registerShapelessAromicRecipe(item, false, params);
    }

    public static void registerShapedAromicRecipe(ItemStack item, boolean hidden, Object ... params) {
        GameRegistry.addRecipe((IRecipe)AromaRegistry.getShapedRecipe(item, hidden, params));
    }

    public static void registerShapelessAromicRecipe(ItemStack item, boolean hidden, Object ... params) {
        GameRegistry.addRecipe((IRecipe)AromaRegistry.getShapelessRecipe(item, hidden, params));
    }
}

