/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.storage;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.PlayerMainInvWrapper;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.MovingAverageLong;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.preloader.asm.AsmConfig;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaTileEntity_PowerSubStationController
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_PowerSubStationController>
implements ISurvivalConstructable {
    protected long mAverageEuUsage = 0L;
    protected final MovingAverageLong mAverageEuAdded = new MovingAverageLong(20);
    protected final MovingAverageLong mAverageEuConsumed = new MovingAverageLong(20);
    protected long mTotalEnergyAdded = 0L;
    protected long mTotalEnergyConsumed = 0L;
    protected long mTotalEnergyLost = 0L;
    protected boolean mIsOutputtingPower = false;
    protected long mBatteryCapacity = 0L;
    private final int ENERGY_TAX = 5;
    private int mCasing;
    private int[] cellCount = new int[6];
    private TopState topState = TopState.MayBeTop;
    private static IStructureDefinition<GregtechMetaTileEntity_PowerSubStationController> STRUCTURE_DEFINITION = null;
    public static final int CELL_HEIGHT_MAX = 16;
    public static final int CELL_HEIGHT_MIN = 2;
    private static final long CELL_TIER_EV_CAPACITY = 100000000L;
    private static final long CELL_TIER_MULTIPLIER = 4L;

    public GregtechMetaTileEntity_PowerSubStationController(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_PowerSubStationController(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Energy Buffer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Consumes " + this.ENERGY_TAX + "% of the average voltage of all energy type hatches").addInfo("Does not require maintenance").addInfo("Can be built with variable height between 4-18").addInfo("Hatches can be placed nearly anywhere").addInfo("HV Energy/Dynamo Hatches are the lowest tier you can use").addInfo("Supports voltages >= UHV using MAX tier components.").addSeparator().addController("Bottom Center").addCasingInfoMin("Sub-Station External Casings", 10, false).addDynamoHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addSubChannelUsage("capacitor", "Vanadium Capacitor Cell Tier").addSubChannelUsage("height", "Height of structure").toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(24)), new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER))};
        }
        if (side == this.getBaseMetaTileEntity().getBackFacing()) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(24)), this.mIsOutputtingPower ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[(int)this.getOutputTier()] : Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[(int)this.getInputTier()]};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(23))};
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    private void checkMachineProblem(String msg, int xOff, int yOff, int zOff) {
        IGregTechTileEntity te = this.getBaseMetaTileEntity();
        Block tBlock = te.getBlockOffset(xOff, yOff, zOff);
        byte tMeta = te.getMetaIDOffset(xOff, yOff, zOff);
        String name = tBlock.func_149732_F();
        String problem = msg + ": (" + xOff + ", " + yOff + ", " + zOff + ") " + name + ":" + tMeta;
        this.checkMachineProblem(problem);
    }

    private void checkMachineProblem(String msg) {
        if (!AsmConfig.disableAllLogging) {
            Logger.INFO("Power Sub-Station problem: " + msg);
        }
    }

    public static int getCellTier(Block aBlock, int aMeta) {
        if (aBlock == ModBlocks.blockCasings2Misc && aMeta == 7) {
            return 4;
        }
        if (aBlock == ModBlocks.blockCasings3Misc && aMeta == 4) {
            return 5;
        }
        if (aBlock == ModBlocks.blockCasings3Misc && aMeta == 5) {
            return 6;
        }
        if (aBlock == ModBlocks.blockCasings3Misc && aMeta == 6) {
            return 7;
        }
        if (aBlock == ModBlocks.blockCasings3Misc && aMeta == 7) {
            return 8;
        }
        if (aBlock == ModBlocks.blockCasings3Misc && aMeta == 8) {
            return 9;
        }
        return -1;
    }

    public static int getMetaFromTier(int tier) {
        if (tier == 4) {
            return 7;
        }
        if (tier >= 5 && tier <= 9) {
            return tier - 1;
        }
        return 0;
    }

    public static Block getBlockFromTier(int tier) {
        switch (tier) {
            case 4: {
                return ModBlocks.blockCasings2Misc;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ModBlocks.blockCasings3Misc;
            }
        }
        return null;
    }

    public static int getMaxHatchTier(int aCellTier) {
        switch (aCellTier) {
            case 9: {
                return GT_Values.VOLTAGE_NAMES[9].equals("Ultimate High Voltage") ? 15 : 9;
            }
        }
        if (aCellTier < 4) {
            return 0;
        }
        return aCellTier;
    }

    public IStructureDefinition<GregtechMetaTileEntity_PowerSubStationController> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName + "bottom", StructureUtility.transpose((String[][])new String[][]{{"BB~BB", "BBBBB", "BBBBB", "BBBBB", "BBBBB"}})).addShape(this.mName + "layer", StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CIIIC", "CIIIC", "CIIIC", "CCCCC"}})).addShape(this.mName + "mid", StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CHHHC", "CHHHC", "CHHHC", "CCCCC"}})).addShape(this.mName + "top", StructureUtility.transpose((String[][])new String[][]{{"TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_PowerSubStationController.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTEnergy), GT_HatchElement.Dynamo.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTDynamo), GT_HatchElement.Maintenance}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(TAE.GTPP_INDEX(24)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)8))})).addElement('B', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_PowerSubStationController.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTEnergy), GT_HatchElement.Dynamo.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTDynamo), GT_HatchElement.Maintenance}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP}).casingIndex(TAE.GTPP_INDEX(24)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)8))})).addElement('T', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_PowerSubStationController.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTEnergy), GT_HatchElement.Dynamo.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTDynamo), GT_HatchElement.Maintenance}).disallowOnly(new ForgeDirection[]{ForgeDirection.DOWN}).casingIndex(TAE.GTPP_INDEX(24)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)8))})).addElement('I', StructureUtility.withChannel((String)"cell", (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onlyIf(x -> x.topState != TopState.NotTop, (IStructureElement)StructureUtility.onElementPass(x -> {
                x.topState = TopState.Top;
            }, (IStructureElement)GT_StructureUtility.ofHatchAdderOptional(GregtechMetaTileEntity_PowerSubStationController::addPowerSubStationList, (int)TAE.GTPP_INDEX(24), (int)1, (Block)ModBlocks.blockCasings2Misc, (int)8))), StructureUtility.onlyIf(x -> x.topState != TopState.Top, (IStructureElement)StructureUtility.onElementPass(x -> {
                x.topState = TopState.NotTop;
            }, (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> {
                x.cellCount[0] = x.cellCount[0] + 1;
            }, GregtechMetaTileEntity_PowerSubStationController.ofCell(4)), StructureUtility.onElementPass(x -> {
                x.cellCount[1] = x.cellCount[1] + 1;
            }, GregtechMetaTileEntity_PowerSubStationController.ofCell(5)), StructureUtility.onElementPass(x -> {
                x.cellCount[2] = x.cellCount[2] + 1;
            }, GregtechMetaTileEntity_PowerSubStationController.ofCell(6)), StructureUtility.onElementPass(x -> {
                x.cellCount[3] = x.cellCount[3] + 1;
            }, GregtechMetaTileEntity_PowerSubStationController.ofCell(7)), StructureUtility.onElementPass(x -> {
                x.cellCount[4] = x.cellCount[4] + 1;
            }, GregtechMetaTileEntity_PowerSubStationController.ofCell(8)), StructureUtility.onElementPass(x -> {
                x.cellCount[5] = x.cellCount[5] + 1;
            }, GregtechMetaTileEntity_PowerSubStationController.ofCell(9))})))}))).addElement('H', GregtechMetaTileEntity_PowerSubStationController.ofCell(4)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public static <T> IStructureElement<T> ofCell(final int aIndex) {
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                int meta;
                Block block = world.func_147439_a(x, y, z);
                int tier = GregtechMetaTileEntity_PowerSubStationController.getCellTier(block, meta = world.func_72805_g(x, y, z));
                return aIndex == tier;
            }

            public int getIndex(int size) {
                if (size > 6) {
                    size = 6;
                }
                return size + 3;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregtechMetaTileEntity_PowerSubStationController.getBlockFromTier(this.getIndex(trigger.field_77994_a)), (int)GregtechMetaTileEntity_PowerSubStationController.getMetaFromTier(this.getIndex(trigger.field_77994_a)));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, GregtechMetaTileEntity_PowerSubStationController.getBlockFromTier(this.getIndex(trigger.field_77994_a)), GregtechMetaTileEntity_PowerSubStationController.getMetaFromTier(this.getIndex(trigger.field_77994_a)), 3);
            }

            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)GregtechMetaTileEntity_PowerSubStationController.getBlockFromTier(trigger.field_77994_a), (int)GregtechMetaTileEntity_PowerSubStationController.getMetaFromTier(trigger.field_77994_a));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                int meta;
                Block block = world.func_147439_a(x, y, z);
                int tier = GregtechMetaTileEntity_PowerSubStationController.getCellTier(block, meta = world.func_72805_g(x, y, z));
                if (tier >= 0) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)GregtechMetaTileEntity_PowerSubStationController.getBlockFromTier(this.getIndex(trigger.field_77994_a)), (int)GregtechMetaTileEntity_PowerSubStationController.getMetaFromTier(this.getIndex(trigger.field_77994_a)), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int layer = Math.min(stackSize.field_77994_a + 3, 18);
        this.log("Layer: " + layer);
        this.log("Building 0");
        this.buildPiece(this.mName + "bottom", stackSize, hintsOnly, 2, 0, 0);
        this.log("Built 0");
        for (int i = 1; i < layer - 1; ++i) {
            this.log("Building " + i);
            this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 2, i, 0);
            this.log("Built " + i);
        }
        this.log("Building " + (layer - 1));
        this.buildPiece(this.mName + "top", stackSize, hintsOnly, 2, layer - 1, 0);
        this.log("Built " + (layer - 1));
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int layer = Math.min(ChannelDataAccessor.getChannelData((ItemStack)stackSize, (String)"height") + 3, 18);
        int built = this.survivialBuildPiece(this.mName + "bottom", stackSize, 2, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        for (int i = 1; i < layer - 1; ++i) {
            built = this.survivialBuildPiece(this.mName + "mid", stackSize, 2, i, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        return this.survivialBuildPiece(this.mName + "top", stackSize, 2, layer - 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        block10: {
            this.mCasing = 0;
            this.mEnergyHatches.clear();
            this.mDynamoHatches.clear();
            this.mTecTechEnergyHatches.clear();
            this.mTecTechDynamoHatches.clear();
            this.mAllEnergyHatches.clear();
            this.mAllDynamoHatches.clear();
            for (int i = 0; i < 6; ++i) {
                this.cellCount[i] = 0;
            }
            this.log("Checking 0");
            if (!this.checkPiece(this.mName + "bottom", 2, 0, 0)) {
                this.log("Failed on Layer 0");
                return false;
            }
            this.log("Pass 0");
            int layer = 1;
            this.topState = TopState.MayBeTop;
            do {
                if (!this.checkPiece(this.mName + "layer", 2, layer, 0)) {
                    return false;
                }
                ++layer;
                if (this.topState == TopState.Top) break block10;
                this.topState = TopState.MayBeTop;
            } while (layer <= 18);
            return false;
        }
        int level = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.cellCount[i] == 0) continue;
            if (level == 0) {
                level = i + 4;
                continue;
            }
            return false;
        }
        int tier = GregtechMetaTileEntity_PowerSubStationController.getMaxHatchTier(level);
        long volSum = 0L;
        for (GT_MetaTileEntity_Hatch hatch : this.mAllDynamoHatches) {
            if (hatch.mTier > tier || hatch.mTier < 3) {
                return false;
            }
            volSum += 8L << hatch.mTier * 2;
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mAllEnergyHatches) {
            if (hatch.mTier > tier || hatch.mTier < 3) {
                return false;
            }
            volSum += 8L << hatch.mTier * 2;
        }
        this.mBatteryCapacity = GregtechMetaTileEntity_PowerSubStationController.getCapacityFromCellTier(level) * (long)this.cellCount[level - 4];
        this.mAverageEuUsage = this.mAllEnergyHatches.size() + this.mAllDynamoHatches.size() > 0 ? volSum / (long)(this.mAllEnergyHatches.size() + this.mAllDynamoHatches.size()) : 0L;
        this.fixAllMaintenanceIssue();
        return true;
    }

    public final boolean addPowerSubStationList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (Mods.TecTech.isModLoaded()) {
            if (this.isThisHatchMultiDynamo(aMetaTileEntity)) {
                return this.addToMachineList(aTileEntity, aBaseCasingIndex);
            }
            if (this.isThisHatchMultiEnergy(aMetaTileEntity)) {
                return this.addToMachineList(aTileEntity, aBaseCasingIndex);
            }
        }
        return false;
    }

    public static long getCapacityFromCellTier(int aOverallCellTier) {
        if (aOverallCellTier < 4) {
            return 0L;
        }
        aOverallCellTier -= 4;
        long capacity = 100000000L;
        while (aOverallCellTier > 0) {
            capacity *= 4L;
            --aOverallCellTier;
        }
        return capacity;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_PowerSubStationController(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74772_a("mAverageEuUsage", this.mAverageEuUsage);
        this.mAverageEuAdded.write(aNBT, "mAverageEuAdded");
        this.mAverageEuConsumed.write(aNBT, "mAverageEuConsumed");
        aNBT.func_74772_a("mTotalEnergyAdded", this.mTotalEnergyAdded);
        aNBT.func_74772_a("mTotalEnergyLost", this.mTotalEnergyLost);
        aNBT.func_74772_a("mTotalEnergyConsumed", this.mTotalEnergyConsumed);
        aNBT.func_74772_a("mTotalRunTime", this.mTotalRunTime);
        aNBT.func_74757_a("mIsOutputtingPower", this.mIsOutputtingPower);
        aNBT.func_74772_a("mBatteryCapacity", this.mBatteryCapacity);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mAverageEuUsage")) {
            this.mAverageEuUsage = aNBT.func_74763_f("mAverageEuUsage");
        }
        switch (aNBT.func_150299_b("mAverageEuAdded")) {
            case 7: {
                this.mAverageEuAdded.read(aNBT, "mAverageEuAdded");
                break;
            }
            case 4: {
                this.mAverageEuAdded.set(aNBT.func_74763_f("mAverageEuAdded"));
            }
        }
        switch (aNBT.func_150299_b("mAverageEuConsumed")) {
            case 7: {
                this.mAverageEuConsumed.read(aNBT, "mAverageEuConsumed");
                break;
            }
            case 4: {
                this.mAverageEuConsumed.set(aNBT.func_74763_f("mAverageEuConsumed"));
            }
        }
        this.mTotalEnergyAdded = aNBT.func_74763_f("mTotalEnergyAdded");
        this.mTotalEnergyLost = aNBT.func_74763_f("mTotalEnergyLost");
        this.mTotalEnergyConsumed = aNBT.func_74763_f("mTotalEnergyConsumed");
        this.mTotalRunTime = aNBT.func_74763_f("mTotalRunTime");
        this.mIsOutputtingPower = aNBT.func_74767_n("mIsOutputtingPower");
        this.mBatteryCapacity = aNBT.func_74763_f("mBatteryCapacity");
        super.loadNBTData(aNBT);
    }

    public boolean checkRecipe(ItemStack aStack) {
        this.mProgresstime = 0;
        this.mMaxProgresstime = 200;
        this.lEUt = 0L;
        this.mEfficiencyIncrease = 10000;
        this.fixAllMaintenanceIssue();
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    private long drawEnergyFromHatch(MetaTileEntity aHatch) {
        if (!GregtechMetaTileEntity_PowerSubStationController.isValidMetaTileEntity(aHatch)) {
            return 0L;
        }
        long stored = aHatch.getEUVar();
        long voltage = aHatch.maxEUInput() * aHatch.maxAmperesIn();
        if (voltage > stored) {
            return 0L;
        }
        if (this.getBaseMetaTileEntity().increaseStoredEnergyUnits(voltage, false)) {
            aHatch.setEUVar(stored - voltage);
            this.mTotalEnergyAdded += voltage;
            return voltage;
        }
        return 0L;
    }

    private long addEnergyToHatch(MetaTileEntity aHatch) {
        if (!GregtechMetaTileEntity_PowerSubStationController.isValidMetaTileEntity(aHatch)) {
            return 0L;
        }
        long voltage = aHatch.maxEUOutput() * aHatch.maxAmperesOut();
        if (aHatch.getEUVar() > aHatch.maxEUStore() - voltage) {
            return 0L;
        }
        if (this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(voltage, false)) {
            aHatch.getBaseMetaTileEntity().increaseStoredEnergyUnits(voltage, false);
            this.mTotalEnergyConsumed += voltage;
            return voltage;
        }
        return 0L;
    }

    private long computeEnergyTax() {
        float mTax = (float)this.mAverageEuUsage * 0.05f;
        return MathUtils.roundToClosestLong(mTax);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.fixAllMaintenanceIssue();
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.getEUVar() > this.mBatteryCapacity) {
            long energy = (long)((float)this.getEUVar() * 0.99f) - 1000L;
            this.setEUVar(energy);
        }
        long mDecrease = this.computeEnergyTax();
        this.mTotalEnergyLost += Math.min(mDecrease, this.getEUVar());
        this.setEUVar(Math.max(0L, this.getEUVar() - mDecrease));
        long aInputAverage = 0L;
        long aOutputAverage = 0L;
        for (GT_MetaTileEntity_Hatch THatch : this.mDischargeHatches) {
            aInputAverage += this.drawEnergyFromHatch((MetaTileEntity)THatch);
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.mAllEnergyHatches) {
            aInputAverage += this.drawEnergyFromHatch((MetaTileEntity)tHatch);
        }
        for (GT_MetaTileEntity_Hatch THatch : this.mChargeHatches) {
            aOutputAverage += this.addEnergyToHatch((MetaTileEntity)THatch);
        }
        for (GT_MetaTileEntity_Hatch tHatch : this.mAllDynamoHatches) {
            aOutputAverage += this.addEnergyToHatch((MetaTileEntity)tHatch);
        }
        this.mProgresstime = 0;
        this.mAverageEuAdded.sample(aInputAverage);
        this.mAverageEuConsumed.sample(aOutputAverage);
        return true;
    }

    public boolean drainEnergyInput(long aEU) {
        return true;
    }

    public boolean addEnergyOutput(long aEU) {
        return true;
    }

    public long maxEUStore() {
        return this.mBatteryCapacity;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public String[] getExtraInfoData() {
        String mode = this.mIsOutputtingPower ? EnumChatFormatting.GOLD + "Output" + EnumChatFormatting.RESET : EnumChatFormatting.BLUE + "Input" + EnumChatFormatting.RESET;
        String storedEnergyText = this.getEUVar() > this.mBatteryCapacity ? EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.getEUVar()) + EnumChatFormatting.RESET : EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)this.getEUVar()) + EnumChatFormatting.RESET;
        int errorCode = this.getBaseMetaTileEntity().getErrorDisplayID();
        boolean mMaint = errorCode != 0;
        return new String[]{"Ergon Energy - District Sub-Station", "Stored EU: " + storedEnergyText, "Capacity: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.maxEUStore()) + EnumChatFormatting.RESET, "Running Costs: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.computeEnergyTax()) + EnumChatFormatting.RESET + " EU/t", "Controller Mode: " + mode, "Requires Maintenance: " + (!mMaint ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + mMaint + EnumChatFormatting.RESET + " | Code: [" + (!mMaint ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + errorCode + EnumChatFormatting.RESET + "]", "----------------------", "Stats for Nerds", "Average Input: " + EnumChatFormatting.BLUE + GT_Utility.formatNumbers((long)this.getAverageEuAdded()) + EnumChatFormatting.RESET + " EU", "Average Output: " + EnumChatFormatting.GOLD + GT_Utility.formatNumbers((long)this.getAverageEuConsumed()) + EnumChatFormatting.RESET + " EU", "Total Input: " + EnumChatFormatting.BLUE + GT_Utility.formatNumbers((long)this.mTotalEnergyAdded) + EnumChatFormatting.RESET + " EU", "Total Output: " + EnumChatFormatting.GOLD + GT_Utility.formatNumbers((long)this.mTotalEnergyConsumed) + EnumChatFormatting.RESET + " EU", "Total Costs: " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.mTotalEnergyLost) + EnumChatFormatting.RESET + " EU"};
    }

    @Override
    public void explodeMultiblock() {
        super.explodeMultiblock();
    }

    public void doExplosion(long aExplosionPower) {
        super.doExplosion(aExplosionPower);
    }

    public long getMaxInputVoltage() {
        return 32768L;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isEnetInput() {
        return !this.mIsOutputtingPower;
    }

    public boolean isEnetOutput() {
        return this.mIsOutputtingPower;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getBackFacing() && !this.mIsOutputtingPower;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getBackFacing() && this.mIsOutputtingPower;
    }

    public long maxAmperesIn() {
        return 32L;
    }

    public long maxAmperesOut() {
        return 32L;
    }

    public long maxEUInput() {
        return 32768L;
    }

    public long maxEUOutput() {
        return 32768L;
    }

    public final long getAverageEuAdded() {
        return this.mAverageEuAdded.get();
    }

    public final long getAverageEuConsumed() {
        return this.mAverageEuConsumed.get();
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mIsOutputtingPower = Utils.invertBoolean(this.mIsOutputtingPower);
        if (this.mIsOutputtingPower) {
            PlayerUtils.messagePlayer(aPlayer, "Sub-Station is now outputting power from the controller.");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Sub-Station is now inputting power into the controller.");
        }
    }

    public boolean doesBindPlayerInventory() {
        return false;
    }

    public int getGUIWidth() {
        return 196;
    }

    public int getGUIHeight() {
        return 191;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(175, 166));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(149, 149))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setPos(154, 4))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setPos(154, 22))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)new PlayerMainInvWrapper(buildContext.getPlayer().field_71071_by), (int)9).endAtSlot(8).build().setPos(7, 166))).widget(TextWidget.dynamicString(() -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 ? (this.getBaseMetaTileEntity().isActive() ? "Running perfectly" : "Turn on with Mallet") : "").setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 8))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive(val.booleanValue())))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID(val.intValue())))).widget(new TextWidget("In").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(178, 10))).widget(new TextWidget("Out").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(176, 28))).widget(TextWidget.dynamicString(() -> "Avg In: " + GT_Utility.formatNumbers((long)this.getAverageEuAdded()) + " EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(TextWidget.dynamicString(() -> "Avg Out: " + GT_Utility.formatNumbers((long)this.getAverageEuConsumed()) + " EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30))).widget(TextWidget.dynamicString(() -> "Powerloss: " + GT_Utility.formatNumbers((long)this.computeEnergyTax()) + " EU per tick").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 40))).widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_ENERGY_FRAME).setPos(4, 155).setSize(149, 7))).widget(new ProgressBar().setProgress(this::getProgress).setTexture(GTPP_UITextures.PROGRESSBAR_PSS_ENERGY, 147).setDirection(ProgressBar.Direction.RIGHT).setPos(5, 156).setSize(147, 5))).widget(new TextWidget("Stored:").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 132))).widget(TextWidget.dynamicText(() -> {
            int colorScale = (int)((double)(this.getProgress() * 100.0f) * 2.55);
            return new Text(GT_Utility.formatNumbers((long)this.getBaseMetaTileEntity().getStoredEU()) + " EU").color(Utils.rgbtoHexValue(255 - colorScale, colorScale, 0));
        }).setPos(10, 142))).widget(TextWidget.dynamicString(() -> GT_Utility.formatNumbers((double)(this.getProgress() * 100.0f)) + "%").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(70, 155));
    }

    private float getProgress() {
        return (float)this.getBaseMetaTileEntity().getStoredEU() / (float)this.getBaseMetaTileEntity().getEUCapacity();
    }

    private static enum TopState {
        MayBeTop,
        Top,
        NotTop;

    }
}

