/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialDehydrator
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialDehydrator>
implements ISurvivalConstructable {
    private static int CASING_TEXTURE_ID;
    private static String mCasingName;
    private HeatingCoilLevel mHeatingCapacity;
    private boolean mDehydratorMode = false;
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialDehydrator> STRUCTURE_DEFINITION;

    public GregtechMetaTileEntity_IndustrialDehydrator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(3, 10);
    }

    public GregtechMetaTileEntity_IndustrialDehydrator(String aName) {
        super(aName);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(3, 10);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialDehydrator(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Factory Grade Vacuum Furnace").addInfo("Can toggle the operation temperature with a Screwdriver").addInfo("All Dehydrator recipes are Low Temp recipes").addInfo("Speed: +120% | EU Usage: 50% | Parallel: 4").addInfo("Each 900K over the min. Heat Capacity grants 5% speedup (multiplicatively)").addInfo("Each 1800K over the min. Heat Capacity allows for one upgraded overclock").addInfo("Upgraded overclocks reduce recipe time to 25% and increase EU/t to 400%").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 5, 3, true).addController("Bottom Center").addCasingInfoMin(mCasingName, 5, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialDehydrator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"HHH", "H-H", "HHH"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialDehydrator.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex(CASING_TEXTURE_ID).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings4Misc, (int)10))})).addElement('H', GT_StructureUtility.ofCoil(GregtechMetaTileEntity_IndustrialDehydrator::setCoilLevel, GregtechMetaTileEntity_IndustrialDehydrator::getCoilLevel)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 4, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        return this.checkPiece(this.mName, 1, 4, 0) && this.mCasing >= 5 && this.getCoilLevel() != HeatingCoilLevel.None && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mDehydratorMode ? GTPP_Recipe.GTPP_Recipe_Map.sMultiblockChemicalDehydratorRecipes : GTPP_Recipe.GTPP_Recipe_Map.sVacuumFurnaceRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialDehydrator;
    }

    @Override
    public String getMachineType() {
        return "Vacuum Furnace / Dehydrator";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 50;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), 120);
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        GT_Recipe tRecipe;
        this.lEUt = 0L;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.mLastRecipe = tRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        if (tRecipe == null || this.mHeatingCapacity.getHeat() < (long)tRecipe.mSpecialValue) {
            return false;
        }
        GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe(tRecipe).setItemInputs(aItemInputs).setFluidInputs(aFluidInputs).setAvailableEUt(tEnergy).setMaxParallel(aMaxParallelRecipes).enableConsumption().enableOutputCalculation().setEUtModifier((float)aEUPercent / 100.0f).setController((GT_MetaTileEntity_MultiBlockBase)this);
        if (this.batchMode) {
            helper.enableBatchMode(128);
        }
        helper.build();
        if (helper.getCurrentParallel() == 0) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setEUt(tEnergy).setDuration(tRecipe.mDuration).setEUtDiscount((float)aEUPercent / 100.0f).setSpeedBoost(100.0f / (100.0f + (float)aSpeedBonusPercent)).setParallel((int)Math.floor((float)helper.getCurrentParallel() / helper.getDurationMultiplier())).enableHeatOC().enableHeatDiscount().setRecipeHeat(tRecipe.mSpecialValue).setMultiHeat((int)this.getCoilLevel().getHeat()).calculate();
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = (int)Math.ceil((float)calculator.getDuration() * helper.getDurationMultiplier());
        this.mOutputItems = helper.getItemOutputs();
        this.mOutputFluids = helper.getFluidOutputs();
        this.updateSlots();
        this.startProcess();
        return true;
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mDehydratorMode = Utils.invertBoolean(this.mDehydratorMode);
        String aMode = this.mDehydratorMode ? "Dehydrator" : "Vacuum Furnace";
        PlayerUtils.messagePlayer(aPlayer, "Mode: " + aMode);
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mDehydratorMode", this.mDehydratorMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mDehydratorMode = aNBT.func_74767_n("mDehydratorMode");
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.mHeatingCapacity;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.mHeatingCapacity = aCoilLevel;
    }

    static {
        mCasingName = "Vacuum Casing";
        STRUCTURE_DEFINITION = null;
    }
}

