/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import com.google.common.collect.MapMaker;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.core.chunkloading.GTPP_ChunkManager;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaTileEntityChunkLoader
extends GT_MetaTileEntity_BasicMachine {
    private Set<ChunkCoordIntPair> mLoadedChunks = new HashSet<ChunkCoordIntPair>();
    private static final Map<UUID, ForgeChunkManager.Ticket> tickets = new MapMaker().makeMap();
    private boolean refreshTicket;
    private int updateCycle = 0;
    private static final int updateCycleLength = 20;
    private UUID uuid;
    private int prevX;
    private int prevY;
    private int prevZ;
    private boolean hasTicket;

    public GregtechMetaTileEntityChunkLoader(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 4, "Loads " + GregtechMetaTileEntityChunkLoader.getMaxChunksToLoadForTier(aTier) + " chunks when powered", 0, 0, "Recycler.png", "", new ITexture[0]);
    }

    public GregtechMetaTileEntityChunkLoader(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 4, aDescription, aTextures, 0, 0, aGUIName, aNEIName);
    }

    public static int getMaxChunksToLoadForTier(int aTier) {
        if (aTier < 4) {
            return Math.min(9, ForgeChunkManager.getMaxChunkDepthFor((String)Mods.GTPlusPlus.ID));
        }
        if (aTier < 6) {
            return Math.min(49, ForgeChunkManager.getMaxChunkDepthFor((String)Mods.GTPlusPlus.ID));
        }
        if (aTier < 8) {
            return Math.min(225, ForgeChunkManager.getMaxChunkDepthFor((String)Mods.GTPlusPlus.ID));
        }
        return 0;
    }

    public static int getChunkRadiusForTier(int aTier) {
        if (aTier < 4) {
            return Math.min(1, (int)Math.floor(Math.sqrt(ForgeChunkManager.getMaxChunkDepthFor((String)Mods.GTPlusPlus.ID))));
        }
        if (aTier < 6) {
            return Math.min(3, (int)Math.floor(Math.sqrt(ForgeChunkManager.getMaxChunkDepthFor((String)Mods.GTPlusPlus.ID))));
        }
        if (aTier < 8) {
            return Math.min(7, (int)Math.floor(Math.sqrt(ForgeChunkManager.getMaxChunkDepthFor((String)Mods.GTPlusPlus.ID))));
        }
        return 0;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    public String[] getDescription() {
        return new String[]{"Loads " + GregtechMetaTileEntityChunkLoader.getMaxChunksToLoadForTier(this.mTier) + " chunks when powered", "Consumes 2A", "Behaves Identically to a Railcraft World Anchor", CORE.GT_Tooltip.get()};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntityChunkLoader(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public String[] getInfoData() {
        return super.getInfoData();
    }

    public boolean isGivingInformation() {
        return true;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aBaseMetaTileEntity.getXCoord() != this.prevX || aBaseMetaTileEntity.getYCoord() != this.prevY || aBaseMetaTileEntity.getZCoord() != this.prevZ) {
                this.releaseTicket();
                this.prevX = aBaseMetaTileEntity.getXCoord();
                this.prevY = aBaseMetaTileEntity.getYCoord();
                this.prevZ = aBaseMetaTileEntity.getZCoord();
            }
            if (this.hasActiveTicket() && (this.getTicket().world != aBaseMetaTileEntity.getWorld() || this.refreshTicket || !aBaseMetaTileEntity.isAllowedToWork())) {
                this.releaseTicket();
            }
            if (++this.updateCycle % 20 == 0) {
                this.updateCycle = 0;
                if (this.canChunkload()) {
                    this.setEUVar(this.getEUVar() - this.getEnergyConsumption());
                }
            }
            if (!this.hasActiveTicket()) {
                this.requestTicket();
            }
        }
    }

    public long maxAmperesIn() {
        return 4L;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 2L;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 256L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public void onRemoval() {
        super.onRemoval();
        this.releaseTicket();
    }

    public long getEnergyConsumption() {
        return GT_Values.VP[this.mTier] * 2L * 20L;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.prevX = aNBT.func_74762_e("prevX");
        this.prevY = aNBT.func_74762_e("prevY");
        this.prevZ = aNBT.func_74762_e("prevZ");
        NBTTagCompound uuidNBT = aNBT.func_74775_l("uuid");
        this.uuid = new UUID(uuidNBT.func_74763_f("most"), uuidNBT.func_74763_f("least"));
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("prevX", this.prevX);
        aNBT.func_74768_a("prevY", this.prevY);
        aNBT.func_74768_a("prevZ", this.prevZ);
        if (this.uuid != null) {
            NBTTagCompound uuidNBT = new NBTTagCompound();
            uuidNBT.func_74772_a("most", this.uuid.getMostSignificantBits());
            uuidNBT.func_74772_a("least", this.uuid.getLeastSignificantBits());
            aNBT.func_74782_a("uuid", (NBTBase)uuidNBT);
        }
    }

    public boolean canChunkload() {
        return this.getBaseMetaTileEntity().isAllowedToWork() && this.getEUVar() >= this.getEnergyConsumption();
    }

    public boolean addChunkToLoadedList(ChunkCoordIntPair aActiveChunk) {
        return this.mLoadedChunks.add(aActiveChunk);
    }

    public boolean removeChunkFromLoadedList(ChunkCoordIntPair aActiveChunk) {
        return this.mLoadedChunks.remove(aActiveChunk);
    }

    public Set<ChunkCoordIntPair> getManagedChunks() {
        return this.mLoadedChunks;
    }

    public int getChunkloaderTier() {
        return this.mTier;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.setTicket(ticket);
        this.setupChunks();
        if (this.mLoadedChunks != null) {
            for (ChunkCoordIntPair chunk : this.mLoadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void setupChunks() {
        this.mLoadedChunks = !this.hasTicket ? null : GTPP_ChunkManager.getChunksAround(this.getBaseMetaTileEntity().getXCoord() >> 4, this.getBaseMetaTileEntity().getZCoord() >> 4, GregtechMetaTileEntityChunkLoader.getChunkRadiusForTier(this.mTier));
    }

    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestTicket((Object)GTplusplus.instance, (World)this.getBaseMetaTileEntity().getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    public boolean hasActiveTicket() {
        return this.getTicket() != null;
    }

    protected void releaseTicket() {
        this.refreshTicket = false;
        this.setTicket(null);
    }

    protected void requestTicket() {
        ForgeChunkManager.Ticket chunkTicket;
        if (this.canChunkload() && (chunkTicket = this.getTicketFromForge()) != null) {
            this.setTicketData(chunkTicket);
            this.forceChunkLoading(chunkTicket);
        }
    }

    protected void setTicketData(ForgeChunkManager.Ticket chunkTicket) {
        if (chunkTicket != null) {
            chunkTicket.getModData().func_74768_a("xCoord", this.getBaseMetaTileEntity().getXCoord());
            chunkTicket.getModData().func_74768_a("yCoord", (int)this.getBaseMetaTileEntity().getYCoord());
            chunkTicket.getModData().func_74768_a("zCoord", this.getBaseMetaTileEntity().getZCoord());
            chunkTicket.setChunkListDepth(GregtechMetaTileEntityChunkLoader.getMaxChunksToLoadForTier(this.mTier));
        }
    }

    public void setTicket(ForgeChunkManager.Ticket t) {
        ForgeChunkManager.Ticket ticket = this.getTicket();
        if (ticket != t && ticket != null) {
            if (ticket.world == this.getBaseMetaTileEntity().getWorld()) {
                for (ChunkCoordIntPair chunk : ticket.getChunkList()) {
                    if (!ForgeChunkManager.getPersistentChunksFor((World)this.getBaseMetaTileEntity().getWorld()).keys().contains((Object)chunk)) continue;
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                }
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
            tickets.remove(this.getUUID());
        }
        boolean bl = this.hasTicket = t != null;
        if (this.hasTicket) {
            tickets.put(this.getUUID(), t);
        }
    }

    public ForgeChunkManager.Ticket getTicket() {
        return tickets.get(this.getUUID());
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }
}

