/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.FormattedTooltipString;
import gtPlusPlus.core.handler.AchievementHandler;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.LangUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.BaseCustomTileEntity;
import gtPlusPlus.xmod.gregtech.api.metatileentity.custom.power.BaseCustomPower_MTE;
import gtPlusPlus.xmod.gregtech.common.covers.CoverManager;
import gtPlusPlus.xmod.gregtech.common.helpers.MachineUpdateHandler;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Meta_GT_Proxy {
    public static List<Runnable> GT_BlockIconload = new ArrayList<Runnable>();
    public static List<Runnable> GT_ItemIconload = new ArrayList<Runnable>();
    public static AutoMap<Integer> GT_ValidHeatingCoilMetas = new AutoMap();
    private static Class<BaseCustomTileEntity> sBaseMetaTileEntityClass;
    private static Class<BaseCustomPower_MTE> sBaseMetaTileEntityClass2;
    public static AchievementHandler mAssemblyAchievements;
    public static final Map<String, FormattedTooltipString> mCustomGregtechMetaTooltips;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sBlockIcons;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sItemIcons;
    public static Block sBlockMachines;
    static GT_Proxy[] mProxies;

    public static void preInit() {
        Meta_GT_Proxy.fixIC2FluidNames();
        GT_Log.out.println("GT++ Mod: Register TileEntities.");
        BaseCustomTileEntity tBaseMetaTileEntity = Meta_GT_Proxy.constructBaseMetaTileEntity();
        BaseCustomPower_MTE tBaseMetaTileEntity2 = Meta_GT_Proxy.constructBaseMetaTileEntityCustomPower();
        GT_Log.out.println("GT++ Mod: Testing BaseMetaTileEntity.");
        if (tBaseMetaTileEntity == null || tBaseMetaTileEntity2 == null) {
            GT_Log.err.println("GT++ Mod: Fatal Error ocurred while initializing custom BaseMetaTileEntities, crashing Minecraft.");
            CORE.crash("GT++ Mod: Fatal Error ocurred while initializing custom BaseMetaTileEntities, crashing Minecraft.");
        }
        GT_Log.out.println("GT++ Mod: Registering custom BaseMetaTileEntities.");
        GameRegistry.registerTileEntity(tBaseMetaTileEntity.getClass(), (String)"BaseMetaTileEntity_GTPP");
        GameRegistry.registerTileEntity(tBaseMetaTileEntity2.getClass(), (String)"BaseMetaTileEntity_GTPP2");
        CoverManager.generateCustomCovers();
    }

    public static void init() {
        Meta_GT_Proxy.setValidHeatingCoilMetas();
        PollutionUtils.setPollutionFluids();
        Meta_GT_Proxy.fixIC2FluidNames();
        Utils.registerEvent(new MachineUpdateHandler());
    }

    public static void postInit() {
        mAssemblyAchievements = new AchievementHandler();
        Meta_GT_Proxy.fixIC2FluidNames();
        TAE.finalizeTAE();
    }

    public static void fixIC2FluidNames() {
        try {
            Fluid f;
            String aNewHeatedWaterName = "Heated Water";
            Logger.INFO("Renaming [IC2 Hotspring Water] --> [" + aNewHeatedWaterName + "].");
            LanguageRegistry.instance().addStringLocalization("fluidHotWater", "Heated Water");
            LanguageRegistry.instance().addStringLocalization("fluidHotWater", aNewHeatedWaterName);
            LanguageRegistry.instance().addStringLocalization("ic2.fluidHotWater", aNewHeatedWaterName);
            GT_LanguageManager.addStringLocalization((String)"fluidHotWater", (String)aNewHeatedWaterName);
            GT_LanguageManager.addStringLocalization((String)"ic2.fluidHotWater", (String)aNewHeatedWaterName);
            Block b = BlocksItems.getFluidBlock((InternalName)InternalName.fluidHotWater);
            if (b != null) {
                LanguageRegistry.addName((Object)ItemUtils.getSimpleStack(b), (String)aNewHeatedWaterName);
                LanguageRegistry.instance().addStringLocalization(b.func_149739_a(), aNewHeatedWaterName);
                GT_LanguageManager.addStringLocalization((String)b.func_149739_a(), (String)aNewHeatedWaterName);
            }
            if ((f = BlocksItems.getFluid((InternalName)InternalName.fluidHotWater)) != null) {
                LanguageRegistry.instance().addStringLocalization(f.getUnlocalizedName(), aNewHeatedWaterName);
                GT_LanguageManager.addStringLocalization((String)f.getUnlocalizedName(), (String)aNewHeatedWaterName);
                int aDam = FluidRegistry.getFluidID((Fluid)f);
                ItemStack s = ItemList.Display_Fluid.getWithDamage(1L, (long)aDam, new Object[0]);
                if (s != null) {
                    LanguageRegistry.addName((Object)s, (String)aNewHeatedWaterName);
                }
            }
            String[] aLangs = new String[]{"de_DE", "en_US", "en_GB", "en_IC", "es_AR", "es_ES", "es_MX", "es_UY", "es_VE", "fr_CA", "fr_FR", "it_IT", "ko_KR", "pt_BR", "pt_PT", "ru_RU", "sv_SE", "tr_TR", "zh_CN", "zh_TW"};
            String[] aLangValues = new String[]{"Erhitztes Wasser", "Heated Water", "Heated Water", "Heated Water", "Agua caliente", "Agua caliente", "Agua caliente", "Agua caliente", "Agua caliente", "Eau chauff\u00e9e", "Eau chauff\u00e9e", "Acqua riscaldata", "\uc628\uc218", "\u00c1gua aquecida", "\u00c1gua aquecida", "\u0412\u043e\u0434\u0430 \u0441 \u043f\u043e\u0434\u043e\u0433\u0440\u0435\u0432\u043e\u043c", "Uppv\u00e4rmt vatten", "Is\u0131t\u0131lm\u0131\u015f Su", "\u70ed\u6c34", "\u70ed\u6c34"};
            for (int i = 0; i < aLangs.length; ++i) {
                Logger.REFLECTION("Trying to inject new lang data for " + aLangs[i] + ", using value: " + aLangValues[i]);
                LangUtils.rewriteEntryForLanguageRegistry(aLangs[i], "fluidHotWater", aLangValues[i]);
                LangUtils.rewriteEntryForLanguageRegistry(aLangs[i], "ic2.fluidHotWater", aLangValues[i]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean generatePlasmaRecipesForAdvVacFreezer() {
        AutoMap<GT_Recipe> aFreezerMapRebaked = new AutoMap<GT_Recipe>();
        AutoMap<GT_Recipe> aRemovedRecipes = new AutoMap<GT_Recipe>();
        for (GT_Recipe y : GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT.mRecipeList) {
            if (y.mFluidInputs.length <= 0) continue;
            for (FluidStack r : y.mFluidInputs) {
                if (!r.getUnlocalizedName().toLowerCase().contains("plasma")) continue;
                aRemovedRecipes.put(y);
            }
            aFreezerMapRebaked.put(y);
        }
        AutoMap<GTPP_Recipe> aNewRecipes = new AutoMap<GTPP_Recipe>();
        int aAtomicMass = 0;
        int aAtomicTier = 0;
        FluidStack NULL_PLASMA = Materials._NULL.getPlasma(1L);
        for (String s : ELEMENT.NAMES) {
            aAtomicTier = ++aAtomicMass / 30 + 1;
            FluidStack aMoltenFluid = null;
            FluidStack aPlasma = null;
            Materials aGregMaterial = MaterialUtils.getMaterial(s);
            if (aGregMaterial != null) {
                aMoltenFluid = aGregMaterial.getMolten(1L);
                if (aMoltenFluid == null && (aMoltenFluid = aGregMaterial.getFluid(1L)) == null && (aMoltenFluid = aGregMaterial.getGas(1L)) == null) {
                    aMoltenFluid = aGregMaterial.getSolid(1L);
                }
                aPlasma = aGregMaterial.getPlasma(100L);
            }
            if (aMoltenFluid == null || aPlasma == null) {
                if (aMoltenFluid == null) {
                    aMoltenFluid = FluidUtils.getWildcardFluidStack(s, 1);
                }
                if (aPlasma == null) {
                    aPlasma = FluidUtils.getFluidStack("plasma." + s.toLowerCase(), 1);
                }
            }
            if (aMoltenFluid == null || aPlasma == null || aPlasma.isFluidEqual(NULL_PLASMA)) {
                Logger.INFO("Could not generate Advanced Vacuum Freezer recipe. Cooling " + s + " plasma. Molten Form Exists? " + (aMoltenFluid != null) + " | Plasma Exists? " + (aPlasma != null));
                continue;
            }
            int aTotalTickTime = 20 + aAtomicMass;
            GTPP_Recipe aTempRecipe = new GTPP_Recipe(true, new ItemStack[0], new ItemStack[0], null, new int[]{10000}, new FluidStack[]{aPlasma, FluidUtils.getFluidStack("cryotheum", aTotalTickTime)}, new FluidStack[]{aMoltenFluid}, aTotalTickTime, (int)GT_Values.V[4 + aAtomicTier], aAtomicMass);
            if (aTempRecipe == null) continue;
            aNewRecipes.put(aTempRecipe);
        }
        for (GTPP_Recipe w : aNewRecipes) {
            aFreezerMapRebaked.put(w);
        }
        if (aFreezerMapRebaked.size() > 0) {
            int aOriginalCount = GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT.mRecipeList.size();
            GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT.mRecipeList.clear();
            for (GT_Recipe w : aFreezerMapRebaked) {
                GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT.mRecipeList.add(w);
            }
            return GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT.mRecipeList.size() >= aOriginalCount;
        }
        return false;
    }

    public static TileEntity constructCustomGregtechMetaTileEntityByMeta(int aMeta) {
        if (aMeta == 12) {
            return Meta_GT_Proxy.constructBaseMetaTileEntityCustomPower();
        }
        return Meta_GT_Proxy.constructBaseMetaTileEntity();
    }

    public static BaseCustomTileEntity constructBaseMetaTileEntity() {
        if (sBaseMetaTileEntityClass == null) {
            try {
                sBaseMetaTileEntityClass = BaseCustomTileEntity.class;
                return (BaseCustomTileEntity)BaseCustomTileEntity.class.newInstance();
            }
            catch (Throwable arg1) {
                try {
                    Constructor<?> g = BaseCustomTileEntity.class.getConstructors()[0];
                    g.setAccessible(true);
                    return (BaseCustomTileEntity)g.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException g) {
                    // empty catch block
                }
            }
        }
        try {
            return sBaseMetaTileEntityClass.newInstance();
        }
        catch (Throwable arg0) {
            arg0.printStackTrace(GT_Log.err);
            try {
                Constructor<?> g = BaseCustomTileEntity.class.getConstructors()[0];
                g.setAccessible(true);
                return (BaseCustomTileEntity)g.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                GT_Log.err.println("GT++ Mod: Fatal Error ocurred while initializing TileEntities, crashing Minecraft.");
                e.printStackTrace(GT_Log.err);
                CORE.crash("GT++ Mod: Fatal Error ocurred while initializing custom BaseMetaTileEntities, crashing Minecraft.");
                throw new RuntimeException(e);
            }
        }
    }

    public static BaseCustomPower_MTE constructBaseMetaTileEntityCustomPower() {
        if (sBaseMetaTileEntityClass2 == null) {
            try {
                sBaseMetaTileEntityClass2 = BaseCustomPower_MTE.class;
                return (BaseCustomPower_MTE)BaseCustomPower_MTE.class.newInstance();
            }
            catch (Throwable arg1) {
                try {
                    Constructor<?> g = BaseCustomPower_MTE.class.getConstructors()[0];
                    g.setAccessible(true);
                    return (BaseCustomPower_MTE)g.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException g) {
                    // empty catch block
                }
            }
        }
        try {
            return sBaseMetaTileEntityClass2.newInstance();
        }
        catch (Throwable arg0) {
            arg0.printStackTrace(GT_Log.err);
            try {
                Constructor<?> g = BaseCustomPower_MTE.class.getConstructors()[0];
                g.setAccessible(true);
                return (BaseCustomPower_MTE)g.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                GT_Log.err.println("GT++ Mod: Fatal Error ocurred while initializing TileEntities, crashing Minecraft.");
                e.printStackTrace(GT_Log.err);
                CORE.crash("GT++ Mod: Fatal Error ocurred while initializing custom BaseMetaTileEntities, crashing Minecraft.");
                throw new RuntimeException(e);
            }
        }
    }

    public static void setValidHeatingCoilMetas() {
        int i;
        for (i = 0; i <= 6; ++i) {
            GT_ValidHeatingCoilMetas.put(i);
        }
        for (i = 7; i <= 8; ++i) {
            GT_ValidHeatingCoilMetas.put(i);
        }
    }

    public static void setCustomGregtechTooltip(String aNbtTagName, FormattedTooltipString aData) {
        mCustomGregtechMetaTooltips.put(aNbtTagName, aData);
    }

    public static void conStructGtTileBlockTooltip(ItemStack aStack, EntityPlayer aPlayer, List<Object> aList, boolean par4) {
        try {
            NBTTagCompound aNBT;
            int tDamage = aStack.func_77960_j();
            if (tDamage <= 0 || tDamage >= GregTech_API.METATILEENTITIES.length) {
                return;
            }
            if (GregTech_API.METATILEENTITIES[tDamage] != null) {
                IGregTechTileEntity tTileEntity = GregTech_API.METATILEENTITIES[tDamage].getBaseMetaTileEntity();
                if (tTileEntity.getDescription() != null) {
                    int i = 0;
                    for (String tDescription : tTileEntity.getDescription()) {
                        if (GT_Utility.isStringValid((Object)tDescription)) {
                            if (tDescription.contains("%%%")) {
                                String[] tString = tDescription.split("%%%");
                                if (tString.length < 2) continue;
                                StringBuffer tBuffer = new StringBuffer();
                                Object[] tRep = new String[tString.length / 2];
                                for (int j = 0; j < tString.length; ++j) {
                                    if (j % 2 == 0) {
                                        tBuffer.append(tString[j]);
                                        continue;
                                    }
                                    tBuffer.append(" %s");
                                    tRep[j / 2] = tString[j];
                                }
                                aList.add(String.format(GT_LanguageManager.addStringLocalization((String)("TileEntity_DESCRIPTION_" + tDamage + "_Index_" + i++), (String)tBuffer.toString(), (!GregTech_API.sPostloadFinished ? 1 : 0) != 0), tRep));
                                continue;
                            }
                            String tTranslated = GT_LanguageManager.addStringLocalization((String)("TileEntity_DESCRIPTION_" + tDamage + "_Index_" + i++), (String)tDescription, (!GregTech_API.sPostloadFinished ? 1 : 0) != 0);
                            aList.add(tTranslated.equals("") ? tDescription : tTranslated);
                            continue;
                        }
                        ++i;
                    }
                }
                if (tTileEntity.getEUCapacity() > 0L) {
                    String a1;
                    long tVoltage = tTileEntity.getInputVoltage();
                    byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
                    if (tDamage < 30500 && tDamage >= 30400) {
                        int aOffset = tDamage - 30400;
                        if (aOffset <= 10) {
                            tTier = (byte)(tTier - 2);
                            aList.add(EnumChatFormatting.BOLD + "16 Fuse Slots" + EnumChatFormatting.GRAY);
                            aList.add("Per each fuse, you may insert " + EnumChatFormatting.YELLOW + GT_Values.V[tTier] + EnumChatFormatting.GRAY + " EU/t");
                            aList.add("However this " + EnumChatFormatting.ITALIC + EnumChatFormatting.RED + "MUST" + EnumChatFormatting.GRAY + " be in a single Amp");
                            aList.add("This machine can accept upto a single amp of " + GT_Values.VN[Math.min(tTier + 2, 12)] + " as a result");
                            aList.add(GT_LanguageManager.addStringLocalization((String)"TileEntity_Breaker_Loss", (String)("Breaker Loss: " + EnumChatFormatting.RED + "" + GT_Values.V[Math.max(tTier - 1, 0)] / 10L + EnumChatFormatting.GRAY + " EU/t"), (!GregTech_API.sPostloadFinished ? 1 : 0) != 0) + EnumChatFormatting.GRAY);
                        }
                        aList.add(GT_LanguageManager.addStringLocalization((String)"TileEntity_Special_Power_1", (String)(EnumChatFormatting.RED + "Special Power Handling, please read manual"), (!GregTech_API.sPostloadFinished ? 1 : 0) != 0) + EnumChatFormatting.GRAY);
                    }
                    if (tTileEntity.getInputVoltage() > 0L) {
                        String inA = "0";
                        inA = tTileEntity.getInputAmperage() >= 1L ? " at " + EnumChatFormatting.YELLOW + tTileEntity.getInputAmperage() + EnumChatFormatting.GRAY + " Amps" : " at " + EnumChatFormatting.WHITE + tTileEntity.getInputAmperage() + EnumChatFormatting.GRAY + " Amps";
                        a1 = "Voltage IN: " + EnumChatFormatting.GREEN + tTileEntity.getInputVoltage() + " (" + GT_Values.VN[GT_Utility.getTier((long)tTileEntity.getInputVoltage())] + ")" + EnumChatFormatting.GRAY + inA;
                        aList.add(a1);
                    }
                    if (tTileEntity.getOutputVoltage() > 0L) {
                        String outA = "0";
                        outA = tTileEntity.getOutputAmperage() >= 1L ? " at " + EnumChatFormatting.YELLOW + tTileEntity.getOutputAmperage() + EnumChatFormatting.GRAY + " Amps" : " at " + EnumChatFormatting.WHITE + tTileEntity.getOutputAmperage() + EnumChatFormatting.GRAY + " Amps";
                        a1 = "Voltage OUT: " + EnumChatFormatting.GREEN + tTileEntity.getOutputVoltage() + " (" + GT_Values.VN[GT_Utility.getTier((long)tTileEntity.getOutputVoltage())] + ")" + EnumChatFormatting.GRAY + outA;
                        aList.add(a1);
                    }
                    if (tTileEntity.getOutputVoltage() > 0L) {
                        aList.add(GT_LanguageManager.addStringLocalization((String)"TileEntity_Lossess_EU", (String)("Transmission Loss: " + EnumChatFormatting.DARK_BLUE + "" + (tDamage < 30500 && tDamage >= 30400 ? 0 : 1)), (!GregTech_API.sPostloadFinished ? 1 : 0) != 0) + EnumChatFormatting.GRAY);
                    }
                    if (tTileEntity.getEUCapacity() > 0L) {
                        aList.add(GT_LanguageManager.addStringLocalization((String)"TileEntity_EUp_STORE2", (String)"Internal Capacity: ", (!GregTech_API.sPostloadFinished ? 1 : 0) != 0) + EnumChatFormatting.BLUE + tTileEntity.getEUCapacity() + EnumChatFormatting.GRAY + " EU");
                    }
                }
            }
            if ((aNBT = aStack.func_77978_p()) != null) {
                int tFluidAmount;
                FluidStack afluid;
                if (aNBT.func_74767_n("mMuffler")) {
                    aList.add(GT_LanguageManager.addStringLocalization((String)"GT_TileEntity_MUFFLER", (String)"has Muffler Upgrade", (!GregTech_API.sPostloadFinished ? 1 : 0) != 0));
                }
                if (aNBT.func_74767_n("mSteamConverter")) {
                    aList.add(GT_LanguageManager.addStringLocalization((String)"GT_TileEntity_STEAMCONVERTER", (String)"has Steam Upgrade", (!GregTech_API.sPostloadFinished ? 1 : 0) != 0));
                }
                byte tAmount = 0;
                tAmount = aNBT.func_74771_c("mSteamTanks");
                if (tAmount > 0) {
                    aList.add(tAmount + " " + GT_LanguageManager.addStringLocalization((String)"GT_TileEntity_STEAMTANKS", (String)"Steam Tank Upgrades", (!GregTech_API.sPostloadFinished ? 1 : 0) != 0));
                }
                if ((afluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"))) != null && (tFluidAmount = afluid.amount) > 0) {
                    aList.add(GT_LanguageManager.addStringLocalization((String)"GT_TileEntity_FLUIDTANK", (String)("Tank Fluid: " + tFluidAmount + "L " + afluid.getLocalizedName() + ""), (!GregTech_API.sPostloadFinished ? 1 : 0) != 0));
                }
            }
            for (String s : mCustomGregtechMetaTooltips.keySet()) {
                if (!aNBT.func_74764_b(s)) continue;
                String aTip = mCustomGregtechMetaTooltips.get(s).getTooltip(aNBT.func_74779_i(s));
                aList.add(aTip);
            }
            if (tDamage >= 30400 && tDamage < 30500) {
                aList.add(EnumChatFormatting.UNDERLINE + "Special GT++ Machine");
            }
            if (tDamage >= 750 && tDamage < 1000 || tDamage >= 30000 && tDamage < 31000) {
                aList.add(CORE.GT_Tooltip);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
    }

    static {
        mCustomGregtechMetaTooltips = new LinkedHashMap<String, FormattedTooltipString>();
        mProxies = new GT_Proxy[2];
    }
}

