/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.items;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import gtPlusPlus.xmod.forestry.bees.items.FR_StringUtil;

public enum MB_FrameType implements IBeeModifier
{
    COCOA("Chocolate", 240, 1.0f, 1.0f, 0.5f, 1.5f, 1.0f),
    CAGE("Restraint", 240, 0.5f, 1.0f, 0.75f, 0.75f, 1.0f),
    SOUL("Soul", 80, 1.0f, 1.5f, 0.75f, 0.25f, 1.0f),
    CLAY("Healing", 240, 1.0f, 0.5f, 1.5f, 0.75f, 1.0f),
    NOVA("Nova", 240, 1.0f, 100.0f, 1.0E-4f, 1.0f, 1.0f),
    ACCELERATED("Accelerated", 175, 1.0f, 1.2f, 0.9f, 1.8f, 1.0f),
    VOID("Void", 20, 1.0f, 1.0f, 1.0E-4f, 10.0f, 1.0f),
    MUTAGENIC("Mutagenic", 3, 1.0f, 5.0f, 1.0E-4f, 10.0f, 1.0f),
    BUSY("Busy", 2000, 1.0f, 0.0f, 3.0f, 4.0f, 1.0f),
    USELESS("Useless", 100, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f),
    DECAYING("Decaying", 240, 1.0f, 1.0f, 1.0f, 1.0f, 10.0f),
    SLOWING("Slowing", 175, 1.0f, 0.5f, 2.0f, 0.5f, 1.0f),
    STABILIZING("Stabilizing", 60, 1.0f, 0.1f, 1.0f, 0.1f, 0.5f),
    ARBORISTS("Arborists", 240, 3.0f, 0.0f, 3.0f, 0.0f, 1.0f);

    private final String frameName;
    public final int maxDamage;
    private final float territoryMod;
    private final float mutationMod;
    private final float lifespanMod;
    private final float productionMod;
    private final float floweringMod;
    private final float geneticDecayMod;
    private final boolean isSealed;
    private final boolean isLit;
    private final boolean isSunlit;
    private final boolean isHellish;

    private MB_FrameType(String name, int damage, float territory, float mutation, float lifespan, float production, float geneticDecay) {
        this(name, damage, territory, mutation, lifespan, production, 1.0f, geneticDecay, false, false, false, false);
    }

    private MB_FrameType(String name, int damage, float territory, float mutation, float lifespan, float production, float flowering, float geneticDecay, boolean sealed, boolean lit, boolean sunlit, boolean hellish) {
        this.frameName = name;
        this.maxDamage = damage;
        this.territoryMod = territory;
        this.mutationMod = mutation;
        this.lifespanMod = lifespan;
        this.productionMod = production;
        this.floweringMod = flowering;
        this.geneticDecayMod = geneticDecay;
        this.isSealed = sealed;
        this.isLit = lit;
        this.isSunlit = sunlit;
        this.isHellish = hellish;
    }

    public String getName() {
        return this.frameName;
    }

    public String getLocalizedName() {
        return FR_StringUtil.getLocalizedString("frame." + this.frameName);
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.territoryMod;
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.mutationMod;
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.lifespanMod;
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.productionMod;
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.floweringMod;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.geneticDecayMod;
    }

    public boolean isSealed() {
        return this.isSealed;
    }

    public boolean isSelfLighted() {
        return this.isLit;
    }

    public boolean isSunlightSimulated() {
        return this.isSunlit;
    }

    public boolean isHellish() {
        return this.isHellish;
    }
}

