/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;

public class MovingAverageLong {
    private final long[] storage;
    private int ptr;

    public MovingAverageLong(int sampleSize) {
        this.storage = new long[sampleSize];
    }

    public void set(long average) {
        Arrays.fill(this.storage, average);
    }

    public void sample(long data) {
        this.storage[this.ptr] = data;
        this.ptr = (this.ptr + 1) % this.storage.length;
    }

    public long get() {
        BigInteger result = BigInteger.ZERO;
        for (long l : this.storage) {
            result = result.add(BigInteger.valueOf(l));
        }
        return result.divide(BigInteger.valueOf(this.storage.length)).longValue();
    }

    public void write(NBTTagCompound tagCompound, String key) {
        ByteBuffer buf = ByteBuffer.allocate(this.storage.length * 8).order(ByteOrder.nativeOrder());
        buf.asLongBuffer().put(this.storage);
        tagCompound.func_74773_a(key, buf.array());
    }

    public boolean read(NBTTagCompound tagCompound, String key) {
        ByteBuffer buf = ByteBuffer.wrap(tagCompound.func_74770_j(key));
        if (buf.remaining() != this.storage.length * 8) {
            return false;
        }
        buf.asLongBuffer().get(this.storage);
        return true;
    }
}

