/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.fluids;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.GregtechException;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.fluids.BlockFluidBase;
import gtPlusPlus.core.fluids.FactoryFluid;
import gtPlusPlus.core.fluids.FluidPackage;
import gtPlusPlus.core.fluids.ItemGenericFluidBucket;
import gtPlusPlus.core.item.base.itemblock.FluidItemBlock;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidFactory {
    public static final Map<String, Fluid> mNameToFluidMap = new LinkedHashMap<String, Fluid>();
    public static final Map<String, ItemStack> mNameToBucketMap = new LinkedHashMap<String, ItemStack>();
    public static final Map<String, Block> mNameToBlockMap = new LinkedHashMap<String, Block>();
    public static final Map<String, Integer> mNameToMetaMap = new LinkedHashMap<String, Integer>();
    public static final Map<Fluid, String> mFluidToNameMap = new LinkedHashMap<Fluid, String>();
    public static final Map<Fluid, ItemStack> mFluidToBucketMap = new LinkedHashMap<Fluid, ItemStack>();
    public static final Map<Fluid, Block> mFluidToBlockMap = new LinkedHashMap<Fluid, Block>();
    public static final Map<Fluid, Integer> mFluidToMetaMap = new LinkedHashMap<Fluid, Integer>();
    public static final Map<ItemStack, Fluid> mBucketToFluidMap = new LinkedHashMap<ItemStack, Fluid>();
    public static final Map<ItemStack, String> mBucketToNameMap = new LinkedHashMap<ItemStack, String>();
    public static final Map<ItemStack, Block> mBucketToBlockMap = new LinkedHashMap<ItemStack, Block>();
    public static final Map<ItemStack, Integer> mBucketToMetaMap = new LinkedHashMap<ItemStack, Integer>();
    public static final Map<Block, String> mBlockToNameMap = new LinkedHashMap<Block, String>();
    public static final Map<Block, Fluid> mBlockToFluidMap = new LinkedHashMap<Block, Fluid>();
    public static final Map<Block, ItemStack> mBlockToBucketMap = new LinkedHashMap<Block, ItemStack>();
    public static final Map<Block, Integer> mBlockToMetaMap = new LinkedHashMap<Block, Integer>();
    public static final Map<Integer, String> mMetaToNameMap = new LinkedHashMap<Integer, String>();
    public static final Map<Integer, Fluid> mMetaToFluidMap = new LinkedHashMap<Integer, Fluid>();
    public static final Map<Integer, ItemStack> mMetaToBucketMap = new LinkedHashMap<Integer, ItemStack>();
    public static final Map<Integer, Block> mMetaToBlockMap = new LinkedHashMap<Integer, Block>();
    public static final Map<Integer, Integer> mMetaToColourMap = new LinkedHashMap<Integer, Integer>();
    public static Item mGenericBucket;
    private static FluidPackage mErrorFluid;
    private static AutoMap<FluidPackage> mGeneratedFluids;

    public static void preInit() {
    }

    public static void init() {
        mGenericBucket = new ItemGenericFluidBucket(Blocks.field_150350_a);
        GameRegistry.registerItem((Item)mGenericBucket, (String)"gtpp.bucket.generic");
        for (FluidPackage y : mGeneratedFluids) {
            if (!y.valid()) continue;
            GameRegistry.registerBlock((Block)y.mBlock, FluidItemBlock.class, (String)("gtpp_" + y.mName));
            FluidContainerRegistry.registerFluidContainer((Fluid)y.get(), (ItemStack)y.mBucket, (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        Utils.registerEvent(BucketHandler.INSTANCE);
    }

    public static void postInit() {
    }

    public static FluidPackage generate(int aID, String aUnlocalName, short[] aRGB) {
        return FluidFactory.generate(aID, aUnlocalName, Short.MIN_VALUE, Short.MIN_VALUE, Short.MIN_VALUE, Short.MIN_VALUE, aRGB);
    }

    public static FluidPackage generate(int aID, String aUnlocalName, int luminosity, int density, int temp, int viscosity, short[] aRGB) {
        FluidPackage aFluidToGenerate = null;
        if (GTplusplus.CURRENT_LOAD_PHASE != GTplusplus.INIT_PHASE.PRE_INIT) {
            try {
                throw new GregtechException("Cannot generate Fluid Packages outside of Pre-Init!");
            }
            catch (GregtechException e) {
                e.printStackTrace();
                CORE.crash("Cannot generate Fluid Packages outside of Pre-Init!");
            }
        }
        Fluid aGenFluid = FluidFactory.fluid(aUnlocalName, luminosity, density, temp, viscosity, aRGB);
        Block aGenBlock = FluidFactory.block(aGenFluid, aRGB);
        ItemStack aGenBucket = FluidFactory.bucket(aID);
        aFluidToGenerate = new FluidPackage(aID, aUnlocalName, aGenFluid, aGenBucket, aGenBlock);
        if (aFluidToGenerate == null || !aFluidToGenerate.valid()) {
            if (mErrorFluid == null) {
                mErrorFluid = new FluidPackage(0, "", FluidUtils.getWater(1).getFluid(), ItemUtils.getSimpleStack(Items.field_151131_as), Blocks.field_150355_j);
            }
            return mErrorFluid;
        }
        FluidRegistry.registerFluid((Fluid)aFluidToGenerate.get());
        mGeneratedFluids.put(aFluidToGenerate);
        return aFluidToGenerate;
    }

    private static Fluid fluid(String aUnlocalName, int luminosity, int density, int temp, int viscosity, short[] aRGB) {
        return new FactoryFluid(aUnlocalName, luminosity, density, temp, viscosity, aRGB);
    }

    private static ItemStack bucket(int aID) {
        return ItemGenericFluidBucket.registerFluidForBucket(aID);
    }

    private static Block block(Fluid aFluidForBlock, short[] aRGB) {
        if (aFluidForBlock != null) {
            FluidRegistry.registerFluid((Fluid)aFluidForBlock);
            return new BlockFluidBase(aFluidForBlock, aRGB);
        }
        return Blocks.field_150346_d;
    }

    static {
        mGeneratedFluids = new AutoMap();
    }

    public static class BucketHandler {
        public static BucketHandler INSTANCE = new BucketHandler();

        private BucketHandler() {
        }

        @SubscribeEvent
        public void onBucketFill(FillBucketEvent event) {
            ItemStack result = this.fillCustomBucket(event.world, event.target);
            if (result == null) {
                return;
            }
            event.result = result;
            event.setResult(Event.Result.ALLOW);
        }

        private ItemStack fillCustomBucket(World world, MovingObjectPosition pos) {
            Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            ItemStack bucket = mBlockToBucketMap.get(block);
            if (bucket != null && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0) {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                return ItemUtils.getSimpleStack(bucket, 1);
            }
            return null;
        }
    }
}

