/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftRobotics;
import buildcraft.api.core.IZone;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.items.IMapLocation;
import buildcraft.api.items.INamedItem;
import buildcraft.core.ItemMapLocation;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.robotics.ZonePlan;
import buildcraft.robotics.gui.ContainerZonePlan;
import buildcraft.robotics.map.MapWorld;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class TileZonePlan
extends TileBuildCraft
implements IInventory {
    public static final int RESOLUTION = 2048;
    public static final int CRAFT_TIME = 120;
    private static final int PREVIEW_BLOCKS_PER_PIXEL = 10;
    private static int RESOLUTION_CHUNKS = 128;
    public int chunkStartX;
    public int chunkStartZ;
    public short progress = 0;
    public String mapName = "";
    private final byte[] previewColors = new byte[80];
    private final SimpleInventory inv = new SimpleInventory(3, "inv", 64);
    private final SafeTimeTracker previewRecalcTimer = new SafeTimeTracker(100L);
    private boolean previewColorsPushed = false;
    private ZonePlan[] selectedAreas = new ZonePlan[16];
    private int currentSelectedArea = 0;

    public byte[] getPreviewTexture(boolean force) {
        if (!this.previewColorsPushed || force) {
            this.previewColorsPushed = true;
            return this.previewColors;
        }
        return null;
    }

    @Override
    public void initialize() {
        super.initialize();
        int cx = this.field_145851_c >> 4;
        int cz = this.field_145849_e >> 4;
        this.chunkStartX = cx - RESOLUTION_CHUNKS / 2;
        this.chunkStartZ = cz - RESOLUTION_CHUNKS / 2;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.previewRecalcTimer.markTimeIfDelay(this.field_145850_b)) {
            this.recalculatePreview();
        }
        if (this.inv.func_70301_a(0) != null && this.inv.func_70301_a(1) == null && this.inv.func_70301_a(0).func_77973_b() instanceof ItemMapLocation) {
            if (this.progress < 120) {
                this.progress = (short)(this.progress + 1);
                if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                    this.sendNetworkUpdate();
                }
            } else {
                ItemStack stack = this.inv.func_70298_a(0, 1);
                if (this.selectedAreas[this.currentSelectedArea] != null) {
                    ItemMapLocation.setZone(stack, this.selectedAreas[this.currentSelectedArea]);
                    ((INamedItem)stack.func_77973_b()).setName(stack, this.mapName);
                }
                this.inv.func_70299_a(1, stack);
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.sendNetworkUpdate();
        }
    }

    private void recalculatePreview() {
        byte[] newPreviewColors = new byte[80];
        MapWorld mw = BuildCraftRobotics.manager.getWorld(this.field_145850_b);
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 10; ++x) {
                int tx = x * 10 - 50 + 5;
                int ty = y * 10 - 40 + 5;
                newPreviewColors[y * 10 + x] = (byte)mw.getColor(this.field_145851_c - this.field_145851_c % 10 + tx, this.field_145849_e - this.field_145849_e % 10 + ty);
            }
        }
        if (!Arrays.equals(this.previewColors, newPreviewColors)) {
            System.arraycopy(newPreviewColors, 0, this.previewColors, 0, 80);
            this.sendNetworkUpdate();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("name", this.mapName);
        NBTTagCompound invNBT = new NBTTagCompound();
        this.inv.writeToNBT(invNBT);
        nbt.func_74782_a("inv", (NBTBase)invNBT);
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (this.selectedAreas[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            this.selectedAreas[i].writeToNBT(subNBT);
            nbt.func_74782_a("selectedArea[" + i + "]", (NBTBase)subNBT);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mapName = nbt.func_74779_i("name");
        if (this.mapName == null) {
            this.mapName = "";
        }
        this.inv.readFromNBT(nbt.func_74775_l("inv"));
        for (int i = 0; i < this.selectedAreas.length; ++i) {
            if (!nbt.func_74764_b("selectedArea[" + i + "]")) continue;
            this.selectedAreas[i] = new ZonePlan();
            this.selectedAreas[i].readFromNBT(nbt.func_74775_l("selectedArea[" + i + "]"));
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeShort((int)this.progress);
        NetworkUtils.writeUTF(stream, this.mapName);
        stream.writeBytes(this.previewColors, 0, 80);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.progress = stream.readShort();
        this.mapName = NetworkUtils.readUTF(stream);
        stream.readBytes(this.previewColors, 0, 80);
        this.previewColorsPushed = false;
    }

    private void importMap(ItemStack stack) {
        IZone zone;
        if (stack != null && stack.func_77973_b() instanceof IMapLocation && (zone = ((IMapLocation)stack.func_77973_b()).getZone(stack)) != null && zone instanceof ZonePlan) {
            this.selectedAreas[this.currentSelectedArea] = (ZonePlan)zone;
            for (EntityPlayer e : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                if (e.field_71070_bA == null || !(e.field_71070_bA instanceof ContainerZonePlan) || ((ContainerZonePlan)e.field_71070_bA).getTile() != this) continue;
                PacketCommand p = new PacketCommand(e.field_71070_bA, "areaLoaded", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        ((ZonePlan)zone).writeData(data);
                    }
                });
                BuildCraftCore.instance.sendToPlayer(e, p);
            }
        }
    }

    public ZonePlan selectArea(int index) {
        if (this.selectedAreas[index] == null) {
            this.selectedAreas[index] = new ZonePlan();
        }
        this.currentSelectedArea = index;
        return this.selectedAreas[index];
    }

    public void setArea(int index, ZonePlan area) {
        this.selectedAreas[index] = area;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inv.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inv.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inv.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inv.func_70299_a(slotId, itemstack);
        if (!this.field_145850_b.field_72995_K && slotId == 2) {
            this.importMap(itemstack);
        }
    }

    public String func_145825_b() {
        return this.inv.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inv.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inv.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.inv.func_70295_k_();
    }

    public void func_70305_f() {
        this.inv.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inv.func_94041_b(i, itemstack);
    }
}

