/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.core.AELog;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.util.BlockPos;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketCraftRequest
implements IMessage {
    private long amount;
    private boolean heldShift;

    public CPacketCraftRequest() {
    }

    public CPacketCraftRequest(int craftAmt, boolean shift) {
        this.amount = craftAmt;
        this.heldShift = shift;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.amount);
        buf.writeBoolean(this.heldShift);
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readLong();
        this.heldShift = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<CPacketCraftRequest, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketCraftRequest message, MessageContext ctx) {
            if (ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerCraftAmount) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ContainerCraftAmount cca = (ContainerCraftAmount)ctx.getServerHandler().field_147369_b.field_71070_bA;
                Object target = cca.getTarget();
                if (target instanceof IGridHost) {
                    IGridHost gh = (IGridHost)target;
                    IGridNode gn = gh.getGridNode(ForgeDirection.UNKNOWN);
                    if (gn == null) {
                        return null;
                    }
                    IGrid g = gn.getGrid();
                    if (g == null || cca.getItemToCraft() == null) {
                        return null;
                    }
                    cca.getItemToCraft().setStackSize(message.amount);
                    Future futureJob = null;
                    try {
                        ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                        futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                        ContainerOpenContext context = cca.getOpenContext();
                        if (context != null) {
                            TileEntity te = context.getTile();
                            if (te != null) {
                                InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(te), Objects.requireNonNull(context.getSide()), GuiType.FLUID_CRAFTING_CONFIRM);
                            } else if (target instanceof IWirelessTerminal) {
                                InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(((IWirelessTerminal)target).getInventorySlot(), 0, 0), Objects.requireNonNull(context.getSide()), GuiType.FLUID_CRAFTING_CONFIRM_ITEM);
                            }
                            if (player.field_71070_bA instanceof ContainerCraftConfirm) {
                                ContainerCraftConfirm ccc = (ContainerCraftConfirm)player.field_71070_bA;
                                ccc.setAutoStart(message.heldShift);
                                ccc.setJob(futureJob);
                                cca.func_75142_b();
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (futureJob != null) {
                            futureJob.cancel(true);
                        }
                        AELog.debug((Throwable)e);
                    }
                }
            }
            return null;
        }
    }
}

