/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.RecipeHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RecipePartitioner {
    private static final int MIN_SIZE_TO_PARTITION = 2048;
    private static final int PARTITION_SIZE = 128;
    private static final int INSERTIONS_PER_RECIPE = 3;
    private final ImmutableList<RecipeHandler.Recipe> recipeList;
    private final boolean isPartitioned;
    private Map<BloomFilter<Component>, List<RecipeHandler.Recipe>> partitions;

    RecipePartitioner(List<RecipeHandler.Recipe> recipeList) {
        this.recipeList = ImmutableList.copyOf(recipeList);
        this.isPartitioned = recipeList.size() >= 2048;
    }

    void initialize() {
        if (!this.isPartitioned) {
            return;
        }
        this.partitions = new HashMap<BloomFilter<Component>, List<RecipeHandler.Recipe>>();
        for (List partition : Lists.partition(this.recipeList, (int)128)) {
            BloomFilter bloomFilter = BloomFilter.create((Funnel)ComponentFunnel.INSTANCE, (int)(3 * partition.size()));
            partition.stream().flatMap(recipe -> RecipeHandler.filterCircuits((Set<Component>)recipe.inputs().keySet()).stream()).forEach(arg_0 -> ((BloomFilter)bloomFilter).put(arg_0));
            this.partitions.put((BloomFilter<Component>)bloomFilter, partition);
        }
    }

    int size() {
        return this.recipeList.size();
    }

    ImmutableList<RecipeHandler.Recipe> allRecipes() {
        return this.recipeList;
    }

    Iterable<RecipeHandler.Recipe> lookup(Set<Component> components) {
        if (!this.isPartitioned) {
            return this.recipeList;
        }
        ArrayList<List<RecipeHandler.Recipe>> matchingPartitions = new ArrayList<List<RecipeHandler.Recipe>>();
        for (Map.Entry<BloomFilter<Component>, List<RecipeHandler.Recipe>> entry : this.partitions.entrySet()) {
            if (!RecipeHandler.filterCircuits(components).stream().allMatch(arg_0 -> entry.getKey().mightContain(arg_0))) continue;
            matchingPartitions.add(entry.getValue());
        }
        return Iterables.concat(matchingPartitions);
    }

    private static enum ComponentFunnel implements Funnel<Component>
    {
        INSTANCE;


        public void funnel(Component from, PrimitiveSink into) {
            switch (from.type()) {
                case ITEM: {
                    ItemComponent itemComponent = (ItemComponent)from;
                    into.putInt(itemComponent.itemId()).putInt(itemComponent.damage());
                    break;
                }
                case FLUID: {
                    FluidComponent fluidComponent = (FluidComponent)from;
                    into.putInt(fluidComponent.fluidId());
                }
            }
        }
    }
}

