/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.mekanism;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import mekanism.api.energy.IStrictEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardEnergySensorLocation;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class MekRFCard
extends ItemCardEnergySensorLocation {
    public static final UUID CARD_TYPE = new UUID(0L, 3L);

    public MekRFCard() {
        this.func_77655_b("MekRFenergyCard");
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        return this.update(panel.func_145831_w(), card, range);
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity tile = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (tile instanceof IStrictEnergyStorage) {
            IStrictEnergyStorage storage = (IStrictEnergyStorage)tile;
            card.setDouble("energyL", storage.getEnergy());
            card.setDouble("maxStorageL", storage.getMaxEnergy());
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public UUID getCardType() {
        return CARD_TYPE;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        PanelString line;
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        double energy = card.getDouble("energyL");
        double storage = card.getDouble("maxStorageL");
        if ((displaySettings & 1) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergy", energy, showLabels);
            result.add(line);
        }
        if ((displaySettings & 2) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergyFree", storage - energy, showLabels);
            result.add(line);
        }
        if ((displaySettings & 4) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergyStorage", storage, showLabels);
            result.add(line);
        }
        if ((displaySettings & 8) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelEnergyPercentage", storage == 0.0 ? 100.0 : energy * 100.0 / storage, showLabels);
            result.add(line);
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(4);
        result.add(new PanelSetting(LangHelper.translate("1"), 1, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("2"), 4, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("3"), 2, CARD_TYPE));
        result.add(new PanelSetting(LangHelper.translate("4"), 8, CARD_TYPE));
        return result;
    }
}

