/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_Plasma
extends GT_MetaTileEntity_LargeTurbine {
    public GT_MetaTileEntity_LargeTurbine_Plasma(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_Plasma(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][colorIndex + 1];
        iTextureArray[1] = aFacing == side ? (aActive ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5).build() : (this.hasTurbine() ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW5).build() : TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5).build())) : Textures.BlockIcons.casingTexturePages[0][60];
        return iTextureArray;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Plasma Turbine").addInfo("Controller block for the Large Plasma Generator").addInfo("Needs a Turbine, place inside controller").addInfo("Use your Fusion Reactor to produce the Plasma").addSeparator().beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoRange("Tungstensteel Turbine Casing", 8, 31, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addInputHatch("Plasma Fluid, Side centered", 2).addOutputHatch("Molten Fluid, optional, Side centered", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = GT_Recipe.GT_Recipe_Map.sPlasmaFuels.findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_Plasma(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 12;
    }

    @Override
    public int getCasingTextureIndex() {
        return 60;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff, int overflowMultiplier, float[] flowMultipliers) {
        if (aFluids.size() >= 1) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            actualOptimalFlow = GT_Utility.safeInt((long)Math.ceil((double)(aOptFlow *= 800) * (double)flowMultipliers[2] / (double)fuelValue));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GT_Utility.safeInt((long)((float)actualOptimalFlow * (1.5f * (float)overflowMultiplier + 1.0f)));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            String fn = FluidRegistry.getFluidName((FluidStack)firstFuelType);
            String[] nameSegments = fn.split("\\.", 2);
            if (nameSegments.length == 2) {
                String outputName = nameSegments[1];
                FluidStack output = FluidRegistry.getFluidStack((String)outputName, (int)totalFlow);
                if (output == null) {
                    output = FluidRegistry.getFluidStack((String)("molten." + outputName), (int)totalFlow);
                }
                if (output != null) {
                    this.addOutput(output);
                }
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GT_Utility.safeInt((long)((double)fuelValue / 20.0 * (double)totalFlow));
            if (totalFlow != actualOptimalFlow) {
                float efficiency = this.getOverflowEfficiency(totalFlow, actualOptimalFlow, overflowMultiplier);
                tEU = (int)((float)tEU * efficiency);
            }
            if ((long)(tEU = GT_Utility.safeInt((long)((double)aBaseEff / 10000.0 * (double)tEU))) > this.getMaximumOutput()) {
                tEU = GT_Utility.safeInt(this.getMaximumOutput());
            }
            return tEU;
        }
        return 0;
    }

    @Override
    float getOverflowEfficiency(int totalFlow, int actualOptimalFlow, int overflowMultiplier) {
        float efficiency = 0.0f;
        efficiency = totalFlow > actualOptimalFlow ? 1.0f - (float)Math.abs(totalFlow - actualOptimalFlow) / ((float)actualOptimalFlow * (float)(overflowMultiplier * 3 + 1)) : 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
        return efficiency;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!((this.counter & 7) != 0 || aStack != null && aStack.func_77973_b() instanceof GT_MetaGenerated_Tool && aStack.func_77960_j() >= 170 && aStack.func_77960_j() <= 179)) {
            this.stopMachine();
            return false;
        }
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        if (!tFluids.isEmpty()) {
            if (this.baseEff == 0 || this.optFlow == 0 || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                this.counter = 0;
                this.baseEff = GT_Utility.safeInt((long)((5.0f + ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolCombatDamage(aStack)) * 1000.0f));
                this.optFlow = GT_Utility.safeInt((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolStats(aStack).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f));
                this.overflowMultiplier = this.getOverflowMultiplier(aStack);
                this.flowMultipliers[0] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mSteamMultiplier;
                this.flowMultipliers[1] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mGasMultiplier;
                this.flowMultipliers[2] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mPlasmaMultiplier;
            } else {
                ++this.counter;
            }
        }
        if (this.optFlow <= 0 || this.baseEff <= 0) {
            this.stopMachine();
            return false;
        }
        int newPower = this.fluidIntoPower(tFluids, this.optFlow, this.baseEff, this.overflowMultiplier, this.flowMultipliers);
        int difference = newPower - this.mEUt;
        int maxChangeAllowed = Math.max(200, GT_Utility.safeInt((long)Math.abs(difference) / 5L));
        if (Math.abs(difference) > maxChangeAllowed) {
            int change = maxChangeAllowed * (difference > 0 ? 1 : -1);
            this.mEUt += change;
        } else {
            this.mEUt = newPower;
        }
        if (this.mEUt <= 0) {
            this.mEUt = 0;
            this.mEfficiency = 0;
            return false;
        }
        this.mMaxProgresstime = 20;
        this.mEfficiencyIncrease = 200;
        return true;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_LargeTurbine_Plasma.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        String tRunning = this.mMaxProgresstime > 0 ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.running.true") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.running.false") + EnumChatFormatting.RESET;
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET;
        int tDura = 0;
        if (this.mInventory[1] != null && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            tDura = GT_Utility.safeInt((long)(100.0f / (float)GT_MetaGenerated_Tool.getToolMaxDamage(this.mInventory[1]) * (float)GT_MetaGenerated_Tool.getToolDamage(this.mInventory[1]) + 1.0f));
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_LargeTurbine_Plasma.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        String[] ret = new String[]{tRunning + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.mEUt * (long)this.mEfficiency / 10000L) + EnumChatFormatting.RESET + " EU/t", tMaintainance, StatCollector.func_74838_a((String)"GT5U.turbine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(GT_Utility.safeInt((long)this.realOptFlow)) + EnumChatFormatting.RESET + " L/s" + EnumChatFormatting.YELLOW + " (" + (this.looseFit ? StatCollector.func_74838_a((String)"GT5U.turbine.loose") : StatCollector.func_74838_a((String)"GT5U.turbine.tight")) + ")", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + GT_Utility.formatNumbers(this.storedFluid) + EnumChatFormatting.RESET + "L", StatCollector.func_74838_a((String)"GT5U.turbine.dmg") + ": " + EnumChatFormatting.RED + tDura + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
        if (!this.getClass().getName().contains("Steam")) {
            ret[4] = StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.safeInt((long)this.realOptFlow) + EnumChatFormatting.RESET + " L/s";
        }
        return ret;
    }
}

