/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTech_API;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.items.behaviors.Behaviour_None;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Behaviour_Cover_Tool
extends Behaviour_None {
    public static final IItemBehaviour<GT_MetaBase_Item> INSTANCE = new Behaviour_Cover_Tool();
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.cover_copy_paste", "Can copy/paste cover data.");
    private ISerializableObject mStoredData = GregTech_API.sNoBehavior.createDataObject();
    private int mCoverType;

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        boolean isCopyMode = aPlayer.func_70093_af();
        this.initDataFromNBT(tNBT);
        if (aPlayer instanceof EntityPlayerMP && aItem.canUse(aStack, 100.0)) {
            if (isCopyMode) {
                ArrayList tList = new ArrayList();
                this.doCopy(tTileEntity, aWorld, aX, aY, aZ, side, hitX, hitY, hitZ, tList);
                aItem.discharge(aStack, 100.0, Integer.MAX_VALUE, true, false, false);
                this.writeListToNBT(tList, tNBT, aPlayer);
                this.saveDataToNBT(tNBT);
            } else {
                this.doPaste(tTileEntity, side, hitX, hitY, hitZ, aPlayer);
                aItem.discharge(aStack, 25.0, Integer.MAX_VALUE, true, false, false);
            }
        }
        GT_Utility.doSoundAtClient(SoundResource.IC2_TOOLS_OD_SCANNER, 1, 1.0f, (double)aX, (double)aY, (double)aZ);
        return aPlayer instanceof EntityPlayerMP;
    }

    private void initDataFromNBT(NBTTagCompound aNBT) {
        if (aNBT != null) {
            this.mCoverType = aNBT.func_74762_e("mCoverType");
            GT_CoverBehaviorBase<?> tBehavior = GregTech_API.getCoverBehaviorNew(this.mCoverType);
            NBTBase tData = aNBT.func_74781_a("mCoverData");
            this.mStoredData = tData != null ? tBehavior.createDataObject(tData) : GregTech_API.sNoBehavior.createDataObject();
        }
    }

    private void saveDataToNBT(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mCoverType", this.mCoverType);
        if (this.mStoredData == null) {
            this.mStoredData = GregTech_API.sNoBehavior.createDataObject();
        }
        aNBT.func_74782_a("mCoverData", this.mStoredData.saveDataToNBT());
    }

    private void writeListToNBT(List aList, NBTTagCompound aNBT, EntityPlayer aPlayer) {
        if (aList != null && aNBT != null) {
            int tSize = aList.size();
            aNBT.func_74768_a("dataLinesCount", tSize);
            for (int i = 0; i < tSize; ++i) {
                aNBT.func_74778_a("dataLines" + i, (String)aList.get(i));
                GT_Utility.sendChatToPlayer(aPlayer, (String)aList.get(i));
            }
        }
    }

    private void doCopy(TileEntity aTileEntity, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ, List aList) {
        aList.add("----- X: " + EnumChatFormatting.AQUA + GT_Utility.formatNumbers(aX) + EnumChatFormatting.RESET + " Y: " + EnumChatFormatting.AQUA + GT_Utility.formatNumbers(aY) + EnumChatFormatting.RESET + " Z: " + EnumChatFormatting.AQUA + GT_Utility.formatNumbers(aZ) + EnumChatFormatting.RESET + " D: " + EnumChatFormatting.AQUA + aWorld.field_73011_w.field_76574_g + EnumChatFormatting.RESET + " -----");
        if (aTileEntity instanceof ICoverable) {
            ForgeDirection tSide;
            ICoverable tCoverable = (ICoverable)aTileEntity;
            ForgeDirection forgeDirection = tCoverable.getCoverItemAtSide(side) != null ? side : (tSide = tCoverable.getCoverItemAtSide(GT_Utility.determineWrenchingSide(side, hitX, hitY, hitZ)) != null ? GT_Utility.determineWrenchingSide(side, hitX, hitY, hitZ) : ForgeDirection.UNKNOWN);
            if (tSide != ForgeDirection.UNKNOWN) {
                this.mStoredData = tCoverable.getComplexCoverDataAtSide(tSide);
                this.mCoverType = tCoverable.getCoverIDAtSide(tSide);
                aList.add("Block Side: " + EnumChatFormatting.AQUA + tSide.name() + EnumChatFormatting.RESET);
                aList.add("Cover Type: " + EnumChatFormatting.GREEN + tCoverable.getCoverItemAtSide(tSide).func_82833_r() + EnumChatFormatting.RESET);
            } else {
                this.mStoredData = GregTech_API.sNoBehavior.createDataObject();
                this.mCoverType = 0;
                aList.add("No Cover Found");
            }
        } else {
            this.mStoredData = GregTech_API.sNoBehavior.createDataObject();
            this.mCoverType = 0;
            aList.add("No Cover Found");
        }
    }

    private void doPaste(TileEntity aTileEntity, ForgeDirection side, float hitX, float hitY, float hitZ, EntityPlayer aPlayer) {
        if (aTileEntity instanceof ICoverable) {
            ForgeDirection tSide;
            ICoverable tCoverable = (ICoverable)aTileEntity;
            if (this.mCoverType == 0 || this.mStoredData == null) {
                GT_Utility.sendChatToPlayer(aPlayer, "Please Copy a Valid Cover First.");
                return;
            }
            ForgeDirection forgeDirection = tCoverable.getCoverItemAtSide(side) != null ? side : (tSide = tCoverable.getCoverItemAtSide(GT_Utility.determineWrenchingSide(side, hitX, hitY, hitZ)) != null ? GT_Utility.determineWrenchingSide(side, hitX, hitY, hitZ) : ForgeDirection.UNKNOWN);
            if (tSide != ForgeDirection.UNKNOWN) {
                int tCoverID = tCoverable.getCoverIDAtSide(tSide);
                if (tCoverID == this.mCoverType) {
                    tCoverable.setCoverDataAtSide(tSide, this.mStoredData);
                    GT_Utility.sendChatToPlayer(aPlayer, "Cover Data Pasted.");
                } else {
                    GT_Utility.sendChatToPlayer(aPlayer, "Not Matched Cover.");
                }
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, "No Cover Found.");
            }
        }
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        try {
            NBTTagCompound tNBT = aStack.func_77978_p();
            int tSize = tNBT.func_74762_e("dataLinesCount");
            if (tSize < 1) {
                throw new Exception();
            }
            aList.add(EnumChatFormatting.BLUE + "Stored Cover Data:");
            for (int i = 0; i < tSize; ++i) {
                aList.add(EnumChatFormatting.RESET + tNBT.func_74779_i("dataLines" + i));
            }
        }
        catch (Exception e) {
            aList.add(this.mTooltip);
        }
        return aList;
    }
}

