/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.MathExpression;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.IDataFollowerWidget;
import gregtech.api.util.ISerializableObject;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;

public class CoverDataFollower_TextFieldWidget<T extends ISerializableObject>
extends TextFieldWidget
implements IDataFollowerWidget<T, String> {
    private Function<T, String> dataToStateGetter;

    public CoverDataFollower_TextFieldWidget() {
        this.setGetter(() -> "");
        this.setSynced(false, false);
        this.setTextColor(Color.WHITE.dark(1));
        this.setTextAlignment(Alignment.CenterLeft);
        this.setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)});
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        if (this.focusOnGuiOpen) {
            this.shouldGetFocus();
        }
    }

    public CoverDataFollower_TextFieldWidget<T> setDataToStateGetter(Function<T, String> dataToStateGetter) {
        this.dataToStateGetter = dataToStateGetter;
        return this;
    }

    public CoverDataFollower_TextFieldWidget<T> setStateSetter(Consumer<String> setter) {
        super.setSetter(setter);
        return this;
    }

    @Override
    public void updateState(T data) {
        this.setText(this.dataToStateGetter.apply(data));
    }

    public CoverDataFollower_TextFieldWidget<T> setOnScrollNumbers(int baseStep, int ctrlStep, int shiftStep) {
        this.setOnScrollNumbers((val, direction) -> {
            int step = (GuiScreen.func_146272_n() ? shiftStep : (GuiScreen.func_146271_m() ? ctrlStep : baseStep)) * direction;
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Integer.MAX_VALUE;
            }
            return val;
        });
        return this;
    }

    public CoverDataFollower_TextFieldWidget<T> setOnScrollNumbers() {
        return this.setOnScrollNumbers(1, 50, 1000);
    }

    public CoverDataFollower_TextFieldWidget<T> setOnScrollText(int baseStep, int ctrlStep, int shiftStep) {
        this.setOnScroll((text, direction) -> {
            int val = (int)MathExpression.parseMathExpression((String)text, (double)-1.0);
            int step = (GuiScreen.func_146272_n() ? shiftStep : (GuiScreen.func_146271_m() ? ctrlStep : baseStep)) * direction;
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Integer.MAX_VALUE;
            }
            return this.getDecimalFormatter().format(val);
        });
        return this;
    }

    public CoverDataFollower_TextFieldWidget<T> setOnScrollText() {
        return this.setOnScrollText(1, 5, 50);
    }

    public CoverDataFollower_TextFieldWidget<T> setOnScrollNumbersLong(long baseStep, long ctrlStep, long shiftStep) {
        this.setOnScrollNumbersLong((val, direction) -> {
            long step = (GuiScreen.func_146272_n() ? shiftStep : (GuiScreen.func_146271_m() ? ctrlStep : baseStep)) * (long)direction.intValue();
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Long.MAX_VALUE;
            }
            return val;
        });
        return this;
    }
}

