/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen_Ore;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgen_Stone
extends GT_Worldgen_Ore {
    static final double[] sizeConversion = new double[]{1.0, 1.0, 1.333333, 1.333333, 2.0, 2.0, 2.0, 2.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0};
    public Hashtable<Long, StoneSeeds> validStoneSeeds = new Hashtable(1024);

    public GT_Worldgen_Stone(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aDimensionType, int aAmount, int aSize, int aProbability, int aMinY, int aMaxY, Collection<String> aBiomeList, boolean aAllowToGenerateinVoid) {
        super(aName, aDefault, aBlock, aBlockMeta, aDimensionType, aAmount, aSize, aProbability, aMinY, aMaxY, aBiomeList, aAllowToGenerateinVoid);
    }

    @Override
    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        boolean result;
        XSTR stoneRNG = new XSTR();
        ArrayList<ValidSeeds> stones = new ArrayList<ValidSeeds>();
        if (!this.isGenerationAllowed(aWorld, aDimensionType, this.mDimensionType)) {
            return false;
        }
        if (!this.mBiomeList.isEmpty() && !this.mBiomeList.contains(aBiome)) {
            return false;
        }
        double realSize = this.mSize / 16;
        int windowWidth = (int)realSize / 16 + 1;
        for (int x = aChunkX / 16 - windowWidth; x < aChunkX / 16 + windowWidth + 1; ++x) {
            for (int z = aChunkZ / 16 - windowWidth; z < aChunkZ / 16 + windowWidth + 1; ++z) {
                long hash = ((long)aWorld.field_73011_w.field_76574_g & 0xFFL) << 56 | ((long)x & 0xFFFFFFFL) << 28 | (long)z & 0xFFFFFFFL;
                if (!this.validStoneSeeds.containsKey(hash)) {
                    stoneRNG.setSeed(aWorld.func_72905_C() ^ hash + (long)Math.abs(this.mBlockMeta) + (long)Math.abs(this.mSize) + (long)(GregTech_API.sBlockGranites == this.mBlock ? 32768 : 0));
                    if (this.mProbability <= 1 || stoneRNG.nextInt(this.mProbability) == 0) {
                        this.validStoneSeeds.put(hash, new StoneSeeds(true));
                        stones.add(new ValidSeeds(x, z));
                        if (!GT_Values.debugStones) continue;
                        GT_Log.out.println("New stoneseed=" + this.mWorldGenName + " x=" + x + " z=" + z + " realSize=" + realSize);
                        continue;
                    }
                    this.validStoneSeeds.put(hash, new StoneSeeds(false));
                    continue;
                }
                if (!this.validStoneSeeds.get((Object)Long.valueOf((long)hash)).mExists) continue;
                stones.add(new ValidSeeds(x, z));
            }
        }
        boolean bl = result = stones.size() != 0;
        while (stones.size() != 0) {
            int x = ((ValidSeeds)stones.get((int)0)).mX * 16;
            int z = ((ValidSeeds)stones.get((int)0)).mZ * 16;
            stoneRNG.setSeed(aWorld.func_72905_C() ^ (((long)aWorld.field_73011_w.field_76574_g & 0xFFL) << 56 | ((long)x & 0xFFFFFFFL) << 28 | (long)z & 0xFFFFFFFL) + (long)Math.abs(this.mBlockMeta) + (long)Math.abs(this.mSize) + (long)(GregTech_API.sBlockGranites == this.mBlock ? 32768 : 0));
            for (int i = 0; i < this.mAmount; ++i) {
                int tX = x + stoneRNG.nextInt(16);
                int tY = this.mMinY + stoneRNG.nextInt(this.mMaxY - this.mMinY);
                int tZ = z + stoneRNG.nextInt(16);
                double xSize = sizeConversion[stoneRNG.nextInt(sizeConversion.length)];
                double ySize = sizeConversion[stoneRNG.nextInt(sizeConversion.length) / 2];
                double zSize = sizeConversion[stoneRNG.nextInt(sizeConversion.length)];
                int tMinX = tX - (int)(realSize / xSize - 1.0);
                int tMaxX = tX + (int)(realSize / xSize + 2.0);
                int tMinY = tY - (int)(realSize / ySize - 1.0);
                int tMaxY = tY + (int)(realSize / ySize + 2.0);
                int tMinZ = tZ - (int)(realSize / zSize - 1.0);
                int tMaxZ = tZ + (int)(realSize / zSize + 2.0);
                if (aWorld.func_147439_a(aChunkX + 8, tMinY, aChunkZ + 8).isAir((IBlockAccess)aWorld, aChunkX + 8, tMinY, aChunkZ + 8)) {
                    if (GT_Values.debugStones) {
                        GT_Log.out.println(this.mWorldGenName + " tX=" + tX + " tY=" + tY + " tZ=" + tZ + " realSize=" + realSize + " xSize=" + realSize / xSize + " ySize=" + realSize / ySize + " zSize=" + realSize / zSize + " tMinY=" + tMinY + " tMaxY=" + tMaxY + " - Skipped because first requesting chunk would not contain this stone");
                    }
                    long hash = ((long)aWorld.field_73011_w.field_76574_g & 0xFFL) << 56 | ((long)x & 0xFFFFFFFL) << 28 | (long)z & 0xFFFFFFFL;
                    this.validStoneSeeds.remove(hash);
                    this.validStoneSeeds.put(hash, new StoneSeeds(false));
                }
                int wX = Math.max(tMinX, aChunkX + 8);
                int eX = Math.min(tMaxX, aChunkX + 8 + 16);
                int sZ = Math.max(tMinZ, aChunkZ + 8);
                int nZ = Math.min(tMaxZ, aChunkZ + 8 + 16);
                if (GT_Values.debugStones) {
                    GT_Log.out.println(this.mWorldGenName + " tX=" + tX + " tY=" + tY + " tZ=" + tZ + " realSize=" + realSize + " xSize=" + realSize / xSize + " ySize=" + realSize / ySize + " zSize=" + realSize / zSize + " wX=" + wX + " eX=" + eX + " tMinY=" + tMinY + " tMaxY=" + tMaxY + " sZ=" + sZ + " nZ=" + nZ);
                }
                double rightHandSide = realSize * realSize + 1.0;
                for (int iY = tMinY; iY < tMaxY; ++iY) {
                    double leftHandSize;
                    double yCalc = (double)(iY - tY) * ySize;
                    if ((leftHandSize = (yCalc *= yCalc)) > rightHandSide) continue;
                    for (int iX = wX; iX < eX; ++iX) {
                        double xCalc = (double)(iX - tX) * xSize;
                        if ((leftHandSize = yCalc + (xCalc *= xCalc)) > rightHandSide) continue;
                        for (int iZ = sZ; iZ < nZ; ++iZ) {
                            double zCalc = (double)(iZ - tZ) * zSize;
                            if (!((leftHandSize = (zCalc *= zCalc) + xCalc + yCalc) <= rightHandSide)) continue;
                            Block tTargetedBlock = aWorld.func_147439_a(iX, iY, iZ);
                            if (tTargetedBlock instanceof GT_Block_Ores_Abstract) {
                                TileEntity tTileEntity = aWorld.func_147438_o(iX, iY, iZ);
                                if (!(tTileEntity instanceof GT_TileEntity_Ores)) continue;
                                if (tTargetedBlock != GregTech_API.sBlockOres1) {
                                    ((GT_TileEntity_Ores)tTileEntity).convertOreBlock(aWorld, iX, iY, iZ);
                                }
                                ((GT_TileEntity_Ores)tTileEntity).overrideOreBlockMaterial(this.mBlock, (byte)this.mBlockMeta);
                                continue;
                            }
                            if ((!this.mAllowToGenerateinVoid || !aWorld.func_147439_a(iX, iY, iZ).isAir((IBlockAccess)aWorld, iX, iY, iZ)) && (tTargetedBlock == null || !tTargetedBlock.isReplaceableOreGen(aWorld, iX, iY, iZ, Blocks.field_150348_b) && !tTargetedBlock.isReplaceableOreGen(aWorld, iX, iY, iZ, Blocks.field_150406_ce) && !tTargetedBlock.isReplaceableOreGen(aWorld, iX, iY, iZ, Blocks.field_150347_e) && !tTargetedBlock.isReplaceableOreGen(aWorld, iX, iY, iZ, Blocks.field_150377_bs) && !tTargetedBlock.isReplaceableOreGen(aWorld, iX, iY, iZ, Blocks.field_150424_aL) && !tTargetedBlock.isReplaceableOreGen(aWorld, iX, iY, iZ, GregTech_API.sBlockGranites) && !tTargetedBlock.isReplaceableOreGen(aWorld, iX, iY, iZ, GregTech_API.sBlockStones))) continue;
                            aWorld.func_147465_d(iX, iY, iZ, this.mBlock, this.mBlockMeta, 0);
                        }
                    }
                }
            }
            stones.remove(0);
        }
        return result;
    }

    static class StoneSeeds {
        public boolean mExists;

        StoneSeeds(boolean exists) {
            this.mExists = exists;
        }
    }

    static class ValidSeeds {
        public int mX;
        public int mZ;

        ValidSeeds(int x, int z) {
            this.mX = x;
            this.mZ = z;
        }
    }
}

